/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: AlsaMidiDriver.h,v 1.4 2004/01/26 11:16:58 comix Exp $
 *
 */

#include "config.h"

// check if ALSA_SEQ support is enabled
#ifdef USE_ALSA_SEQ


#ifndef ALSA_MIDI_DRIVER_H
#define ALSA_MIDI_DRIVER_H

#include <alsa/asoundlib.h>
#include <string>
#include <vector>
using std::string;
using std::vector;

#include "Object.h"
#include "Hydrogen.h"
#include "Song.h"


class MidiPortInfo
{
	public:
		string name;
		int client;
		int port;
};

/**
 * AlsaMidiDriver
 * Based on Dr Matthias Nagorni alsa sequencer example
 */
class AlsaMidiDriver : public Object
{
	public:
		AlsaMidiDriver();
		~AlsaMidiDriver();

		void open();
		void close();
		void setActive(bool isActive) {	this->active = isActive;	}
		void midi_action(snd_seq_t *seq_handle);
		vector<MidiPortInfo> listAlsaOutputPorts();

	private:
		bool active;
		void noteOnEvent( snd_seq_event_t* ev );
		void noteOffEvent( snd_seq_event_t* ev );
		void controllerEvent( snd_seq_event_t* ev );
		void sysexEvent( unsigned char *midiBuffer, int nBytes );
		void playEvent();
		void stopEvent();

		void midiDump( unsigned char *buffer, int bufSize );
};


#endif // USE_ALSA_SEQ

#endif
