/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: PatternEditorPanel.h,v 1.30 2004/02/10 11:07:31 comix Exp $
 *
 */


#ifndef PATTERN_EDITOR_PANEL_H
#define PATTERN_EDITOR_PANEL_H

#include <map>
using namespace std;

#include "lib/EngineListener.h"

#include "qwidget.h"
#include "qpixmap.h"
#include "qcombobox.h"
#include "qmessagebox.h"
#include "qtooltip.h"
#include "qscrollview.h"
#include "qscrollbar.h"
#include "qframe.h"
#include "qspinbox.h"

#include "Button.h"
#include "PatternEditor.h"
#include "Fader.h"
class PatternEditor;
class PatternEditorRuler;
class PatternEditorInstrumentList;
class PatternEditorVelocityRuler;
class NotePropertiesRuler;

/**
 * Pattern Editor Window
 */
class PatternEditorPanel : public QWidget, public EngineListener {
	Q_OBJECT

	public:
		PatternEditorPanel(QWidget *parent);
		~PatternEditorPanel();
		void updateStart(bool start);

		void resizeEvent ( QResizeEvent *ev );
		void showEvent ( QShowEvent *ev );

		PatternEditor* getPatternEditor() {	return m_pPatternEditor;	}
		PatternEditorVelocityRuler* getVelocityRuler() {	return m_pVelocityRuler;	}
		PatternEditorInstrumentList* getInstrumentList() {	return m_pInstrumentList;	}
		
		void setSelectedInstrument( int nInstr );
		int getSelectedInstrument() {	return m_nSelectedInstrument;	}
		
	public slots:
		void gridResolutionChanged();
		void hearNotesBtnClick(Button *ref);
		void patternSizeComboChanged();
		void recordEventsBtnClick(Button *ref);
		void quantizeEventsBtnClick(Button *ref);

		void syncToExternalHorizontalScrollbar(int);
		void contentsMoving(int dummy);

	private:
		uint m_nPanelWidth;
		uint m_nPanelHeight;
		QPixmap background;
		int m_nSelectedInstrument;

		// editor
		QScrollView* m_pEditorScrollView;
		QFrame* m_pEditorFrame;
		PatternEditor *m_pPatternEditor;

		// ruler
		QScrollView* m_pRulerScrollView;
		QFrame* m_pRulerFrame;
		PatternEditorRuler *m_pPatternEditorRuler;

		// instr list
		QScrollView* m_pInstrListScrollView;
		QFrame* m_pInstrListFrame;
		PatternEditorInstrumentList  *m_pInstrumentList;

		// Velocity ruler
		QScrollView* m_pVelocityRulerScrollView;
		QFrame* m_pVelocityRulerFrame;
		PatternEditorVelocityRuler *m_pVelocityRuler;


		QScrollBar *m_pPatternEditorHScrollBar;
		QScrollBar *m_pPatternEditorVScrollBar;


		NotePropertiesRuler *notePropertiesRuler;

		QComboBox* gridResolutionCombo;
		QComboBox* pPatternSizeCombo;
		QLabel *patternNameLbl;
		ToggleButton *hearNotesBtn;
		ToggleButton *recordEventsBtn;
		ToggleButton *quantizeEventsBtn;

		virtual void patternChanged();
		virtual void patternModified();
		virtual void stateChanged(int state);
		void customEvent( QCustomEvent *ev );
};





#endif


