/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Mixer.h,v 1.36 2004/02/10 11:07:27 comix Exp $
 *
 */


#ifndef MIXER_H
#define MIXER_H

#include "qwidget.h"
#include "qtimer.h"
#include "qscrollview.h"
#include "qhbox.h"


#include "lib/EngineListener.h"
#include "lib/Object.h"

#include "config.h"
#include "MixerLine.h"
#include "Globals.h"
#include "Button.h"

class FxMixerLine;
class MixerLine;
class MasterMixerLine;
class LadspaFXMixerLine;

/**
 * Mixer panel
 */
class Mixer : public QWidget, public EngineListener, public Object {
	Q_OBJECT
	public:
		/** Constructor */
		Mixer(QWidget* parent);

		/** Destructor */
		~Mixer();

		void updateStart(bool start);
		void showEvent ( QShowEvent *ev );
		void hideEvent ( QHideEvent *ev );
		void resizeEvent ( QResizeEvent *ev );
		void soloClicked(uint nLine);

	public slots:
		void noteOnClicked(MixerLine* ref);
		void noteOffClicked(MixerLine* ref);
		void muteClicked(MixerLine* ref);
		void soloClicked(MixerLine* ref);
		void loadClicked(MixerLine* ref);
		void volumeChanged(MixerLine* ref);
		void panChanged(MixerLine* ref);
		void knobChanged(MixerLine* ref, int nKnob);
		void masterVolumeChanged(MasterMixerLine*);
		void nameClicked(MixerLine* ref);
		void nameSelected(MixerLine* ref);
		void humanizeChanged(FxMixerLine* ref);
		void swingChanged(FxMixerLine* ref);
		void activeBtnChanged( FxMixerLine *ref );
		void updateMixer();
		void showFadersPanelClicked(Button* ref);
		void showFXPanelClicked(Button* ref);
		void showPeaksBtnClicked(Button* ref);
		void ladspaActiveBtnClicked( LadspaFXMixerLine* ref );
		void ladspaEditBtnClicked( LadspaFXMixerLine *ref );
		void ladspaVolumeChanged( LadspaFXMixerLine* ref);

	private:
		uint mixerWidth;
		uint mixerHeight;
		uint nMinimumVisibleFadersSize;

		FxMixerLine *humanizeTimeLine;
		FxMixerLine *humanizeVelocityLine;
		FxMixerLine *swingFactorLine;

		LadspaFXMixerLine *m_pLadspaFXLine[MAX_FX];

		QScrollView* m_pFaderScrollView;
		QFrame *m_pLeftFrame;
		ToggleButton *m_pShowFaderPanelBtn;
		ToggleButton *m_pShowFXPanelBtn;
		ToggleButton *m_pShowPeaksBtn;
		MasterMixerLine *masterLine;

		QFrame *m_pFaderFrame;
		MixerLine *mixerLine[MAX_INSTRUMENTS];

		QScrollView* m_pFXScrollView;
		QFrame *m_pFXFrame;

		QPixmap background;
		QTimer *timer;

		void setupMixer();
		uint findMixerLineByRef(MixerLine* ref);

		virtual void noteOn(Note *note);
		void customEvent( QCustomEvent *ev );

};

#endif

