ps.slide <- function(file, background=if(type!=2)"white" else "navy blue", 
	foreground=if(type==2)'yellow' else (if(background=="white")"black" else "white"),
	font='Helvetica',
	pointsize=c(24,28,14,14)[type], hor=type!=4, 
	lwd=c(2,5,2,4)[type],
	mgp=if(under.unix) list(c(1.8,.4,0),c(1.5,.2,0),c(2,.4,0),c(1.5,.2,0))[[type]] else
					 list(c(1.8,.5,0),c(1.5,.4,0),c(2,.5,0),c(1.5,.4,0))[[type]],
	mar=list(c(4,3,2,1)+.1,c(5,4,2.25,2)+.1,c(3,3,1,1)+.1,
		c(5,4,2.25,2)+.1)[[type]],
	pch=202, view=FALSE, pcx=FALSE, tiff=FALSE, close=view|pcx|tiff, bty="l", type=2,
	height=switch(type,NULL,NULL,5,8), width=switch(type,NULL,NULL,7,7),
					 tck=if(type==3 || !under.unix)-.013 else par('tck'), 
					 las=if(type==3)1 else 0, 
					 eps=FALSE, ...) {

if(close) {
  graphics.off()
  file <- .Options$ps.slide.file
  if(view) unix(paste("ghostview ", file, ".ps &", sep=""), output=FALSE)
  if(pcx) {
    unix(paste("(gs -sDEVICE=pbm -sOutputFile=- -r75 -q - quit.ps < ",
	file, ".ps | pnmflip -cw | ppmtopcx > ", file, ".pcx) &", sep=""),
	output=FALSE)
    cat("\nFile ", file, ".pcx being created \n", sep="")
#    if(view) unix(paste("xli ", file, ".pcx &", sep=""), output=FALSE)
  }
  if(tiff) {
    unix(paste("(gs -sDEVICE=pbmraw -sOutputFile=- -r300 -q - quit.ps < ",
         file, ".ps | pnmflip -cw | pnmtotiff > ", file, ".tiff) &",sep=""),
         output=FALSE)
    cat("\nFile ", file, ".tiff being created \n", sep="")
  }
  return(invisible())
}

if(is.logical(background) && background) background <- "navy blue"
options(ps.slide.file=file, TEMPORARY=FALSE)
if(!.R.) {
  cols <- ps.colors.rgb[c(foreground,background),]
  fonts <- if(under.unix)ps.options()$fonts else ps.fonts
  fonts[1] <- font
  if(font=='Times-Roman') fonts[5] <- 'Times-Bold'
  if(under.unix) {
    ps.options(colors=cols, background=2, fonts=fonts, pointsize=pointsize, ...)
    cat('\nIf using legend() be sure to add the arguments background=2, bty="n"\n')
  
  if(length(height) && length(width)) 
	postscript(paste(file,'.ps',sep=''),
			   hor=hor, height=height, width=width,
			   pointsize=.6*pointsize*max(width/(30*12/72.27),
				 height/(30*12/72.27/((1+sqrt(5))/2))),
			   print.it=FALSE, onefile=!eps) else
  postscript(paste(file,".ps",sep=""), hor=hor, print.it=FALSE, onefile=!eps)
} else {
  if(length(height) && length(width)) 
	postscript(paste(file,'.ps',sep=''),
			   hor=hor, height=height, width=width,
			   pointsize=.6*pointsize*max(width/(30*12/72.27),
				 height/(30*12/72.27/((1+sqrt(5))/2))),
			   colors=cols, fonts=fonts, ...) else
	postscript(paste(file,'.ps',sep=''),
			   hor=hor, colors=cols, fonts=fonts, ...)
	  }
} else { # 10Apr01
  if(length(height) && length(width)) 
	postscript(paste(file,'.ps',sep=''),
			   hor=hor, height=height, width=width,
			   pointsize=.6*pointsize*max(width/(30*12/72.27),
				 height/(30*12/72.27/((1+sqrt(5))/2))),
			   fg=foreground, bg=background, family=font, ...) else
	postscript(paste(file,'.ps',sep=''),
			   fg=foreground, bg=background, family=font, ...)
}

  par(lwd=lwd, mgp=mgp, mar=mar, pch=pch, bty=bty, smo=0, tck=tck, las=las)
#  mgp.axis.labels(c(mgp[2], if(las==1) 1.3 else mgp[2]))
  invisible()
}

if(!.R. && !under.unix) ps.colors.rgb <-
structure(.Data = c(1, 0.972549019607843, 0.972549019607843, 0.96078431372549, 
	0.96078431372549, 0.862745098039216, 1, 1, 0.992156862745098, 
	0.992156862745098, 0.980392156862745, 0.980392156862745, 
	0.980392156862745, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	0.941176470588235, 0.96078431372549, 0.96078431372549, 
	0.941176470588235, 0.941176470588235, 0.941176470588235, 
	0.901960784313726, 1, 1, 1, 1, 1, 0, 0.184313725490196, 
	0.184313725490196, 0.184313725490196, 0.184313725490196, 
	0.411764705882353, 0.411764705882353, 0.411764705882353, 
	0.411764705882353, 0.43921568627451, 0.43921568627451, 0.43921568627451,
	0.43921568627451, 0.466666666666667, 0.466666666666667, 
	0.466666666666667, 0.466666666666667, 0.752941176470588, 
	0.752941176470588, 0.827450980392157, 0.827450980392157, 
	0.827450980392157, 0.827450980392157, 0.0980392156862745, 
	0.0980392156862745, 0, 0, 0, 0.392156862745098, 0.392156862745098, 
	0.282352941176471, 0.282352941176471, 0.415686274509804, 
	0.415686274509804, 0.482352941176471, 0.482352941176471, 
	0.517647058823529, 0.517647058823529, 0, 0, 0.254901960784314, 
	0.254901960784314, 0, 0.117647058823529, 0.117647058823529, 0, 0, 
	0.529411764705882, 0.529411764705882, 0.529411764705882, 
	0.529411764705882, 0.274509803921569, 0.274509803921569, 
	0.690196078431373, 0.690196078431373, 0.67843137254902, 
	0.67843137254902, 0.690196078431373, 0.690196078431373, 
	0.686274509803922, 0.686274509803922, 0, 0, 0.282352941176471, 
	0.282352941176471, 0.250980392156863, 0, 0.87843137254902, 
	0.87843137254902, 0.372549019607843, 0.372549019607843, 0.4, 0.4, 
	0.498039215686275, 0, 0, 0.333333333333333, 0.333333333333333, 
	0.56078431372549, 0.56078431372549, 0.180392156862745, 
	0.180392156862745, 0.235294117647059, 0.235294117647059, 
	0.125490196078431, 0.125490196078431, 0.596078431372549, 
	0.596078431372549, 0, 0, 0.486274509803922, 0.486274509803922, 0, 
	0.498039215686275, 0, 0, 0.67843137254902, 0.67843137254902, 
	0.196078431372549, 0.196078431372549, 0.603921568627451, 
	0.603921568627451, 0.133333333333333, 0.133333333333333, 
	0.419607843137255, 0.419607843137255, 0.741176470588235, 
	0.741176470588235, 0.941176470588235, 0.933333333333333, 
	0.933333333333333, 0.980392156862745, 0.980392156862745, 1, 1, 1, 1, 
	0.933333333333333, 0.933333333333333, 0.854901960784314, 
	0.72156862745098, 0.72156862745098, 0.737254901960784, 
	0.737254901960784, 0.803921568627451, 0.803921568627451, 
	0.545098039215686, 0.545098039215686, 0.627450980392157, 
	0.803921568627451, 0.870588235294118, 0.96078431372549, 
	0.96078431372549, 0.956862745098039, 0.956862745098039, 
	0.823529411764706, 0.823529411764706, 0.698039215686274, 
	0.647058823529412, 0.913725490196078, 0.913725490196078, 
	0.980392156862745, 1, 1, 1, 1, 1, 1, 0.941176470588235, 
	0.941176470588235, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.858823529411765, 
	0.858823529411765, 0.690196078431373, 0.780392156862745, 
	0.780392156862745, 0.815686274509804, 0.815686274509804, 1, 
	0.933333333333333, 0.866666666666667, 0.854901960784314, 
	0.729411764705882, 0.729411764705882, 0.6, 0.6, 0.580392156862745, 
	0.580392156862745, 0.541176470588235, 0.541176470588235, 
	0.627450980392157, 0.576470588235294, 0.576470588235294, 
	0.847058823529412, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 0.941176470588235, 0.87843137254902, 
	0.756862745098039, 0.513725490196078, 1, 0.933333333333333, 
	0.803921568627451, 0.545098039215686, 1, 0.933333333333333, 
	0.803921568627451, 0.545098039215686, 0.941176470588235, 
	0.87843137254902, 0.756862745098039, 0.513725490196078, 
	0.513725490196078, 0.47843137254902, 0.411764705882353, 
	0.27843137254902, 0.282352941176471, 0.262745098039216, 
	0.227450980392157, 0.152941176470588, 0, 0, 0, 0, 0.117647058823529, 
	0.109803921568627, 0.0941176470588235, 0.0627450980392157, 
	0.388235294117647, 0.36078431372549, 0.309803921568627, 
	0.211764705882353, 0, 0, 0, 0, 0.529411764705882, 0.494117647058824, 
	0.423529411764706, 0.290196078431373, 0.690196078431373, 
	0.643137254901961, 0.552941176470588, 0.376470588235294, 
	0.776470588235294, 0.725490196078431, 0.623529411764706, 
	0.423529411764706, 0.792156862745098, 0.737254901960784, 
	0.635294117647059, 0.431372549019608, 0.749019607843137, 
	0.698039215686274, 0.603921568627451, 0.407843137254902, 
	0.87843137254902, 0.819607843137255, 0.705882352941177, 
	0.47843137254902, 0.733333333333333, 0.682352941176471, 
	0.588235294117647, 0.4, 0.596078431372549, 0.556862745098039, 
	0.47843137254902, 0.325490196078431, 0, 0, 0, 0, 0, 0, 0, 0, 
	0.592156862745098, 0.552941176470588, 0.474509803921569, 
	0.32156862745098, 0.498039215686275, 0.462745098039216, 0.4, 
	0.270588235294118, 0.756862745098039, 0.705882352941177, 
	0.607843137254902, 0.411764705882353, 0.329411764705882, 
	0.305882352941176, 0.262745098039216, 0.180392156862745, 
	0.603921568627451, 0.564705882352941, 0.486274509803922, 
	0.329411764705882, 0, 0, 0, 0, 0, 0, 0, 0, 0.498039215686275, 
	0.462745098039216, 0.4, 0.270588235294118, 0.752941176470588, 
	0.701960784313725, 0.603921568627451, 0.411764705882353, 
	0.792156862745098, 0.737254901960784, 0.635294117647059, 
	0.431372549019608, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 0.87843137254902, 0.819607843137255, 
	0.705882352941177, 0.47843137254902, 0.749019607843137, 
	0.698039215686274, 0.603921568627451, 0.407843137254902, 
	0.607843137254902, 0.568627450980392, 0.490196078431373, 
	0.333333333333333, 0.670588235294118, 0.623529411764706, 
	0.537254901960784, 0.364705882352941, 1, 0.933333333333333, 
	0.803921568627451, 0.545098039215686, 0, 0, 0.0117647058823529, 
	0.0117647058823529, 0.0196078431372549, 0.0196078431372549, 
	0.0313725490196078, 0.0313725490196078, 0.0392156862745098, 
	0.0392156862745098, 0.0509803921568627, 0.0509803921568627, 
	0.0588235294117647, 0.0588235294117647, 0.0705882352941176, 
	0.0705882352941176, 0.0784313725490196, 0.0784313725490196, 
	0.0901960784313725, 0.0901960784313725, 0.101960784313725, 
	0.101960784313725, 0.109803921568627, 0.109803921568627, 
	0.12156862745098, 0.12156862745098, 0.129411764705882, 
	0.129411764705882, 0.141176470588235, 0.141176470588235, 
	0.149019607843137, 0.149019607843137, 0.16078431372549, 
	0.16078431372549, 0.168627450980392, 0.168627450980392, 
	0.180392156862745, 0.180392156862745, 0.188235294117647, 
	0.188235294117647, 0.2, 0.2, 0.211764705882353, 0.211764705882353, 
	0.219607843137255, 0.219607843137255, 0.231372549019608, 
	0.231372549019608, 0.23921568627451, 0.23921568627451, 
	0.250980392156863, 0.250980392156863, 0.258823529411765, 
	0.258823529411765, 0.270588235294118, 0.270588235294118, 
	0.27843137254902, 0.27843137254902, 0.290196078431373, 
	0.290196078431373, 0.301960784313725, 0.301960784313725, 
	0.309803921568627, 0.309803921568627, 0.32156862745098, 
	0.32156862745098, 0.329411764705882, 0.329411764705882, 
	0.341176470588235, 0.341176470588235, 0.349019607843137, 
	0.349019607843137, 0.36078431372549, 0.36078431372549, 
	0.368627450980392, 0.368627450980392, 0.380392156862745, 
	0.380392156862745, 0.388235294117647, 0.388235294117647, 0.4, 0.4, 
	0.411764705882353, 0.411764705882353, 0.419607843137255, 
	0.419607843137255, 0.431372549019608, 0.431372549019608, 
	0.43921568627451, 0.43921568627451, 0.450980392156863, 
	0.450980392156863, 0.458823529411765, 0.458823529411765, 
	0.470588235294118, 0.470588235294118, 0.47843137254902, 
	0.47843137254902, 0.490196078431373, 0.490196078431373, 
	0.498039215686275, 0.498039215686275, 0.509803921568627, 
	0.509803921568627, 0.52156862745098, 0.52156862745098, 
	0.529411764705882, 0.529411764705882, 0.541176470588235, 
	0.541176470588235, 0.549019607843137, 0.549019607843137, 
	0.56078431372549, 0.56078431372549, 0.568627450980392, 
	0.568627450980392, 0.580392156862745, 0.580392156862745, 
	0.588235294117647, 0.588235294117647, 0.6, 0.6, 0.611764705882353, 
	0.611764705882353, 0.619607843137255, 0.619607843137255, 
	0.631372549019608, 0.631372549019608, 0.63921568627451, 
	0.63921568627451, 0.650980392156863, 0.650980392156863, 
	0.658823529411765, 0.658823529411765, 0.670588235294118, 
	0.670588235294118, 0.67843137254902, 0.67843137254902, 
	0.690196078431373, 0.690196078431373, 0.701960784313725, 
	0.701960784313725, 0.709803921568627, 0.709803921568627, 
	0.72156862745098, 0.72156862745098, 0.729411764705882, 
	0.729411764705882, 0.741176470588235, 0.741176470588235, 
	0.749019607843137, 0.749019607843137, 0.76078431372549, 
	0.76078431372549, 0.768627450980392, 0.768627450980392, 
	0.780392156862745, 0.780392156862745, 0.788235294117647, 
	0.788235294117647, 0.8, 0.8, 0.811764705882353, 0.811764705882353, 
	0.819607843137255, 0.819607843137255, 0.831372549019608, 
	0.831372549019608, 0.83921568627451, 0.83921568627451, 
	0.850980392156863, 0.850980392156863, 0.858823529411765, 
	0.858823529411765, 0.870588235294118, 0.870588235294118, 
	0.87843137254902, 0.87843137254902, 0.890196078431372, 
	0.890196078431372, 0.898039215686275, 0.898039215686275, 
	0.909803921568627, 0.909803921568627, 0.92156862745098, 
	0.92156862745098, 0.929411764705882, 0.929411764705882, 
	0.941176470588235, 0.941176470588235, 0.949019607843137, 
	0.949019607843137, 0.96078431372549, 0.96078431372549, 
	0.968627450980392, 0.968627450980392, 0.980392156862745, 
	0.980392156862745, 0.988235294117647, 0.988235294117647, 1, 1, 
	0.980392156862745, 0.972549019607843, 0.972549019607843, 
	0.96078431372549, 0.96078431372549, 0.862745098039216, 
	0.980392156862745, 0.980392156862745, 0.96078431372549, 
	0.96078431372549, 0.941176470588235, 0.92156862745098, 0.92156862745098,
	0.937254901960784, 0.937254901960784, 0.92156862745098, 
	0.92156862745098, 0.894117647058824, 0.854901960784314, 
	0.854901960784314, 0.870588235294118, 0.870588235294118, 
	0.894117647058824, 0.972549019607843, 1, 0.980392156862745, 
	0.980392156862745, 0.96078431372549, 1, 1, 1, 1, 0.972549019607843, 
	0.972549019607843, 0.901960784313726, 0.941176470588235, 
	0.941176470588235, 0.894117647058824, 0.894117647058824, 1, 0, 
	0.309803921568627, 0.309803921568627, 0.309803921568627, 
	0.309803921568627, 0.411764705882353, 0.411764705882353, 
	0.411764705882353, 0.411764705882353, 0.501960784313725, 
	0.501960784313725, 0.501960784313725, 0.501960784313725, 
	0.533333333333333, 0.533333333333333, 0.533333333333333, 
	0.533333333333333, 0.752941176470588, 0.752941176470588, 
	0.827450980392157, 0.827450980392157, 0.827450980392157, 
	0.827450980392157, 0.0980392156862745, 0.0980392156862745, 0, 0, 0, 
	0.584313725490196, 0.584313725490196, 0.23921568627451, 
	0.23921568627451, 0.352941176470588, 0.352941176470588, 
	0.407843137254902, 0.407843137254902, 0.43921568627451, 
	0.43921568627451, 0, 0, 0.411764705882353, 0.411764705882353, 0, 
	0.564705882352941, 0.564705882352941, 0.749019607843137, 
	0.749019607843137, 0.807843137254902, 0.807843137254902, 
	0.807843137254902, 0.807843137254902, 0.509803921568627, 
	0.509803921568627, 0.768627450980392, 0.768627450980392, 
	0.847058823529412, 0.847058823529412, 0.87843137254902, 
	0.87843137254902, 0.933333333333333, 0.933333333333333, 
	0.807843137254902, 0.807843137254902, 0.819607843137255, 
	0.819607843137255, 0.87843137254902, 1, 1, 1, 0.619607843137255, 
	0.619607843137255, 0.803921568627451, 0.803921568627451, 1, 
	0.392156862745098, 0.392156862745098, 0.419607843137255, 
	0.419607843137255, 0.737254901960784, 0.737254901960784, 
	0.545098039215686, 0.545098039215686, 0.701960784313725, 
	0.701960784313725, 0.698039215686274, 0.698039215686274, 
	0.984313725490196, 0.984313725490196, 1, 1, 0.988235294117647, 
	0.988235294117647, 1, 1, 0.980392156862745, 0.980392156862745, 1, 1, 
	0.803921568627451, 0.803921568627451, 0.803921568627451, 
	0.803921568627451, 0.545098039215686, 0.545098039215686, 
	0.556862745098039, 0.556862745098039, 0.717647058823529, 
	0.717647058823529, 0.901960784313726, 0.909803921568627, 
	0.909803921568627, 0.980392156862745, 0.980392156862745, 1, 1, 1, 
	0.843137254901961, 0.866666666666667, 0.866666666666667, 
	0.647058823529412, 0.525490196078431, 0.525490196078431, 
	0.56078431372549, 0.56078431372549, 0.36078431372549, 0.36078431372549, 
	0.270588235294118, 0.270588235294118, 0.32156862745098, 
	0.52156862745098, 0.72156862745098, 0.96078431372549, 0.870588235294118,
	0.643137254901961, 0.643137254901961, 0.705882352941177, 
	0.411764705882353, 0.133333333333333, 0.164705882352941, 
	0.588235294117647, 0.588235294117647, 0.501960784313725, 
	0.627450980392157, 0.627450980392157, 0.647058823529412, 
	0.549019607843137, 0.549019607843137, 0.498039215686275, 
	0.501960784313725, 0.501960784313725, 0.388235294117647, 
	0.270588235294118, 0.270588235294118, 0, 0.411764705882353, 
	0.411764705882353, 0.0784313725490196, 0.0784313725490196, 
	0.752941176470588, 0.713725490196078, 0.713725490196078, 
	0.43921568627451, 0.43921568627451, 0.188235294117647, 
	0.0823529411764706, 0.0823529411764706, 0.125490196078431, 
	0.125490196078431, 0, 0.509803921568627, 0.627450980392157, 
	0.43921568627451, 0.333333333333333, 0.333333333333333, 
	0.196078431372549, 0.196078431372549, 0, 0, 0.168627450980392, 
	0.168627450980392, 0.125490196078431, 0.43921568627451, 
	0.43921568627451, 0.749019607843137, 0.980392156862745, 
	0.913725490196078, 0.788235294117647, 0.537254901960784, 
	0.96078431372549, 0.898039215686275, 0.772549019607843, 
	0.525490196078431, 0.937254901960784, 0.874509803921569, 
	0.752941176470588, 0.513725490196078, 0.894117647058824, 
	0.835294117647059, 0.717647058823529, 0.490196078431373, 
	0.854901960784314, 0.796078431372549, 0.686274509803922, 
	0.466666666666667, 0.870588235294118, 0.811764705882353, 
	0.701960784313725, 0.474509803921569, 0.980392156862745, 
	0.913725490196078, 0.788235294117647, 0.537254901960784, 
	0.972549019607843, 0.909803921568627, 0.784313725490196, 
	0.533333333333333, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 0.941176470588235, 0.87843137254902, 
	0.756862745098039, 0.513725490196078, 0.894117647058824, 
	0.835294117647059, 0.717647058823529, 0.490196078431373, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 
	0.435294117647059, 0.403921568627451, 0.349019607843137, 
	0.235294117647059, 0.462745098039216, 0.431372549019608, 
	0.372549019607843, 0.250980392156863, 0, 0, 0, 0, 0.564705882352941, 
	0.525490196078431, 0.454901960784314, 0.305882352941176, 
	0.72156862745098, 0.674509803921569, 0.580392156862745, 
	0.392156862745098, 0.749019607843137, 0.698039215686274, 
	0.603921568627451, 0.407843137254902, 0.807843137254902, 
	0.752941176470588, 0.650980392156863, 0.43921568627451, 
	0.886274509803922, 0.827450980392157, 0.713725490196078, 
	0.482352941176471, 0.886274509803922, 0.827450980392157, 
	0.713725490196078, 0.482352941176471, 0.882352941176471, 
	0.823529411764706, 0.709803921568627, 0.482352941176471, 
	0.937254901960784, 0.874509803921569, 0.752941176470588, 
	0.513725490196078, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 0.96078431372549, 0.898039215686275, 
	0.772549019607843, 0.525490196078431, 0.96078431372549, 
	0.898039215686275, 0.772549019607843, 0.525490196078431, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 
	0.964705882352941, 0.901960784313726, 0.776470588235294, 
	0.525490196078431, 0.925490196078431, 0.862745098039216, 
	0.745098039215686, 0.505882352941176, 1, 0.933333333333333, 
	0.803921568627451, 0.545098039215686, 1, 0.933333333333333, 
	0.803921568627451, 0.545098039215686, 0.843137254901961, 
	0.788235294117647, 0.67843137254902, 0.458823529411765, 
	0.756862745098039, 0.705882352941177, 0.607843137254902, 
	0.411764705882353, 0.725490196078431, 0.67843137254902, 
	0.584313725490196, 0.396078431372549, 0.756862745098039, 
	0.705882352941177, 0.607843137254902, 0.411764705882353, 
	0.415686274509804, 0.388235294117647, 0.333333333333333, 
	0.227450980392157, 0.509803921568627, 0.474509803921569, 
	0.407843137254902, 0.27843137254902, 0.827450980392157, 
	0.772549019607843, 0.666666666666667, 0.450980392156863, 
	0.905882352941176, 0.847058823529412, 0.729411764705882, 
	0.494117647058824, 0.647058823529412, 0.603921568627451, 
	0.52156862745098, 0.352941176470588, 0.498039215686275, 
	0.462745098039216, 0.4, 0.270588235294118, 0.188235294117647, 
	0.172549019607843, 0.149019607843137, 0.101960784313725, 
	0.250980392156863, 0.231372549019608, 0.2, 0.137254901960784, 
	0.549019607843137, 0.509803921568627, 0.43921568627451, 
	0.298039215686275, 0.627450980392157, 0.584313725490196, 
	0.505882352941176, 0.341176470588235, 0.647058823529412, 
	0.603921568627451, 0.52156862745098, 0.352941176470588, 
	0.498039215686275, 0.462745098039216, 0.4, 0.270588235294118, 
	0.447058823529412, 0.415686274509804, 0.356862745098039, 
	0.243137254901961, 0.388235294117647, 0.36078431372549, 
	0.309803921568627, 0.211764705882353, 0.270588235294118, 
	0.250980392156863, 0.215686274509804, 0.145098039215686, 0, 0, 0, 0, 
	0.0784313725490196, 0.0705882352941176, 0.0627450980392157, 
	0.0392156862745098, 0.431372549019608, 0.415686274509804, 
	0.376470588235294, 0.227450980392157, 0.709803921568627, 
	0.662745098039216, 0.568627450980392, 0.388235294117647, 
	0.682352941176471, 0.635294117647059, 0.549019607843137, 
	0.372549019607843, 0.509803921568627, 0.474509803921569, 
	0.407843137254902, 0.27843137254902, 0.203921568627451, 
	0.188235294117647, 0.16078431372549, 0.109803921568627, 
	0.243137254901961, 0.227450980392157, 0.196078431372549, 
	0.133333333333333, 0, 0, 0, 0, 0.513725490196078, 0.47843137254902, 
	0.411764705882353, 0.27843137254902, 0.733333333333333, 
	0.682352941176471, 0.588235294117647, 0.4, 0.4, 0.372549019607843, 
	0.32156862745098, 0.215686274509804, 0.243137254901961, 
	0.227450980392157, 0.196078431372549, 0.133333333333333, 
	0.188235294117647, 0.172549019607843, 0.149019607843137, 
	0.101960784313725, 0.509803921568627, 0.474509803921569, 
	0.407843137254902, 0.27843137254902, 0.882352941176471, 
	0.823529411764706, 0.709803921568627, 0.482352941176471, 0, 0, 
	0.0117647058823529, 0.0117647058823529, 0.0196078431372549, 
	0.0196078431372549, 0.0313725490196078, 0.0313725490196078, 
	0.0392156862745098, 0.0392156862745098, 0.0509803921568627, 
	0.0509803921568627, 0.0588235294117647, 0.0588235294117647, 
	0.0705882352941176, 0.0705882352941176, 0.0784313725490196, 
	0.0784313725490196, 0.0901960784313725, 0.0901960784313725, 
	0.101960784313725, 0.101960784313725, 0.109803921568627, 
	0.109803921568627, 0.12156862745098, 0.12156862745098, 
	0.129411764705882, 0.129411764705882, 0.141176470588235, 
	0.141176470588235, 0.149019607843137, 0.149019607843137, 
	0.16078431372549, 0.16078431372549, 0.168627450980392, 
	0.168627450980392, 0.180392156862745, 0.180392156862745, 
	0.188235294117647, 0.188235294117647, 0.2, 0.2, 0.211764705882353, 
	0.211764705882353, 0.219607843137255, 0.219607843137255, 
	0.231372549019608, 0.231372549019608, 0.23921568627451, 
	0.23921568627451, 0.250980392156863, 0.250980392156863, 
	0.258823529411765, 0.258823529411765, 0.270588235294118, 
	0.270588235294118, 0.27843137254902, 0.27843137254902, 
	0.290196078431373, 0.290196078431373, 0.301960784313725, 
	0.301960784313725, 0.309803921568627, 0.309803921568627, 
	0.32156862745098, 0.32156862745098, 0.329411764705882, 
	0.329411764705882, 0.341176470588235, 0.341176470588235, 
	0.349019607843137, 0.349019607843137, 0.36078431372549, 
	0.36078431372549, 0.368627450980392, 0.368627450980392, 
	0.380392156862745, 0.380392156862745, 0.388235294117647, 
	0.388235294117647, 0.4, 0.4, 0.411764705882353, 0.411764705882353, 
	0.419607843137255, 0.419607843137255, 0.431372549019608, 
	0.431372549019608, 0.43921568627451, 0.43921568627451, 
	0.450980392156863, 0.450980392156863, 0.458823529411765, 
	0.458823529411765, 0.470588235294118, 0.470588235294118, 
	0.47843137254902, 0.47843137254902, 0.490196078431373, 
	0.490196078431373, 0.498039215686275, 0.498039215686275, 
	0.509803921568627, 0.509803921568627, 0.52156862745098, 
	0.52156862745098, 0.529411764705882, 0.529411764705882, 
	0.541176470588235, 0.541176470588235, 0.549019607843137, 
	0.549019607843137, 0.56078431372549, 0.56078431372549, 
	0.568627450980392, 0.568627450980392, 0.580392156862745, 
	0.580392156862745, 0.588235294117647, 0.588235294117647, 0.6, 0.6, 
	0.611764705882353, 0.611764705882353, 0.619607843137255, 
	0.619607843137255, 0.631372549019608, 0.631372549019608, 
	0.63921568627451, 0.63921568627451, 0.650980392156863, 
	0.650980392156863, 0.658823529411765, 0.658823529411765, 
	0.670588235294118, 0.670588235294118, 0.67843137254902, 
	0.67843137254902, 0.690196078431373, 0.690196078431373, 
	0.701960784313725, 0.701960784313725, 0.709803921568627, 
	0.709803921568627, 0.72156862745098, 0.72156862745098, 
	0.729411764705882, 0.729411764705882, 0.741176470588235, 
	0.741176470588235, 0.749019607843137, 0.749019607843137, 
	0.76078431372549, 0.76078431372549, 0.768627450980392, 
	0.768627450980392, 0.780392156862745, 0.780392156862745, 
	0.788235294117647, 0.788235294117647, 0.8, 0.8, 0.811764705882353, 
	0.811764705882353, 0.819607843137255, 0.819607843137255, 
	0.831372549019608, 0.831372549019608, 0.83921568627451, 
	0.83921568627451, 0.850980392156863, 0.850980392156863, 
	0.858823529411765, 0.858823529411765, 0.870588235294118, 
	0.870588235294118, 0.87843137254902, 0.87843137254902, 
	0.890196078431372, 0.890196078431372, 0.898039215686275, 
	0.898039215686275, 0.909803921568627, 0.909803921568627, 
	0.92156862745098, 0.92156862745098, 0.929411764705882, 
	0.929411764705882, 0.941176470588235, 0.941176470588235, 
	0.949019607843137, 0.949019607843137, 0.96078431372549, 
	0.96078431372549, 0.968627450980392, 0.968627450980392, 
	0.980392156862745, 0.980392156862745, 0.988235294117647, 
	0.988235294117647, 1, 1, 0.980392156862745, 1, 1, 0.96078431372549, 
	0.96078431372549, 0.862745098039216, 0.941176470588235, 
	0.941176470588235, 0.901960784313726, 0.901960784313726, 
	0.901960784313726, 0.843137254901961, 0.843137254901961, 
	0.835294117647059, 0.835294117647059, 0.803921568627451, 
	0.803921568627451, 0.768627450980392, 0.725490196078431, 
	0.725490196078431, 0.67843137254902, 0.67843137254902, 
	0.709803921568627, 0.862745098039216, 0.941176470588235, 
	0.803921568627451, 0.803921568627451, 0.933333333333333, 
	0.941176470588235, 0.980392156862745, 0.980392156862745, 1, 1, 1, 
	0.980392156862745, 0.96078431372549, 0.96078431372549, 
	0.882352941176471, 0.882352941176471, 1, 0, 0.309803921568627, 
	0.309803921568627, 0.309803921568627, 0.309803921568627, 
	0.411764705882353, 0.411764705882353, 0.411764705882353, 
	0.411764705882353, 0.564705882352941, 0.564705882352941, 
	0.564705882352941, 0.564705882352941, 0.6, 0.6, 0.6, 0.6, 
	0.752941176470588, 0.752941176470588, 0.827450980392157, 
	0.827450980392157, 0.827450980392157, 0.827450980392157, 
	0.43921568627451, 0.43921568627451, 0.501960784313725, 
	0.501960784313725, 0.501960784313725, 0.929411764705882, 
	0.929411764705882, 0.545098039215686, 0.545098039215686, 
	0.803921568627451, 0.803921568627451, 0.933333333333333, 
	0.933333333333333, 1, 1, 0.803921568627451, 0.803921568627451, 
	0.882352941176471, 0.882352941176471, 1, 1, 1, 1, 1, 0.92156862745098, 
	0.92156862745098, 0.980392156862745, 0.980392156862745, 
	0.705882352941177, 0.705882352941177, 0.870588235294118, 
	0.870588235294118, 0.901960784313726, 0.901960784313726, 
	0.901960784313726, 0.901960784313726, 0.933333333333333, 
	0.933333333333333, 0.819607843137255, 0.819607843137255, 0.8, 0.8, 
	0.815686274509804, 1, 1, 1, 0.627450980392157, 0.627450980392157, 
	0.666666666666667, 0.666666666666667, 0.831372549019608, 0, 0, 
	0.184313725490196, 0.184313725490196, 0.56078431372549, 
	0.56078431372549, 0.341176470588235, 0.341176470588235, 
	0.443137254901961, 0.443137254901961, 0.666666666666667, 
	0.666666666666667, 0.596078431372549, 0.596078431372549, 
	0.498039215686275, 0.498039215686275, 0, 0, 0, 0, 0.603921568627451, 
	0.603921568627451, 0.184313725490196, 0.184313725490196, 
	0.196078431372549, 0.196078431372549, 0.196078431372549, 
	0.196078431372549, 0.133333333333333, 0.133333333333333, 
	0.137254901960784, 0.137254901960784, 0.419607843137255, 
	0.419607843137255, 0.549019607843137, 0.666666666666667, 
	0.666666666666667, 0.823529411764706, 0.823529411764706, 
	0.87843137254902, 0.87843137254902, 0, 0, 0.509803921568627, 
	0.509803921568627, 0.125490196078431, 0.0431372549019608, 
	0.0431372549019608, 0.56078431372549, 0.56078431372549, 
	0.36078431372549, 0.36078431372549, 0.0745098039215686, 
	0.0745098039215686, 0.176470588235294, 0.247058823529412, 
	0.529411764705882, 0.862745098039216, 0.701960784313725, 
	0.376470588235294, 0.376470588235294, 0.549019607843137, 
	0.117647058823529, 0.133333333333333, 0.164705882352941, 
	0.47843137254902, 0.47843137254902, 0.447058823529412, 0.47843137254902,
	0.47843137254902, 0, 0, 0, 0.313725490196078, 0.501960784313725, 
	0.501960784313725, 0.27843137254902, 0, 0, 0, 0.705882352941177, 
	0.705882352941177, 0.576470588235294, 0.576470588235294, 
	0.796078431372549, 0.756862745098039, 0.756862745098039, 
	0.576470588235294, 0.576470588235294, 0.376470588235294, 
	0.52156862745098, 0.52156862745098, 0.564705882352941, 
	0.564705882352941, 1, 0.933333333333333, 0.866666666666667, 
	0.83921568627451, 0.827450980392157, 0.827450980392157, 0.8, 0.8, 
	0.827450980392157, 0.827450980392157, 0.886274509803922, 
	0.886274509803922, 0.941176470588235, 0.858823529411765, 
	0.858823529411765, 0.847058823529412, 0.980392156862745, 
	0.913725490196078, 0.788235294117647, 0.537254901960784, 
	0.933333333333333, 0.870588235294118, 0.749019607843137, 
	0.509803921568627, 0.858823529411765, 0.8, 0.690196078431373, 
	0.470588235294118, 0.768627450980392, 0.717647058823529, 
	0.619607843137255, 0.419607843137255, 0.725490196078431, 
	0.67843137254902, 0.584313725490196, 0.396078431372549, 
	0.67843137254902, 0.631372549019608, 0.545098039215686, 
	0.368627450980392, 0.803921568627451, 0.749019607843137, 
	0.647058823529412, 0.43921568627451, 0.862745098039216, 
	0.803921568627451, 0.694117647058824, 0.470588235294118, 
	0.941176470588235, 0.87843137254902, 0.756862745098039, 
	0.513725490196078, 0.941176470588235, 0.87843137254902, 
	0.756862745098039, 0.513725490196078, 0.96078431372549, 
	0.898039215686275, 0.772549019607843, 0.525490196078431, 
	0.882352941176471, 0.823529411764706, 0.709803921568627, 
	0.482352941176471, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 0.831372549019608, 0.776470588235294, 
	0.666666666666667, 0.454901960784314, 0.756862745098039, 
	0.705882352941177, 0.607843137254902, 0.411764705882353, 
	0.623529411764706, 0.580392156862745, 0.501960784313725, 
	0.341176470588235, 0.603921568627451, 0.564705882352941, 
	0.486274509803922, 0.329411764705882, 0.498039215686275, 
	0.462745098039216, 0.4, 0.270588235294118, 0, 0, 0, 0, 0, 0, 0, 0, 
	0.243137254901961, 0.227450980392157, 0.196078431372549, 
	0.133333333333333, 0.43921568627451, 0.407843137254902, 
	0.352941176470588, 0.23921568627451, 0.56078431372549, 0.52156862745098,
	0.450980392156863, 0.305882352941176, 0.545098039215686, 
	0.509803921568627, 0.43921568627451, 0.298039215686275, 
	0.87843137254902, 0.819607843137255, 0.705882352941177, 
	0.47843137254902, 0, 0, 0, 0, 0, 0, 0, 0, 0.145098039215686, 
	0.133333333333333, 0.113725490196078, 0.0784313725490196, 
	0.0588235294117647, 0.0549019607843137, 0.0470588235294118, 
	0.0313725490196078, 0.756862745098039, 0.705882352941177, 
	0.607843137254902, 0.411764705882353, 0.415686274509804, 
	0.388235294117647, 0.333333333333333, 0.227450980392157, 
	0.27843137254902, 0.258823529411765, 0.223529411764706, 
	0.149019607843137, 0.607843137254902, 0.568627450980392, 
	0.490196078431373, 0.333333333333333, 0.729411764705882, 
	0.682352941176471, 0.588235294117647, 0.4, 0.309803921568627, 
	0.286274509803922, 0.247058823529412, 0.168627450980392, 
	0.141176470588235, 0.129411764705882, 0.113725490196078, 
	0.0745098039215686, 0.188235294117647, 0.172549019607843, 
	0.149019607843137, 0.101960784313725, 0.250980392156863, 
	0.231372549019608, 0.2, 0.137254901960784, 0.411764705882353, 
	0.384313725490196, 0.329411764705882, 0.223529411764706, 
	0.47843137254902, 0.447058823529412, 0.384313725490196, 
	0.258823529411765, 0, 0, 0, 0, 0, 0, 0, 0, 0.337254901960784, 
	0.313725490196078, 0.270588235294118, 0.184313725490196, 
	0.27843137254902, 0.258823529411765, 0.223529411764706, 
	0.149019607843137, 0, 0, 0, 0, 0, 0, 0, 0, 0.576470588235294, 
	0.537254901960784, 0.462745098039216, 0.313725490196078, 
	0.705882352941177, 0.654901960784314, 0.564705882352941, 
	0.384313725490196, 0.772549019607843, 0.72156862745098, 
	0.619607843137255, 0.423529411764706, 0.725490196078431, 
	0.67843137254902, 0.584313725490196, 0.396078431372549, 
	0.670588235294118, 0.623529411764706, 0.537254901960784, 
	0.364705882352941, 0.701960784313725, 0.654901960784314, 
	0.564705882352941, 0.384313725490196, 0.588235294117647, 
	0.549019607843137, 0.470588235294118, 0.32156862745098, 1, 
	0.933333333333333, 0.803921568627451, 0.545098039215686, 
	0.980392156862745, 0.913725490196078, 0.788235294117647, 
	0.537254901960784, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 1, 0.933333333333333, 0.803921568627451, 
	0.545098039215686, 0, 0, 0.0117647058823529, 0.0117647058823529, 
	0.0196078431372549, 0.0196078431372549, 0.0313725490196078, 
	0.0313725490196078, 0.0392156862745098, 0.0392156862745098, 
	0.0509803921568627, 0.0509803921568627, 0.0588235294117647, 
	0.0588235294117647, 0.0705882352941176, 0.0705882352941176, 
	0.0784313725490196, 0.0784313725490196, 0.0901960784313725, 
	0.0901960784313725, 0.101960784313725, 0.101960784313725, 
	0.109803921568627, 0.109803921568627, 0.12156862745098, 
	0.12156862745098, 0.129411764705882, 0.129411764705882, 
	0.141176470588235, 0.141176470588235, 0.149019607843137, 
	0.149019607843137, 0.16078431372549, 0.16078431372549, 
	0.168627450980392, 0.168627450980392, 0.180392156862745, 
	0.180392156862745, 0.188235294117647, 0.188235294117647, 0.2, 0.2, 
	0.211764705882353, 0.211764705882353, 0.219607843137255, 
	0.219607843137255, 0.231372549019608, 0.231372549019608, 
	0.23921568627451, 0.23921568627451, 0.250980392156863, 
	0.250980392156863, 0.258823529411765, 0.258823529411765, 
	0.270588235294118, 0.270588235294118, 0.27843137254902, 
	0.27843137254902, 0.290196078431373, 0.290196078431373, 
	0.301960784313725, 0.301960784313725, 0.309803921568627, 
	0.309803921568627, 0.32156862745098, 0.32156862745098, 
	0.329411764705882, 0.329411764705882, 0.341176470588235, 
	0.341176470588235, 0.349019607843137, 0.349019607843137, 
	0.36078431372549, 0.36078431372549, 0.368627450980392, 
	0.368627450980392, 0.380392156862745, 0.380392156862745, 
	0.388235294117647, 0.388235294117647, 0.4, 0.4, 0.411764705882353, 
	0.411764705882353, 0.419607843137255, 0.419607843137255, 
	0.431372549019608, 0.431372549019608, 0.43921568627451, 
	0.43921568627451, 0.450980392156863, 0.450980392156863, 
	0.458823529411765, 0.458823529411765, 0.470588235294118, 
	0.470588235294118, 0.47843137254902, 0.47843137254902, 
	0.490196078431373, 0.490196078431373, 0.498039215686275, 
	0.498039215686275, 0.509803921568627, 0.509803921568627, 
	0.52156862745098, 0.52156862745098, 0.529411764705882, 
	0.529411764705882, 0.541176470588235, 0.541176470588235, 
	0.549019607843137, 0.549019607843137, 0.56078431372549, 
	0.56078431372549, 0.568627450980392, 0.568627450980392, 
	0.580392156862745, 0.580392156862745, 0.588235294117647, 
	0.588235294117647, 0.6, 0.6, 0.611764705882353, 0.611764705882353, 
	0.619607843137255, 0.619607843137255, 0.631372549019608, 
	0.631372549019608, 0.63921568627451, 0.63921568627451, 
	0.650980392156863, 0.650980392156863, 0.658823529411765, 
	0.658823529411765, 0.670588235294118, 0.670588235294118, 
	0.67843137254902, 0.67843137254902, 0.690196078431373, 
	0.690196078431373, 0.701960784313725, 0.701960784313725, 
	0.709803921568627, 0.709803921568627, 0.72156862745098, 
	0.72156862745098, 0.729411764705882, 0.729411764705882, 
	0.741176470588235, 0.741176470588235, 0.749019607843137, 
	0.749019607843137, 0.76078431372549, 0.76078431372549, 
	0.768627450980392, 0.768627450980392, 0.780392156862745, 
	0.780392156862745, 0.788235294117647, 0.788235294117647, 0.8, 0.8, 
	0.811764705882353, 0.811764705882353, 0.819607843137255, 
	0.819607843137255, 0.831372549019608, 0.831372549019608, 
	0.83921568627451, 0.83921568627451, 0.850980392156863, 
	0.850980392156863, 0.858823529411765, 0.858823529411765, 
	0.870588235294118, 0.870588235294118, 0.87843137254902, 
	0.87843137254902, 0.890196078431372, 0.890196078431372, 
	0.898039215686275, 0.898039215686275, 0.909803921568627, 
	0.909803921568627, 0.92156862745098, 0.92156862745098, 
	0.929411764705882, 0.929411764705882, 0.941176470588235, 
	0.941176470588235, 0.949019607843137, 0.949019607843137, 
	0.96078431372549, 0.96078431372549, 0.968627450980392, 
	0.968627450980392, 0.980392156862745, 0.980392156862745, 
	0.988235294117647, 0.988235294117647, 1, 1), .Dim = c(738, 3), 
	.Dimnames = list(c("snow", "ghost white", "GhostWhite", "white smoke", 
	"WhiteSmoke", "gainsboro", "floral white", "FloralWhite", "old lace", 
	"OldLace", "linen", "antique white", "AntiqueWhite", "papaya whip", 
	"PapayaWhip", "blanched almond", "BlanchedAlmond", "bisque", 
	"peach puff", "PeachPuff", "navajo white", "NavajoWhite", "moccasin", 
	"cornsilk", "ivory", "lemon chiffon", "LemonChiffon", "seashell", 
	"honeydew", "mint cream", "MintCream", "azure", "alice blue", 
	"AliceBlue", "lavender", "lavender blush", "LavenderBlush", 
	"misty rose", "MistyRose", "white", "black", "dark slate gray", 
	"DarkSlateGray", "dark slate grey", "DarkSlateGrey", "dim gray", 
	"DimGray", "dim grey", "DimGrey", "slate gray", "SlateGray", 
	"slate grey", "SlateGrey", "light slate gray", "LightSlateGray", 
	"light slate grey", "LightSlateGrey", "gray", "grey", "light grey", 
	"LightGrey", "light gray", "LightGray", "midnight blue", "MidnightBlue",
	"navy", "navy blue", "NavyBlue", "cornflower blue", "CornflowerBlue", 
	"dark slate blue", "DarkSlateBlue", "slate blue", "SlateBlue", 
	"medium slate blue", "MediumSlateBlue", "light slate blue", 
	"LightSlateBlue", "medium blue", "MediumBlue", "royal blue", 
	"RoyalBlue", "blue", "dodger blue", "DodgerBlue", "deep sky blue", 
	"DeepSkyBlue", "sky blue", "SkyBlue", "light sky blue", "LightSkyBlue", 
	"steel blue", "SteelBlue", "light steel blue", "LightSteelBlue", 
	"light blue", "LightBlue", "powder blue", "PowderBlue", 
	"pale turquoise", "PaleTurquoise", "dark turquoise", "DarkTurquoise", 
	"medium turquoise", "MediumTurquoise", "turquoise", "cyan", 
	"light cyan", "LightCyan", "cadet blue", "CadetBlue", 
	"medium aquamarine", "MediumAquamarine", "aquamarine", "dark green", 
	"DarkGreen", "dark olive green", "DarkOliveGreen", "dark sea green", 
	"DarkSeaGreen", "sea green", "SeaGreen", "medium sea green", 
	"MediumSeaGreen", "light sea green", "LightSeaGreen", "pale green", 
	"PaleGreen", "spring green", "SpringGreen", "lawn green", "LawnGreen", 
	"green", "chartreuse", "medium spring green", "MediumSpringGreen", 
	"green yellow", "GreenYellow", "lime green", "LimeGreen", 
	"yellow green", "YellowGreen", "forest green", "ForestGreen", 
	"olive drab", "OliveDrab", "dark khaki", "DarkKhaki", "khaki", 
	"pale goldenrod", "PaleGoldenrod", "light goldenrod yellow", 
	"LightGoldenrodYellow", "light yellow", "LightYellow", "yellow", "gold",
	"light goldenrod", "LightGoldenrod", "goldenrod", "dark goldenrod", 
	"DarkGoldenrod", "rosy brown", "RosyBrown", "indian red", "IndianRed", 
	"saddle brown", "SaddleBrown", "sienna", "peru", "burlywood", "beige", 
	"wheat", "sandy brown", "SandyBrown", "tan", "chocolate", "firebrick", 
	"brown", "dark salmon", "DarkSalmon", "salmon", "light salmon", 
	"LightSalmon", "orange", "dark orange", "DarkOrange", "coral", 
	"light coral", "LightCoral", "tomato", "orange red", "OrangeRed", "red",
	"hot pink", "HotPink", "deep pink", "DeepPink", "pink", "light pink", 
	"LightPink", "pale violet red", "PaleVioletRed", "maroon", 
	"medium violet red", "MediumVioletRed", "violet red", "VioletRed", 
	"magenta", "violet", "plum", "orchid", "medium orchid", "MediumOrchid", 
	"dark orchid", "DarkOrchid", "dark violet", "DarkViolet", "blue violet",
	"BlueViolet", "purple", "medium purple", "MediumPurple", "thistle", 
	"snow1", "snow2", "snow3", "snow4", "seashell1", "seashell2", 
	"seashell3", "seashell4", "AntiqueWhite1", "AntiqueWhite2", 
	"AntiqueWhite3", "AntiqueWhite4", "bisque1", "bisque2", "bisque3", 
	"bisque4", "PeachPuff1", "PeachPuff2", "PeachPuff3", "PeachPuff4", 
	"NavajoWhite1", "NavajoWhite2", "NavajoWhite3", "NavajoWhite4", 
	"LemonChiffon1", "LemonChiffon2", "LemonChiffon3", "LemonChiffon4", 
	"cornsilk1", "cornsilk2", "cornsilk3", "cornsilk4", "ivory1", "ivory2", 
	"ivory3", "ivory4", "honeydew1", "honeydew2", "honeydew3", "honeydew4", 
	"LavenderBlush1", "LavenderBlush2", "LavenderBlush3", "LavenderBlush4", 
	"MistyRose1", "MistyRose2", "MistyRose3", "MistyRose4", "azure1", 
	"azure2", "azure3", "azure4", "SlateBlue1", "SlateBlue2", "SlateBlue3", 
	"SlateBlue4", "RoyalBlue1", "RoyalBlue2", "RoyalBlue3", "RoyalBlue4", 
	"blue1", "blue2", "blue3", "blue4", "DodgerBlue1", "DodgerBlue2", 
	"DodgerBlue3", "DodgerBlue4", "SteelBlue1", "SteelBlue2", "SteelBlue3", 
	"SteelBlue4", "DeepSkyBlue1", "DeepSkyBlue2", "DeepSkyBlue3", 
	"DeepSkyBlue4", "SkyBlue1", "SkyBlue2", "SkyBlue3", "SkyBlue4", 
	"LightSkyBlue1", "LightSkyBlue2", "LightSkyBlue3", "LightSkyBlue4", 
	"SlateGray1", "SlateGray2", "SlateGray3", "SlateGray4", 
	"LightSteelBlue1", "LightSteelBlue2", "LightSteelBlue3", 
	"LightSteelBlue4", "LightBlue1", "LightBlue2", "LightBlue3", 
	"LightBlue4", "LightCyan1", "LightCyan2", "LightCyan3", "LightCyan4", 
	"PaleTurquoise1", "PaleTurquoise2", "PaleTurquoise3", "PaleTurquoise4", 
	"CadetBlue1", "CadetBlue2", "CadetBlue3", "CadetBlue4", "turquoise1", 
	"turquoise2", "turquoise3", "turquoise4", "cyan1", "cyan2", "cyan3", 
	"cyan4", "DarkSlateGray1", "DarkSlateGray2", "DarkSlateGray3", 
	"DarkSlateGray4", "aquamarine1", "aquamarine2", "aquamarine3", 
	"aquamarine4", "DarkSeaGreen1", "DarkSeaGreen2", "DarkSeaGreen3", 
	"DarkSeaGreen4", "SeaGreen1", "SeaGreen2", "SeaGreen3", "SeaGreen4", 
	"PaleGreen1", "PaleGreen2", "PaleGreen3", "PaleGreen4", "SpringGreen1", 
	"SpringGreen2", "SpringGreen3", "SpringGreen4", "green1", "green2", 
	"green3", "green4", "chartreuse1", "chartreuse2", "chartreuse3", 
	"chartreuse4", "OliveDrab1", "OliveDrab2", "OliveDrab3", "OliveDrab4", 
	"DarkOliveGreen1", "DarkOliveGreen2", "DarkOliveGreen3", 
	"DarkOliveGreen4", "khaki1", "khaki2", "khaki3", "khaki4", 
	"LightGoldenrod1", "LightGoldenrod2", "LightGoldenrod3", 
	"LightGoldenrod4", "LightYellow1", "LightYellow2", "LightYellow3", 
	"LightYellow4", "yellow1", "yellow2", "yellow3", "yellow4", "gold1", 
	"gold2", "gold3", "gold4", "goldenrod1", "goldenrod2", "goldenrod3", 
	"goldenrod4", "DarkGoldenrod1", "DarkGoldenrod2", "DarkGoldenrod3", 
	"DarkGoldenrod4", "RosyBrown1", "RosyBrown2", "RosyBrown3", 
	"RosyBrown4", "IndianRed1", "IndianRed2", "IndianRed3", "IndianRed4", 
	"sienna1", "sienna2", "sienna3", "sienna4", "burlywood1", "burlywood2", 
	"burlywood3", "burlywood4", "wheat1", "wheat2", "wheat3", "wheat4", 
	"tan1", "tan2", "tan3", "tan4", "chocolate1", "chocolate2", 
	"chocolate3", "chocolate4", "firebrick1", "firebrick2", "firebrick3", 
	"firebrick4", "brown1", "brown2", "brown3", "brown4", "salmon1", 
	"salmon2", "salmon3", "salmon4", "LightSalmon1", "LightSalmon2", 
	"LightSalmon3", "LightSalmon4", "orange1", "orange2", "orange3", 
	"orange4", "DarkOrange1", "DarkOrange2", "DarkOrange3", "DarkOrange4", 
	"coral1", "coral2", "coral3", "coral4", "tomato1", "tomato2", "tomato3",
	"tomato4", "OrangeRed1", "OrangeRed2", "OrangeRed3", "OrangeRed4", 
	"red1", "red2", "red3", "red4", "DeepPink1", "DeepPink2", "DeepPink3", 
	"DeepPink4", "HotPink1", "HotPink2", "HotPink3", "HotPink4", "pink1", 
	"pink2", "pink3", "pink4", "LightPink1", "LightPink2", "LightPink3", 
	"LightPink4", "PaleVioletRed1", "PaleVioletRed2", "PaleVioletRed3", 
	"PaleVioletRed4", "maroon1", "maroon2", "maroon3", "maroon4", 
	"VioletRed1", "VioletRed2", "VioletRed3", "VioletRed4", "magenta1", 
	"magenta2", "magenta3", "magenta4", "orchid1", "orchid2", "orchid3", 
	"orchid4", "plum1", "plum2", "plum3", "plum4", "MediumOrchid1", 
	"MediumOrchid2", "MediumOrchid3", "MediumOrchid4", "DarkOrchid1", 
	"DarkOrchid2", "DarkOrchid3", "DarkOrchid4", "purple1", "purple2", 
	"purple3", "purple4", "MediumPurple1", "MediumPurple2", "MediumPurple3",
	"MediumPurple4", "thistle1", "thistle2", "thistle3", "thistle4", 
	"gray0", "grey0", "gray1", "grey1", "gray2", "grey2", "gray3", "grey3", 
	"gray4", "grey4", "gray5", "grey5", "gray6", "grey6", "gray7", "grey7", 
	"gray8", "grey8", "gray9", "grey9", "gray10", "grey10", "gray11", 
	"grey11", "gray12", "grey12", "gray13", "grey13", "gray14", "grey14", 
	"gray15", "grey15", "gray16", "grey16", "gray17", "grey17", "gray18", 
	"grey18", "gray19", "grey19", "gray20", "grey20", "gray21", "grey21", 
	"gray22", "grey22", "gray23", "grey23", "gray24", "grey24", "gray25", 
	"grey25", "gray26", "grey26", "gray27", "grey27", "gray28", "grey28", 
	"gray29", "grey29", "gray30", "grey30", "gray31", "grey31", "gray32", 
	"grey32", "gray33", "grey33", "gray34", "grey34", "gray35", "grey35", 
	"gray36", "grey36", "gray37", "grey37", "gray38", "grey38", "gray39", 
	"grey39", "gray40", "grey40", "gray41", "grey41", "gray42", "grey42", 
	"gray43", "grey43", "gray44", "grey44", "gray45", "grey45", "gray46", 
	"grey46", "gray47", "grey47", "gray48", "grey48", "gray49", "grey49", 
	"gray50", "grey50", "gray51", "grey51", "gray52", "grey52", "gray53", 
	"grey53", "gray54", "grey54", "gray55", "grey55", "gray56", "grey56", 
	"gray57", "grey57", "gray58", "grey58", "gray59", "grey59", "gray60", 
	"grey60", "gray61", "grey61", "gray62", "grey62", "gray63", "grey63", 
	"gray64", "grey64", "gray65", "grey65", "gray66", "grey66", "gray67", 
	"grey67", "gray68", "grey68", "gray69", "grey69", "gray70", "grey70", 
	"gray71", "grey71", "gray72", "grey72", "gray73", "grey73", "gray74", 
	"grey74", "gray75", "grey75", "gray76", "grey76", "gray77", "grey77", 
	"gray78", "grey78", "gray79", "grey79", "gray80", "grey80", "gray81", 
	"grey81", "gray82", "grey82", "gray83", "grey83", "gray84", "grey84", 
	"gray85", "grey85", "gray86", "grey86", "gray87", "grey87", "gray88", 
	"grey88", "gray89", "grey89", "gray90", "grey90", "gray91", "grey91", 
	"gray92", "grey92", "gray93", "grey93", "gray94", "grey94", "gray95", 
	"grey95", "gray96", "grey96", "gray97", "grey97", "gray98", "grey98", 
	"gray99", "grey99", "gray100", "grey100"), c("Red", "Green", "Blue")))

setps <- function(filename, w=0, h=3, pointsize=10, sublines=0, toplines=0,
		type="symbol", lwd=2, font='Helvetica',
		leftlines=0, las=1, 
		trellis=!(missing(setTrellis.) & missing(strip.blank) &
				  missing(lty.dot.line) & missing(lwd.dot.line)), 
		setTrellis.=TRUE, 
		strip.blank = TRUE, lty.dot.line = 1, lwd.dot.line = 1,
		seqno=NULL, color=FALSE) {

  filebase <- if(type=='char') filename else as.character(substitute(filename))
  if(length(seqno)) filebase <- paste(filebase,seqno,sep='')
  filename <- paste(filebase,'.ps',sep='')
  if(length(.Options$setpsPrefix))
    filename <- paste(.Options$setpsPrefix, filename, sep='')

#Changed after submission to s-news: pointsize=NULL
#Antonio likes the default
#ratio of width/height to be the "golden ratio", which is the default.
#I often prefer a smaller ratio of 1.4. If exactly one of (width, height)
#is zero, the "ratio" is used to replace it based on the one specified.
#For a single figure in the plot I usually use psfig(filename,height=3).
#For a single figure in the plot I usually use psfig(filename,height=3).
#The logic in psfig assumes that one figure is being drawn, i.e., that
#par(mfrow=c(1,1)) is in effect. It will work for multiple plots if you
#set pointsize to something like 9.
#sublines specifies the number of extra lines to leave at the bottom of
#the plot for subtitles.
#
#   I include an S function that sets the stage for EPS graphics
#generation that will be incorporated by TeX (LaTeX, etc.), and that
#does a little of what you want, by hand, not in the smart way you
#envision.
#  Note that this function intentionally disallows main titles, with
#the understanding that they will be part of the figure's caption,
#which TeX itself generates. You may like to use it as starting point
#to get something that suits your needs.
#
#  - Antonio Possolo
#
#       Applied Mathematics & Statistics
#       The Boeing Company
#                          antonio@atc.boeing.com
#
#
#Added else scale <-   FEH 8Sep92, also added arg "ratio",
#commented out warning message for omitting main title,
#added arg sublines, pointsize
#may want to specify pointsize=9 if multiple plots used
#added lwd FEH 27Oct92
#added toplines FEH 18Oct93
#override fonts spec to ps.options because of bug - FEH 21Apr94
#added bty="l" FEH 24Aug94
#added leftlines FEH 26Aug94
#added onefile 27Feb95
#maden font default to Helvetica 25Mar00
#Doug Bates just does this:
#a) use postscript(filename, height=xx, width=yy, pointsize=10)
#b) change the figure's region on the page by using
#   par (mar=c(3.5, 3.5, 1.5, 0.5))  ## for example and perhaps also
#   par (mgp=c(2.5, 0.5, 0))
#
  # added color=FALSE 7feb03
psfig <-
function(file = "", width = 0, height = 0, ratio= (1 + sqrt(5))/2,
		 font = 'Helvetica', 
		 pointsize=NULL, sublines=0, 
		 toplines=0, leftlines=0, lwd=0.5, bty="l", onefile=FALSE, 
		 las=NULL, trellis=FALSE, color=FALSE) {

#	POSTSCRIPT FIGURE MAKER
#	for incorporation into TeX using PSFIG or BoxedEPSF.
#	The strategy is to create a pleasant aspect ratio, 
#	while minimizing white space around the figure.
#
# Aspect ratio is Golden Ratio
# Standard width is 30 picas = 30*12/(72.27) inches
	StandardWidth <- (30 * 12)/(72.27)
	StandardHeight <- StandardWidth/ratio
	StandardPointSize <- 9
	if ( width == 0 & height == 0 ) 
		{ 
		width <- StandardWidth
		height <- StandardHeight
		scale <- 1
		}
	if ( width > 0 & height == 0 ) 
		{ 
		height <- width/ratio
		scale <- width/StandardWidth
		}
	if ( width == 0 & height > 0 ) 
		{ 
		width <- height*ratio
		scale <- width/StandardWidth
		}
	else scale <- max(width/StandardWidth,height/StandardHeight)

	if(!length(pointsize)) pointsize <- round(scale * StandardPointSize)
#
#	FONTS & FONT SELECTION
#
#  1 Helvetica               19 Bookman-DemiItalic
#  2 Courier                 20 Bookman-Light
#  3 Times-Roman             21 Bookman-LightItalic
#  4 Helvetica-Oblique       22 Helvetica-Narrow
#  5 Helvetica-Bold          23 Helvetica-Narrow-Bold
#  6 Helvetica-BoldOblique   24 Helvetica-Narrow-BoldOblique
#  7 Courier-Oblique         25 Helvetica-Narrow-Oblique
#  8 Courier-Bold            26 NewCenturySchlbk-Roman
#  9 Courier-BoldOblique     27 NewCenturySchlbk-Bold
# 10 Times-Italic            28 NewCenturySchlbk-Italic
# 11 Times-Bold              29 NewCenturySchlbk-BoldItalic
# 12 Times-BoldItalic        30 Palatino-Roman
# 13 Symbol                  31 Palatino-Bold
# 14 AvantGarde-Book         32 Palatino-Italic
# 15 AvantGarde-BookOblique  33 Palatino-BoldItalic
# 16 AvantGarde-Demi         34 ZapfChancery-MediumItalic
# 17 AvantGarde-DemiOblique  35 ZapfDingbats
# 18 Bookman-Demi           
#
    if(!.R.) {
      ps.fonts <- if(under.unix)ps.options()$fonts else ps.fonts

      if(is.numeric(font)) {  # was is.number 10Apr01
		fontNumber <- font
		if(fontNumber < 1 | fontNumber > length(ps.fonts)) {
          fontNumber <- 1
          cat(paste(
                    "\tPSFIG WARNING: Font requested is not available\n",
                    "\t\tSubstituted by Helvetica\n"))
		}
      }
      else {
		fontName <- font
		fontNumber <- match(fontName, ps.fonts)
		if(is.na(fontNumber)) {
          fontNumber <- 1
          cat(paste(
                    "\tPSFIG WARNING: Font requested is not available\n",
                    "\t\tSubstituted by Helvetica\n"))
		}
      }
	if(under.unix) {
     ## do.call 21Oct99 - problem with lazy eval in unix
	  if(trellis)
        do.call('trellis.device',
                list(device='postscript', file=file,
                     horizontal = FALSE, width = width, height = height,
                     pointsize = pointsize, fonts=ps.fonts[fontNumber],
                     font = 1, maximize=TRUE, onefile=onefile,
                     print.it=FALSE, color=color)) else
	  postscript(file = file, horizontal = FALSE, width = width, height = height,
		pointsize = pointsize, fonts=ps.fonts[fontNumber], font = 1, 
		maximize=TRUE, onefile=onefile, print.it=FALSE)	
        # was font=fontNumber, fonts omitted - bug
	}
	else {
	  if(trellis)
        do.call('trellis.device',
                list(device='postscript',
                     file = file, horizontal = FALSE, width = width,
                     height = height,
                     pointsize = pointsize,
                     fonts=ps.fonts[fontNumber],
                     font = 1, color=color)) else
	  postscript(file = file, horizontal = FALSE, width = width, height = height,
		pointsize = pointsize, fonts=ps.fonts[fontNumber], font = 1)
	}

#
#	PLOT DESIGN
#	Lines are 1pt wide, which is half standard width
#	(LWD is interpreted in units of 1/36 inch
#	 LWD=0 yields the thinnest possible line on the device)
#	Axis labels closer to axes than default 
#	(MGP: margin line for the axis title, axis labels, 
#	 and axis line in units of MEX)
#	Margin widths narrower than default
#	(MAR: bottom, left, top, right)
	if(trellis) return(invisible())
    } else {   # 10Apr01
      if(trellis) do.call('trellis.device',
                          list(device='postscript',
                               file = file, horizontal = FALSE,
                               width = width, height = height,
                               pointsize = pointsize,
                               family=font, color=color, paper='special',
                               bg=if(!color)'white' else NULL)) else
	  postscript(file = file, horizontal = FALSE, width = width, height = height,
                 pointsize = pointsize, family=font,
                 onefile=onefile, print.it=FALSE, paper='special')	
    }
    if(.R.) par(lwd=lwd, mgp=c(2.2,.45,0), tcl=-0.4,
                mar=c(3+sublines+.25*(sublines>0),3.5+leftlines,
                      1+toplines,1)+.1, bty=bty) else
    par(lwd=lwd, mgp=c(2,.4,0),
        mar=c(3+sublines+.25*(sublines>0),3+leftlines,
              1+toplines, 1)+.1, bty=bty)
    ## was mgp=c(2, 0.5, 0) 11Jan01  c(2.5,.6,0) R c(2,.4,0) S+ 27jan03
	#	SMO is number of rasters that the piecewise linear
#	approximation to a curve is allowed to differ from the exact
#	position of the curve.
	par(smo = 0)	#	PLOTTING SYMBOL
#	PCH  selects plotting characters from Standard Encoding
#	(PostScript Language Reference Manual, p.252)
#	168 = currency
#	180 = centered period
#	183 = bullet (with a negative font parameter yields a circle)
	par(pch = 1)	# was 183 11Jan01
# MAIN TITLE not allowed: plot will be described in figure caption, 
#	handled by TeX itself.
#	cat(paste("\tPSFIG WARNING:", "Do not use high-level parameter MAIN\n",
#		"\t\tFigure caption should be created within LaTeX\n"))	#
	if(length(las)) par(las=las)
	invisible()
}

  psfig(filename, h=h, w=w, ratio=1.4, 
        pointsize=pointsize,sublines=sublines,toplines=toplines,
        lwd=lwd,font=font,leftlines=leftlines, las=las,
        trellis=trellis, color=color)  # color= 7feb03
          
  if(trellis && setTrellis.) setTrellis(strip.blank = strip.blank, 
     lty.dot.line = lty.dot.line, lwd.dot.line = lwd.dot.line)

	topdf <- function(filebase) {
	  cmd <- if(under.unix)'gs' else 'gswin32c'
	  cmd <- paste(cmd,' -q -dNOPAUSE -dBATCH -sDEVICE#pdfwrite -sOutputFile#',filebase,'.pdf -c save pop -f ',filebase,'.ps',sep='')
	  sys(cmd)
	  invisible()
	}
  formals(topdf) <- list(filebase=filebase)
  storeTemp(topdf)
  invisible()
}


setpdf <- function(filename, w=0, h=4, pointsize=10, sublines=0, toplines=0,
				   type="symbol", lwd=1.5,
                   font=if(.R.)'Helvetica' else 1,
                   ratio= if(.R.) 4/3 else (1 + sqrt(5))/2,
				   leftlines=0, las=1, bty='l', hor=FALSE,
                   trellis=!(missing(setTrellis.) & missing(strip.blank) &
                             missing(lty.dot.line) & missing(lwd.dot.line)), 
                   setTrellis.=TRUE, 
                   strip.blank = TRUE, lty.dot.line = 1, lwd.dot.line =1,
                   region=c(0, 0, h, w), color=FALSE, seqno=NULL, ...) {

  if(type=="char") filename <- paste(filename,seqno,".pdf",sep="") else
  filename <- paste(substitute(filename),seqno,".pdf",sep="")
  if(length(.Options$setpdfPrefix))
    filename <- paste(.Options$setpdfPrefix, filename, sep='')

  if (w > 0 & h == 0) h <- w/ratio
  if (w == 0 & h > 0) w <- h*ratio
  if(.R.) {
    if(trellis) trellis.device('pdf', file=filename, width=w, height=h,
                               pointsize=pointsize, family=font,
                               color=color,onefile=FALSE,
                               bg=ifelse(color,NULL,'white')) else
                pdf(filename, width=w, height=h, pointsize=pointsize,
                    family=font,onefile=FALSE)
  } else {
    if(trellis) trellis.device('pdf.graph', file=filename,
                               horizontal=hor, width=w, height=h,
                               pointsize=pointsize, font=font,
                               region=region,
                               color=color) else
    pdf.graph(filename, horizontal=hor, width=w, height=h,
              pointsize=pointsize, font=font, region=region,
              color=color)
  }
  if(!trellis) {
    if(.R.) par(lwd=lwd, mgp=c(2.2,.45,0), tcl=-0.4,
                mar=c(3+sublines+.25*(sublines>0),3.5+leftlines,
                      1+toplines,1)+.1, bty=bty) else
    par(lwd=lwd, mgp=c(2,.4,0),
        mar=c(3+sublines+.25*(sublines>0),3+leftlines,
              1+toplines, 1)+.1, bty=bty)

    ## was mgp=c(2.5,.6,0) R c(2,.6,0) S+ 27jan03
    par(smo = 0)
  }
  if(length(las)) par(las=las)
  if(trellis && setTrellis.)
    setTrellis(strip.blank = strip.blank, 
               lty.dot.line = lty.dot.line, lwd.dot.line = lwd.dot.line)
  invisible()
}

tex  <-  function(string, lref='c', psref='c', scale=1, srt=0) 
  paste('\\tex[',lref,'][',psref,'][',
        format(scale),'][',format(srt),']{',string,'}',sep='')

showPsfrag <- function(filename) {
  file <- paste(as.character(substitute(filename)),'ps',sep='.')
  out <- "TEMPltx"
  cat('\\documentclass{article}',
      '\\usepackage{graphics}',
      '\\usepackage[scanall]{psfrag}',
      '\\begin{document}',
      paste('\\includegraphics{',file,'}',sep=''),
      '\\end{document}',sep='\n', file=paste(out,'tex',sep='.'))
  sys(paste('latex "\\scrollmode\\input" ',out,';dvips -o ',out,'.ps ',out,
            '; gv ',out,'.ps  &',
            sep=''))
  unlink(paste(out,c('tex','log','dvi','ps','aux','pfg'),sep='.'))
  invisible()
}
