// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// Edited by Anirban Biswas <utpal@cal2.vsnl.net.in>
// This file is part of the hk_postgreclearsqlclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_postgresqlconnection.h"
#include <hk_postgresqldatabase.h>
#include <dlfcn.h>
#include "hk_drivermanager.h"
#include "hk_actionquery.h"

hk_postgresqlconnection::hk_postgresqlconnection(hk_drivermanager* c):hk_connection(c)
{
    p_SQL_Connection=NULL;
    set_tcp_port(default_tcp_port());
    set_host("");
    set_user("postgres");
    p_connectionsuccessfullyestablished=false;
}


hk_postgresqlconnection::~hk_postgresqlconnection()
{
//driver_specific_disconnect();
    if (p_SQL_Connection) PQfinish(p_SQL_Connection);
    p_SQL_Connection=NULL;
}


bool  hk_postgresqlconnection::driver_specific_connect()
{
//  char* db=0;
//  char* xunix_port=0;
    hk_string conn_info;
    if (!p_connected)
    {
        if (user().size()>0)
	{
	 conn_info="user=";
         conn_info+=user();
	}
	if (password().size()>0)
	{
	 conn_info+=" password='"+password()+"'";

	}
        conn_info+=" dbname=";
        conn_info+=p_postgresdatabase.size()==0?"template1":"'"+p_postgresdatabase+"'";
	if (host().size()>0)
	{
	 conn_info+=" host=";
         conn_info+=host();
         conn_info+=" port=";
         conn_info+=longint2string(tcp_port());
	}
        if (p_SQL_Connection!=NULL) PQfinish(p_SQL_Connection);
        p_SQL_Connection = PQconnectdb(conn_info.c_str());
        if(PQstatus(p_SQL_Connection) == CONNECTION_OK)
        {
            p_connected = true;
            p_connectionsuccessfullyestablished=true;
        }
        else
        {
            cerr << "NOT WORKING"<<endl;
            p_connected = false;
            if (p_connectionsuccessfullyestablished&&p_postgresdatabase.size()>0)
            {
//login was possible, but database name is wrong
//so try to connect again with the default databasename
                p_postgresdatabase="";
                driver_specific_connect();
                return false;
            }
        }

    }

    if (!p_connected)
        servermessage();

    return p_connected;

}


PGconn * hk_postgresqlconnection::dbhandler()
{
    return p_SQL_Connection;
}


void hk_postgresqlconnection::getdbhandler(PGconn *newconnection)
{
    p_SQL_Connection = newconnection;

}


bool hk_postgresqlconnection::driver_specific_disconnect()

{
    if (p_connected)
    {
        PQfinish(p_SQL_Connection);
        p_SQL_Connection=NULL;
        p_connected=false;

    }
    return p_connected;

}


vector<hk_string>* hk_postgresqlconnection::driver_specific_dblist(void)
{

    PGresult  * Res;
    p_databaselist.erase(p_databaselist.begin(),p_databaselist.end());

    if (p_connected)
    {

        Res=PQexec(dbhandler() , "SELECT datname FROM pg_database");
        if (  (PQresultStatus(Res)) == PGRES_TUPLES_OK )
        {
            for (int i=0 ; i < PQntuples(Res); i++)
            {
                p_databaselist.insert(p_databaselist.end(), PQgetvalue(Res , i , 0) );
            }
        }
        PQclear(Res);
    } else cerr <<"not connected"<<endl;
    ;
    return &p_databaselist;
}


hk_database* hk_postgresqlconnection::driver_specific_new_database(void)
{
    hk_postgresqldatabase* db;
    db = new hk_postgresqldatabase(this);
    return db;
}


bool hk_postgresqlconnection::server_supports(support_enum t) const
{
    switch (t)
    {
        case SUPPORTS_TRANSACTIONS:
        case SUPPORTS_DATETIMECOLUMN:
	case SUPPORTS_RENAME_DATABASE:
	case SUPPORTS_LOCAL_FILEFORMAT:
            return false;

        default : return true;
    }

}


bool hk_postgresqlconnection::server_needs(need_enum t) const
{
    switch (t)
    {
        case NEEDS_LOGIN:
        case NEEDS_HOST:
        case NEEDS_USERNAME:
        case NEEDS_PASSWORD:
        case NEEDS_PORT:
	case NEEDS_NULL_TERMINATED_SQL:
	case NEEDS_DATABASENAME:
             return true;

        default: return false;
    }

}


bool hk_postgresqlconnection::driver_specific_new_password(const hk_string& newpasswd)
{
    hk_postgresqldatabase* db=new hk_postgresqldatabase(this);
    hk_actionquery* p_q= db->driver_specific_new_actionquery();
    if (p_q==NULL) return false;
    hk_string pwdsql="ALTER USER ";
    pwdsql+=user();
    pwdsql+=" WITH PASSWORD '";
    pwdsql+=newpasswd;
    pwdsql+="'";
    p_q->set_sql(pwdsql.c_str(),pwdsql.size());
    bool result= p_q->execute();
    delete p_q;
    delete db;
    return result;

}


void hk_postgresqlconnection::servermessage(void)
{
    if (!p_SQL_Connection)return;
    set_last_servermessage(PQerrorMessage(p_SQL_Connection));
    cerr<< "Postgresql error message "<<PQerrorMessage(p_SQL_Connection)<<endl;
}


void    hk_postgresqlconnection::set_postgresdatabase(const hk_string& db)
{
    p_postgresdatabase=db;

}


hk_string hk_postgresqlconnection::drivername(void) const
{

    return "postgres";
}


unsigned int    hk_postgresqlconnection::default_tcp_port(void) const
{
    return 5432;
}


bool    hk_postgresqlconnection::driver_specific_delete_database(const hk_string& dbase)
{

if (database() && database()->name()==dbase)
{
   new_database("template1");
}
return hk_connection::driver_specific_delete_database(dbase);

}



//***********************************************************

hk_connection* create_connection(hk_drivermanager* cl)
{
    return new hk_postgresqlconnection(cl);
}


hk_string hk_classesversion(void)
{
return (hk_string)HK_VERSION;
}
