/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hlinkmgr.h,v 1.1.24.1 2004/07/09 01:51:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef HLINKMGR_H
#define HLINKMGR_H

// Forward declarations
typedef _INTERFACE IUnknown               IUnknown;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef enum _HXFocusContext             HXFocusContext;
class CHXSimpleList;

class PXHyperlink
{
public:
    PXHyperlink();
    virtual ~PXHyperlink();

    HXxRect     m_Rect;
    IHXBuffer* m_pLinkStr;
    UINT32      m_ulTabIndex;
    UINT32      m_ulLexicalOrder;
};

class PXHyperlinkManager : public CHXBaseCountingObject,
                           public IUnknown
{
public:
    PXHyperlinkManager();
    virtual ~PXHyperlinkManager();

    // IUnknown Methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID ID, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    // PXHyperlinkManager methods
    HX_RESULT Init(IUnknown* pContext, UINT32 ulW, UINT32 ulH);
    HX_RESULT SetDefaultLink(const char *pszDefaultLink);
    HX_RESULT AddLink(HXxRect cRect, const char* pszLink,
                      UINT32 ulTabIndex = 0, UINT32 ulLexicalOrder = 0);
    BOOL      GetActiveLink(INT16 sX, INT16 sY, INT32 lCurW, INT32 lCurH,
                            REF(IHXBuffer*) rpLinkStr);
    void      NavigateKeyboardFocus(HXFocusContext eFocus);
    BOOL      AnyLinkWithKeyboardFocus() const;
    BOOL      GetLinkWithKeyboardFocus(REF(HXxRect)     rRect,
                                       REF(IHXBuffer*) rpBuffer);
    void      ClearKeyboardFocus();
protected:
    INT32                   m_lRefCount;
    IHXCommonClassFactory* m_pCommonClassFactory;
    UINT32                  m_ulWidth;
    UINT32                  m_ulHeight;
    IHXBuffer*             m_pDefaultLinkStr;
    BOOL                    m_bHaveDefault;
    CHXSimpleList*          m_pLinkPairList;
    BOOL                    m_bSomeLinkHasKeyboardFocus;
    BOOL                    m_bDefaultLinkHasKeyboardFocus;
    PXHyperlink*            m_pKeyboardFocusLink;

    void ClearLinkPairList();
    BOOL GetFirstLink(REF(PXHyperlink*) rpLink);
    BOOL GetLastLink(REF(PXHyperlink*) rpLink);
    BOOL GetNextLink(PXHyperlink*      pCurLink,
                     REF(PXHyperlink*) rpNextLink);
    BOOL GetPrevLink(PXHyperlink*      pCurLink,
                     REF(PXHyperlink*) rpPrevLink);
    void GetFirstLinkWithDefault();
    void GetLastLinkWithDefault();
    void GetNextLinkWithDefault();
    void GetPrevLinkWithDefault();
};

inline PXHyperlink::PXHyperlink()
{
    m_Rect.left   = 0;
    m_Rect.right  = 0;
    m_Rect.top    = 0;
    m_Rect.bottom = 0;
    m_pLinkStr    = NULL;
}

inline PXHyperlink::~PXHyperlink()
{
    HX_RELEASE(m_pLinkStr);
}

inline BOOL PXHyperlinkManager::AnyLinkWithKeyboardFocus() const
{
    return m_bSomeLinkHasKeyboardFocus;
}

#endif
