/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcjpgff.h,v 1.1.26.1 2004/07/09 01:51:14 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXCJPGFF_H
#define PXCJPGFF_H

// Forward declarations
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXValues             IHXValues;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
class PXParseSession;
class PXMapManager;


class CRealPixJPEGFileFormatCodec : public CHXBaseCountingObject,
                                    public IHXPlugin,
                                    public IHXRealPixFileFormatCodec
{
public:
    CRealPixJPEGFileFormatCodec();
    virtual ~CRealPixJPEGFileFormatCodec();

    // IUnknown Methods
    STDMETHOD (QueryInterface)  (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)  (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

    // IHXPlugin methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        bMultipleLoad,
                                    REF(const char*) pDescription,
                                    REF(const char*) pCopyright,
                                    REF(const char*) pMoreInfoURL,
                                    REF(ULONG32)     ulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown*        pContext);

    // IHXRealPixFileFormatCodec methods
    STDMETHOD(GetFileFormatCodecInfo) (THIS_ REF(const char**) rppszFileExtension,
                                             REF(const char**) rppszFileMimeType,
                                             REF(const char*)  rpszStreamMimeType,
                                             REF(UINT32)       rulStreamVersion,
                                             REF(UINT32)       rulMaxPerImageOpaque,
                                             REF(UINT32)       rulMaxPerPacketOpaque);
    STDMETHOD_(BOOL,ValidInputData)   (THIS_ IHXBuffer*       pBuffer);
    STDMETHOD(ParseImage)             (THIS_ IHXBuffer*       pBuffer,
                                             REF(UINT32)       rulNumPackets,
                                             REF(IHXValues*)  rpParam,
                                             REF(UINT32)       rulSessionHandle);
    STDMETHOD(GetImagePacket)         (THIS_ UINT32            ulSessionHandle,
                                             UINT32            ulPacketNum,
                                             REF(IHXBuffer*)  rpPacketBuffer,
                                             REF(IHXBuffer*)  rpOpaquePacketData,
                                             REF(BOOL)         rbRequired);
    STDMETHOD(ReleaseImage)           (THIS_ UINT32            ulSessionHandle);

    // CRealPixJPEGFileFormatCodec methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
protected:
    HX_RESULT ParseBuffer(IHXBuffer*     pBuffer,
                          PXParseSession* pSession,
                          REF(HXxSize)    rImageDim);
    HX_RESULT GetBuffers(IHXBuffer*      pBuffer,
                         UINT32           ulOffset,
                         UINT32           ulSize,
                         UINT32           ulPacketIndex,
                         UINT16           usCurBlock,
                         UINT16           usNumBlocks,
                         REF(IHXBuffer*) rpData,
                         REF(IHXBuffer*) rpOpaque);
    void      ReleaseAllSessions();
    HX_RESULT ComputeHeaderSize(BYTE* pBuf, UINT32 ulLen, REF(UINT32) rulHdrSize,
                                REF(UINT32) rulNumBytesParsed);
    HX_RESULT GetHeaderBuffers(IHXBuffer*      pBuffer,
                               UINT32           ulOffset,
                               UINT32           ulSize,
                               UINT32           ulPacketIndex,
                               UINT16           usCurBlock,
                               UINT16           usNumBlocks,
                               REF(IHXBuffer*) rpData,
                               REF(IHXBuffer*) rpOpaque,
                               REF(UINT32)      rulWidth,
                               REF(UINT32)      rulHeight,
                               REF(UINT32)      rulRestartInterval);
    HX_RESULT CopyHeaderStripMarkers(BYTE*       pOrigBuf,
                                     UINT32      ulOrigBufLen,
                                     BYTE*       pHdrBuf,
                                     UINT32      ulHdrBufLen,
                                     REF(UINT32) rulWidth,
                                     REF(UINT32) rulHeight,
                                     REF(UINT32) rulRestartInterval);

    INT32                   m_lRefCount;
    IUnknown*               m_pContext;
    IHXCommonClassFactory* m_pCommonClassFactory;
    PXMapManager*           m_pMapManager;
    BOOL                    m_bOnServer;

    static const char*      m_pszDescription;
    static const char*      m_pszCopyright;
    static const char*      m_pszMoreInfoURL;
    static const char*      m_ppszFileExtension[];
    static const char*      m_ppszFileMimeType[];
    static const char*      m_pszStreamMimeType;
    static const UINT32     m_ulStreamVersion;

    enum {kMarkerSOF0 = 0xC0, kMarkerSOF15 = 0xCF, kMarkerCOM  = 0xFE, kMarkerDHT   = 0xC4,
          kMarkerRST0 = 0xD0, kMarkerRST1  = 0xD1, kMarkerRST2 = 0xD2, kMarkerRST3  = 0xD3,
          kMarkerRST4 = 0xD4, kMarkerRST5  = 0xD5, kMarkerRST6 = 0xD6, kMarkerRST7  = 0xD7,
          kMarkerSOI  = 0xD8, kMarkerEOI   = 0xD9, kMarkerSOS  = 0xDA, kMarkerDQT   = 0xDB,
          kMarkerDRI  = 0xDD, kMarkerAPP0  = 0xE0, kMarkerAPP1 = 0xE1, kMarkerAPP15 = 0xEF,
          kMarkerTEM  = 0x01, kMarkerDAC   = 0xCC};

    enum
    {
        kMinPacketSize     = 320,
        kDefaultPacketSize = 460
    };
};

#endif
