/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxjpgff.h,v 1.2.24.1 2004/07/09 01:53:32 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXJPGFF_H
#define PXJPGFF_H

// Forward declarations
typedef _INTERFACE IHXRequest            IHXRequest;
typedef _INTERFACE IHXFormatResponse     IHXFormatResponse;
typedef _INTERFACE IHXFileObject         IHXFileObject;
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXPacket             IHXPacket;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
typedef _INTERFACE IHXErrorMessages      IHXErrorMessages;
typedef _INTERFACE IHXFileStat           IHXFileStat;
class CHXSimpleList;
class CHXString;


class CJPEGFileFormat : public CHXBaseCountingObject,
                        public IHXPlugin,
                        public IHXFileFormatObject,
                        public IHXFileResponse,
                        public IHXFileStatResponse,
                        public IHXBackChannel,
                        public IHXASMSource,
			public IHXThreadSafeMethods
{
public:
    CJPEGFileFormat();
    virtual ~CJPEGFileFormat();
    
    // IUnknown methods
    STDMETHOD (QueryInterface)   (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)   (THIS);
    STDMETHOD_(UINT32, Release)  (THIS);

    // IHXPlugin methods
    STDMETHOD(GetPluginInfo)     (THIS_ REF(BOOL)        rbLoadMultiple,
                                        REF(const char*) rpszDescription,
                                        REF(const char*) rpszCopyright,
                                        REF(const char*) rpszMoreInfoURL,
                                        REF(UINT32)      rulVersionNumber);
    STDMETHOD(InitPlugin)        (THIS_ IUnknown* pContext);

    // IHXFileFormatObject methods
    STDMETHOD(GetFileFormatInfo) (THIS_ REF(const char**)   rppszFileMimeTypes,
                                        REF(const char**)   rppszFileExtensions,
                                        REF(const char**)   rppszFileOpenNames);
    STDMETHOD(InitFileFormat)    (THIS_ IHXRequest*        pRequest,
                                        IHXFormatResponse* pFormatResponse,
                                        IHXFileObject*     pFileObject);
    STDMETHOD(GetFileHeader)     (THIS);
    STDMETHOD(GetStreamHeader)   (THIS_ UINT16 usStreamNum);
    STDMETHOD(GetPacket)         (THIS_ UINT16 usStreamNum);
    STDMETHOD(Seek)              (THIS_ UINT32 ulRequestedTime);
    STDMETHOD(Close)             (THIS);

    // IHXFileResponse methods
    STDMETHOD(InitDone)          (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone)          (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone)          (THIS_ HX_RESULT status, IHXBuffer* pBuffer);
    STDMETHOD(WriteDone)         (THIS_ HX_RESULT status);
    STDMETHOD(CloseDone)         (THIS_ HX_RESULT status);

    // IHXFileStatResponse methods
    STDMETHOD(StatDone)          (THIS_ HX_RESULT status,
                                        UINT32    ulSize,
                                        UINT32    ulCreationTime,
                                        UINT32    ulAccessTime,
                                        UINT32    ulModificationTime,
                                        UINT32    ulMode);

    // IHXBackChannel methods
    STDMETHOD(PacketReady)       (THIS_ IHXPacket* pPacket);

    // IHXASMSource methods
    STDMETHOD (Subscribe)        (THIS_ UINT16 usStreamNumber, UINT16 usRuleNumber);
    STDMETHOD (Unsubscribe)      (THIS_ UINT16 usStreamNumber, UINT16 usRuleNumber);

    // IHXThreadSafeMethods
    STDMETHOD_(UINT32, IsThreadSafe) (THIS);

    // CJPEGFileFormat methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
private:
    enum
    {
        kStateConstructed,
        kStatePluginInitialized,
        kStateFileInitPending,
        kStateFileStatPending,
        kStateFileReadPending,
        kStateFileFormatInitialized,
        kStateFileHeaderSent,
        kStateStreamHeaderSent,
        kReadSize            = 4096,
        kDefaultPacketSize   = 480,
        kMinimumPacketSize   = 320,
        kDefaultBitRate      = 12000,
        kDefaultDuration     = 5000,
        kDefaultDisplayTime  = 0,
        kJPEGPacketOverhead  = 20,
        kIRMAPacketOverhead  = 20,
        kTargetBrowser       = 0,
        kTargetPlayer        = 1,
        kURLTypeNormal       = 0,
        kURLTypeCommandPause = 1,
        kURLTypeCommandPlay  = 2,
        kURLTypeCommandSeek  = 3,
        kURLTypeCommandStop  = 4
    };

    enum {kMarkerSOF0 = 0xC0, kMarkerSOF1 = 0xC1, kMarkerSOF2 = 0xC2, kMarkerDHT  = 0xC4,
          kMarkerRST0 = 0xD0, kMarkerRST1 = 0xD1, kMarkerRST2 = 0xD2, kMarkerRST3 = 0xD3,
          kMarkerRST4 = 0xD4, kMarkerRST5 = 0xD5, kMarkerRST6 = 0xD6, kMarkerRST7 = 0xD7,
          kMarkerSOI  = 0xD8, kMarkerEOI  = 0xD9, kMarkerSOS  = 0xDA, kMarkerDQT  = 0xDB,
          kMarkerDRI  = 0xDD, kMarkerAPP0 = 0xE0, kMarkerTEM  = 0x01};

    struct PacketInfo
    {
        BYTE*   m_pBuffer;
        UINT32  m_ulSize;
        UINT32  m_ulSequenceNumber;
        UINT32  m_ulStartingBlock;
        UINT32  m_ulNumBlocks;
    };

    INT32                  m_lRefCount;
    IUnknown*              m_pContext;
    IHXFileObject*         m_pFileObject;
    IHXFormatResponse*     m_pFormatResponse;
    IHXCommonClassFactory* m_pClassFactory;
    IHXRequest*            m_pRequest;
    IHXErrorMessages*      m_pError;
    UINT32                 m_ulState;
    IHXFileStat*           m_pFileStat;
    UINT32                 m_ulFileSize;
    IHXBuffer*             m_pFileBuffer;
    CHXSimpleList*         m_pPacketInfoList;
    void*                  m_pPacketInfoListItr;
    UINT32                 m_ulRestartInterval;
    UINT32                 m_ulImageWidth;
    UINT32                 m_ulImageHeight;
    UINT32                 m_ulBitRate;
    UINT32                 m_ulPreroll;
    UINT32                 m_ulMaxPacketSize;
    UINT32                 m_ulMinPacketSize;
    UINT32                 m_ulAvgPacketSize;
    UINT32                 m_ulTotalBytesToSend;
    UINT32                 m_ulDuration;
    INT32                  m_lCurrentTimeStamp;
    UINT32                 m_ulDisplayTime;
    CHXString*             m_pURL;
    UINT32                 m_ulTarget;
    UINT32                 m_ulURLType;
    UINT32                 m_ulSeekTime;
    BOOL                   m_bReliable;
    IHXBuffer*             m_pMediaOpacityStr;
    IHXBuffer*             m_pMediaChromaKeyStr;
    IHXBuffer*             m_pMediaChromaKeyTolStr;
    IHXBuffer*             m_pMediaChromaKeyOpacityStr;
    UINT32                 m_ulBytesRead;

    static const UINT32    m_ulContentVersion;
    static const UINT32    m_ulStreamVersion;
    static const char* const     m_pszDescription;
    static const char* const     m_pszCopyright;
    static const char* const     m_pszMoreInfoURL;
    static const char* const     m_ppszFileMimeTypes[];
    static const char* const     m_ppszFileExtensions[];
    static const char* const     m_ppszFileOpenNames[];
    static const char* const     m_pszStreamMimeType;

    void      ClearPacketInfoList();
    HX_RESULT ParseImageBuffer(BYTE* pFileBuffer, UINT32 ulFileSize);

    UINT32 TransmissionTime(UINT32 ulBytes, UINT32 ulBitrate)
    {
        return (ulBitrate ? ((ulBytes * 8000) / ulBitrate) + 1 : 0);
    };
    void      ReportError(UINT32 ulErrorID);
    HX_RESULT GetResourceErrorString(UINT32 ulErrorID, CHXString& rErrorStr);
};


#endif
