/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxparse.cpp,v 1.1.26.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "ihxpckts.h"

// hxmisc
#include "baseobj.h"
#include "unkimp.h"

// hxcont
#include "carray.h"
#include "hxmap.h"

// pxcomlib
#include "carray.h"
#include "pxmapmgr.h"
#include "pxparse.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

PXParseSession::PXParseSession()
{
    m_lRefCount               = 0;
    m_pPacketInfoArray        = NULL;
    m_ulNumPackets            = 0;
    m_ulMaxPacketSize         = 0;
    m_ulMinPacketSize         = 0;
    m_ulTotalBytes            = 0;
    m_ulTotalRequiredBytes    = 0;
    m_ulTotalNonRequiredBytes = 0;
}

PXParseSession::~PXParseSession()
{
    if (m_pPacketInfoArray)
    {
        for (UINT32 i = 0; i < (UINT32) m_pPacketInfoArray->GetSize(); i++)
        {
            PacketInfo* pInfo = (PacketInfo*) m_pPacketInfoArray->GetAt(i);
            if (pInfo)
            {
                HX_RELEASE(pInfo->m_pDataBuffer);
                HX_RELEASE(pInfo->m_pOpaqueBuffer);
            }
            HX_DELETE(pInfo);
        }
    }
    HX_DELETE(m_pPacketInfoArray);
}

STDMETHODIMP PXParseSession::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (IsEqualIID(riid, IID_IUnknown))
    {
        AddRef();
        *ppvObj = (IUnknown *) this;
    }
    else
    {
        *ppvObj = NULL;
        retVal  = HXR_NOINTERFACE;
    }

    return retVal;
}

STDMETHODIMP_(UINT32) PXParseSession::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(UINT32) PXParseSession::Release()
{
    
    if (InterlockedDecrement(&m_lRefCount) > 0)
        return m_lRefCount;

    delete this;

    return 0;
}

HX_RESULT PXParseSession::InitSize(UINT32 ulSize)
{
    HX_RESULT retVal = SetSize(ulSize);
    if (SUCCEEDED(retVal))
    {
        // NULL out all the pointers
        for (UINT32 i = 0; i < (UINT32) m_pPacketInfoArray->GetSize(); i++)
        {
            m_pPacketInfoArray->SetAt(i, NULL);
        }
    }
    return retVal;
}

HX_RESULT PXParseSession::SetSize(UINT32 ulSize)
{
    HX_RESULT retVal = HXR_OK;

    if (ulSize)
    {
        // If the pointer array doesn't exist, then create it
        if (!m_pPacketInfoArray)
        {
            m_pPacketInfoArray = new CHXPtrArray();
            if (!m_pPacketInfoArray)
            {
                retVal = HXR_OUTOFMEMORY;
            }
        }

        if (SUCCEEDED(retVal))
        {
            UINT32 ulOldSize = m_pPacketInfoArray->GetSize();
            // Set the size
            m_pPacketInfoArray->SetSize(ulSize);
            // If the new size is less than the old one, then
            // free up the unused space
            if (ulSize < ulOldSize)
            {
                m_pPacketInfoArray->FreeExtra();
            }
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

UINT32 PXParseSession::GetSize()
{
    UINT32 ulNum = 0;
    if (m_pPacketInfoArray)
    {
        ulNum = m_pPacketInfoArray->GetSize();
    }
    return ulNum;
}

HX_RESULT PXParseSession::AddPacket(IHXBuffer* pDataBuffer,
                                    IHXBuffer* pOpaqueBuffer,
                                    BOOL        bRequired)
{
    HX_RESULT retVal = HXR_OK;

    if (pDataBuffer)
    {
        // Create a new PacketInfo struct
        PacketInfo* pInfo = new PacketInfo;
        if (pInfo)
        {
            // Set the members of the PacketInfo struct
            pInfo->m_pDataBuffer   = pDataBuffer;
            pInfo->m_pOpaqueBuffer = pOpaqueBuffer;
            pInfo->m_bRequired     = bRequired;

            // AddRef the objects
            pInfo->m_pDataBuffer->AddRef();
            if (pInfo->m_pOpaqueBuffer)
            {
                pInfo->m_pOpaqueBuffer->AddRef();
            }

            // Set the struct into the array
            m_pPacketInfoArray->SetAt(m_ulNumPackets, (void*) pInfo);

            // Update the statistics
            UINT32 ulBytes = pDataBuffer->GetSize() + (pOpaqueBuffer ? pOpaqueBuffer->GetSize() : 0);
            if (m_ulNumPackets)
            {
                if (ulBytes < m_ulMinPacketSize)
                {
                    m_ulMinPacketSize = ulBytes;
                }
                if (ulBytes > m_ulMaxPacketSize)
                {
                    m_ulMaxPacketSize = ulBytes;
                }
            }
            else
            {
                m_ulMinPacketSize = ulBytes;
                m_ulMaxPacketSize = ulBytes;
            }
            m_ulTotalBytes += ulBytes;
            if (bRequired)
            {
                m_ulTotalRequiredBytes += ulBytes;
            }
            else
            {
                m_ulTotalNonRequiredBytes += ulBytes;
            }
            m_ulNumPackets++;
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

HX_RESULT PXParseSession::GetPacket(UINT32           ulPacketIndex,
                                    REF(IHXBuffer*) rpDataBuffer,
                                    REF(IHXBuffer*) rpOpaqueBuffer,
                                    REF(BOOL)        rbRequired)
{
    HX_RESULT retVal = HXR_OK;

    if (m_pPacketInfoArray)
    {
        if (ulPacketIndex < m_ulNumPackets)
        {
            PacketInfo* pInfo = (PacketInfo*) m_pPacketInfoArray->GetAt(ulPacketIndex);
            if (pInfo)
            {
                if (pInfo->m_pDataBuffer)
                {
                    rpDataBuffer   = pInfo->m_pDataBuffer;
                    rpOpaqueBuffer = pInfo->m_pOpaqueBuffer;
                    rbRequired     = pInfo->m_bRequired;

                    rpDataBuffer->AddRef();
                    if (rpOpaqueBuffer)
                    {
                        rpOpaqueBuffer->AddRef();
                    }
                }
                else
                {
                    retVal = HXR_FAIL;
                }
            }
            else
            {
                retVal = HXR_FAIL;
            }
        }
        else
        {
            retVal = HXR_INVALID_PARAMETER;
        }
    }
    else
    {
        retVal = HXR_UNEXPECTED;
    }

    return retVal;
}

