/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.algorithm.gzip.GZipCompressor;
import nom.tam.fits.compression.algorithm.gzip2.GZip2Compressor;
import nom.tam.fits.compression.algorithm.hcompress.HCompressor;
import nom.tam.fits.compression.algorithm.plio.PLIOCompress;
import nom.tam.fits.compression.algorithm.rice.RiceCompressor;
import nom.tam.fits.compression.provider.CompressorControlNameComputer;
import nom.tam.fits.compression.provider.api.ICompressorProvider;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.api.IHeaderAccess;
import nom.tam.fits.compression.provider.param.hcompress.HCompressParameters;
import nom.tam.fits.compression.provider.param.hcompress.HCompressQuantizeParameters;
import nom.tam.fits.compression.provider.param.rice.RiceCompressParameters;
import nom.tam.fits.compression.provider.param.rice.RiceQuantizeCompressParameters;

public class CompressorProvider
implements ICompressorProvider {
    private static final ICompressOption NULL_OPTION = new ICompressOption(){

        @Override
        public ICompressOption copy() {
            return this;
        }

        @Override
        public ICompressParameters getCompressionParameters() {
            return NULL_PARAMETERS;
        }

        @Override
        public boolean isLossyCompression() {
            return false;
        }

        @Override
        public void setParameters(ICompressParameters parameters) {
        }

        @Override
        public ICompressOption setTileHeight(int value) {
            return this;
        }

        @Override
        public ICompressOption setTileWidth(int value) {
            return this;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return clazz.isAssignableFrom(this.getClass()) ? (T)clazz.cast(this) : null;
        }
    };
    private static final ICompressParameters NULL_PARAMETERS = new ICompressParameters(){

        @Override
        public void addColumnsToTable(BinaryTableHDU hdu) {
        }

        @Override
        public ICompressParameters copy(ICompressOption clone) {
            return this;
        }

        @Override
        public void getValuesFromColumn(int index) {
        }

        @Override
        public void getValuesFromHeader(IHeaderAccess header) {
        }

        @Override
        public void initializeColumns(IHeaderAccess header, BinaryTable binaryTable, int size) throws FitsException {
        }

        @Override
        public void initializeColumns(int length) {
        }

        @Override
        public void setValueFromColumn(int index) {
        }

        @Override
        public void setValuesInHeader(IHeaderAccess header) {
        }
    };
    private static final Class<?>[][] AVAILABLE_COMPRESSORS = new Class[][]{{RiceCompressor.ByteRiceCompressor.class, RiceCompressParameters.class}, {RiceCompressor.ShortRiceCompressor.class, RiceCompressParameters.class}, {RiceCompressor.IntRiceCompressor.class, RiceCompressParameters.class}, {RiceCompressor.FloatRiceCompressor.class, RiceQuantizeCompressParameters.class}, {RiceCompressor.DoubleRiceCompressor.class, RiceQuantizeCompressParameters.class}, {PLIOCompress.BytePLIOCompressor.class}, {PLIOCompress.ShortPLIOCompressor.class}, {PLIOCompress.IntPLIOCompressor.class}, {HCompressor.ByteHCompressor.class, HCompressParameters.class}, {HCompressor.ShortHCompressor.class, HCompressParameters.class}, {HCompressor.IntHCompressor.class, HCompressParameters.class}, {HCompressor.FloatHCompressor.class, HCompressQuantizeParameters.class}, {HCompressor.DoubleHCompressor.class, HCompressQuantizeParameters.class}, {HCompressor.DoubleHCompressor.class}, {GZip2Compressor.ShortGZip2Compressor.class}, {GZip2Compressor.IntGZip2Compressor.class}, {GZip2Compressor.LongGZip2Compressor.class}, {GZipCompressor.ByteGZipCompressor.class}, {GZipCompressor.ShortGZipCompressor.class}, {GZipCompressor.IntGZipCompressor.class}, {GZipCompressor.LongGZipCompressor.class}, {GZipCompressor.FloatGZipCompressor.class}, {GZipCompressor.DoubleGZipCompressor.class}};
    private static final CompressorControlNameComputer NAME_COMPUTER = new CompressorControlNameComputer();
    private static final Logger LOG = Logger.getLogger(CompressorProvider.class.getName());

    public static ICompressorControl findCompressorControl(String quantAlgorithm, String compressionAlgorithm, Class<?> baseType) {
        ICompressorProvider defaultProvider = null;
        for (ICompressorProvider iTileCompressorProvider : ServiceLoader.load(ICompressorProvider.class, Thread.currentThread().getContextClassLoader())) {
            if (iTileCompressorProvider instanceof CompressorProvider) {
                defaultProvider = iTileCompressorProvider;
                continue;
            }
            ICompressorControl result = iTileCompressorProvider.createCompressorControl(quantAlgorithm, compressionAlgorithm, baseType);
            if (result == null) continue;
            return result;
        }
        return defaultProvider.createCompressorControl(quantAlgorithm, compressionAlgorithm, baseType);
    }

    @Override
    public ICompressorControl createCompressorControl(String quantAlgorithm, String compressionAlgorithm, Class<?> baseType) {
        String className = NAME_COMPUTER.createCompressorClassName(quantAlgorithm, compressionAlgorithm, baseType);
        for (Class<?>[] clazz : AVAILABLE_COMPRESSORS) {
            Class<?> compressorClass = clazz[0];
            if (!compressorClass.getSimpleName().equals(className)) continue;
            if (clazz.length > 1) {
                Class<?> parametersClass = clazz[1];
                return new TileCompressorControl(compressorClass, parametersClass);
            }
            return new TileCompressorControl(compressorClass);
        }
        return null;
    }

    protected static class TileCompressorControl
    implements ICompressorControl {
        private final Constructor<ICompressor<Buffer>> constructor;
        private final Class<? extends ICompressOption> optionClass;
        private final Constructor<ICompressParameters> parametersConstructor;

        protected TileCompressorControl(Class<?> compressorClass) {
            this(compressorClass, null);
        }

        protected TileCompressorControl(Class<?> compressorClass, Class<?> parametersClass) {
            this.constructor = compressorClass.getConstructors()[0];
            this.optionClass = this.constructor.getParameterTypes().length == 0 ? null : this.constructor.getParameterTypes()[0];
            this.parametersConstructor = parametersClass != null ? parametersClass.getConstructors()[0] : null;
        }

        @Override
        public boolean compress(Buffer in, ByteBuffer out, ICompressOption option) {
            try {
                return this.newCompressor(option).compress(in, out);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "could not compress using " + this.constructor + " must fallback to other compression method", e);
                return false;
            }
        }

        @Override
        public void decompress(ByteBuffer in, Buffer out, ICompressOption option) {
            try {
                this.newCompressor(option).decompress(in, out);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not decompress " + this.constructor, e);
            }
        }

        @Override
        public ICompressOption option() {
            if (this.optionClass != null) {
                try {
                    ICompressOption option = this.optionClass.newInstance();
                    if (this.parametersConstructor != null) {
                        option.setParameters(this.parametersConstructor.newInstance(option));
                    } else {
                        option.setParameters(NULL_PARAMETERS);
                    }
                    return option;
                }
                catch (Exception e) {
                    throw new IllegalStateException("could not instantiate option class for " + this.constructor, e);
                }
            }
            return NULL_OPTION;
        }

        private ICompressor<Buffer> newCompressor(ICompressOption option) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            return this.constructor.getParameterTypes().length == 0 ? this.constructor.newInstance(new Object[0]) : this.constructor.newInstance(option);
        }
    }
}

