/* The preferences window.
 *
 * Copyright (c) 2003 Ole Laursen.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef PREFERENCES_WINDOW_HPP
#define PREFERENCES_WINDOW_HPP

#include <memory>
#include <vector>

#include <libglademm/xml.h>
#include <sigc++/object.h>
#include <gconfmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/label.h>
#include <gtkmm/liststore.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/treeview.h>
#include <gtkmm/window.h>

#include <libgnomeuimm/color-picker.h>
#include <libgnomeuimm/font-picker.h>


class Applet;
class Monitor;

class PreferencesWindow: public SigC::Object
{
public:
  PreferencesWindow(Applet &applet);
  ~PreferencesWindow();

  void show();
  
private:
  Glib::RefPtr<Gnome::Glade::Xml> ui;

  Gtk::Window *window;
  
  Gtk::SpinButton *update_interval_spinbutton;
  Gtk::RadioButton *panel_background_radiobutton;
  Gtk::RadioButton *background_color_radiobutton;
  Gnome::UI::ColorPicker *background_colorpicker;
  
  Gtk::RadioButton *curve_radiobutton;
  Gtk::RadioButton *bar_radiobutton;
  Gtk::RadioButton *column_radiobutton;
  Gtk::RadioButton *text_radiobutton;
  Gtk::RadioButton *flame_radiobutton;

  Gtk::Widget *curve_options;
  Gtk::SpinButton *curve_size_spinbutton;
  Gtk::SpinButton *curve_samples_spinbutton;
  Gtk::Widget *bar_options;
  Gtk::SpinButton *bar_size_spinbutton;
  Gtk::Widget *column_options;
  Gtk::SpinButton *column_size_spinbutton;
  Gtk::SpinButton *column_samples_spinbutton;
  Gtk::Widget *flame_options;
  Gtk::SpinButton *flame_size_spinbutton;
  Gtk::Widget *text_options;
  Gtk::CheckButton *font_checkbutton;
  Gnome::UI::FontPicker *fontpicker;

  Gtk::Button *remove_button;
  Gtk::Button *change_button;
  Gtk::TreeView *monitor_treeview;
  Gtk::Widget *monitor_options;

  Gtk::Widget *monitor_curve_options;
  Gtk::SpinButton *line_width_spinbutton;
  Gnome::UI::ColorPicker *line_colorpicker;
  Gtk::Widget *monitor_bar_options;
  Gnome::UI::ColorPicker *bar_colorpicker;
  Gtk::Widget *monitor_column_options;
  Gnome::UI::ColorPicker *column_colorpicker;
  Gtk::Widget *monitor_flame_options;
  Gnome::UI::ColorPicker *flame_colorpicker;
  
  class MonitorColumns: public Gtk::TreeModel::ColumnRecord
  {
  public:
    Gtk::TreeModelColumn<Glib::ustring> name;
    Gtk::TreeModelColumn<Glib::ustring> dir;

    MonitorColumns() { add(name); add(dir); }
  };
  
  Glib::RefPtr<Gtk::ListStore> monitor_store;
  typedef Gtk::ListStore::iterator store_iter;
  
  // GConf
  void viewer_type_listener(unsigned int, Gnome::Conf::Entry entry);
  void update_interval_listener(unsigned int, Gnome::Conf::Entry entry);
  void background_color_listener(unsigned int, Gnome::Conf::Entry entry);
  void use_background_color_listener(unsigned int, Gnome::Conf::Entry entry);
  void size_listener(unsigned int, Gnome::Conf::Entry entry);
  void samples_listener(unsigned int, Gnome::Conf::Entry entry);
  void font_listener(unsigned int, Gnome::Conf::Entry entry);
  void monitors_listener(unsigned int, Gnome::Conf::Entry entry);
  void line_width_listener(unsigned int, Gnome::Conf::Entry entry);
  void monitor_color_listener(unsigned int, Gnome::Conf::Entry entry);

  void stop_monitor_listeners();
  
  std::vector<unsigned int> monitor_listeners;

  // GUI
  void on_update_interval_spinbutton_changed();
  void on_background_colorpicker_set(unsigned int r, unsigned int g,
				     unsigned int b, unsigned int a);
  void on_background_color_radiobutton_toggled();
  
  void on_curve_radiobutton_toggled();
  void on_bar_radiobutton_toggled();
  void on_column_radiobutton_toggled();
  void on_text_radiobutton_toggled();
  void on_flame_radiobutton_toggled();
  
  void on_size_spinbutton_changed(Gtk::SpinButton *size_sb);
  void on_samples_spinbutton_changed(Gtk::SpinButton *samples_sb);
  void on_font_checkbutton_toggled();
  void on_fontpicker_set(const Glib::ustring &font);

  void on_add_button_clicked();
  void on_remove_button_clicked();
  void on_change_button_clicked();
  void on_selection_changed();

  void on_line_width_spinbutton_changed();
  void on_monitor_colorpicker_set(unsigned int r, unsigned int g,
				  unsigned int b, unsigned int a);

  void on_close_button_clicked();
  bool on_closed(GdkEventAny *);

  Applet &applet;
};

#endif
