/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005, 2007 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include "callbacks.h"
#include "utils.h"
#include "preferences.h"
#include "gui_utils.h"
#include "db.h"

extern GtkWidget *window;
extern preferencestype preferences;

static gchar *
my_strreplace(const char *str, const char *delimiter, const char *replacement)
{
	gchar **split;
	gchar *ret;

	g_return_val_if_fail (str != NULL, NULL);
	g_return_val_if_fail (delimiter != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);

	split = g_strsplit (str, delimiter, 0);
	ret = g_strjoinv (replacement, split);
	g_strfreev (split);

	return ret;
}

gboolean
on_preferencesdialog_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive (window, 1);
	return FALSE;
}


void
on_preferencescancelbutton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive (window, 1);
	gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_preferencesokbutton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *preferencesdialog, *typestextview, *materialstextview,
		*periodstextview;
	GtkWidget *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10, *p11, *p12,
		*p13, *p14, *p15;
	GtkTextBuffer *buffer;
	GtkTextIter start, end;
	gboolean check;
	gchar **states;
	gint i;
	GtkWidget *entry;
	gchar *line;
	gint nr;
	

	preferencesdialog = gtk_widget_get_toplevel (GTK_WIDGET(button));

	typestextview = lookup_widget (preferencesdialog, "typestextview");
	materialstextview = lookup_widget (preferencesdialog, "materialstextview");
	periodstextview = lookup_widget (preferencesdialog, "periodstextview");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (typestextview));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	preferences.types = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
	preferences.types = my_strreplace (preferences.types, "\n", " ");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (materialstextview));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	preferences.materials = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
	preferences.materials = my_strreplace (preferences.materials, "\n", " ");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (periodstextview));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	preferences.periods = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
	preferences.periods = my_strreplace (preferences.periods, "\n", " ");

	set_combostrings ();

	/* refresh the combostrings */
	entry = lookup_widget (window, "entry");
	line = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	nr = atoi (line);
	if (nr > 1)
	{
		clearall ();
		load_from_db (nr);
	}
	g_free (line);

	p1 = lookup_widget (preferencesdialog, "p1");
	p2 = lookup_widget (preferencesdialog, "p2");
	p3 = lookup_widget (preferencesdialog, "p3");
	p4 = lookup_widget (preferencesdialog, "p4");
	p5 = lookup_widget (preferencesdialog, "p5");
	p6 = lookup_widget (preferencesdialog, "p6");
	p7 = lookup_widget (preferencesdialog, "p7");
	p8 = lookup_widget (preferencesdialog, "p8");
	p9 = lookup_widget (preferencesdialog, "p9");
	p10 = lookup_widget (preferencesdialog, "p10");
	p11 = lookup_widget (preferencesdialog, "p11");
	p12 = lookup_widget (preferencesdialog, "p12");
	p13 = lookup_widget (preferencesdialog, "p13");
	p14 = lookup_widget (preferencesdialog, "p14");
	p15 = lookup_widget (preferencesdialog, "p15");

	states = g_new0 (gchar *, 16);
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p1));
	states[0] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p2));
	states[1] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p3));
	states[2] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p4));
	states[3] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p5));
	states[4] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p6));
	states[5] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p7));
	states[6] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p8));
	states[7] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p9));
	states[8] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p10));
	states[9] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p11));
	states[10] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p12));
	states[11] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p13));
	states[12] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p14));
	states[13] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p15));
	states[14] = g_strdup (check ? "1" : "0");
	states[15] = NULL;

	preferences.colvisible = g_strjoinv (",", states);

	for (i = 0; i < 15; i++)
		g_free (states[i]);
	g_free (states);

	gtk_widget_set_sensitive (window, 1);
	gtk_widget_destroy (preferencesdialog);
}

