/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <sqlite3.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "preferences.h"
#include "gui_utils.h"

gboolean im1, im2;

extern GtkWidget *window;
extern sqlite3 *db;
extern gint max;
extern statestype state;
extern gint brightness1, brightness2;

/* clicking  the '...' buttons will display a filechooser dialog */
void
on_image1button_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *fileselection, *image1entry;
	gchar *image1;
	
	fileselection = create_imagechooserdialog ();
	g_signal_connect
		(fileselection, "update-preview", G_CALLBACK (preview_update), NULL);

	im1 = TRUE;
	im2 = FALSE;

	image1entry = lookup_widget (window, "image1entry");
	image1 = gtk_editable_get_chars (GTK_EDITABLE(image1entry), 0, -1);	
	if (strlen (image1) > 0)
		gtk_file_chooser_set_filename (GTK_FILE_CHOOSER(fileselection), image1);
	else
		gtk_file_chooser_set_filename (GTK_FILE_CHOOSER(fileselection), state.imageloaddir);
	g_free (image1);

	gtk_widget_set_sensitive (window, 0);
	gtk_widget_show (fileselection);
}

void
on_image2button_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *fileselection, *image2entry;
	gchar *image2;

	fileselection = create_imagechooserdialog ();
	g_signal_connect
		(fileselection, "update-preview", G_CALLBACK (preview_update), NULL);

	im1 = FALSE;
	im2 = TRUE;

	image2entry = lookup_widget (window, "image2entry");
	image2 = gtk_editable_get_chars (GTK_EDITABLE(image2entry), 0, -1);
	if (strlen (image2) > 0)
		gtk_file_chooser_set_filename (GTK_FILE_CHOOSER(fileselection), image2);
	else
		gtk_file_chooser_set_filename (GTK_FILE_CHOOSER(fileselection), state.imageloaddir);
	g_free (image2);

	gtk_widget_set_sensitive (window, 0);
	gtk_widget_show (fileselection);
}

gboolean
exit_program                           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	sqlite3_close (db);
	savepreferences ();
	g_free (state.imageloaddir);
	g_free (state.table);
	gtk_main_quit ();
	return FALSE;
}


/* clicking an image will display the original image */
void
on_imagebutton1_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *imagewindow, *imageentry, *image;
	gchar *imagestr;
	GdkPixbuf *pix;

	imagewindow = create_imagewindow ();
	imageentry = lookup_widget (window, "image1entry");
	imagestr = gtk_editable_get_chars (GTK_EDITABLE(imageentry), 0, -1);	
	if (strlen (imagestr) > 0)
	{
		pix = gdk_pixbuf_new_from_file (imagestr, NULL);
		if (pix)
		{
			brightness1 = 0;
			image = gtk_image_new_from_pixbuf (pix);
			gtk_container_add (GTK_CONTAINER(imagewindow), image);
			gtk_widget_set_sensitive (window, 0);
			gtk_widget_show_all (imagewindow);
			g_signal_connect ((gpointer) imagewindow, "key_press_event",
				G_CALLBACK (on_imagewindow_keypress), GINT_TO_POINTER(1));
			g_object_unref (pix);
		}
	}
}

void
on_imagebutton2_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *imagewindow, *imageentry, *image;
	gchar *imagestr;
	GdkPixbuf *pix;

	imagewindow = create_imagewindow ();
	imageentry = lookup_widget (window, "image2entry");
	imagestr = gtk_editable_get_chars (GTK_EDITABLE(imageentry), 0, -1);	
	if (strlen (imagestr) > 0)
	{
		pix = gdk_pixbuf_new_from_file (imagestr, NULL);
		if (pix)
		{
			brightness2 = 0;
			image = gtk_image_new_from_pixbuf (pix);
			gtk_container_add (GTK_CONTAINER(imagewindow), image);
			gtk_widget_set_sensitive (window, 0);
			gtk_widget_show_all (imagewindow);
			g_signal_connect ((gpointer) imagewindow, "key_press_event",
				G_CALLBACK (on_imagewindow_keypress), GINT_TO_POINTER(2));
			g_object_unref (pix);
		}
	}
}


void
on_image1entry_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkWidget *imagebutton, *image;
	gchar *imagepath;
	GdkPixbuf *pixbuf;

	imagepath = gtk_editable_get_chars (editable, 0, -1);
	pixbuf = gdk_pixbuf_new_from_file_at_size (imagepath, 150, 150, NULL);
	imagebutton = lookup_widget (window, "imagebutton1");
	gtk_container_foreach (GTK_CONTAINER(imagebutton),
		(GtkCallback)gtk_widget_destroy, NULL);
	if (pixbuf)
	{
		image = gtk_image_new_from_pixbuf (pixbuf);
		gtk_container_add (GTK_CONTAINER (imagebutton), image);
		gtk_widget_show (image);
		g_object_unref (pixbuf);
		state.imageloaddir = g_strdup (imagepath);
	}
}


void
on_image2entry_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkWidget *imagebutton, *image;
	gchar *imagepath;
	GdkPixbuf *pixbuf;

	imagepath = gtk_editable_get_chars (editable, 0, -1);
	pixbuf = gdk_pixbuf_new_from_file_at_size (imagepath, 150, 150, NULL);
	imagebutton = lookup_widget (window, "imagebutton2");
	gtk_container_foreach (GTK_CONTAINER(imagebutton),
		(GtkCallback)gtk_widget_destroy, NULL);
	if (pixbuf)
	{
		imagebutton = lookup_widget (window, "imagebutton2");
		gtk_container_foreach (GTK_CONTAINER(imagebutton),
			(GtkCallback)gtk_widget_destroy, NULL);
		image = gtk_image_new_from_pixbuf (pixbuf);
		gtk_container_add (GTK_CONTAINER (imagebutton), image);
		gtk_widget_show (image);
		g_object_unref (pixbuf);
		state.imageloaddir = g_strdup (imagepath);
	}
}

