{-# OPTIONS -fglasgow-exts -fallow-overlapping-instances -fallow-undecidable-instances #-}
module HAppS.Util.StdMain.StartState(StartState(..), StartStateEx(..)) where

import Data.Monoid
import HAppS.MACID(Handler)
import HAppS.MACID.Types(Proxy)

class StartState sp where
    startStateM :: IO sp
    runPart     :: (outer -> sp) -> (sp -> outer -> outer) -> [Handler outer]
    runPart _ _ = []

instance Monoid m => StartState m where startStateM = return mempty
instance StartState Int           where startStateM = return 0
instance StartState Integer       where startStateM = return 0


class StartStateEx outer local where
    startStateExM :: Proxy outer -> IO local
    runPartEx     :: (outer -> local) -> (local -> outer -> outer) -> [Handler outer]

instance StartState simple => StartStateEx outer simple where
    startStateExM _ = startStateM
    runPartEx       = runPart
