{-# OPTIONS -cpp -fglasgow-exts #-}
module HAppS.Util.StdMain
    (-- * Running an application
     simpleMain,stdMain, stdMainWithSaver, StdPart(..),CanMain(..),
     -- * Initial state and handlers
     module HAppS.Util.StdMain.StartState,
     module HAppS.Util.StdMain.StartStateTH
    ) where

import System.Log.Logger
import qualified System.Log.Handler as SLH
-- import System.Log.Handler (LogHandler) -- why doesn't this work?
import System.Log.Handler.Simple
import System.Log.Handler.Syslog

import Control.Monad
import Data.List
import Data.Char
import System.Environment
import System.IO
import System.Console.GetOpt
import Control.Monad.Trans
import Control.Concurrent
#ifdef UNIX
import System.Posix.Signals hiding (Handler)
#endif

import HAppS.MACID
import HAppS.MACID.Types
import HAppS.Util.StdMain.Config
import HAppS.Util.StdMain.StartState
import HAppS.Util.StdMain.StartStateTH

-- | Run a web application with a user specified Saver.
stdMainWithSaver :: (StartStateEx st st, Serialize st) => Saver -> StdPart st -> IO ()
stdMainWithSaver saver sp
    = stdMainEx sp $ \config _ hs ->
      runWithConf (config { txcSaver = saver }) hs

-- | Run a web application with FileSaver.
stdMain :: (MonadIO m, StartStateEx st st, Serialize st) => StdPart st -> m ()
stdMain sp = stdMainEx sp $ \config fs hs -> do
    pn   <- liftIO getProgName
    let fp = if null fs then pn++"_state" else head fs
    let conf = config { txcSaver = FileSaver fp, txcLogger = FileSaver (pn++"_error.log") }
    runWithConf conf hs

simpleMain sp = stdMainEx sp $ \config fs hs -> do
    pn  <- liftIO getProgName
    let conf = config {txcSaver = FileSaver $ "."++pn++"_state",txcLogger = FileSaver $ "."++pn++"_error_log"}
    runWithConf conf hs

mkTxConfig :: [Flag] -> TxConfig
mkTxConfig = foldr worker nullTxConfig
    where worker (ConcurrentThreads n) c = c{txcSideEffectThreads = n}
          worker _ c = c

data NullLogger
instance SLH.LogHandler NullLogger where
    setLevel = error "Don't do this! This logger should not be used!"
    getLevel = error "Don't do this! This logger should not be used!"
    emit = error "Don't do this! This logger should not be used!"
    close = error "This logger should not be used!"

setLoggingSettings :: [Flag] -> IO ()
setLoggingSettings flags = do updateGlobalLogger "" (setHandlers ([] :: [NullLogger]))
                              s <- streamHandler stdout DEBUG
                              updateGlobalLogger "HAppS" (setHandlers [s] . setLevel WARNING)
                              mapM_ worker flags
    where worker (LogTarget SysLog)  = do s <- openlog "HAppS" [PID] DAEMON DEBUG -- This priority seems to be ignored?
                                          updateGlobalLogger "HAppS" (setHandlers [s])
          worker (LogTarget StdOut)  = do s <- streamHandler stdout DEBUG
                                          updateGlobalLogger "HAppS" (setHandlers [s])
          worker (LogTarget (File path)) = do s <- fileHandler path DEBUG  -- This priority seems to be ignored?
                                              updateGlobalLogger "HAppS" (setHandlers [s])
          worker (LogLevel priority) = do updateGlobalLogger "HAppS" (setLevel priority)
                                          rlogger <- getLogger "HAppS"
                                          logM "" WARNING ("Set logging priority to " ++ show (getLevel rlogger))
          worker _ = return ()


runWithConf :: forall m st. (MonadIO m, StartStateEx st st, Serialize st) => TxConfig -> [Handler st] -> m ()
runWithConf conf hs = liftIO $ do
    st0 <- startStateExM (Proxy :: Proxy st)
    tx  <- runTxSystem conf st0 (hs++runPartEx id (\new _ -> new))
#ifdef UNIX
    installHandler keyboardSignal (CatchOnce (txCheckpointAndExit tx)) Nothing
    takeMVar (txTerminationMVar tx)
#else
    let loop 'e' = txCheckpointAndExit tx
        loop _   = getChar >>= loop
    loop 'c'
#endif

-- order should not matter, though it does now.
-- we should ALSO allow multiple loggers at the same time! --log-target=stdout --log-target=syslog
options = [Option "" ["concurrent-threads"] (ReqArg (ConcurrentThreads . read) "num")
                      "Number of threads to use when executing side-effects. Default: 60"
          ,Option "" ["log-level"] (ReqArg (LogLevel . read . map toUpper) "level")
                      "Log level: DEBUG, INFO, NOTICE, WARNING, ERROR, CRITICAL, ALERT, EMERGENCY. Default: WARNING"
          ,Option "" ["log-target"] (ReqArg (LogTarget . readTarget) "target")
                      "Log target: stdout, syslog, or a FilePath such as /home/foo/bar.log . Default: stdout"
          ]

data Target = File FilePath | StdOut | SysLog deriving (Read,Show,Eq,Ord)

data Flag = ConcurrentThreads Int | LogLevel Priority | LogTarget Target deriving Show

readTarget arg = case map toLower arg of
                   "stdout" -> StdOut
                   "syslog" -> SysLog
                   _        -> File arg
castOptions = flip map options $ \(Option c f desc help) -> Option c f (worker desc) help
              where worker (NoArg _) = (NoArg ())
                    worker (ReqArg _ f) = ReqArg (const ()) f
                    worker (OptArg _ f) = OptArg (const ()) f
stdMainEx sp act = do
    args <- liftIO getArgs
    pn   <- liftIO getProgName
    let err n ls = liftIO $
                           -- XXX these next lines should be written to stderr!
                   do putStrLn ("Syntax error in command line - "++n)
                      putStrLn $ unlines $ map ("    "++) ls
                      putStrLn ("Usage "++usageInfo pn (castOptions ++ stdPartUsage sp))
    case getOpt' Permute options args of
      (flags,fs,args',[]) -> 
          liftIO (setLoggingSettings flags) >>
          case runOptM (stdPartHandlers sp) args' of
            Right (hs,[]) -> act (mkTxConfig flags) fs hs
            Right (_,ua)  -> err "unused arguments" ua
            Left es       -> err "errors" es
      (_,_,_,es)          -> err "errors" es



-- | StdParts are for heterogenous lists of application parts.
--
-- > data StdPart st = forall cf. ConfHandler cf => (:*:) (cf -> Handler st) (StdPart st)
-- >                | End
--
#ifndef __HADDOCK__
infixr :*:
data StdPart st = forall cf. ConfHandler cf => (cf -> Handler st) :*: (StdPart st)
                | End
#else
data StdPart st = HaddockDummy
#endif

stdPartUsage :: StdPart st -> [OptDescr ()]
stdPartUsage = concat . loop
    where loop (c :*: r) = confUsage c : loop r
          loop End       = []

stdPartHandlers :: StdPart st -> OptM [Handler st]
stdPartHandlers = sequence . loop
    where loop (c :*: r) = confHandler c : loop r
          loop End       = []

---
class CanMain a where
    asMain::a->IO ()
