{-# OPTIONS -fallow-overlapping-instances #-}
module HAppS.Protocols.UDP where

--import Data.Binary
import Control.Concurrent
import Control.Exception as E
import Control.Monad (liftM,foldM)
import Data.Typeable
import Foreign
import Foreign.Marshal
import HAppS.MACID
import HAppS.MACID.Logger
import HAppS.Protocols.SimpleHTTP2 ( runServerParts, ServerPart(..))
import HAppS.Util.Common ( readM )
import HAppS.Util.StdMain.Config
import Network.Socket hiding (listen)
import System.IO ( IOMode(WriteMode),hClose )
import System.Log.Logger

import qualified Data.ByteString as BS
--udpServer :: Ev st -> Conf -> Hander st
udpServer ss conf = SyncH $ return (work,listen conf)
    where work etf = etf $ liftM (either (error "Expected response") id) . runServerParts ss =<< getEvent

instance LogFormat Request where
    logFormat _ = show

{-instance Binary Request where
    put = put . show
    get = fmap read get-}

instance ConfHandler Conf where
    confUsage _ = copt ho
    confHandler fun = liftM fun (getOptM ho >>= foldM (\x y -> y x) nullConf)

ho :: [OptDescr (Conf -> OptM Conf)]
ho = [Option [] ["udp-port"] (ReqArg (\h c -> do x <- readM h; return c { port = x }) "port") "port to bind udp server"]


-- | UDP configuration
data Conf = Conf { bodyLimit :: Int -- ^ Limit on the number of bytes accepted for Requests
                 , port      :: Int -- ^ Port for the server to listen on.
                 } deriving(Show)

nullConf = Conf { bodyLimit = 2 * 1024
                , port      = 9000
                }


data Request = Request { udpMsg :: BS.ByteString, udpAddr :: SockAddr} deriving Typeable

instance Show Request where
    showsPrec n (Request bs (SockAddrInet port ip)) = showsPrec n (bs, port, ip)
    -- FIXME: support SockAddrUnix.
instance Read Request where
    readsPrec n str = do ((bs, port, ip),rest) <- readsPrec n str
                         return (Request bs (SockAddrInet (fromIntegral port) ip), rest)


listen :: Conf -> (Request -> IO ()) -> IO ()
listen conf hand = do
  s <- socket AF_INET Datagram 0
  bindSocket s (SockAddrInet (fromIntegral $ port conf) iNADDR_ANY)
  let work (bs, addr) = hand $ Request bs addr -- hand . uncurry Request
      maxInput = 1024*2
      loop = recvBSFrom s maxInput >>= forkIO . work >> loop
      pe e = logM "HAppS.Protocols.UDP" ERROR ("ERROR in accept thread: "++show e)
      infi = loop `E.catch` pe >> infi
  infi

recvBSFrom :: Socket -> Int -> IO (BS.ByteString, SockAddr)
recvBSFrom sock maxLength
    = do ptr <- mallocBytes maxLength
         (len, sockAddr) <- recvBufFrom sock ptr maxLength
         return (BS.packCStringLen (ptr,len), sockAddr)

sendUDPMessage             :: HostAddress -> PortNumber -> BS.ByteString -> IO ()
sendUDPMessage ip port msg =
    do fd <- socket AF_INET Datagram 0
       let target = (SockAddrInet (fromIntegral port) ip)
       connect fd target
       handle <- socketToHandle fd WriteMode
       BS.hPut handle msg
       hClose handle
