{-# OPTIONS -fglasgow-exts #-}
module HAppS.Protocols.HTTP.Types
    (Request(..), Result(..), RqBody(..), Input(..),
     getHeader,delHeader,getRqHeader, -- getHeader', 
     hasHeader, hasHeader',setRsCode,
     addHeader, setHeader, getRsHeader,
     Conf(..), nullConf, sresult, sresult',sresult'',sresult''',
     redirect,
     RsFlags(..), nullRsFlags, noContentLength,
     Version(..), Method(..), Headers(..), continueHTTP,
     Host, getHeadersBS
    ) where

import qualified Data.Map as M
import Data.Typeable(Typeable)
import Data.ByteString.Char8 as P(ByteString,pack,concat,unsafePackAddress,map,unpack)
import HAppS.Protocols.SURI
import System.IO(Handle)
import Data.Char (toLower)

import HAppS.Protocols.HTTP.Multipart ( ContentType )


-- lowercase pack
lpack = (P.map toLower) . P.pack

-- | HTTP version
data Version = Version Int Int
             deriving(Show,Read,Eq)

isHTTP1_1 rq = case rqVersion rq of Version 1 1 -> True; _ -> False
-- | Should the connection be used for further messages after this.
continueHTTP :: Request -> Result -> Bool
--continueHTTP rq res = isHTTP1_1 rq && getHeader' connectionC rq /= Just closeC && rsfContentLenth (rsFlags res)
continueHTTP rq res = isHTTP1_1 rq && getHeader connectionC rq /= Just closeC && rsfContentLenth (rsFlags res)

-- | HTTP configuration
data Conf = Conf { bodyLimit :: Int -- ^ Limit on the number of bytes accepted for Requests
                 , port      :: Int -- ^ Port for the server to listen on.
                 } deriving(Show)
nullConf = Conf { bodyLimit = 64 * 1024
                , port      = 8000
                }



-- | HTTP request method
data Method  = GET | HEAD | POST | PUT | DELETE | TRACE | OPTIONS | CONNECT
               deriving(Show,Read,Eq)

-- | Combined headers.
newtype Headers = Headers { unHeaders :: M.Map ByteString ByteString }

instance Show Headers where show = show . M.toList . unHeaders
instance Read Headers where readsPrec k s = mapFst (Headers . M.fromList) (readsPrec k s)

-- | Result flags
data RsFlags = RsFlags 
    { rsfContentLenth :: Bool -- ^ whether a content-length header will be added to the result.
    } deriving(Show,Read,Typeable)
nullRsFlags = RsFlags { rsfContentLenth = True }
-- | Don't display a Content-Lenght field for the 'Result'.
noContentLength :: Result -> Result
noContentLength res = res { rsFlags = upd } where upd = (rsFlags res) { rsfContentLenth = False }

data Input = Input
    { inputValue :: ByteString
    , inputFilename :: Maybe String
    , inputContentType :: ContentType
    }

type Host = (String,Int)

data Result  = Result  { rsCode    :: Int,
                         rsHeaders :: Headers,
                         rsFlags   :: RsFlags,
                         rsBody    :: [ByteString]
                       } deriving(Show,Read,Typeable)
data Request = Request { rqMethod  :: Method,
                         rqURI     :: SURI,
                         rqVersion :: Version,
                         rqHeaders :: Headers,
                         rqBody    :: RqBody,
                         rqPeer    :: Host
                       } deriving(Show,Read,Typeable)

class HasHeaders a where 
    updateHeaders::(Headers->Headers)->a->a
    headers::a->Headers

instance HasHeaders Result where updateHeaders f rs = rs{rsHeaders=f $ rsHeaders rs}
                                 headers = rsHeaders
instance HasHeaders Request where updateHeaders f rq = rq{rqHeaders = f $ rqHeaders rq} 
                                  headers = rqHeaders

data RqBody = NoBody                       -- ^ No request body present
            | Body ByteString              -- ^ Normal request body present
            | LargeBody ByteString Handle  -- ^ Large request body seen, let the user worry about limits

instance Show RqBody where
    show NoBody          = "N"
    show (Body s)        = 'B':show s
    show (LargeBody _ _) = "L"
instance Read RqBody where
    readsPrec k (' ':r) = readsPrec k r
    readsPrec _ ('N':r) = [(NoBody,r)]
    readsPrec k ('B':r) = mapFst Body $ readsPrec k r
    readsPrec _ ('L':r) = [(error "LargeBody cannot be deserialized",r)]
    readsPrec _ _       = []

mapFst _ []         = []
mapFst f ((k,v):xs) = (f k, v) : mapFst f xs

setRsCode code rs = return rs {rsCode = code}

class StringLike a b where
    xpack::a->b
instance StringLike String ByteString where
    xpack=pack
instance StringLike ByteString String where
    xpack=unpack
instance StringLike a a where xpack=id

getHeadersBS :: HasHeaders ho => ho -> [(ByteString,ByteString)]
getHeadersBS = M.toList . unHeaders . headers

--getHeaderString key rq =getHeader key rq >>= return . unpack

--getHeader :: Monad m => String -> Request -> m ByteString
--getHeader key rq = getHeader' (pack key) rq

--getHeader::(Monad m, Functor m,HasHeaders rq,StringLike ByteString v)=>String->rq -> m v
--getHeader key rq = fmap xpack $ getHeader' (xpack key) rq

--getHeader' :: Monad m => ByteString -> Request -> m ByteString
--getHeader' :: (Monad m,HasHeaders r) => ByteString -> r -> m ByteString
--getHeader' key rq = M.lookup (P.map toLower key) $ unHeaders $ headers rq -- rqHeaders rq
--getHeader' key rq = M.lookup (P.map toLower key) $ unHeaders $ headers rq -- rqHeaders rq

getRqHeader key rq = getHeader key (rq::Request)
getHeader key rq = fmap xpack $ M.lookup (P.map toLower $ xpack key) $ unHeaders $ headers rq -- rqHeaders rq

--getRsHeader :: (Monad m,HasHeaders r) => String -> r -> m ByteString
getRsHeader key rq = M.lookup (lpack key) $ unHeaders $ headers rq -- rsHeaders rq

hasHeader :: String -> Headers -> Bool
hasHeader key rq = hasHeader' (pack key) rq

hasHeader' :: ByteString -> Headers -> Bool
hasHeader' key rq = M.member (P.map toLower key) $ unHeaders rq

addHeader :: (HasHeaders r) => String -> String -> r -> r
addHeader k v = updateHeaders $ \headers -> Headers $ ins (lpack k) (pack v) (unHeaders headers)
    where  ins = M.insertWith (\n o -> P.concat [o, commaSpaceC,n])

setHeader :: (HasHeaders r) => String -> String -> r -> r
setHeader k v = updateHeaders $ \headers->Headers $ M.insert (lpack k) (pack v) (unHeaders $ headers) 

delHeader key = updateHeaders $ \headers-> Headers $ M.delete (xpack key) (unHeaders headers)

sresult :: Monad m => Int -> String -> m Result
sresult code s = sresult' code [pack s]

sresult' :: Monad m => Int -> [ByteString] -> m Result
sresult' code s = return $ Result code (Headers M.empty) nullRsFlags s

--sresult' :: Monad m => Int -> [ByteString] -> m Result
sresult'' code s = return $ Just $ Result code (Headers M.empty) nullRsFlags [pack s]
sresult''' code s = return $ Just $ return $ Result code (Headers M.empty) nullRsFlags [pack s]

--mbsresult' code s = return $ Just $ Result code (Headers M.empty) nullRsFlags s


redirect :: (ToSURI s, Monad m) => s -> m Result
redirect s = return $ Result 302 (Headers $ M.singleton locationC (pack (render (toSURI s)))) nullRsFlags []


-- constants here
locationC   = P.unsafePackAddress  8 "Location"#
commaSpaceC = P.unsafePackAddress  2 ", "#
closeC      = P.unsafePackAddress  5 "close"#
connectionC = P.unsafePackAddress 10 "Connection"#

