{-# OPTIONS -cpp #-}
module HAppS.Protocols.HTTP.Listen(listen) where

import System.Log.Logger

import HAppS.Protocols.HTTP.Types
import HAppS.Protocols.HTTP.Handler

import Control.Exception as E
import Control.Concurrent
import Network
import System.IO
{-
#ifndef mingw32_HOST_OS
-}
import System.Posix.Signals
{-
#endif
-}

listen :: Conf -> (Request -> IO Result) -> IO ()
listen conf hand = do
{-
#ifndef mingw32_HOST_OS
-}
  installHandler openEndedPipe Ignore Nothing
{-
#endif
-}
  s <- listenOn $ PortNumber $ toEnum $ port conf
  let work (h,hn,p) = do hSetBuffering h NoBuffering
                         let eh x = logM "HAppS.Protocols.HTTP.Listen" ERROR ("HTTP request failed with: "++show x)
                         request conf h (hn,fromIntegral p) hand `E.catch` eh
                         hClose h
  let loop = accept s >>= forkIO . work >> loop
  let pe e = logM "HAppS.Protocols.HTTP.Listen" ERROR ("ERROR in accept thread: "++show e)
  let infi = loop `E.catch` pe >> infi
  infi

