{-# OPTIONS -fglasgow-exts #-}
module HAppS.Protocols.HTTP
    (-- * Handlers
    handler, handlerIO, EvParPure, EvParIO,EvPar,EvParFn,
     -- * Server parts
     -- handleWith, 
     ext, basicAuth,
     -- * Serving files
     -- module HAppS.Protocols.HTTP.FileServe,
     -- * Types
     module HAppS.Protocols.HTTP.Types
    ) where

--import HAppS.Protocols.HTTP.FileServe
import HAppS.Protocols.HTTP.Listen
import HAppS.Protocols.HTTP.ServerPart
import HAppS.Protocols.HTTP.Types
import HAppS.MACID
import HAppS.MACID.Logger

import Control.Monad.Reader
import Data.ByteString.Char8(unpack)

type EvParFn st res = Ev st Request res -> Request -> IO Result
type EvPar res st = ReaderT (EvParFn st res) IO
--type EvPar res st = ReaderT (Ev st Request res -> Request -> IO Result) IO
--type EvPar res st = ReaderT (Ev st Request res -> Request -> IO (Maybe Result)) IO
type EvParPure st = EvPar Result st
type EvParIO  st = EvPar (IO Result) st

evParM :: r -> (t -> ReaderT r m a) -> t -> m a
evParM cfun wfun req = runReaderT (wfun req) cfun

ext :: Ev st Request res -> ServerPart (EvPar res st) Request Result
ext x = Handle $ \req -> do f <- ask
                            liftIO $ f x req


handlerIO :: Conf -> [ServerPart (EvParIO st) Request Result] -> Handler st
handlerIO conf ss = SyncH $ return (work, listen conf)
    where work ef = evParM ef $ compileServerParts defResult ss
          defResult = sresult 404 []

handler :: Conf -> [ServerPart (EvParPure st) Request Result] -> Handler st
handler conf ss = SyncH $ return (work, listen conf)
    where work ef = evParM (\evh ev -> ef (fmap return evh) ev) $ 
                    compileServerParts defResult ss
          defResult = sresult 404 []

instance Serialize Request where
    typeString _  = "HAppS.Protocols.HTTP.Request"
    encodeStringM = defaultEncodeStringM
    decodeStringM = defaultDecodeStringM

instance LogFormat Request where
    logFormat _ r = unwords [show $ rqMethod r, show $ rqURI r, show $ rqVersion r
                            ,"\n\n"++unlines [unpack k ++ ": "++unpack v | (k,v) <- getHeadersBS r]
                            ,show (rqBody r)]
