{-# OPTIONS -fglasgow-exts -fallow-undecidable-instances -fallow-overlapping-instances  #-}
module HAppS.MACID.Serialize
    (Serialize(..),encodeString,
     defaultTypeString,defaultEncodeStringM,defaultDecodeStringM
    ) where

import Control.Monad.Identity
import Control.Monad.Trans
--import Data.Binary
import Data.Int()
import Data.Typeable
import Foreign
import qualified Data.ByteString.Char8 as P
import HAppS.MACID.Types


--class (Read a,Show a,Typeable a)=> Serialize a where
class Serialize a where
    -- | Type string. This is used for event deserialization multiplexing.
    typeString :: Proxy a -> String
    -- | Decode an object from a String.
    decodeStringM :: MonadIO m => String -> m (a,String)
    -- | Encode an object to a String.
    encodeStringM :: Monad m => a -> m String
    -- | Encode an object to a list of PackedString.
    encodeFPS :: Monad m => a -> m [P.ByteString]
    encodeFPS x = liftM ((:[]) . P.pack) (encodeStringM x)

--    encodeBinary :: a -> Put
--    decodeBinary :: Get a

--    typeString    = defaultTypeString
--    encodeStringM = defaultEncodeStringM
--    decodeStringM = defaultDecodeStringM

instance (Read a,Show a,{-Binary a,-}Typeable a) => Serialize a where
    typeString    = defaultTypeString
    encodeStringM = defaultEncodeStringM
    decodeStringM = defaultDecodeStringM
--    encodeBinary  = put
--    decodeBinary  = get


--instance (Read a, Show a, Typeable a) => Serialize (Wrap a) where
--    typeString    = defaultTypeString
--    encodeStringM = defaultEncodeStringM
--    decodeStringM = defaultDecodeStringM

{--
for when you want to start versioning state
instance Serialize Model where
    typeString _  = "Model"
    encodeStringM = liftM ('1':) . defaultEncodeStringM
    decodeStringM ('1':r) = defaultDecodeStringM r
    decodeStringM _       = fail "Unsupported version of state"
--}

instance Show a => Show (Wrap a) where show = show . unWrap
instance Read a => Read (Wrap a) where readsPrec k str = mapFst Wrap $ readsPrec k str
{-instance Binary a => Binary (Wrap a) where
    get = liftM Wrap get
    put = put . unWrap-}

defaultTypeString :: Typeable a => Proxy a -> String
defaultTypeString = show . typeOf . unProxy
    where unProxy :: Proxy a -> a
          unProxy _ = undefined

defaultEncodeStringM :: (Monad m,Show a) => a -> m String
defaultEncodeStringM x = let s = show x in return (show (length s) ++ (' ':s))


defaultDecodeStringM :: (Read a, Monad m) => String -> m (a,String)
defaultDecodeStringM str =
  case readsPrec 0 str of
       [(len,' ':r)] -> let (k,v) = splitAt len r
                            val = readsPrec 0 k
                        in case val of
                             [(x,"")] -> return (x,v)
                             _        -> fail (
                                               "decodeStringM: parsing failed @ "++
--                                               (show $ typeString $ proxyOf val)++" "++
                                               (take (min 256 len) k))
       _ -> fail ("decodeStringM: parsing length field failed @ "++show (take 10 str))


-- | Serialize an object to a string, using error for failure.
encodeString :: Serialize a => a -> String
encodeString s = x where Identity x = encodeStringM s

mapFst :: (k -> t) -> [(k,v)] -> [(t,v)]
mapFst _ []     = []
mapFst f ((a,b):xs) = (f a,b) : mapFst f xs

unwrapFstM :: Monad m => m (Wrap a,b) -> m (a,b)
unwrapFstM c = c >>= \(Wrap a,b) -> return (a,b)

-- | Instances
{-
instance Serialize Int where
    typeString    = defaultTypeString
    decodeStringM = unwrapFstM . decodeStringM
    encodeStringM = encodeStringM . Wrap

instance Serialize Int64 where
    typeString    = defaultTypeString
    decodeStringM = unwrapFstM . decodeStringM
    encodeStringM = encodeStringM . Wrap

instance Serialize Integer where
    typeString    = defaultTypeString
    decodeStringM = unwrapFstM . decodeStringM
    encodeStringM = encodeStringM . Wrap
-}
instance Serialize () where
    typeString       = defaultTypeString
    decodeStringM x  = return ((), x)
    encodeStringM () = return ""
--    encodeBinary  () = return ()
--    decodeBinary     = return ()

instance Serialize a => Serialize [a] where
    typeString  x    = concat ["[", typeString (y x), "]"] where y :: Proxy [a] -> Proxy a; y _ = undefined
    encodeStringM xs = do s  <- encodeStringM $ length xs
                          ss <- mapM encodeStringM xs
                          return $ concat (s:ss)
    decodeStringM s  = do (x,r) <- decodeStringM s
                          let one :: Int; one = 1
                          (y,r) <- foldM (\(ys,t) _ -> do (y,r) <- decodeStringM t; return (y:ys,r)) ([],r) [one .. x]
                          return (reverse y, r)
--    encodeBinary l   = do put (length l)
--                          mapM_ encodeBinary l
--    decodeBinary     = do n <- get :: Get Int
--                          replicateM n decodeBinary

{-
instance Serialize Char where
    typeString           = defaultTypeString
    encodeStringM c      = return [c]
    decodeStringM (c:cs) = return (c,cs)
    decodeStringM []     = fail "decodeStringM (Char) - empty string."
-}
