{-# OPTIONS -fglasgow-exts #-}
module HAppS.MACID.Monad where

import Control.Exception(Exception)
import Control.Concurrent.STM
import Control.Monad.State
import HAppS.MACID.Types
import HAppS.MACID.Var

import System.Log.Logger

instance Monad (Ev st ev) where
    return x = Ev $ \_ -> return x
    fail x   = Ev ( \_ -> unsafeIOToSTM (logM "HAppS.MACID.Monad" CRITICAL ("Ev failure: "++x)) >> fail x)
    ev >>= f = Ev $ \env -> do x <- unEv ev env
                               unEv (f x) env

instance MonadState st (Ev st ev) where
    get   = readRef =<< sel evState
    put x = flip writeRef x =<< sel evState

instance Functor (Ev st ev) where fmap = liftM

-- | Lift an STM action into Ev.
liftSTM :: STM a -> AnyEv a
liftSTM = unsafeSTMToEv

-- | Catch errors.
catchEv :: Ev st ev a -> (Exception -> a) -> Ev st ev a
catchEv (Ev cmd) fun = Ev $ \env -> cmd env `catchSTM` (return . fun)


-- | Select a part of the environment.
sel :: (Env state event -> b) -> Ev state event b
sel f = Ev (return . f)

-- | Run a computation with a local environment.
plocal :: (Env sta a -> Env stb b) -> Ev stb b r -> Ev sta a r
plocal fun (Ev c) = Ev (c . fun)

-- | Run a computation with local state. Changes to state will be visible to outside.
localState :: (outer -> inner) -> (inner -> outer -> outer) -> Ev inner ev a -> Ev outer ev a
localState ifun ufun (Ev cmd) = Ev $ \env -> do
    old <- readRefSTM (evState env)
    ntv <- newRefSTM $! ifun old
    res <- cmd $ env { evState = ntv }
    new <- readRefSTM ntv
    writeRefSTM (evState env) $! ufun new old
    return res


-- | Run a computation with local event type.
localEvent :: ev -> Ev st ev a -> Ev st oev a
localEvent ev (Ev cmd) = Ev $ \env ->
    cmd $ env { evEvent = (evEvent env) { txEvent = ev } }
