{-# OPTIONS -fglasgow-exts #-}
--Copyright (C) 2005 HAppS.org. All Rights Reserved.
module HAppS.DBMS.Index where
import Prelude hiding (Eq,Ord)
import qualified Prelude as P
import qualified Data.Map as FMap
import qualified Data.Set as Set
import Data.List(foldl')
import Data.Maybe
import HAppS.Util.Common
-- import HAppS.DBMS.IndexVal

class Index index key elt where
	empty::index key elt
	insert::key->elt->index key elt->index key elt
	delete::key->elt->index key elt ->index key elt
	keys::index key elt->[Set.Set key]

--	member::key->index key elt->Bool
--	keys::index key elt->[key]

---data Map key elt = Map (FMap.Map key elt) (FMap.Map elt (Set.Set key))

data Ord key elt = Ord (FMap.Map elt (Set.Set key)) 
--type Ord k e = IV OrdIndex k e

instance (P.Ord key,P.Ord elt) => Index Ord key elt  where
	empty= Ord FMap.empty
	insert key val (Ord b) = 
		Ord $ maybe (FMap.insert val (Set.singleton key) $! b)
				(\s->FMap.insert val (Set.insert key s) b) (FMap.lookup val $! b)
	delete key val (Ord b) = 
		Ord $ if Set.size oldSet > 1 then FMap.insert val newSet b
			else FMap.delete val b
		where 
		oldSet = fromJust $ FMap.lookup val b
		newSet = Set.delete key oldSet 
	keys (Ord b) = FMap.elems b

class Eq index where
	eq::(P.Ord key,P.Ord elt,P.Eq elt)=>elt->index key elt->Set.Set key
	neq::(P.Ord key,P.Ord elt,P.Eq elt)=>elt->index key elt->Set.Set key

class (Eq index) => Ordable index where
	lt::(P.Ord key,P.Ord elt,P.Eq elt)=>elt->index key elt->Set.Set key
	lte::(P.Ord key,P.Ord elt,P.Eq elt)=>elt->index key elt->Set.Set key
	gt::(P.Ord key,P.Ord elt,P.Eq elt)=>elt->index key elt->Set.Set key
	gte::(P.Ord key,P.Ord elt,P.Eq elt)=>elt->index key elt->Set.Set key
	
instance Eq Ord where
	eq val (Ord b)=maybe Set.empty id $ FMap.lookup val b
	neq val (Ord b)=Set.unions $ FMap.elems $ FMap.filterWithKey (\k _->k/=val) b

instance Ordable Ord where
	--thanks to Thomasz Zielonka for explanation of splitLookup
	lt val (Ord b) = Set.unions $ FMap.elems $ (\ (x,_,_) ->x) $FMap.splitLookup val b
	gt val (Ord b) = Set.unions $ FMap.elems $ (\ (_,_,x) ->x) $FMap.splitLookup val b
	lte val (Ord b) = let (l,e,_) = FMap.splitLookup val b in 
						  Set.unions $ maybe [] return e ++ FMap.elems l
	gte val (Ord b) = let (_,e,g) = FMap.splitLookup val b in 
						  Set.unions $ maybe [] return e ++ FMap.elems g

	--lt val (Ord b)= Set.unions $ map snd $ takeWhile (\x->fst x<val) $ FMap.assocs b
	--lte val (Ord b)= Set.unions $ map snd $ takeWhile (\x->fst x<=val) $ FMap.assocs b
	--gt val (Ord b)= Set.unions $ map snd $ dropWhile (\x->fst x<=val) $ FMap.assocs b
	--gte val (Ord b)= Set.unions $ map snd $ dropWhile (\x->fst x<val) $ FMap.assocs b



data Text key elt= 
	Text (FMap.Map elt (Set.Set key))

--type Text k e = IV TextIndex k e

class Wordable x 
	where 
	getWords::x->[x]
	normWord::x->x

instance Wordable String 
	where 
	getWords=map normWord.words
	normWord=trim
	

instance (Wordable elt,P.Ord key,P.Ord elt) => Index Text key elt where
	empty=Text FMap.empty 
	insert item string (Text b) =
		Text $ foldl' addWord b $ getWords string
		where 
		addWord fm word =  
			FMap.insert word (maybe (Set.singleton item) 
							  (Set.insert item) $ FMap.lookup word fm) fm
	delete item val (Text b)= 	Text (foldl' remove b $ getWords  val)
		where 
		remove b word = 
			if Set.size oldSet > 1 then FMap.insert word newSet b 
			   else FMap.delete word b
			where
			oldSet = fromJust $ FMap.lookup word b
			newSet = Set.delete item oldSet 
	keys (Text b) = FMap.elems b


mkWords "" = [""]
mkWords x = filter (/="") $ mkWords' x
mkWords' [] = []
mkWords' ('\"':rs)= let (t,rs')=split (=='\"') rs in t:mkWords rs'
mkWords' rs = let (tag,rs')=split (==' ') rs in tag:mkWords rs'



--matches 

{--

	insert item string (Text b) =
		Text $ foldlStrict addWord b $ words string
		where 
		addWord w fm =  
			FMap.insert word (maybe (Set.singleton item) 
							  (Set.insert item) $ FMap.lookup word fm) fm
			where word = normWord w
	delete item val (Text b)= 	Text (foldlStrict remove b $ words  val)
		where 
		remove word b = 
			if Set.size oldSet > 1 then FMap.insert word newSet b 
			   else FMap.delete word b
			where
			oldSet = fromJust $ FMap.lookup word b
			newSet = Set.delete item oldSet 
	keys (Text b) = FMap.elems b
--}
--normWord val = trim val


{--instance Eq Text where
	eq val (Text b)=maybe Set.empty id $ FMap.lookup (normWord val) b
	neq val (Text b)=Set.unions $ FMap.elems $ 
					  FMap.filterWithKey (\k e->k/=normWord val) b
--}

contains val (Text b) = maybe Set.empty id $ FMap.lookup (normWord val) b
