module Main where
import System.Directory
import System

main = do
       args <- getArgs
       print args
       if null args then usage else do
       let (name:portBase:x) = args
       createDirectoryIfMissing True name
       createDirectoryIfMissing True $ name ++ "/src"
       createDirectoryIfMissing True $ name ++ "/static"
       createDirectoryIfMissing True $ name  ++ "/doc"
       writeFile (name++"/buildRun.sh") $ buildRun name portBase

usage = print "usage"

buildRun name portBase = "sp ghc -o " ++ name++".exe --make src/Main.hs\n\n\
                         \echo access your server via http on "++portBase++"80\n\n\
                         \echo type 'e' to exit\n\n\
                         \./"++name++".exe --http-port="++portBase++"80\n"
                                
--                         \ echo access your server via smtp on "++portBase++"25\n\n                                       