#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>
#include <signal.h>
#include "main_window.h"
#include "main_window_cb.h"
#include "nuevo_window.h"
#include "gwget_data.h"
#include "utils.h"


GladeXML *xml_pref = NULL;


void on_stop_button_clicked (GtkWidget *widget, gpointer data) 
{
	GwgetData* gwgetdata;
	
	
	
	gwgetdata = gwget_data_get_selected();
	if (gwgetdata) {
		gwget_data_stop_download(gwgetdata);
	}
	
}





gboolean
on_treeview1_button_press_event(GtkWidget *widget, GdkEventButton *event,gpointer user_data)
{
	GtkWidget *popup,*treev;
	GdkEventButton *event_button;
	GtkTreeSelection *select;
	GtkTreeIter iter;
    GtkTreeModel *model;
	GwgetData *gwgetdata;
	
	treev=glade_xml_get_widget(xml,"treeview1");
	select=gtk_tree_view_get_selection(GTK_TREE_VIEW(treev));
		
	if (event->type == GDK_BUTTON_PRESS) {
		event_button = (GdkEventButton *) event;
		if (event->button==3 && gtk_tree_selection_get_selected (select, &model, &iter)) {
			gwgetdata=gwget_data_get_selected();
			if (gwget_data_run(gwgetdata)) {
				gtk_widget_set_sensitive(glade_xml_get_widget(xml,"pause_download"),TRUE);
				gtk_widget_set_sensitive(glade_xml_get_widget(xml,"continue_download"),FALSE);
				gtk_widget_set_sensitive(glade_xml_get_widget(xml,"cancel_download"),TRUE);
			}
			else {
				if (gwgetdata->state==DL_COMPLETED) {
					gtk_widget_set_sensitive(glade_xml_get_widget(xml,"continue_download"),FALSE);
					gtk_widget_set_sensitive(glade_xml_get_widget(xml,"pause_download"),FALSE);
					gtk_widget_set_sensitive(glade_xml_get_widget(xml,"cancel_download"),FALSE);
				}
				else {
					gtk_widget_set_sensitive(glade_xml_get_widget(xml,"continue_download"),TRUE);
					gtk_widget_set_sensitive(glade_xml_get_widget(xml,"pause_download"),FALSE);
				
				}
			}
			popup=glade_xml_get_widget(xml,"popup1");
			gtk_menu_popup (GTK_MENU(popup), NULL, NULL, NULL, NULL, 
					event_button->button, event_button->time);
			return TRUE;
		}
	}
	return FALSE;			   

}

void stop_all_downloads(void)
{
	GwgetData* gwgetdata;
	GtkTreeIter iter;
	gint length,i;
	gchar *url;
	
	length=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(model),NULL);
	gtk_tree_model_get_iter_root(model,&iter);
	for (i=0;i<length;i++) {
		gtk_tree_model_get (model, &iter, URL_COLUMN, &url, -1);
		gwgetdata=g_object_get_data(G_OBJECT(model),url);
			
		if (gwget_data_run(gwgetdata)) {
				kill(gwgetdata->wget_pid,SIGKILL);
		}
	}

}

void on_quit1_activate(GtkWidget *widget, gpointer data) 
{
	gint response;
	gchar *url,*key;
	GwgetData *gwgetdata;
	GtkTreeIter iter;
	gint i,length;
	
	/* calculate the number of items in the treeview */
	length=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(model),NULL);
	printf("i; %d\n",length);
	
	/* Save the number of current downloads in the treev */
	/* When load again we can known the number of directories to load */
	gconf_client_set_int(gconf_client,"/apps/gwget2/n_downloads",length,NULL);
		
	gtk_tree_model_get_iter_root(model,&iter);
	for (i=0;i<length;i++) {
		
		gtk_tree_model_get (model, &iter, URL_COLUMN, &url, -1);
		gwgetdata=g_object_get_data(G_OBJECT(model),url);
	
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d",i);
		gconf_client_add_dir(gconf_client,key,
						GCONF_CLIENT_PRELOAD_NONE,NULL);
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/url",i);
		gconf_client_set_string(gconf_client,key,
					gwgetdata->url,NULL);
		
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/filename",i);
		gconf_client_set_string(gconf_client,key,
					gwgetdata->filename,NULL);	
	
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/dir",i);
		gconf_client_set_string(gconf_client,key,
					gwgetdata->dir,NULL);	
		
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/state",i);
		gconf_client_set_int(gconf_client,key,
					gwgetdata->state,NULL);	
		
		gtk_tree_model_iter_next(model,&iter);
	}

	if (num_of_download>0) {
		response = run_dialog(_("Cancel current downloads?"),_("There is at least one active download left. Really cancel all running transfers?"));
		if (response == GTK_RESPONSE_OK) {
			stop_all_downloads();
			gtk_main_quit();
		}
	}
	else {
		gtk_main_quit();
	}
	
	
}


void on_about1_activate(GtkWidget *widget, gpointer data)
{
	/* gchar *xml_file = NULL;
	GtkWidget *window = NULL;
	
	
	if (!xml_about) {
		xml_file=g_build_filename(PACKAGE_DATA_DIR,"about.glade",NULL);
		xml_about = glade_xml_new(xml_file,NULL,NULL);
		glade_xml_signal_autoconnect(xml_about);
	}
		
	window = glade_xml_get_widget (xml_about, "about1");
	gtk_widget_show(window);
		
	return;
	*/
	static GtkWidget *about = NULL;
	GdkPixbuf *pixbuf = NULL;
	gchar *logo_file;
	gchar *copy_text = "GNU GPL 2.0";
	gchar *about_text = _("A download manager for gnome2 using wget as backend.");
	gchar *authors[] = { 
			"David Sedeño Fernández <david@alderia.com>",
			NULL
	};

	gchar  *documenters[] = {
		                "",
		NULL
	};

	gchar *translator_credits = _("translator_credits");

	if (about != NULL ) 
	{
		gdk_window_show (about->window);
		gdk_window_raise (about->window);
		return;
	}

	logo_file=g_strdup_printf("%s/%s",PACKAGE_DATA_DIR,"gwget-large.png");
	pixbuf = gdk_pixbuf_new_from_file (logo_file, NULL);

	about = gnome_about_new (_("Gwget2"), VERSION,
			     	copy_text,
				about_text,
				(const char **)authors,
				(const char **)NULL,
				(const char *)translator_credits,
				pixbuf);

	if (pixbuf != NULL)
		g_object_unref (pixbuf);
	
	g_signal_connect (G_OBJECT (about), "destroy",
			G_CALLBACK (gtk_widget_destroyed), &about);
	                                                                                                                             
	gtk_widget_show (about);



	
}

/*
void 
on_about1_close(GtkWidget *widget, gpointer data)
{
	GtkWidget *window;
	
	window=glade_xml_get_widget(xml_about,"about1");
	gtk_widget_destroy(GTK_WIDGET(window));
	
	g_object_unref(G_OBJECT (xml_about));
	
	xml_about = NULL;
	
	return;
	
}
*/

void on_boton_nuevo_clicked(GtkWidget *widget, gpointer data) 
{
	create_nuevo_window();
}
	
void new_download(GwgetData* gwgetdata) {
	GtkTreeIter iter;
	
	gtk_list_store_append (GTK_LIST_STORE(model), &iter);
	gtk_list_store_set (GTK_LIST_STORE(model), &iter,URL_COLUMN,gwgetdata->url,
		CURRENTSIZE_COLUMN,gwgetdata->cur_size, FILENAME_COLUMN, gwgetdata->filename,
	    -1);
	
	gwgetdata->file_list=iter; 
	
	g_object_set_data(G_OBJECT(model),gwgetdata->url,gwgetdata);
		
}


void on_boton_pref_clicked(GtkWidget *widget, gpointer data)
{
	gchar *xml_file = NULL;
	GtkWidget *window = NULL,*entry=NULL;
	
	
	if (!xml_pref) {
		xml_file=g_build_filename(PACKAGE_DATA_DIR,"preferences.glade",NULL);
		xml_pref = glade_xml_new(xml_file,NULL,NULL);
		glade_xml_signal_autoconnect(xml_pref);
	}
		
	window = glade_xml_get_widget (xml_pref, "pref_window");
	entry = glade_xml_get_widget(xml_pref,"save_in_entry");
	gtk_entry_set_text(GTK_ENTRY(entry),gwget2_pref.download_dir);
	entry = glade_xml_get_widget(xml_pref,"num_retries_entry");
	gtk_entry_set_text(GTK_ENTRY(entry),g_strdup_printf("%d",gwget2_pref.num_retries));
	
	gtk_widget_show(window);
		
	return;
	
}

void 
on_pref_cancel_button_clicked(GtkWidget *widget,gpointer data)
{
	GtkWidget *pref_window = NULL;
	
	pref_window = glade_xml_get_widget(xml_pref,"pref_window");
	gtk_widget_hide(pref_window);
	
	
}
	
void 
on_pref_ok_button_clicked(GtkWidget *widget,gpointer data)
{
	GtkWidget *save_in = NULL, *pref_window = NULL,*num_retries=NULL,*resume;
	
	
	save_in=glade_xml_get_widget(xml_pref,"save_in_entry");
	gwget2_pref.download_dir=g_strdup(gtk_entry_get_text(GTK_ENTRY(save_in)));
	
	num_retries=glade_xml_get_widget(xml_pref,"num_retries_entry");
	gwget2_pref.num_retries=atoi(gtk_entry_get_text(GTK_ENTRY(num_retries)));
	
	resume=glade_xml_get_widget(xml_pref,"resume_at_start");
	gwget2_pref.resume_at_start=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(resume));
	
	pref_window = glade_xml_get_widget(xml_pref,"pref_window");
	gtk_widget_hide(pref_window);
	
	gconf_client_set_string(gconf_client,"/apps/gwget2/download_dir",
					g_strdup(gtk_entry_get_text(GTK_ENTRY(save_in))),NULL);
	gconf_client_set_int(gconf_client,"/apps/gwget2/num_retries",
					atoi(gtk_entry_get_text(GTK_ENTRY(num_retries))),NULL);
	gconf_client_set_bool(gconf_client,"/apps/gwget2/resume_at_start",
					gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(resume)),NULL);
}

void
on_browse_save_in_button_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *filesel = NULL;
	
	filesel= glade_xml_get_widget(xml_pref,"fileselection1");
	gtk_widget_set_sensitive (GTK_WIDGET(GTK_FILE_SELECTION(filesel)->file_list),FALSE);
	
	gtk_widget_show(filesel);
}
	
void
on_fs_cancel_button_clicked(GtkWidget *widget, gpointer data) 
{
	GtkWidget *filesel=NULL;
	filesel= glade_xml_get_widget(xml_pref,"fileselection1");
	
	gtk_widget_hide(filesel);
}

void 
on_fs_ok_button_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *filesel=NULL, *save_in = NULL;
	
	filesel= glade_xml_get_widget(xml_pref,"fileselection1");
	save_in = glade_xml_get_widget(xml_pref,"save_in_entry");
	
	gtk_entry_set_text(GTK_ENTRY(save_in),gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)));	
	printf("%s\n",gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)));
	
	gtk_widget_hide(filesel);
}
	
void 
on_popup_pause_button_clicked(GtkWidget *widget, gpointer data)
{
	GwgetData *gwgetdata;
	
	gwgetdata = gwget_data_get_selected();

	if (gwgetdata) {
		gwget_data_stop_download(gwgetdata);
	}
	
}

void on_popup_continue_activate(GtkWidget *widget, gpointer data)
{
	GwgetData *gwgetdata;
	
	
	
	
	/* gwget_data_get_selected doen't work :(  */
	gwgetdata = gwget_data_get_selected();
	
	
	if (gwgetdata) {
		printf("Iniciando...\n");
		gwget_data_start_download(gwgetdata);
	}
	else {
		printf("NULO\n");
	}
	
}

void on_cancel_download_activate(GtkWidget *widget,gpointer data)
{
	gint response;
	GwgetData *gwgetdata;
	gchar *msg;
	
	gwgetdata = gwget_data_get_selected();
	
	/* if (gwgetdata && (gwgetdata->state==DL_RETRIEVING)) */
	if (gwgetdata) 
	{
		msg = g_strdup_printf(_("Really cancel current download? (Url: %s)"),gwgetdata->url);
		response = run_dialog(_("Cancel download?"),_(msg));
		if (response==GTK_RESPONSE_OK) {
			gwget_data_stop_download(gwgetdata); 
			unlink (gwgetdata->local_filename);
    		gwgetdata->total_time = 0;
    		gwget_data_set_state (gwgetdata, DL_COMPLETED);
			gtk_list_store_remove(GTK_LIST_STORE(model),&gwgetdata->file_list);
			gwget_data_free(gwgetdata);
		}
	}
}


/* Remove completed downloads (popup) */
void on_remove_completed_activate(GtkWidget *widget, gpointer data)
{
	gint response;
	GwgetData *gwgetdata;
	GtkTreeIter iter;
	gint length,i;
	gchar *url;
	
	response = run_dialog(_("Remove completed"),_("Really remove completed downloads from the list?"));
	if (response == GTK_RESPONSE_OK) {
		length=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(model),NULL);
		gtk_tree_model_get_iter_root(model,&iter);
		for (i=0;i<length;i++) {
			gtk_tree_model_get (model, &iter, URL_COLUMN, &url, -1);
			printf("URL:%s\n",url);
			gwgetdata=g_object_get_data(G_OBJECT(model),url);
			
			if (gwgetdata->state==DL_COMPLETED) {
				gtk_list_store_remove(GTK_LIST_STORE(model),&iter);
				printf("Remove: %s\n",url);
			}
			else {
				gtk_tree_model_iter_next(model,&iter);
			}
		}
	}
				
}

/* Remove not running downloads (popup) */
void on_remove_notrunning_activate(GtkWidget *widget, gpointer data)
{
	gint response;
	GwgetData *gwgetdata;
	GtkTreeIter iter;
	gint length,i;
	gchar *url;
	
	response = run_dialog(_("Remove not running"),_("Really remove not running downloads from the list?"));
	if (response == GTK_RESPONSE_OK) {
		length=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(model),NULL);
		gtk_tree_model_get_iter_root(model,&iter);
		for (i=0;i<length;i++) {
			gtk_tree_model_get (model, &iter, URL_COLUMN, &url, -1);
			printf("URL:%s\n",url);
			gwgetdata=g_object_get_data(G_OBJECT(model),url);
			
			if (gwgetdata->state!=DL_RETRIEVING) {
				gtk_list_store_remove(GTK_LIST_STORE(model),&iter);
				printf("Remove: %s\n",url);
			}
			else {
				gtk_tree_model_iter_next(model,&iter);
			}
		}
	}
				
}

/* Remove all downloads (popup) */
void on_remove_all_activate(GtkWidget *widget, gpointer data)
{
	gint response;
	GwgetData *gwgetdata;
	GtkTreeIter iter;
	gint length,i;
	gchar *url;
	
	response = run_dialog(_("Remove all"),_("Really remove all downloads from the list?"));
	if (response == GTK_RESPONSE_OK) {
		length=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(model),NULL);
		gtk_tree_model_get_iter_root(model,&iter);
		printf("Length: %d\n",length);
		for (i=0;i<length;i++) {
			gtk_tree_model_get (model, &iter, URL_COLUMN, &url, -1);
			printf("URL:%s\n",url);
			gwgetdata=g_object_get_data(G_OBJECT(model),url);
			/* If it's running we must stop it */
			/* because the function that update the info will */
			/* be continue trying to update the info, so segfault! */
			if (gwgetdata->state==DL_RETRIEVING) {
				gwget_data_stop_download(gwgetdata);
			}
			
			gtk_list_store_remove(GTK_LIST_STORE(model),&iter);
			printf("Remove: %s\n",url);
			
		}
	}
				
}
	


