#include <config.h>
#include <glade/glade.h>
#include <gnome.h>
#include <gconf/gconf-client.h>
#include "main_window.h"
#include "main_window_cb.h"
#include "gwget_data.h"



/* Global Preferences */
Preferences gwget2_pref;

enum {
        TARGET_URI_LIST,
        TARGET_NETSCAPE_URL,
        TARGET_TEXT_PLAIN
};
                                                                                
/*
 * The used enumeration.
 */
guint dnd_type;


/* target types for dnd */
static  GtkTargetEntry dragtypes[] = {
        { "text/uri-list", 0, TARGET_URI_LIST },
        { "text/plain", 0, TARGET_NETSCAPE_URL }
};

void main_window(void) 
{
	GtkWidget * window = NULL;
	gchar *xml_file = NULL;
	GtkWidget *treev;
	GtkTreeSelection *select;

	
	if (!xml) {
		xml_file=g_build_filename(PACKAGE_DATA_DIR,"gwget.glade",NULL);
		xml = glade_xml_new(xml_file,NULL,NULL);
	
		glade_xml_signal_autoconnect(xml);
	}
	
	window = glade_xml_get_widget(xml,"main_window");
	treev = glade_xml_get_widget(xml,"treeview1");
	model = create_model();
	gtk_tree_view_set_model(GTK_TREE_VIEW(treev),GTK_TREE_MODEL(model));
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (treev));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	
	
	/* add the columns titles to the tree view */
    add_columns (GTK_TREE_VIEW (treev));
	
	gconf_client = gconf_client_get_default();
	gconf_client_add_dir (gconf_client, "/apps/gwget2", GCONF_CLIENT_PRELOAD_NONE,
                        NULL);
	
	/* gwget2_pref.download_dir=NULL; */
	gwget2_get_defaults_from_gconf();
	
	/* Drag and drop set up */
	gtk_drag_dest_set(GTK_WIDGET(window), 
						GTK_DEST_DEFAULT_ALL | GTK_DEST_DEFAULT_HIGHLIGHT,
						dragtypes, sizeof(dragtypes) / sizeof(dragtypes[0]),
                        GDK_ACTION_COPY);
						
	g_signal_connect(G_OBJECT(window), "drag-data-received",
                         G_CALLBACK(on_treeview_drag_received),
                         GUINT_TO_POINTER(dnd_type));

	
	
	gtk_widget_show(window);
}

void gwget2_get_defaults_from_gconf(void)
{
	gint num_dl,i;
	GwgetData *data;
	gchar *key,*url,*dir;
	DlState state;
	
	gwget2_pref.download_dir=gconf_client_get_string(gconf_client,"/apps/gwget2/download_dir",NULL);
	gwget2_pref.num_retries=gconf_client_get_int(gconf_client,"/apps/gwget2/num_retries",NULL);
	gwget2_pref.resume_at_start=gconf_client_get_bool(gconf_client,"/apps/gwget2/resume_at_start",NULL);
	
	num_dl=gconf_client_get_int(gconf_client,"/apps/gwget2/n_downloads",NULL);
	for (i=0;i<num_dl;i++) {
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/url",i);
		url=gconf_client_get_string(gconf_client,key,NULL);
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/dir",i);
		dir=gconf_client_get_string(gconf_client,key,NULL);
		data=gwget_data_create(url,dir);
		key=g_strdup_printf("/apps/gwget2/downloads_data/%d/state",i);
		state=gconf_client_get_int(gconf_client,key,NULL); 
		new_download(data);
		gwget_data_set_state(data,state); 
		if (gwget2_pref.resume_at_start && data->state!=DL_COMPLETED) {
			gwget_data_start_download(data);
		}
	}
	
}


void on_main_window_delete_event(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();
}

GtkTreeModel *
create_model (void)
{
  GtkListStore *model;
	model = gtk_list_store_new (NUM_COLUMNS,
				  G_TYPE_STRING, /* File name */
			      G_TYPE_STRING, /* URL */
			      G_TYPE_STRING, /* State */
				  G_TYPE_STRING, /* Current size */
				  G_TYPE_STRING, /* Total Size */
				  G_TYPE_STRING, /* Total Time */
				  G_TYPE_STRING,  /* Percentage */
				  G_TYPE_STRING,		/* Elapse Time */
			      G_TYPE_STRING,		/* Current time  */
				  G_TYPE_STRING,		/* Estimated time  */
				  G_TYPE_STRING,		/* Remain Time */
				/* Not viewable columns */ 
				  G_TYPE_INT, 		/* Pid */
				  G_TYPE_INT,		/* State int column */
				  G_TYPE_STRING 	/* Speed */
				  
				);
				  
	return GTK_TREE_MODEL (model);
}

void
add_columns (GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;

 
	
   /* File Name Column */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("File Name"),
						     renderer,
						     "text",
						     FILENAME_COLUMN,
						     NULL);
  gtk_tree_view_column_set_sort_column_id (column, URL_COLUMN);
  gtk_tree_view_append_column (treeview, column);

	/* State Column */
   renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("State"),
							renderer,
						     "text",
							STATE_COLUMN,
							NULL);
	gtk_tree_view_append_column (treeview, column);
	
	/* Current Size */
	renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Current Size"),
							renderer,
						     "text",
							CURRENTSIZE_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, CURRENTSIZE_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	
	/* Total Size */
	renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Total Size"),
							renderer,
						     "text",
							TOTALSIZE_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, TOTALSIZE_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	
	/* Percentage */
	renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Percentage"),
							renderer,
						     "text",
							PERCENTAGE_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, PERCENTAGE_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	
	
	/* Total Time */
	/* renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Total Time"),
							renderer,
						     "text",
							TOTALTIME_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, TOTALTIME_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	*/
	
	/* Elapse Time */
	 renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Elapsed Time"),
							renderer,
						     "text",
							ELAPSETIME_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, ELAPSETIME_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	
	/* Current Time */
	/*
	renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Current Time"),
							renderer,
						     "text",
							CURRENTTIME_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, CURRENTTIME_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	*/
	
	/* Estimated Time */
	/* renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Estimated Time"),
							renderer,
						     "text",
							ESTIMATEDTIME_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, ESTIMATEDTIME_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	*/
	/* REMAINTIME_COLUMN */
	renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Remaining Time"),
							renderer,
						     "text",
							REMAINTIME_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, REMAINTIME_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	
	/* Speed */
	renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Speed"),
							renderer,
						     "text",
							SPEED_COLUMN,
							NULL);
	gtk_tree_view_column_set_sort_column_id (column, SPEED_COLUMN);
  	gtk_tree_view_append_column (treeview, column);
	
	  	
}

void on_treeview_drag_received(GtkWidget * widget, GdkDragContext * context, int x,
                     int y, GtkSelectionData * seldata, guint info,
                     guint time, gpointer data)
{
	gchar *file;
	GwgetData *gwgetdata;
	
	dnd_type = GPOINTER_TO_UINT(data);
    file=((gchar *) (seldata->data));
      
	printf("URL1: %s\ntype: %d\n", file,dnd_type);	
    if(dnd_type==TARGET_URI_LIST || dnd_type==TARGET_NETSCAPE_URL)
    {
		gwgetdata=gwget_data_create(file,gwget2_pref.download_dir);
		new_download(gwgetdata);
		gwget_data_start_download(gwgetdata);
		
		gtk_drag_finish(context, TRUE, FALSE, time);
	}
	else
	{
		gtk_drag_finish(context, FALSE, TRUE, time);
    }
}


	
