# GUI For ufw (Uncomplicated FireWall) - Version 0.20.6
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import gtk
import gobject
import commands 
import string
import time
import locale
import gettext
_ = gettext.gettext

from checks                   import check_gufw_status,check_deny_all,check_gufw_log
from file_operations          import save_rules_file,changed_rules,file_add_line
from variables_paths_messages import *



# Set window
def set_window_values(p_gufw,p_status,p_message):

    # Not working (and not finish working)
    if p_status == c_not_working:
        block_all_events(p_gufw)                                       # Blocks events.
        reboot_ufw()                                                   # Restart ufw
        set_active_values(p_gufw,c_not_working)                        # Set values
        set_sensitive_values(p_gufw,check_gufw_status())               # Set sensitive
        unblock_all_events(p_gufw)                                     # Unblock events
    # Working...
    elif p_status == c_working:
        block_all_events(p_gufw)                                       # Block events.
        save_rules_file()                                              # Save actual rules for future comparation
        set_active_values(p_gufw,c_working)                            # Set values
        set_sensitive_values(p_gufw,c_working)                         # Set sensitive
        if p_message == c_enabled: 
            p_gufw.status.push(1, _(text_012))
        if check_gufw_log() == c_enabled:                              # Start message in Gufw log.
            file_add_line(path_gufw_log,"[" + time.strftime('%x %X') + "] " + _(text_024) + "\n")

    # Finish working
    elif p_status == c_finish_working:
        reboot_ufw()                                                   # Restart ufw
        set_active_values(p_gufw,c_not_working)                        # Set values
        set_sensitive_values(p_gufw,check_gufw_status())               # Set sensitive
        unblock_all_events(p_gufw)                                     # Unblock events
        if ( p_message == c_enabled ) and ( changed_rules() == True ): # Message about operation
            p_gufw.status.push(1, _(text_023))	
        elif ( p_message == c_enabled ):
            p_gufw.status.push(1, _(text_043))
            if check_gufw_log() == c_enabled:                              
            	file_add_line(path_gufw_log,"[" + time.strftime('%x %X') + "] " + _(text_043) + "\n")
        if check_gufw_log() == c_enabled:                              # Start message in Gufw log.
            file_add_line(path_gufw_log,"[" + time.strftime('%x %X') + "] " + _(text_025) + "\n")
            
       




#Set status of shields, status text, tooltip rules, tray icon.
def set_status_shield(p_gufw,p_status):

    # Working?
    if p_status == c_working:
        # Shield
        p_gufw.shield_image.set_from_file(path_gufw_default)
        # Status text
        l_text = '<span font_desc=" ' + c_font_text + '" foreground="' + c_color_working + '"><b>' + _(text_007) + '</b></span>'
        p_gufw.label_status.set_markup(l_text)
        # Tray Icon
        tray_icon.set_from_file(path_icon_tray)
        tray_icon.set_tooltip(_(text_012))
            
    # Not working -> Disabled / Enabled Allow / Enabled Deny
    else:
        # Disabled
        if check_gufw_status() == c_disabled:
            # Shield
            p_gufw.shield_image.set_from_file(path_gufw_disabled)
            # Status text
            l_text = '<span font_desc="' + c_font_text + '" foreground="' + c_color_disabled + '"><b>' + _(text_006) + '</b></span>'
            p_gufw.label_status.set_markup(l_text)
            # Tray Icon
            tray_icon.set_from_file(path_icon_disabled)
            tray_icon.set_tooltip(_(text_014))

        # Enabled -> Deny all    
        elif check_deny_all() == c_enabled:
            # Shield
            p_gufw.shield_image.set_from_file(path_gufw_deny)
            # Status text
            l_text = '<span font_desc="' + c_font_text + '" foreground="' + c_color_deny + '"><b>' + _(text_005) + '</b></span>'
            p_gufw.label_status.set_markup(l_text)
            # Tray Icon
            tray_icon.set_from_file(path_icon_deny)
            tray_icon.set_tooltip(_(text_016))

        # Enabled -> Allow all
        else:
            # Shield
            p_gufw.shield_image.set_from_file(path_gufw_allow)
            # Status text
            l_text = '<span font_desc="' + c_font_text + '" foreground="' + c_color_allow + '"><b>' + _(text_005) + '</b></span>'
            p_gufw.label_status.set_markup(l_text)
            # Tray Icon
            tray_icon.set_from_file(path_icon_allow)
            tray_icon.set_tooltip(_(text_018))

        
# Refresh Rules
def set_text_rules(p_gufw,p_select_all):

    v_rules_model.clear()

    l_row    = 1
    l_status = commands.getstatusoutput(cmd_status)
    l_status = string.split(l_status[1],"\n")				

    # For all rules
    for l_line in l_status:

        l_line = l_line.upper()
        if ( l_line.find(c_default.upper()) == -1 ) and ( l_line.find(c_new_profiles.upper()) == -1 ) and ( ( l_line.find(c_allow.upper()) != -1 ) or ( l_line.find(c_deny.upper()) != -1 ) or ( l_line.find(c_limit.upper()) != -1 ) ):

            l_iterador = v_rules_model.insert(l_row)
            v_rules_model.set_value(l_iterador,0,l_row) 
            
            # Deny?
            if l_line.find(c_deny.upper()) != -1:
                l_split_rule = l_line.split(c_deny.upper())
                
                v_rules_model.set_value(l_iterador,1,l_split_rule[0].capitalize())
                v_rules_model.set_value(l_iterador,2,c_deny.upper())
                v_rules_model.set_value(l_iterador,3,string.strip(l_split_rule[1]).capitalize())

            # Allow?
            elif l_line.find(c_allow.upper()) != -1:
                l_split_rule = l_line.split(c_allow.upper())
                v_rules_model.set_value(l_iterador,1,l_split_rule[0].capitalize())
                v_rules_model.set_value(l_iterador,2,c_allow.upper())
                v_rules_model.set_value(l_iterador,3,string.strip(l_split_rule[1]).capitalize())
                
            # Limit?
            elif l_line.find(c_limit.upper()) != -1:
                l_split_rule = l_line.split(c_limit.upper())
                v_rules_model.set_value(l_iterador,1,l_split_rule[0].capitalize())
                v_rules_model.set_value(l_iterador,2,c_limit.upper())
                v_rules_model.set_value(l_iterador,3,string.strip(l_split_rule[1]).capitalize())

            
            # Color Allow/Deny/Limit
            # Allow?
            if l_line.find(c_allow.upper()) != -1:
                if check_deny_all() == c_disabled:
                    v_rules_model.set_value(l_iterador,4,c_color_disabled)
                else:
                    v_rules_model.set_value(l_iterador,4,c_color_allow)
            # Deny?
            elif l_line.find(c_deny.upper()) != -1:
                if check_deny_all() == c_enabled:
                    v_rules_model.set_value(l_iterador,4,c_color_disabled)
                else:
                    v_rules_model.set_value(l_iterador,4,c_color_deny)
            # Limit?
            elif l_line.find(c_limit.upper()) != -1:
                v_rules_model.set_value(l_iterador,4,c_color_limit)


            l_row += 1
            
    if p_select_all == c_select_all:
        treeselection = p_gufw.rules.get_selection()
        while l_row >= 0:
            treeselection.select_path(l_row)
            l_row = l_row - 1

        
        
        
        
# Set sensitive the window items.
def set_sensitive_values(p_gufw,p_status):
    # Firewall
    if p_status == c_working:
        p_status = c_disabled
        p_gufw.firewall.set_sensitive(c_disabled)
    else:
        p_gufw.firewall.set_sensitive(c_enabled)
    # Menu
    p_gufw.add_menu.set_sensitive(p_status)
    p_gufw.import_menu.set_sensitive(p_status)
    p_gufw.export_menu.set_sensitive(p_status)
    p_gufw.about_menu.set_sensitive(p_status)
    if check_gufw_log() == c_enabled:
    	p_gufw.gufw_log.set_sensitive(p_status)
    else:
    	p_gufw.gufw_log.set_sensitive(c_disabled)
    p_gufw.edit_pref.set_sensitive(p_status)
    # Deny/Allow all
    p_gufw.deny_all.set_sensitive(p_status)
    p_gufw.allow_all.set_sensitive(p_status)
    # Simple tab
    p_gufw.simple_action.set_sensitive(p_status)
    p_gufw.simple_port.set_sensitive(p_status)
    p_gufw.simple_proto.set_sensitive(p_status)
    p_gufw.simple_add1.set_sensitive(p_status)
    # Preconfigured tab
    p_gufw.preconf_action.set_sensitive(p_status)
    p_gufw.preconf_service.set_sensitive(p_status)
    p_gufw.preconf_add1.set_sensitive(p_status)
    p_gufw.preconf_program.set_sensitive(p_status)
    p_gufw.preconf_type.set_sensitive(p_status)
    # Advanced tab
    p_gufw.advanced_action.set_sensitive(p_status)
    p_gufw.advanced_proto.set_sensitive(p_status)
    p_gufw.advanced_fromip.set_sensitive(p_status)
    p_gufw.advanced_fromport.set_sensitive(p_status)
    p_gufw.advanced_fromport_range.set_sensitive(p_status)
    p_gufw.advanced_toip.set_sensitive(p_status)
    p_gufw.advanced_toport.set_sensitive(p_status)
    p_gufw.advanced_toport_range.set_sensitive(p_status)
    p_gufw.advanced_add1.set_sensitive(p_status)
    p_gufw.advanced_clear.set_sensitive(p_status)
    # Delete one/all
    p_gufw.remove_one.set_sensitive(p_status)
    p_gufw.select_all.set_sensitive(p_status)
    p_gufw.close_app.set_sensitive(p_status)

        
        
# Set active values of window
def set_active_values(p_gufw,p_working):
    
    # Text & Shield
    set_status_shield(p_gufw,p_working)

    # Firewall
    p_gufw.firewall.set_active(check_gufw_status())
    
    # Allow/Deny all
    p_gufw.deny_all.set_active(check_deny_all())
    p_gufw.allow_all.set_active(not check_deny_all())
    
    # Preconfigured type
    set_preconf_type(p_gufw)
    
    # Set rules when not working
    if p_working != c_working:
    	set_text_rules(p_gufw,c_not_select_all)
    	
    # Status Gufw (Enabled/Disabled/No Working)
    if p_working == c_working:
    	p_gufw.flg_status.set_text(c_working_txt)
    elif check_gufw_status() == c_disabled:
    	p_gufw.flg_status.set_text(c_disabled_txt)
    else:
    	p_gufw.flg_status.set_text(c_enabled_txt)

    # Bar progress
    p_gufw.progress.set_fraction(0.0) 


# Block events
def block_all_events(p_gufw):
    # Menu
    p_gufw.import_menu.handler_block(t_handlers_block[2])
    p_gufw.export_menu.handler_block(t_handlers_block[3])
    p_gufw.edit_pref.handler_block(t_handlers_block[4])
    p_gufw.gufw_log.handler_block(t_handlers_block[5])
    p_gufw.about_menu.handler_block(t_handlers_block[6])
    p_gufw.add_menu.handler_block(t_handlers_block[8])
    # Main
    p_gufw.firewall.handler_block(t_handlers_block[9])
    p_gufw.allow_all.handler_block(t_handlers_block[10])
    # Simple
    p_gufw.simple_add1.handler_block(t_handlers_block[11])
    # Preconfigured
    p_gufw.preconf_add1.handler_block(t_handlers_block[12])
    p_gufw.preconf_type.handler_block(t_handlers_block[13])
    # Advanced
    p_gufw.advanced_add1.handler_block(t_handlers_block[14])
    p_gufw.advanced_clear.handler_block(t_handlers_block[15])
    p_gufw.advanced_fromip.handler_block(t_handlers_block[16])
    p_gufw.advanced_toip.handler_block(t_handlers_block[17])
    # Remove one/all
    p_gufw.remove_one.handler_block(t_handlers_block[18])
    p_gufw.select_all.handler_block(t_handlers_block[19])
    p_gufw.close_app.handler_block(t_handlers_block[20])
    

# Unblock events.    
def unblock_all_events(p_gufw):
    # Menu
    p_gufw.import_menu.handler_unblock(t_handlers_block[2])
    p_gufw.export_menu.handler_unblock(t_handlers_block[3])
    p_gufw.edit_pref.handler_unblock(t_handlers_block[4])
    p_gufw.gufw_log.handler_unblock(t_handlers_block[5])
    p_gufw.about_menu.handler_unblock(t_handlers_block[6])
    p_gufw.add_menu.handler_unblock(t_handlers_block[8])
    # Main
    p_gufw.firewall.handler_unblock(t_handlers_block[9])
    p_gufw.allow_all.handler_unblock(t_handlers_block[10])
    # Simple
    p_gufw.simple_add1.handler_unblock(t_handlers_block[11])
    # Preconfigured
    p_gufw.preconf_add1.handler_unblock(t_handlers_block[12])
    p_gufw.preconf_type.handler_unblock(t_handlers_block[13])
    # Advanced
    p_gufw.advanced_add1.handler_unblock(t_handlers_block[14])
    p_gufw.advanced_clear.handler_unblock(t_handlers_block[15])
    p_gufw.advanced_fromip.handler_unblock(t_handlers_block[16])
    p_gufw.advanced_toip.handler_unblock(t_handlers_block[17])
    # Remove one/all
    p_gufw.remove_one.handler_unblock(t_handlers_block[18])
    p_gufw.select_all.handler_unblock(t_handlers_block[19])
    p_gufw.close_app.handler_unblock(t_handlers_block[20])

# Type preconfigured pushed.
def set_preconf_type(p_gufw):

    l_type = p_gufw.preconf_type.get_active()

    if l_type == 0:
        p_gufw.preconf_service.show()
        p_gufw.preconf_program.hide()
    else:
        p_gufw.preconf_service.hide()
        p_gufw.preconf_program.show()


# Reboot ufw
def reboot_ufw():
    commands.getstatusoutput("/etc/init.d/ufw restart")




# Parameter = --quiet -> Only Icon tray.
# else Show window.
def show_window(p_gufw):
    l_parameters = sys.argv
    l_found_tray = " "
    
    for l_param in l_parameters:
        if l_param.find("--quiet") != -1:
            l_found_tray = "X"
            v_coordx[0] = 1
            v_coordy[0] = 1

   
    if l_found_tray != "X":
            p_gufw.window.show()
