# GUI For ufw (Uncomplicated FireWall) - Version 0.20.6
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import gobject
import gtk
import string
import commands 
import gnome
import os
import time
import locale
import gettext
_ = gettext.gettext

from gtk             import glade
from general_rutines import add_to_gufw_log,popup,popup_answer,view_print,component_command
from set_window      import set_window_values
from file_operations import dialog_file,file_to_list,file_replace_string,list_search_string
from checks          import check_autostart,check_gufw_log,check_minimize_on_close,check_show_tray,check_ufw_log

from variables_paths_messages import *




# ---------------------------- FILE MENU ------------------------------
# Export rules
def export_rules(self,p_gufw):
    set_window_values(p_gufw,c_working,c_enabled)
    task = export_rutine(p_gufw)
    gobject.idle_add(task.next)

# Export rules to file
def export_rutine(p_gufw):
    
    # Load rules in lists
    l_ipv4 = []
    l_ipv6 = []
    if ( file_to_list(path_ufw_rules_ipv4,l_ipv4) == c_error ) or ( file_to_list(path_ufw_rules_ipv6,l_ipv6) == c_error ):
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
        
    # Check if exist rules to export
    if ( list_search_string(l_ipv4,c_tuple) != c_found ) and ( list_search_string(l_ipv6,c_tuple) != c_found):
        p_gufw.status.push(1, _(text_028))
        add_to_gufw_log(_(text_028))
        set_window_values(p_gufw,c_finish_working,c_disabled)
        yield None
        return
    
    l_file = dialog_file(1)
    
    if l_file == c_none:
        add_to_gufw_log(_(text_060))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
    else:
        # Confirmation overwrite popup
        if os.path.exists(l_file):
            result = popup_answer(_(text_074))
            if result == gtk.RESPONSE_CANCEL:
                add_to_gufw_log(_(text_060))
                set_window_values(p_gufw,c_finish_working,c_enabled)
                yield None
                return 
            
    # File exist?
    try:
        l_rules_export = open(l_file, "w") 
    except IOError:
        popup(_(text_076))
        add_to_gufw_log(_(text_076))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return

    # Write header file
    l_rules_export.write(c_gufw_header_import_export)

    # Count total rows for progress bar
    l_rows = 0
    l_row  = 0
    for l_line in l_ipv4:
        l_rows += 1
    for l_line in l_ipv6:
        l_rows += 1

    # Save rules to file
    for l_line in l_ipv4:
        
        l_row += 1
        l_line = l_line.upper()
        
        if l_line.find(c_tuple) != -1:
            l_rules_export.write(l_line)

        # Progress bar
        l_progress = float(l_row) / float(l_rows)
        if l_progress > 1:
            l_progress = 1.0
        p_gufw.progress.set_fraction(l_progress)
        yield True

    for l_line in l_ipv6:
        
        l_row += 1
        l_line = l_line.upper()
        
        if l_line.find(c_tuple) != -1:
            l_rules_export.write(l_line)
        
        # Progress bar
        l_progress = float(l_row) / float(l_rows)
        if l_progress > 1:
            l_progress = 1.0
        p_gufw.progress.set_fraction(l_progress)
        yield True

    # Close files
    l_rules_export.close()
    add_to_gufw_log(_(text_071) + l_file)
    p_gufw.status.push(1, _(text_071))
    
    set_window_values(p_gufw,c_finish_working,c_disabled)
    yield None
    
    

# Import rules
def import_rules(self,p_gufw):
    set_window_values(p_gufw,c_working,c_enabled)
    task = import_rutine(p_gufw)
    gobject.idle_add(task.next)



# Import rules from file
def import_rutine(p_gufw):
    
    l_file = dialog_file(0)
    
    if l_file == "None":
        add_to_gufw_log(_(text_060))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
    else:
        # Confirmation overwrite popup
        result = popup_answer(_(text_081))
        # Canceled
        if result == gtk.RESPONSE_CANCEL:
            add_to_gufw_log(_(text_060))
            set_window_values(p_gufw,c_finish_working,c_enabled)
            yield None
            return 

    # Error opening file.
    try:
        l_rules_aux = open(l_file, "r")
    except IOError:
        popup(_(text_083))
        add_to_gufw_log(_(text_083))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
        
    l_rules_aux.close()

    l_rules_import = []
    
    if file_to_list(l_file,l_rules_import) == c_error:
    	set_window_values(p_gufw,c_finish_working,c_enabled)
    	yield None
    	return
    
    # Rows in file for progress bar
    l_rows = 0
    l_row  = 0
    for l_line in l_rules_import:
        l_rows += 1
    if l_rows == 0:
        popup(_(text_085))
        add_to_gufw_log(_(text_085))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
    
    # Import rules
    sw_first  = "X"
    for l_line in l_rules_import:
        # Check first line file for format.
        if sw_first == "X":
            sw_first = " "
            if l_line <> c_gufw_header_import_export:
                # Error in format file
                popup(_(text_085))
                add_to_gufw_log(_(text_085))
                set_window_values(p_gufw,c_finish_working,c_enabled)
                yield None
                return
            else:
                p_gufw.progress.set_fraction(0.2)
                yield True

        else:
            # Descomponent rule
            l_line        = l_line.upper()
            l_line = l_line.replace("\n","")
            l_rule_descomponent = l_line.split(" ")

            # Descomponent rule
            l_actual_rule = l_rule_descomponent[3]
            l_proto       = l_rule_descomponent[4]

            # TO
            l_to_port  = l_rule_descomponent[5]
            l_to_ip    = l_rule_descomponent[6]

            # FROM
            l_from_port  = l_rule_descomponent[7]
            l_from_ip    = l_rule_descomponent[8]

            # Component command
            l_command = component_command("",l_actual_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)
            commands.getstatusoutput(l_command)
            add_to_gufw_log(l_command)

            # Progress bar
            l_row += 1
            l_progress = float(l_row) / float(l_rows)
            if l_progress > 1:
                l_progress = 1.0
            p_gufw.progress.set_fraction(l_progress)
            yield True
                
    add_to_gufw_log(_(text_070) + l_file)
    set_window_values(p_gufw,c_finish_working,c_enabled)
    yield None


# Add rules from file
def add_rules(self,p_gufw):
    set_window_values(p_gufw,c_working,c_enabled)
    task = add_ips_rutine(p_gufw)
    gobject.idle_add(task.next)



# Add rules to file
def add_ips_rutine(p_gufw):
    
    l_file = dialog_file(2)
    
    # Canceled?
    if l_file == c_none:
        add_to_gufw_log(_(text_060))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
    else:
        # Confirmation add popup
        result = popup_answer(_(text_088))

        # Canceled overwrite?
        if result == gtk.RESPONSE_CANCEL:
            add_to_gufw_log(_(text_060))
            set_window_values(p_gufw,c_finish_working,c_enabled)
            yield None
            return 

    # Open file
    try:
        l_rules_aux = open(l_file, "r") 
    except IOError:
        popup(_(text_083))
        add_to_gufw_log(_(text_083))
        set_window_values(p_gufw,c_finish_working,c_enabled)
        yield None
        return
    l_rules_aux.close()
    
    l_rules_import = []
    
    if file_to_list(l_file,l_rules_import) == c_error:
    	set_window_values(p_gufw,c_finish_working,c_enabled)
    	yield None
    	return
    
    # Number rows & format file checked
    l_rows = 0
    l_row  = 0
    for l_rule in l_rules_import:
        l_rows += 1
        l_rule = l_rule.replace(" ","")
        if l_rule != "\n":
            l_split1 = string.split(l_rule,":")
            if len(l_split1) == 2:
                l_split2 = string.split(l_split1[1],"-")
            if ( len(l_split1) != 2 ) or ( len(l_split2) != 2 ):
                popup(_(text_091) + str(l_rows) + _(text_092))
                p_gufw.status.push(1, _(text_085))
                set_window_values(p_gufw,c_finish_working,c_disabled)
                yield None
                return
                
    
    # Add IP addresses
    for l_rule in l_rules_import:
           
        if l_rule != "":
            l_split1 = string.split(l_rule,":")
            if len(l_split1) == 2:
                l_split2 = string.split(l_split1[1],"-")
            
            if ( len(l_split1) == 2 ) and ( len(l_split2) == 2 ):
                l_ip = string.split(l_split1[1],"-")
                                
                l_command = component_command("",c_deny,c_any,l_ip[0],c_any,c_any,c_any)
                commands.getstatusoutput(l_command)
                add_to_gufw_log(l_command)
                
        l_row += 1
        l_progress = float(l_row) / float(l_rows)
        if l_progress > 1:
            l_progress = 1.0
            
        p_gufw.progress.set_fraction(l_progress)
        yield True
     
    add_to_gufw_log(_(text_072))
    set_window_values(p_gufw,c_finish_working,c_enabled)
    yield None








	



# --------------------- HELP AND PREFERENCED MENU ---------------------
def see_gufw_log(self,p_gufw):
   
    # Open preferences window	
    pref_dialog = glade.XML(path_gufw_logging, "log_window")
    dialog      = pref_dialog.get_widget("log_window")
    text_log    = pref_dialog.get_widget("tv_gufw_log")
    
    # Load log
    l_file = open(path_gufw_log, "r") 
    string = l_file.read()
    text_log = text_log.get_buffer()
    text_log.set_text(_(text_097) + string + _(text_098))
    l_file.close()

    pref_dialog.signal_autoconnect({
      "btn_close_clicked_cb":         lambda x:close_gufw_log(p_gufw,pref_dialog),
      "cb_wrapping_toggled_cb":       lambda x:wrapping_gufw_log(pref_dialog),
      "btn_clear_clicked_cb":         lambda x:clear_gufw_log(pref_dialog)
    })
    dialog.connect("delete_event", lambda w,e: exit_close_gufwlog_btn(p_gufw,pref_dialog))

    set_window_values(p_gufw,c_working,c_disabled)
    add_to_gufw_log(_(text_009))

    dialog.show()

        
# Close gufw log in close button
def exit_close_gufwlog_btn(p_gufw,pref_dialog):
    dialog = pref_dialog.get_widget("log_window")
    dialog.destroy()
    p_gufw.status.push(1,"")
    set_window_values(p_gufw,c_finish_working,c_disabled)
    
    
# Close preferences window
def close_gufw_log(p_gufw,pref_dialog):
    dialog = pref_dialog.get_widget("log_window")
    dialog.destroy()
    set_window_values(p_gufw,c_finish_working,c_disabled)


# Hide/Show main window when close button is pressed
def show_hide_close_button(self,p_gufw):
    if p_gufw.flg_status.get_text() == c_working_txt:
        return True

    # Minimize when close?
    if check_minimize_on_close() == c_enabled:
        if p_gufw.window.get_property("visible"):
            l_coordinates = p_gufw.window.get_position()
            v_coordx[0] = l_coordinates[0]
            v_coordy[0] = l_coordinates[1]
            p_gufw.window.hide()
        return True
    # Exit when close?
    else:
        sys.exit()
   
    

# Wrapping Gufw log
def wrapping_gufw_log(pref_dialog):
    dialog     = pref_dialog.get_widget("log_window")
    l_wrapping = pref_dialog.get_widget("cb_wrapping")
    text_log   = pref_dialog.get_widget("tv_gufw_log")
    
    if l_wrapping.get_active():
    	text_log.set_wrap_mode(gtk.WRAP_WORD)
    else:
    	text_log.set_wrap_mode(gtk.WRAP_NONE)

# Clear Gufw log
def clear_gufw_log(pref_dialog):
    dialog = pref_dialog.get_widget("log_window")
    text_log = pref_dialog.get_widget("tv_gufw_log")
    l_file = open(path_gufw_log, "w")
    l_file.close()
    
    add_to_gufw_log(_(text_024))
    add_to_gufw_log(_(text_099))
    
    l_file = open(path_gufw_log, "r") 
    string = l_file.read()
    text_log = text_log.get_buffer()
    text_log.set_text(_(text_097) + string + "[" + time.strftime('%x %X') + "] " + _(text_025) + "\n" + _(text_098))
    l_file.close()
    
    


# Edit preferences show window
def edit_preferences(self,p_gufw):
    view_print("Edit preferences")
    
    # Open preferences window	
    pref_dialog = glade.XML(path_preferences, "preferences_window")
    dialog      = pref_dialog.get_widget("preferences_window")
    
    # Gufw log?
    if check_gufw_log() == c_disabled:
        pref_gufw_log = pref_dialog.get_widget("cb_gufw_log")
        pref_gufw_log.set_active(c_disabled)

    # ufw log?
    l_ufw_log = check_ufw_log()
    if l_ufw_log == c_none:
        pref_ufw_log = pref_dialog.get_widget("cb_ufw_log")
        pref_ufw_log.set_sensitive(False)
        pref_ufw_log.set_active(c_disabled)
    elif l_ufw_log == "Off":
        pref_ufw_log = pref_dialog.get_widget("cb_ufw_log")
        pref_ufw_log.set_active(c_disabled)
                
    # Show tray icon
    if check_show_tray() == c_disabled:
        pref_showtray = pref_dialog.get_widget("cb_show_tray")
        pref_showtray.set_active(c_disabled)
        # Minimize window
        pref_minimize = pref_dialog.get_widget("cb_minimize_close")
        pref_minimize.set_sensitive(c_disabled)
        pref_minimize.set_active(c_disabled)
        if check_minimize_on_close() == c_enabled:
            file_replace_string(path_gufw_config,c_minimize_yes,c_minimize_no)
        # Autostart
        pref_autostart = pref_dialog.get_widget("cb_autostart")
        pref_autostart.set_sensitive(c_disabled)
        pref_autostart.set_active(c_disabled)
        if check_autostart() == c_enabled:
        	set_autostart(c_disabled)
    else:
        # Close Gufw when close button pressed.
        if check_minimize_on_close() == c_disabled:
            pref_minimize = pref_dialog.get_widget("cb_minimize_close")
            pref_minimize.set_active(c_disabled)
        pref_autostart = pref_dialog.get_widget("cb_autostart")
        if check_autostart() == c_none:
            pref_autostart.set_sensitive(c_disabled)
            pref_autostart.set_active(c_disabled)
        elif check_autostart() == c_disabled:
            pref_autostart.set_active(c_disabled)
            
    pref_dialog.signal_autoconnect({
        "cb_gufw_log_clicked_cb":             lambda x:edit_gufw_log(p_gufw,pref_dialog),
        "cb_ufw_log_clicked_cb":              lambda x:edit_ufw_log(p_gufw,pref_dialog),
        "cb_show_tray_clicked_cb":            lambda x:edit_tray_icon(p_gufw,pref_dialog),
        "cb_minimize_close_clicked_cb":       lambda x:edit_minimize(p_gufw,pref_dialog),
        "cb_autostart_clicked_cb":            lambda x:edit_autostart(p_gufw,pref_dialog),
        "btn_close_clicked_cb":               lambda x:exit_preferences(p_gufw,pref_dialog),
    })
    dialog.connect("delete_event", lambda w,e: exit_close_pref_btn(p_gufw,pref_dialog))

    set_window_values(p_gufw,c_working,c_enabled)
    add_to_gufw_log(_(text_010))
    dialog.show()


# Close button in Preferences window
def exit_close_pref_btn(p_gufw,pref_dialog):
    dialog = pref_dialog.get_widget("preferences_window")
    dialog.destroy()
    commands.getstatusoutput("cp -f " + path_gufw_config + " " + path_gufw_config + "_backup")
    p_gufw.status.push(1,"")
    set_window_values(p_gufw,c_finish_working,c_disabled)


# Clicked Gufw Log in Preferences Window
def edit_gufw_log(p_gufw,p_preferences):
    view_print("Change Gufw log")
    
    l_gufw_log = p_preferences.get_widget("cb_gufw_log")
    if l_gufw_log.get_active():
        file_replace_string(path_gufw_config,c_gufw_log_no,c_gufw_log_yes)
    else:
        file_replace_string(path_gufw_config,c_gufw_log_yes,c_gufw_log_no)


# Clicked ufw Log in Preferences Window
def edit_ufw_log(p_gufw,p_preferences):
    view_print("Change ufw log")
        
    l_ufw_log = p_preferences.get_widget("cb_ufw_log")
    if l_ufw_log.get_active():
        commands.getstatusoutput(cmd_logging_on)
    else:
        commands.getstatusoutput(cmd_logging_off)

	
# Clicked Tray Icon in Preferences Window
def edit_tray_icon(p_gufw,p_preferences):
    view_print("Change tray icon")

    l_show_tray = p_preferences.get_widget("cb_show_tray")
    l_minimize  = p_preferences.get_widget("cb_minimize_close")
    l_autostart = p_preferences.get_widget("cb_autostart")

    if l_show_tray.get_active():
        tray_icon.set_visible(c_enabled)
        file_replace_string(path_gufw_config,c_show_tray_no,c_show_tray_yes)
        
        l_minimize.set_active(c_disabled)
        l_minimize.set_sensitive(c_enabled)
        file_replace_string(path_gufw_config,c_minimize_yes,c_minimize_no)
        
        if check_autostart() != c_none:
            l_autostart.set_active(c_disabled)
            l_autostart.set_sensitive(c_enabled)
            set_autostart(c_disabled)

    else:
        tray_icon.set_visible(c_disabled)
        file_replace_string(path_gufw_config,c_show_tray_yes,c_show_tray_no)
                                
        l_minimize.set_active(c_disabled)
        l_minimize.set_sensitive(c_disabled)
        file_replace_string(path_gufw_config,c_minimize_yes,c_minimize_no)
        
        if check_autostart() != c_none:
            l_autostart.set_active(c_disabled)
            l_autostart.set_sensitive(c_disabled)
            set_autostart(c_disabled)

        if not p_gufw.window.get_property("visible"):
            p_gufw.window.move(v_coordx[0],v_coordy[0])
            p_gufw.window.show()
    
    
    
# Clicked ufw Log in Preferences Window
def edit_minimize(p_gufw,p_preferences):
    view_print("Change minimize preference")
            
    l_minimize = p_preferences.get_widget("cb_minimize_close")
    l_autostart = p_preferences.get_widget("cb_autostart")

    if l_minimize.get_active():
        file_replace_string(path_gufw_config,c_minimize_no,c_minimize_yes)
    else:
        file_replace_string(path_gufw_config,c_minimize_yes,c_minimize_no)



# Clicked ufw Log in Preferences Window
def edit_autostart(p_gufw,p_preferences):
    view_print("Change autostart preference")
            
    l_autostart = p_preferences.get_widget("cb_autostart")
    if l_autostart.get_active():
        set_autostart(c_enabled)
    else:
        set_autostart(c_disabled)
            



# Close preferences window
def exit_preferences(p_gufw,pref_dialog):
    dialog = pref_dialog.get_widget("preferences_window")
    dialog.destroy()
    commands.getstatusoutput("cp -f " + path_gufw_config + " " + path_gufw_config + "_backup")
    p_gufw.status.push(1,"")
    set_window_values(p_gufw,c_finish_working,c_disabled)

	


# Open Help Gnome
def help(self):
    view_print("Help")
    
    # Search in Gnome system.
    l_error = " "
    try:
        l_file = open(path_app_help, "r") 
    except IOError:
        l_error = "X"

    # Search in folder user.
    if l_error != "X":
        props = { gnome.PARAM_APP_DATADIR : home_app }
    else:
        props = { gnome.PARAM_APP_DATADIR : path_system_root }
        

    prog = gnome.program_init(c_name_app, c_version_app, properties=props)
    
    try:
        gnome.help_display(c_name_app)
    except:
        popup(_(text_064))
        return


# About Window				
def about(self,p_gufw):
    view_print("About dialog")

    set_window_values(p_gufw,c_working,c_enabled)
    # Open About Window glade
    about = gtk.glade.XML(path_about).get_widget("aboutdialog")
    about.set_translator_credits(_(text_063))
    about.show_all()
    about.run()
    about.hide_all()
    add_to_gufw_log(_(text_026))
    p_gufw.status.push(1, "")
    set_window_values(p_gufw,c_finish_working,c_disabled)



# Copy file for autostart.
def set_autostart(p_enabled):

    # Exits folder?
    if os.path.exists(path_autostart_gnome) == False:
        if os.path.exists(path_autostart_kde) == False:
            return
        else: l_path_autostart = path_autostart_kde + file_autostart
    else: l_path_autostart = path_autostart_gnome + file_autostart

    # Copy link into autostart user folder
    if p_enabled == c_enabled:
        l_command = "cp -f " + path_gufw_autostart + " " + l_path_autostart 
        commands.getstatusoutput(l_command)	
                    
    # Delete file autostart
    else:
        l_command = "rm -f " + l_path_autostart
        commands.getstatusoutput(l_command)


        
        
