/*
 *   Copyright (C) 2007-2009 Tristan Heaven <tristanheaven@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _GUI_H_
#define _GUI_H_

#include <stdbool.h>
#include <gtk/gtk.h>

enum {
	VIEW_FILE,
	VIEW_TEXT,
	VIEW_FILE_LIST
};

struct {
	GtkBuilder *builder;
	bool busy;
} gui;

void gui_init(void);
void gui_signal_connect(void);
GObject *gui_get_object(const char *name);
GtkWidget *gui_get_widget(const char *name);
int gui_view(void);
void gui_update(void);
void gui_clear(void);
void gui_busy(const bool set);
void gui_window_resizable(const bool set);
bool gui_window_maximised(void);
void gui_chooser_set_filename(const char *path);
void gui_dialog_hide(void);

#endif // _GUI_H_
