%{
/*
** parser.y: A simple grammar for the XML-like language we use.
** copyright: (c) 2003 by László Pere
** email: pipas@linux.pte.hu
**
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
**
** $Id: parser.y,v 1.5 2004/11/25 21:16:57 root Exp root $
** $Log: parser.y,v $
** Revision 1.5  2004/11/25 21:16:57  root
** *** empty log message ***
**
** Revision 1.4  2004/11/25 21:15:21  root
**   o No, the grammar still has problems.
**
** Revision 1.2  2004/11/25 19:53:03  pipas
**   o New object: tag attributes.
**
** Revision 1.1  2004/11/19 22:10:08  pipas
** Initial revision
**
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gtkdialog.h"
#include "automaton.h"

int linenumber = 1;
extern char *Token;
extern gint no_warning;

//
// Function declarations
//
int yywarning(char *c);
void yyerror_simple(char *c);

%}

%union { 
  double    dval;
  char      *cval;
  tag_attr *nvval;
};

%token BEGINTITLE ENDTITLE
%token VBOX EVBOX
%token HBOX EHBOX
%token NOTEBOOK ENOTEBOOK PART_NOTEBOOK
%token <cval>  FRAME
%token <cval>  TAG_ATTR_NAME
%type  <nvval> tagattr
%token EFRAME
%token ENTRY EENTRY PART_ENTRY
%token MENUBAR EMENUBAR MENU EMENU MENUITEM EMENUITEM
%token EDIT EEDIT
%token TREE ETREE
%token CHOOSER ECHOOSER
%token LABEL ELABEL
%token ITEM EITEM PART_ITEM
%token BUTTON EBUTTON 
%token BUTTONOK BUTTONCANCEL BUTTONHELP BUTTONYES BUTTONNO
%token CHECKBOX ECHECKBOX
%token RADIO ERADIO
%token LIST ELIST
%token TABLE ETABLE
%token COMBO ECOMBO
%token GVIM EGVIM

%token TEXT ETEXT
%token PIXMAP EPIXMAP
%token DEFAULT EDEFAULT
%token VISIBLE EVISIBLE
%token VARIABLE EVARIABLE
%token WIDTH EWIDTH
%token HEIGHT EHEIGHT
%token INPUT INPUTFILE EINPUT PART_INPUT PART_INPUTFILE
%token OUTPUT OUTPUTFILE EOUTPUT
%token ACTION EACTION PART_ACTION 
%token ACTIONCLEAR ACTIONFILESEL ACTIONREMOVE ACTIONREFRESH 
%token ACTIONAPPEND ACTIONLAUNCH
%token WTITLE EWTITLE

%token <dval> NUMBER 
%left '-' '+'        
%left '*' '/'        
%nonassoc     UMINUS 

%token <cval>  STRING

/*
** The grammar. 
 */
%%   
wlist: widget
  | wlist wlist        { token_store(SUM);                }
  | VBOX wlist EVBOX   { token_store(PUSH | WIDGET_VBOX); }
  | HBOX wlist EHBOX   { token_store(PUSH | WIDGET_HBOX); }
  | NOTEBOOK wlist ENOTEBOOK   { token_store(PUSH | WIDGET_NOTEBOOK); }
  | PART_NOTEBOOK tagattr '>' wlist ENOTEBOOK {
                          token_store_attr(PUSH | WIDGET_NOTEBOOK, $2);
                        }
  | FRAME wlist EFRAME { 
                         token_store_with_argument(SET|ATTR_LABEL, $1); 
                         token_store(PUSH | WIDGET_FRAME);
		       }
  ;

widget:  text
       | entry
       | edit
       | tree
       | chooser
       | button
       | checkbox
       | radiobutton
       | list
       | table
       | combo
       | gvim
       | menubar
       | window
       ;

entry: ENTRY attr EENTRY {
                          token_store(PUSH | WIDGET_ENTRY); 
			 }
     | PART_ENTRY tagattr '>' attr EENTRY {
                          token_store_attr(PUSH | WIDGET_ENTRY, $2);
                        }
     | ENTRY attr ENTRY {
                  yyerror("</entry> expected instead of <entry>.");} 
     ;

edit: EDIT attr EEDIT  {token_store(PUSH | WIDGET_EDIT); }
    | EDIT attr EDIT  {yyerror("</edit> expected instead of <edit>.");}
    ;

tree: TREE attr ETREE  {token_store(PUSH | WIDGET_TREE); }
    | TREE attr TREE   {yyerror("</tree> expected instead of <tree>.");}
    ;

chooser: CHOOSER attr ECHOOSER  {token_store(PUSH | WIDGET_CHOOSER); }
    | CHOOSER attr CHOOSER   {yyerror("</chooser> expected instead of <chooser>.");}
    ;

text: TEXT attr ETEXT             {token_store(PUSH | WIDGET_LABEL); } 
    | TEXT attr TEXT  {yyerror("</text> expected instead of <text>.");}
    ;

button: BUTTON attr EBUTTON  {token_store(PUSH | WIDGET_BUTTON);  }
      | BUTTONOK attr EBUTTON    {token_store(PUSH | WIDGET_OKBUTTON);}
      | BUTTONCANCEL attr EBUTTON {token_store(PUSH | WIDGET_CANCELBUTTON);}
      | BUTTONHELP attr EBUTTON   {token_store(PUSH | WIDGET_HELPBUTTON);}
      | BUTTONNO attr EBUTTON     {token_store(PUSH | WIDGET_NOBUTTON);}
      | BUTTONYES attr EBUTTON     {token_store(PUSH | WIDGET_YESBUTTON);}
      ;
checkbox: CHECKBOX attr ECHECKBOX {token_store(PUSH | WIDGET_CHECKBOX);}
        | CHECKBOX attr CHECKBOX  {
           yyerror("</checkbox> expected instead of <checkbox>.");  }
        ;

radiobutton: RADIO attr ERADIO    {token_store(PUSH | WIDGET_RADIO);}
           ;

list: LIST attr ELIST             {token_store(PUSH | WIDGET_LIST); }
    ;

table: TABLE attr ETABLE          {token_store(PUSH | WIDGET_TABLE);}
    ;

combo: COMBO attr ECOMBO          {token_store(PUSH | WIDGET_COMBO);}
    ;

gvim: GVIM attr EGVIM             {token_store(PUSH | WIDGET_GVIM);}
    ;

combo: PIXMAP attr EPIXMAP       {token_store(PUSH | WIDGET_PIXMAP);}
    ;

menubar: MENUBAR EMENUBAR        {
                    yyerror("Empty menubar without a single <menu> tag.");
		    }
       | MENUBAR menus EMENUBAR  {token_store(PUSH | WIDGET_MENUBAR);}
       ;

menus: MENU EMENU                { yyerror("Empty menu without <menuitem> tag.");}
     | MENU menuitems attr EMENU      { token_store(PUSH | WIDGET_MENU);   } 
     | menus MENU EMENU          { yyerror("Empty menu without <menuitem> tag.");}
     | menus MENU menuitems attr EMENU { token_store(PUSH | WIDGET_MENU);   
                                    token_store(SUM);
                                  } 
     ;

menuitems: MENUITEM attr EMENUITEM   {token_store(PUSH | WIDGET_MENUITEM); } 
	 | menuitems MENUITEM attr EMENUITEM {
	                                       token_store(PUSH | WIDGET_MENUITEM); 
					       token_store(SUM);
	                                     } 
	 ;

window: WTITLE STRING EWTITLE {window_title($2);}
    |   WTITLE EWTITLE {window_title("MAIN_DIALOG");}
    ;

attr:
    | attr defaultvalue
    | attr visible
    | attr variable
    | attr label
    | attr width
    | attr height
    | attr input
    | attr output
    | attr action
    | attr item
    ;

label:    LABEL STRING ELABEL          {
     token_store_with_argument( SET | ATTR_LABEL, $2);     }
     ;
variable: VARIABLE STRING EVARIABLE    {
     token_store_with_argument( SET | ATTR_VARIABLE, $2); }
     ; 
visible: VISIBLE STRING EVISIBLE       {
     token_store_with_argument( SET | ATTR_VISIBLE, $2);  }
     ; 
defaultvalue: DEFAULT STRING EDEFAULT  {
     token_store_with_argument( SET | ATTR_DEFAULT, $2);   }
     ;
width: WIDTH STRING EWIDTH             {
     token_store_with_argument( SET | ATTR_WIDTH, $2);    }
     ;
height: HEIGHT STRING EHEIGHT           {
     token_store_with_argument( SET | ATTR_HEIGHT, $2);   }
     ;
input: INPUT STRING EINPUT    { 
	token_store_with_argument(SET|ATTR_INPUT|SUB_ATTR_SHELL,$2);
	                      }
     | PART_INPUT tagattr '>' STRING EINPUT {
	token_store_with_argument_attr(SET|ATTR_INPUT, $4, $2);
	                                        }
     | INPUTFILE STRING EINPUT  { 
	token_store_with_argument(SET|ATTR_INPUT|SUB_ATTR_FILE,$2); 
	                        }
     | PART_INPUTFILE tagattr '>' STRING EINPUT {
	token_store_with_argument_attr(SET|ATTR_INPUT|SUB_ATTR_FILE, $4, $2);
	                                        }
     | PART_INPUTFILE tagattr '>' EINPUT {
	token_store_with_argument_attr(SET|ATTR_INPUT|SUB_ATTR_FILE, "", $2);
	                                        }
     ;

output: OUTPUT STRING EOUTPUT {
         fprintf( stderr, "<output>: Not implemented.\n" ); }
      | OUTPUTFILE STRING EOUTPUT {
         token_store_with_argument(SET|ATTR_OUTPUT|SUB_ATTR_FILE,$2);}
      ;
action: ACTION STRING EACTION  { token_store_with_argument( SET|ATTR_ACTION, $2); }
     | PART_ACTION tagattr '>' STRING EACTION {
		      token_store_with_argument_attr(SET | ATTR_ACTION, $4, $2);
     					}
     | actionclear  
     | actionappend
     | actionfilesel
     | actionremove
     | actionrefresh
     | actionlaunch
     ;

actionclear: ACTIONCLEAR STRING EACTION             { 
  token_store_with_argument( SET|ATTR_ACTION|SUB_ATTR_CLEAR, $2);}
     ;

actionappend: ACTIONAPPEND STRING EACTION             { 
  token_store_with_argument( SET|ATTR_ACTION|SUB_ATTR_APPEND, $2);}
     ;

actionremove: ACTIONREMOVE STRING EACTION             { 
  token_store_with_argument( SET|ATTR_ACTION|SUB_ATTR_REMOVE, $2);}
     ;

actionfilesel: ACTIONFILESEL STRING EACTION             { 
  token_store_with_argument( SET|ATTR_ACTION|SUB_ATTR_FILESEL, $2);}
     ;

actionrefresh: ACTIONREFRESH STRING EACTION             { 
  token_store_with_argument( SET|ATTR_ACTION|SUB_ATTR_REFRESH, $2);}
     ;

actionlaunch: ACTIONLAUNCH STRING EACTION             { 
  token_store_with_argument( SET|ATTR_ACTION|SUB_ATTR_LAUNCH, $2);}
     ;

item: ITEM STRING EITEM { 
                      token_store_with_argument( SET | ATTR_ITEM, $2);
		    }
    | PART_ITEM tagattr '>' STRING EITEM {
		      token_store_with_argument_attr(SET | ATTR_ITEM, $4, $2);
                    }
    ;

tagattr: TAG_ATTR_NAME STRING { $$ = new_tag_attributeset($1, $2); }
       | tagattr TAG_ATTR_NAME STRING {
                                  $$ = add_tag_attribute($1, $2, $3);
		                      }
       ;
%%

int yywrap(void)
{
	run_program();
	return (0);
}

int yyerror(char *c)
{
	printf("\nError in line %d, near token '%s': %s\n", 
			linenumber, Token, c);
	exit(EXIT_FAILURE);
}

void yyerror_simple(char *c)
{
	printf("\n%s: Error: %s\n", PACKAGE, c);
	exit(EXIT_FAILURE);
}

int yywarning(char *c){
	if (!no_warning)
		printf("Warning: %s\n", c);
	return no_warning;
}

