/* 
** attributes.h: Handles the attributes of widgets
** copyright: (c) 2003 by Lszl Pere
** email: pipas@linux.pte.hu
**
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
*/
#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gtkdialog.h"
#include "memory.h"

/* How much attributes we store in an attribute set? */
#define ATTRNUMBER 32 

typedef struct _Attribute {
	char 		*text;
	tag_attr	*tag_attributes;
} Attribute;

typedef struct _AttributeSet {
  int    n_attr;      /* How many attributes can be found here?  */
  GList  **attr;      /* Attributes are linked lists.            */
  GList  **_pointer;  /* Pointers for incremental read function. */
} AttributeSet;


AttributeSet *attributeset_new( void );
gboolean attributeset_is_avail( AttributeSet *set, int attribute );
gboolean attributeset_cmp_left( AttributeSet *set, int attribute,
                                const char *str );
char *attributeset_get_first( AttributeSet *set, int attribute );
char *attributeset_get_next( AttributeSet *set, int attribute );
char *attributeset_set_if_unset( AttributeSet *set, int attribute,
                            const char *s);

char *attributeset_insert(AttributeSet * set, 
		          int attribute, 
			  const char *s
			  );
char *attributeset_insert_with_tagattrs(AttributeSet * set, 
		          		int attribute, 
			  		const char *s,
			  		tag_attr *t_attr);

char *attributeset_get_this_tagattr(AttributeSet *set,
		int attribute,
		const char *name);


#endif

