/* GStreamer
 *
 * Copyright (C) 2003 Ronald Bultje <rbultje@ronald.bitfreak.net>
 *               2006 Edgard Lima <edgard.lima@indt.org.br>
 *
 * gstv4l2colorbalance.h: color balance interface implementation for V4L2
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_V4L2_COLOR_BALANCE_H__
#define __GST_V4L2_COLOR_BALANCE_H__

#include <gst/gst.h>
#include <gst/interfaces/colorbalance.h>
#include "v4l2_calls.h"

G_BEGIN_DECLS

#define GST_TYPE_V4L2_COLOR_BALANCE_CHANNEL \
  (gst_v4l2_color_balance_channel_get_type ())
#define GST_V4L2_COLOR_BALANCE_CHANNEL(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_V4L2_COLOR_BALANCE_CHANNEL, \
			       GstV4l2ColorBalanceChannel))
#define GST_V4L2_COLOR_BALANCE_CHANNEL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_V4L2_COLOR_BALANCE_CHANNEL, \
			    GstV4l2ColorBalanceChannelClass))
#define GST_IS_V4L2_COLOR_BALANCE_CHANNEL(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_V4L2_COLOR_BALANCE_CHANNEL))
#define GST_IS_V4L2_COLOR_BALANCE_CHANNEL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), GST_TYPE_V4L2_COLOR_BALANCE_CHANNEL))

typedef struct _GstV4l2ColorBalanceChannel {
  GstColorBalanceChannel parent;

  guint32 id;
} GstV4l2ColorBalanceChannel;

typedef struct _GstV4l2ColorBalanceChannelClass {
  GstColorBalanceChannelClass parent;
} GstV4l2ColorBalanceChannelClass;

GType	gst_v4l2_color_balance_channel_get_type	(void);

extern const GList *
gst_v4l2_color_balance_list_channels (GstV4l2Object * v4l2object);

extern void
gst_v4l2_color_balance_set_value (GstV4l2Object * v4l2object,
      GstColorBalanceChannel * channel, gint value);

extern gint
gst_v4l2_color_balance_get_value (GstV4l2Object * v4l2object,
                                  GstColorBalanceChannel * channel);

#define GST_IMPLEMENT_V4L2_COLOR_BALANCE_METHODS(Type, interface_as_function)         \
                                                                                      \
static const GList *                                                                  \
interface_as_function ## _color_balance_list_channels (GstColorBalance * balance)     \
{                                                                                     \
  Type *this = (Type*) balance;                                                       \
  return gst_v4l2_color_balance_list_channels(this->v4l2object);                      \
}                                                                                     \
                                                                                      \
static void                                                                           \
interface_as_function ## _color_balance_set_value (GstColorBalance * balance,         \
                                                   GstColorBalanceChannel * channel,  \
                                                   gint value)                        \
{                                                                                     \
  Type *this = (Type*) balance;                                                       \
  return gst_v4l2_color_balance_set_value(this->v4l2object, channel, value);          \
}                                                                                     \
                                                                                      \
static gint                                                                           \
interface_as_function ## _color_balance_get_value (GstColorBalance * balance,         \
                                                   GstColorBalanceChannel * channel)  \
{                                                                                     \
  Type *this = (Type*) balance;                                                       \
  return gst_v4l2_color_balance_get_value(this->v4l2object, channel);                 \
}                                                                                     \
                                                                                      \
void                                                                                  \
interface_as_function ## _color_balance_interface_init (GstColorBalanceClass * klass) \
{                                                                                     \
  GST_COLOR_BALANCE_TYPE (klass) = GST_COLOR_BALANCE_HARDWARE;                        \
                                                                                      \
  /* default virtual functions */                                                     \
  klass->list_channels = interface_as_function ## _color_balance_list_channels;       \
  klass->set_value = interface_as_function ## _color_balance_set_value;               \
  klass->get_value = interface_as_function ## _color_balance_get_value;               \
}                                                                                     \

#endif /* __GST_V4L2_COLOR_BALANCE_H__ */
