#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
char *charstrs[256];
int charlens[256];
char *version_str="001.001";
int kcode_high;
char *StdHW="32";
char *StdVW="32";
char *UniqueId="9876";
char *FontBase="Wadalab";
int ecol=0;
int StdEncMode;
int CustomEncMode;

main(ac,ag)
char **ag;
{
  int i;
  
  for(i=1;i<ac;i++){
    if(*ag[i]!='-')break;
    if(!strcmp(ag[i]+1,"version")){
      version_str=ag[++i];
    }
    else if(!strcmp(ag[i]+1,"StdHW")){
      StdHW=ag[++i];
    }
    else if(!strcmp(ag[i]+1,"StdEnc")){
      StdEncMode=1;
    }
    else if(!strcmp(ag[i]+1,"CustomEnc")){
      CustomEncMode=1;
    }
    else if(!strcmp(ag[i]+1,"StdVW")){
      StdVW=ag[++i];
    }
    else if(!strcmp(ag[i]+1,"UniqueId")){
      UniqueId=ag[++i];
    }
    else if(!strcmp(ag[i]+1,"FontBase")){
      FontBase=ag[++i];
    }
  }
  for(;i<ac;i++)
    readfiles(ag[i]);
  output_pfa();
}

typedef struct				/* Builtin Standard Encoding */
{
   int  index;
   char *name;
} EncodingTable;

static EncodingTable StdEnc[] = {
   040 , "space",
   041 , "exclam",
   042 , "quotedbl",
   043 , "numbersign",
   044 , "dollar",
   045 , "percent",
   046 , "ampersand",
   047 , "quoteright",
   050 , "parenleft",
   051 , "parenright",
   052 , "asterisk",
   053 , "plus",
   054 , "comma",
   055 , "hyphen",
   056 , "period",
   057 , "slash",
   060 , "zero",
   061 , "one",
   062 , "two",
   063 , "three",
   064 , "four",
   065 , "five",
   066 , "six",
   067 , "seven",
   070 , "eight",
   071 , "nine",
   072 , "colon",
   073 , "semicolon",
   074 , "less",
   075 , "equal",
   076 , "greater",
   077 , "question",
  0100 , "at",
  0101 , "A",
  0102 , "B",
  0103 , "C",
  0104 , "D",
  0105 , "E",
  0106 , "F",
  0107 , "G",
  0110 , "H",
  0111 , "I",
  0112 , "J",
  0113 , "K",
  0114 , "L",
  0115 , "M",
  0116 , "N",
  0117 , "O",
  0120 , "P",
  0121 , "Q",
  0122 , "R",
  0123 , "S",
  0124 , "T",
  0125 , "U",
  0126 , "V",
  0127 , "W",
  0130 , "X",
  0131 , "Y",
  0132 , "Z",
  0133 , "bracketleft",
  0134 , "backslash",
  0135 , "bracketright",
  0136 , "asciicircum",
  0137 , "underscore",
  0140 , "quoteleft",
  0141 , "a",
  0142 , "b",
  0143 , "c",
  0144 , "d",
  0145 , "e",
  0146 , "f",
  0147 , "g",
  0150 , "h",
  0151 , "i",
  0152 , "j",
  0153 , "k",
  0154 , "l",
  0155 , "m",
  0156 , "n",
  0157 , "o",
  0160 , "p",
  0161 , "q",
  0162 , "r",
  0163 , "s",
  0164 , "t",
  0165 , "u",
  0166 , "v",
  0167 , "w",
  0170 , "x",
  0171 , "y",
  0172 , "z",
  0173 , "braceleft",
  0174 , "bar",
  0175 , "braceright",
  0176 , "asciitilde",
  0241 , "exclamdown",
  0242 , "cent",
  0243 , "sterling",
  0244 , "fraction",
  0245 , "yen",
  0246 , "florin",
  0247 , "section",
  0250 , "currency",
  0251 , "quotesingle",
  0252 , "quotedblleft",
  0253 , "guillemotleft",
  0254 , "guilsinglleft",
  0255 , "guilsinglright",
  0256 , "fi",
  0257 , "fl",
  0261 , "endash",
  0262 , "dagger",
  0263 , "daggerdbl",
  0264 , "periodcentered",
  0266 , "paragraph",
  0267 , "bullet",
  0270 , "quotesinglbase",
  0271 , "quotedblbase",
  0272 , "quotedblright",
  0273 , "guillemotright",
  0274 , "ellipsis",
  0275 , "perthousand",
  0277 , "questiondown",
  0301 , "grave",
  0302 , "acute",
  0303 , "circumflex",
  0304 , "tilde",
  0305 , "macron",
  0306 , "breve",
  0307 , "dotaccent",
  0310 , "dieresis",
  0312 , "ring",
  0313 , "cedilla",
  0315 , "hungarumlaut",
  0316 , "ogonek",
  0317 , "caron",
  0320 , "emdash",
  0341 , "AE",
  0343 , "ordfeminine",
  0350 , "Lslash",
  0351 , "Oslash",
  0352 , "OE",
  0353 , "ordmasculine",
  0361 , "ae",
  0365 , "dotlessi",
  0370 , "lslash",
  0371 , "oslash",
  0372 , "oe",
  0373 , "germandbls",
    0,      0
};

static EncodingTable ISO8859Enc[] = {
  32, "space",
  33, "exclam",
  34, "quotedbl",
  35, "numbersign",
  36, "dollar",
  37, "percent",
  38, "ampersand",
  39, "quoteright",
  40, "parenleft",
  41, "parenright",
  42, "asterisk",
  43, "plus",
  44, "comma",
  45, "minus",
  46, "period",
  47, "slash",
  48, "zero",
  49, "one",
  50, "two",
  51, "three",
  52, "four",
  53, "five",
  54, "six",
  55, "seven",
  56, "eight",
  57, "nine",
  58, "colon",
  59, "semicolon",
  60, "less",
  61, "equal",
  62, "greater",
  63, "question",
  64, "at",
  65, "A",
  66, "B",
  67, "C",
  68, "D",
  69, "E",
  70, "F",
  71, "G",
  72, "H",
  73, "I",
  74, "J",
  75, "K",
  76, "L",
  77, "M",
  78, "N",
  79, "O",
  80, "P",
  81, "Q",
  82, "R",
  83, "S",
  84, "T",
  85, "U",
  86, "V",
  87, "W",
  88, "X",
  89, "Y",
  90, "Z",
  91, "bracketleft",
  92, "backslash",
  93, "bracketright",
  94, "asciicircum",
  95, "underscore",
  96, "quoteleft",
  97, "a",
  98, "b",
  99, "c",
 100, "d",
 101, "e",
 102, "f",
 103, "g",
 104, "h",
 105, "i",
 106, "j",
 107, "k",
 108, "l",
 109, "m",
 110, "n",
 111, "o",
 112, "p",
 113, "q",
 114, "r",
 115, "s",
 116, "t",
 117, "u",
 118, "v",
 119, "w",
 120, "x",
 121, "y",
 122, "z",
 123, "braceleft",
 124, "bar",
 125, "braceright",
 126, "asciitilde",
 161, "exclamdown",
 162, "cent",
 163, "sterling",
 164, "currency",
 165, "yen",
 166, "brokenbar",
 167, "section",
 168, "dieresis",
 169, "copyright",
 170, "ordfeminine",
 171, "guillemotleft",
 172, "logicalnot",
 173, "hyphen",
 174, "registered",
 175, "macron",
 176, "degree",
 177, "plusminus",
 178, "twosuperior",
 179, "threesuperior",
 180, "acute",
 181, "mu",
 182, "paragraph",
 183, "periodcentered",
 184, "cedilla",
 185, "onesuperior",
 186, "ordmasculine",
 187, "guillemotright",
 188, "onequarter",
 189, "onehalf",
 190, "threequarters",
 191, "questiondown",
 192, "Agrave",
 193, "Aacute",
 194, "Acircumflex",
 195, "Atilde",
 196, "Adieresis",
 197, "Aring",
 198, "AE",
 199, "Ccedilla",
 200, "Egrave",
 201, "Eacute",
 202, "Ecircumflex",
 203, "Edieresis",
 204, "Igrave",
 205, "Iacute",
 206, "Icircumflex",
 207, "Idieresis",
 208, "Eth",
 209, "Ntilde",
 210, "Ograve",
 211, "Oacute",
 212, "Ocircumflex",
 213, "Otilde",
 214, "Odieresis",
 215, "multiply",
 216, "Oslash",
 217, "Ugrave",
 218, "Uacute",
 219, "Ucircumflex",
 220, "Udieresis",
 221, "Yacute",
 222, "Thorn",
 223, "germandbls",
 224, "agrave",
 225, "aacute",
 226, "acircumflex",
 227, "atilde",
 228, "adieresis",
 229, "aring",
 230, "ae",
 231, "ccedilla",
 232, "egrave",
 233, "eacute",
 234, "ecircumflex",
 235, "edieresis",
 236, "igrave",
 237, "iacute",
 238, "icircumflex",
 239, "idieresis",
 240, "eth",
 241, "ntilde",
 242, "ograve",
 243, "oacute",
 244, "ocircumflex",
 245, "otilde",
 246, "odieresis",
 247, "divide",
 248, "oslash",
 249, "ugrave",
 250, "uacute",
 251, "ucircumflex",
 252, "udieresis",
 253, "yacute",
 254, "thorn",
 255, "ydieresis",
    0,      0
};

readfiles(filename)
char *filename;
{
  FILE *fd;
  char buf[4096],*cptr;
  int kcode_low,i,len,kcode,c1,c;

  if((fd=fopen(filename,"r"))==NULL){
    fprintf(stderr,"File %s is not found\n",filename);
    exit(1);
  }
  while(fgets(buf,4096,fd)!=NULL){
    len=strlen(buf);
    if(buf[0]=='<' && !strncmp(buf+len-6 ,"CompD",5)){
      kcode=strtol(buf+len-12,NULL,16);
      kcode_high=(kcode>>8)&255;
      charstrs[kcode_low=(kcode&255)]=(char *)malloc((len-16)/2);
      charlens[kcode_low]=(len-16)/2;
      for(i=0,cptr=charstrs[kcode_low];i<(len-16)/2;i++){
	c1=buf[i*2+1];c=buf[i*2+2];
	*cptr++ = ((c1>='a' ? c1-'a'+10 : c1-'0')<<4)
	  |(c>='a' ? c-'a'+10 : c-'0');
      }
    }
  }
  fclose(fd);
}
output_header()
{
  time_t now=time(0);
  int i;
  printf("%%!PS-AdobeFont-1.0: %s.r%02x %s\n",FontBase,kcode_high,version_str);
  printf("%%%%Creation Date: %s",ctime(&now));
  printf("%%%%VMusage: 100000 100000\n"); /* dummy */
  printf("11 dict begin\n");
  printf("/FontInfo 8 dict dup begin\n");
  printf("/version (%s) readonly def\n",version_str);
  printf("/FullName (%s.r%02x) readonly def\n",FontBase);
  printf("/FamilyName (%s) readonly def\n",FontBase);
  printf("/Weight (Regular) readonly def\n");
  printf("/ItalicAngle 0 def\n");
  printf("/isFixedPitch true def\n");
  printf("/UnderlinePosition 0 def\n");
  printf("/UnderlineThickness 0 def\n");
  printf("end readonly def\n");
  printf("/FontName /%s.r%02x def\n",FontBase,kcode_high);
  if(CustomEncMode){
    printf("/Encoding 256 array\n");
    printf("0 1 255 {1 index exch /.notdef put} for\n");
    for(i=0x21;i<=0x7e;i++)
      printf("dup %d /c%02X put\n",i,i);
    printf("readonly def\n");
  }
  else
    printf("/Encoding StandardEncoding def\n");
  printf("/PaintType 0 def\n");
  printf("/FontType 1 def\n");
  printf("/FontMatrix [.001 0 0 .001 0 -0.16] readonly def\n");
  printf("/UniqueId %s def\n",UniqueId);
  printf("/FontBBox [0 0 1000 1000] readonly def \n");
  printf("currentdict end\n");
  printf("currentfile eexec\n");
}
output_pfa()
{
  int i,j,len,charlen;
  /* new integer ii for counting characters */
  int ii=1;
  output_header();
  e_putchar(0);
  e_putchar(0);
  e_putchar(0);
  e_putchar(0);
  if(CustomEncMode)
    e_printf("dup /Private 14 dict dup begin\n");
  else
    e_printf("dup /Private 17 dict dup begin\n");
  e_printf("/-|{string currentfile exch readstring pop}executeonly def\n");
  e_printf("/|-{noaccess def}executeonly def\n");
  e_printf("/|{noaccess put}executeonly def\n");
  e_printf("/BlueValues [] |-\n");
  e_printf("/OtherBlues [] |-\n");
  e_printf("/MinFeature{16 16} |-\n");
  e_printf("/StdHW [ %s ] |-\n",StdHW);
  e_printf("/StdVW [ %s ] |-\n",StdVW);
  e_printf("/ForceBold false def\n");
  e_printf("/password 5839 def\n");
  e_printf("/UniqueId %s def\n",UniqueId);
  e_printf("/OtherSubrs [] |-\n");
  e_printf("/Subrs 5 array\n");
  e_printf("dup 0 15 -| \020\2771p|\020\024\020=-\223D\\\342R |\n");
  e_printf("dup 1 9 -| \020\2771py\274\366Uz |\n");
  e_printf("dup 2 9 -| \020\2771py\275\304\236i |\n");
  e_printf("dup 3 5 -| \020\2771p\371 |\n");
  e_printf("dup 4 12 -| \020\2771p~\266+6\034\3446z |\n");
  e_printf("|-\n");
  for(i=0;i<256;i++){
    if(charstrs[i]!=NULL)
      ii++;
  }
  e_printf("2 index /CharStrings %i dict dup begin\n",ii);
  e_printf("/.notdef 10 -| \020\277\061\160\171\312\070\217\347\143 |-\n");
  for(i=0;i<256;i++){
    if(charstrs[i]!=NULL){
      if(CustomEncMode)
	e_printf("/c%2X %d -| ",i,charlens[i]);
      else
	e_printf("/%s %d -| ",(StdEncMode ? StdEnc[i-040].name : ISO8859Enc[i-040].name),charlens[i]);
      for(j=0;j<charlens[i];j++)
	e_putchar(*(charstrs[i]+j));
      e_printf(" |-\n");
    }
  }
  e_printf("end\n");
  e_printf("end\n");
  e_printf("readonly put\n");
  e_printf("noaccess put\n");
  e_printf("dup/FontName get exch definefont pop\n");
  e_printf("mark currentfile closefile\n");
  putchar('\n');
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("0000000000000000000000000000000000000000000000000000000000000000\n");
  printf("cleartomark\n");
}

e_printf(form,i0,i1,i2,i3,i4,i5,i6,i7,i8,i9)
char *form;
{
  int len,i;
  unsigned char buf[4096];
  sprintf(buf,form,i0,i1,i2,i3,i4,i5,i6,i7,i8,i9);
  len=strlen(buf);
  for(i=0;i<len;i++)
    e_putchar(buf[i]);
}
e_putchar(plain)
unsigned char plain;
{
  printf("%02X",encrypt_char(plain));
  ecol+=2;
  if(ecol==64){putchar('\n');ecol=0;}
}

unsigned short r=55665,c1=52845,c2=22719;
encrypt_char(plain)
unsigned char plain;
{

  unsigned char cipher;
  cipher=(plain ^ (r>>8));
  r=(cipher+r)*c1+c2;
  return cipher;
}

