/*
 * Copyright 2003-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package groovy.util

import junit.framework.Assert

class StringTestUtil {
    static void assertMultilineStringsEqual(String a, String b) {
        def aLines = a.trim().replaceAll('\r','').split('\n')
        def bLines = b.trim().replaceAll('\r','').split('\n')
        assert aLines.size() == bLines.size()
        for (i in 0..<aLines.size()) {
            Assert.assertEquals(aLines[i].trim(), bLines[i].trim())
        }
    }
}