/*
 * Copyright 2003-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package groovy.bugs

public class Groovy3208Bug extends GroovyTestCase {

   void testBug () {
      new Sub().each { assertEquals("ABC", it.doIt()) }
      
      assertEquals("ABC", new Sub().doItAgain())
   }
   
//    void testSubclassStaticContextProperty() {
//       assert "ABC" == Sub.doItStatically()
//       assert "ABC" == Sub.doItStaticallyAgain()
//    }
}

class Super {
   static final String PROP = "ABC"
   def doIt = { PROP }
//   static doItStatically = { PROP }
}

class Sub extends Super {
   String doItAgain() { PROP }
//   static String doItStaticallyAgain() { PROP }
}
