/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS sse2_double kernel generator.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include "../nb_kernel.h"
#include "types/simple.h"
#include "vec.h"
#include "nrnb.h"

#include "gromacs/simd/math_x86_sse2_double.h"
#include "kernelutil_x86_sse2_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSh_VdwLJEwSh_GeomW4P1_VF_sse2_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            LJEwald
 * Geometry:                   Water4-Particle
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecEwSh_VdwLJEwSh_GeomW4P1_VF_sse2_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    __m128d          ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128d          dx30,dy30,dz30,rsq30,rinv30,rinvsq30,r30,qq30,c6_30,c12_30;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m128d          rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m128d          one_sixth   = _mm_set1_pd(1.0/6.0);
    __m128d          one_twelfth = _mm_set1_pd(1.0/12.0);
    __m128d           c6grid_00;
    __m128d           c6grid_10;
    __m128d           c6grid_20;
    __m128d           c6grid_30;
    __m128d           ewclj,ewclj2,ewclj6,ewcljrsq,poly,exponent,f6A,f6B,sh_lj_ewald;
    real             *vdwgridparam;
    __m128d           one_half = _mm_set1_pd(0.5);
    __m128d           minus_one = _mm_set1_pd(-1.0);
    __m128i          ewitab;
    __m128d          ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;
    vdwgridparam     = fr->ljpme_c6grid;
    sh_lj_ewald      = _mm_set1_pd(fr->ic->sh_lj_ewald);
    ewclj            = _mm_set1_pd(fr->ewaldcoeff_lj);
    ewclj2           = _mm_mul_pd(minus_one,_mm_mul_pd(ewclj,ewclj));

    sh_ewald         = _mm_set1_pd(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));
    iq3              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+3]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm_set1_pd(rcutoff_scalar);
    rcutoff2         = _mm_mul_pd(rcutoff,rcutoff);

    sh_vdw_invrcut6  = _mm_set1_pd(fr->ic->sh_invrc6);
    rvdw             = _mm_set1_pd(fr->rvdw);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_4rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();
        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();
        fix3             = _mm_setzero_pd();
        fiy3             = _mm_setzero_pd();
        fiz3             = _mm_setzero_pd();

        /* Reset potential sums */
        velecsum         = _mm_setzero_pd();
        vvdwsum          = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx30             = _mm_sub_pd(ix3,jx0);
            dy30             = _mm_sub_pd(iy3,jy0);
            dz30             = _mm_sub_pd(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq30            = gmx_mm_calc_rsq_pd(dx30,dy30,dz30);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv30           = gmx_mm_invsqrt_pd(rsq30);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq30         = _mm_mul_pd(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = gmx_mm_load_2real_swizzle_pd(charge+jnrA+0,charge+jnrB+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm_load_2pair_swizzle_pd(vdwparam+vdwioffset0+vdwjidx0A,
                                         vdwparam+vdwioffset0+vdwjidx0B,&c6_00,&c12_00);

            c6grid_00       = gmx_mm_load_2real_swizzle_pd(vdwgridparam+vdwioffset0+vdwjidx0A,
                                                               vdwgridparam+vdwioffset0+vdwjidx0B);

            /* Analytical LJ-PME */
            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            ewcljrsq         = _mm_mul_pd(ewclj2,rsq00);
            ewclj6           = _mm_mul_pd(ewclj2,_mm_mul_pd(ewclj2,ewclj2));
            exponent         = gmx_simd_exp_d(ewcljrsq);
            /* poly = exp(-(beta*r)^2) * (1 + (beta*r)^2 + (beta*r)^4 /2) */
            poly             = _mm_mul_pd(exponent,_mm_add_pd(_mm_sub_pd(one,ewcljrsq),_mm_mul_pd(_mm_mul_pd(ewcljrsq,ewcljrsq),one_half)));
            /* vvdw6 = [C6 - C6grid * (1-poly)]/r6 */
            vvdw6            = _mm_mul_pd(_mm_sub_pd(c6_00,_mm_mul_pd(c6grid_00,_mm_sub_pd(one,poly))),rinvsix);
            vvdw12           = _mm_mul_pd(c12_00,_mm_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm_sub_pd(_mm_mul_pd( _mm_sub_pd(vvdw12 , _mm_mul_pd(c12_00,_mm_mul_pd(sh_vdw_invrcut6,sh_vdw_invrcut6))),one_twelfth),
	    		       _mm_mul_pd( _mm_sub_pd(vvdw6,_mm_add_pd(_mm_mul_pd(c6_00,sh_vdw_invrcut6),_mm_mul_pd(c6grid_00,sh_lj_ewald))),one_sixth));
            /* fvdw = vvdw12/r - (vvdw6/r + (C6grid * exponent * beta^6)/r) */
            fvdw             = _mm_mul_pd(_mm_sub_pd(vvdw12,_mm_sub_pd(vvdw6,_mm_mul_pd(_mm_mul_pd(c6grid_00,one_sixth),_mm_mul_pd(exponent,ewclj6)))),rinvsq00);

            cutoff_mask      = _mm_cmplt_pd(rsq00,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            vvdw             = _mm_and_pd(vvdw,cutoff_mask);
            vvdwsum          = _mm_add_pd(vvdwsum,vvdw);

            fscal            = fvdw;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq10,_mm_sub_pd(_mm_sub_pd(rinv10,sh_ewald),velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq10,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq20,_mm_sub_pd(_mm_sub_pd(rinv20,sh_ewald),velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq20,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq30,rcutoff2))
            {

            r30              = _mm_mul_pd(rsq30,rinv30);

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm_mul_pd(iq3,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r30,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq30,_mm_sub_pd(_mm_sub_pd(rinv30,sh_ewald),velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq30,rinv30),_mm_sub_pd(rinvsq30,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq30,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx30);
            ty               = _mm_mul_pd(fscal,dy30);
            tz               = _mm_mul_pd(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm_add_pd(fix3,tx);
            fiy3             = _mm_add_pd(fiy3,ty);
            fiz3             = _mm_add_pd(fiz3,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            gmx_mm_decrement_1rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0);

            /* Inner loop uses 203 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx30             = _mm_sub_pd(ix3,jx0);
            dy30             = _mm_sub_pd(iy3,jy0);
            dz30             = _mm_sub_pd(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq30            = gmx_mm_calc_rsq_pd(dx30,dy30,dz30);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv30           = gmx_mm_invsqrt_pd(rsq30);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq30         = _mm_mul_pd(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = _mm_load_sd(charge+jnrA+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm_load_1pair_swizzle_pd(vdwparam+vdwioffset0+vdwjidx0A,&c6_00,&c12_00);

            c6grid_00       = gmx_mm_load_1real_pd(vdwgridparam+vdwioffset0+vdwjidx0A);

            /* Analytical LJ-PME */
            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            ewcljrsq         = _mm_mul_pd(ewclj2,rsq00);
            ewclj6           = _mm_mul_pd(ewclj2,_mm_mul_pd(ewclj2,ewclj2));
            exponent         = gmx_simd_exp_d(ewcljrsq);
            /* poly = exp(-(beta*r)^2) * (1 + (beta*r)^2 + (beta*r)^4 /2) */
            poly             = _mm_mul_pd(exponent,_mm_add_pd(_mm_sub_pd(one,ewcljrsq),_mm_mul_pd(_mm_mul_pd(ewcljrsq,ewcljrsq),one_half)));
            /* vvdw6 = [C6 - C6grid * (1-poly)]/r6 */
            vvdw6            = _mm_mul_pd(_mm_sub_pd(c6_00,_mm_mul_pd(c6grid_00,_mm_sub_pd(one,poly))),rinvsix);
            vvdw12           = _mm_mul_pd(c12_00,_mm_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm_sub_pd(_mm_mul_pd( _mm_sub_pd(vvdw12 , _mm_mul_pd(c12_00,_mm_mul_pd(sh_vdw_invrcut6,sh_vdw_invrcut6))),one_twelfth),
	    		       _mm_mul_pd( _mm_sub_pd(vvdw6,_mm_add_pd(_mm_mul_pd(c6_00,sh_vdw_invrcut6),_mm_mul_pd(c6grid_00,sh_lj_ewald))),one_sixth));
            /* fvdw = vvdw12/r - (vvdw6/r + (C6grid * exponent * beta^6)/r) */
            fvdw             = _mm_mul_pd(_mm_sub_pd(vvdw12,_mm_sub_pd(vvdw6,_mm_mul_pd(_mm_mul_pd(c6grid_00,one_sixth),_mm_mul_pd(exponent,ewclj6)))),rinvsq00);

            cutoff_mask      = _mm_cmplt_pd(rsq00,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            vvdw             = _mm_and_pd(vvdw,cutoff_mask);
            vvdw             = _mm_unpacklo_pd(vvdw,_mm_setzero_pd());
            vvdwsum          = _mm_add_pd(vvdwsum,vvdw);

            fscal            = fvdw;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq10,_mm_sub_pd(_mm_sub_pd(rinv10,sh_ewald),velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq10,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq20,_mm_sub_pd(_mm_sub_pd(rinv20,sh_ewald),velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq20,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq30,rcutoff2))
            {

            r30              = _mm_mul_pd(rsq30,rinv30);

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm_mul_pd(iq3,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r30,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + gmx_mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + gmx_mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_add_pd(ewtabF,_mm_mul_pd(eweps,ewtabD));
            velec            = _mm_sub_pd(ewtabV,_mm_mul_pd(_mm_mul_pd(ewtabhalfspace,eweps),_mm_add_pd(ewtabF,felec)));
            velec            = _mm_mul_pd(qq30,_mm_sub_pd(_mm_sub_pd(rinv30,sh_ewald),velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq30,rinv30),_mm_sub_pd(rinvsq30,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq30,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx30);
            ty               = _mm_mul_pd(fscal,dy30);
            tz               = _mm_mul_pd(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm_add_pd(fix3,tx);
            fiy3             = _mm_add_pd(fiy3,ty);
            fiz3             = _mm_add_pd(fiz3,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            gmx_mm_decrement_1rvec_1ptr_swizzle_pd(f+j_coord_offsetA,fjx0,fjy0,fjz0);

            /* Inner loop uses 203 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_4atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_pd(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_mm_update_1pot_pd(vvdwsum,kernel_data->energygrp_vdw+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 26 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W4_VF,outeriter*26 + inneriter*203);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSh_VdwLJEwSh_GeomW4P1_F_sse2_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            LJEwald
 * Geometry:                   Water4-Particle
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecEwSh_VdwLJEwSh_GeomW4P1_F_sse2_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    __m128d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    __m128d          ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx0A,vdwjidx0B;
    __m128d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m128d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m128d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m128d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m128d          dx30,dy30,dz30,rsq30,rinv30,rinvsq30,r30,qq30,c6_30,c12_30;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m128d          rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m128d          one_sixth   = _mm_set1_pd(1.0/6.0);
    __m128d          one_twelfth = _mm_set1_pd(1.0/12.0);
    __m128d           c6grid_00;
    __m128d           c6grid_10;
    __m128d           c6grid_20;
    __m128d           c6grid_30;
    __m128d           ewclj,ewclj2,ewclj6,ewcljrsq,poly,exponent,f6A,f6B,sh_lj_ewald;
    real             *vdwgridparam;
    __m128d           one_half = _mm_set1_pd(0.5);
    __m128d           minus_one = _mm_set1_pd(-1.0);
    __m128i          ewitab;
    __m128d          ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;
    vdwgridparam     = fr->ljpme_c6grid;
    sh_lj_ewald      = _mm_set1_pd(fr->ic->sh_lj_ewald);
    ewclj            = _mm_set1_pd(fr->ewaldcoeff_lj);
    ewclj2           = _mm_mul_pd(minus_one,_mm_mul_pd(ewclj,ewclj));

    sh_ewald         = _mm_set1_pd(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_F;
    ewtabscale       = _mm_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));
    iq3              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+3]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm_set1_pd(rcutoff_scalar);
    rcutoff2         = _mm_mul_pd(rcutoff,rcutoff);

    sh_vdw_invrcut6  = _mm_set1_pd(fr->ic->sh_invrc6);
    rvdw             = _mm_set1_pd(fr->rvdw);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_4rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix0             = _mm_setzero_pd();
        fiy0             = _mm_setzero_pd();
        fiz0             = _mm_setzero_pd();
        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();
        fix3             = _mm_setzero_pd();
        fiy3             = _mm_setzero_pd();
        fiz3             = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_2ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx30             = _mm_sub_pd(ix3,jx0);
            dy30             = _mm_sub_pd(iy3,jy0);
            dz30             = _mm_sub_pd(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq30            = gmx_mm_calc_rsq_pd(dx30,dy30,dz30);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv30           = gmx_mm_invsqrt_pd(rsq30);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq30         = _mm_mul_pd(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = gmx_mm_load_2real_swizzle_pd(charge+jnrA+0,charge+jnrB+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm_load_2pair_swizzle_pd(vdwparam+vdwioffset0+vdwjidx0A,
                                         vdwparam+vdwioffset0+vdwjidx0B,&c6_00,&c12_00);

            c6grid_00       = gmx_mm_load_2real_swizzle_pd(vdwgridparam+vdwioffset0+vdwjidx0A,
                                                               vdwgridparam+vdwioffset0+vdwjidx0B);

            /* Analytical LJ-PME */
            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            ewcljrsq         = _mm_mul_pd(ewclj2,rsq00);
            ewclj6           = _mm_mul_pd(ewclj2,_mm_mul_pd(ewclj2,ewclj2));
            exponent         = gmx_simd_exp_d(ewcljrsq);
            /* poly = exp(-(beta*r)^2) * (1 + (beta*r)^2 + (beta*r)^4 /2) */
            poly             = _mm_mul_pd(exponent,_mm_add_pd(_mm_sub_pd(one,ewcljrsq),_mm_mul_pd(_mm_mul_pd(ewcljrsq,ewcljrsq),one_half)));
            /* f6A = 6 * C6grid * (1 - poly) */
            f6A              = _mm_mul_pd(c6grid_00,_mm_sub_pd(one,poly));
            /* f6B = C6grid * exponent * beta^6 */
            f6B              = _mm_mul_pd(_mm_mul_pd(c6grid_00,one_sixth),_mm_mul_pd(exponent,ewclj6));
            /* fvdw = 12*C12/r13 - ((6*C6 - f6A)/r6 + f6B)/r */
	    fvdw              = _mm_mul_pd(_mm_add_pd(_mm_mul_pd(_mm_sub_pd(_mm_mul_pd(c12_00,rinvsix),_mm_sub_pd(c6_00,f6A)),rinvsix),f6B),rinvsq00);

            cutoff_mask      = _mm_cmplt_pd(rsq00,rcutoff2);

            fscal            = fvdw;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq10,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq20,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq30,rcutoff2))
            {

            r30              = _mm_mul_pd(rsq30,rinv30);

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm_mul_pd(iq3,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r30,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            gmx_mm_load_2pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),ewtab+gmx_mm_extract_epi32(ewitab,1),
                                         &ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq30,rinv30),_mm_sub_pd(rinvsq30,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq30,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx30);
            ty               = _mm_mul_pd(fscal,dy30);
            tz               = _mm_mul_pd(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm_add_pd(fix3,tx);
            fiy3             = _mm_add_pd(fiy3,ty);
            fiz3             = _mm_add_pd(fiz3,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            gmx_mm_decrement_1rvec_2ptr_swizzle_pd(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0);

            /* Inner loop uses 169 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_1rvec_1ptr_swizzle_pd(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm_sub_pd(ix0,jx0);
            dy00             = _mm_sub_pd(iy0,jy0);
            dz00             = _mm_sub_pd(iz0,jz0);
            dx10             = _mm_sub_pd(ix1,jx0);
            dy10             = _mm_sub_pd(iy1,jy0);
            dz10             = _mm_sub_pd(iz1,jz0);
            dx20             = _mm_sub_pd(ix2,jx0);
            dy20             = _mm_sub_pd(iy2,jy0);
            dz20             = _mm_sub_pd(iz2,jz0);
            dx30             = _mm_sub_pd(ix3,jx0);
            dy30             = _mm_sub_pd(iy3,jy0);
            dz30             = _mm_sub_pd(iz3,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm_calc_rsq_pd(dx20,dy20,dz20);
            rsq30            = gmx_mm_calc_rsq_pd(dx30,dy30,dz30);

            rinv00           = gmx_mm_invsqrt_pd(rsq00);
            rinv10           = gmx_mm_invsqrt_pd(rsq10);
            rinv20           = gmx_mm_invsqrt_pd(rsq20);
            rinv30           = gmx_mm_invsqrt_pd(rsq30);

            rinvsq00         = _mm_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm_mul_pd(rinv20,rinv20);
            rinvsq30         = _mm_mul_pd(rinv30,rinv30);

            /* Load parameters for j particles */
            jq0              = _mm_load_sd(charge+jnrA+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];

            fjx0             = _mm_setzero_pd();
            fjy0             = _mm_setzero_pd();
            fjz0             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            gmx_mm_load_1pair_swizzle_pd(vdwparam+vdwioffset0+vdwjidx0A,&c6_00,&c12_00);

            c6grid_00       = gmx_mm_load_1real_pd(vdwgridparam+vdwioffset0+vdwjidx0A);

            /* Analytical LJ-PME */
            rinvsix          = _mm_mul_pd(_mm_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            ewcljrsq         = _mm_mul_pd(ewclj2,rsq00);
            ewclj6           = _mm_mul_pd(ewclj2,_mm_mul_pd(ewclj2,ewclj2));
            exponent         = gmx_simd_exp_d(ewcljrsq);
            /* poly = exp(-(beta*r)^2) * (1 + (beta*r)^2 + (beta*r)^4 /2) */
            poly             = _mm_mul_pd(exponent,_mm_add_pd(_mm_sub_pd(one,ewcljrsq),_mm_mul_pd(_mm_mul_pd(ewcljrsq,ewcljrsq),one_half)));
            /* f6A = 6 * C6grid * (1 - poly) */
            f6A              = _mm_mul_pd(c6grid_00,_mm_sub_pd(one,poly));
            /* f6B = C6grid * exponent * beta^6 */
            f6B              = _mm_mul_pd(_mm_mul_pd(c6grid_00,one_sixth),_mm_mul_pd(exponent,ewclj6));
            /* fvdw = 12*C12/r13 - ((6*C6 - f6A)/r6 + f6B)/r */
	    fvdw              = _mm_mul_pd(_mm_add_pd(_mm_mul_pd(_mm_sub_pd(_mm_mul_pd(c12_00,rinvsix),_mm_sub_pd(c6_00,f6A)),rinvsix),f6B),rinvsq00);

            cutoff_mask      = _mm_cmplt_pd(rsq00,rcutoff2);

            fscal            = fvdw;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx00);
            ty               = _mm_mul_pd(fscal,dy00);
            tz               = _mm_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm_add_pd(fix0,tx);
            fiy0             = _mm_add_pd(fiy0,ty);
            fiz0             = _mm_add_pd(fiz0,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm_mul_pd(rsq10,rinv10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r10,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq10,rinv10),_mm_sub_pd(rinvsq10,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq10,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx10);
            ty               = _mm_mul_pd(fscal,dy10);
            tz               = _mm_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm_add_pd(fix1,tx);
            fiy1             = _mm_add_pd(fiy1,ty);
            fiz1             = _mm_add_pd(fiz1,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm_mul_pd(rsq20,rinv20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r20,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq20,rinv20),_mm_sub_pd(rinvsq20,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq20,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx20);
            ty               = _mm_mul_pd(fscal,dy20);
            tz               = _mm_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm_add_pd(fix2,tx);
            fiy2             = _mm_add_pd(fiy2,ty);
            fiz2             = _mm_add_pd(fiz2,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq30,rcutoff2))
            {

            r30              = _mm_mul_pd(rsq30,rinv30);

            /* Compute parameters for interactions between i and j atoms */
            qq30             = _mm_mul_pd(iq3,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r30,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
            eweps            = _mm_sub_pd(ewrt,_mm_cvtepi32_pd(ewitab));
            gmx_mm_load_1pair_swizzle_pd(ewtab+gmx_mm_extract_epi32(ewitab,0),&ewtabF,&ewtabFn);
            felec            = _mm_add_pd(_mm_mul_pd( _mm_sub_pd(one,eweps),ewtabF),_mm_mul_pd(eweps,ewtabFn));
            felec            = _mm_mul_pd(_mm_mul_pd(qq30,rinv30),_mm_sub_pd(rinvsq30,felec));

            cutoff_mask      = _mm_cmplt_pd(rsq30,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Calculate temporary vectorial force */
            tx               = _mm_mul_pd(fscal,dx30);
            ty               = _mm_mul_pd(fscal,dy30);
            tz               = _mm_mul_pd(fscal,dz30);

            /* Update vectorial force */
            fix3             = _mm_add_pd(fix3,tx);
            fiy3             = _mm_add_pd(fiy3,ty);
            fiz3             = _mm_add_pd(fiz3,tz);

            fjx0             = _mm_add_pd(fjx0,tx);
            fjy0             = _mm_add_pd(fjy0,ty);
            fjz0             = _mm_add_pd(fjz0,tz);

            }

            gmx_mm_decrement_1rvec_1ptr_swizzle_pd(f+j_coord_offsetA,fjx0,fjy0,fjz0);

            /* Inner loop uses 169 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_4atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 24 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W4_F,outeriter*24 + inneriter*169);
}
