# This file is part of the graph-includes package
#
# (c) 2005 Yann Dirson <ydirson@altern.org>
# Distributed under version 2 of the GNU GPL.

package graphincludes::extractor::perl;
use strict;
use warnings;

use base qw(graphincludes::extractor);

use graphincludes::params;

# This is only a preliminary extractor for perl dependencies.  It should
# correctly catch:
# - use <bareword>
# - require <bareword>
# - require "<file>"
# - require '<file>'
# - use base qw(<single-class>)
#
# It misses:
# - all other "use base <whatever>", including qw(several classes)
# - direct uses of "import base"
# - require <expr>
# - do <expr>
# - statements not the 1st of a line
#
# It will be confused by "require <expr>", trying to locate a file
# with a name corresponding to the un-eval'ed expression.

sub pattern { '\.(pm|pl)$' }

sub getdeps {
  my $self = shift;
  my %deps;

  @ARGV = @{$self->{FILES}};
  while (<>) {
    my $dstfile;
    if (m/^\s*require\s*["'](\S+)["']/) {
      print STDERR "Found quoted require: $_" if $graphincludes::params::debug;
      $dstfile = $self->locatefile ($1, '.', @graphincludes::params::inclpath);

    } elsif (m/^\s*use\s+base\s+qw\(\s*([\w:]+)\s*\)/) {
      print STDERR "Found use_base: $_" if $graphincludes::params::debug;
      $dstfile = $1;
      $dstfile =~ s|::|/|g;
      $dstfile = $self->locatefile ($dstfile . '.pm', '.', @graphincludes::params::inclpath);

    } elsif (m/^\s*(?:use|require)\s*([\w:]+)/) {
      print STDERR "Found use/require: $_" if $graphincludes::params::debug;
      $dstfile = $1;
      $dstfile =~ s|::|/|g;
      $dstfile = $self->locatefile ($dstfile . '.pm', '.', @graphincludes::params::inclpath);

    } else {
      next;
    }

    if (defined $dstfile) {
      $self->record_dep (\%deps, $ARGV, $dstfile);
    } else {
      $self->record_missed_dep ($ARGV, $1);
    }
  }
  return \%deps;
}

1;
