/***************************************************************************
                          testapdu.pl  -  description
                             -------------------
    begin                : Thu Apr 11 2002
    copyright            : (C) 2002 by Renaud Mariana
    email                : rmariana@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
/*
 * Print out the ATR of a smartcard and
 * try out sending apdu [0xA0,0x0,0x0,P2,0] with
 * P2 in the range [0..15]
 *
*/


:- include('pcsc/muscle').


start :-
	scard_establish_context,
	scard_connect,

	% print ATR data
	scard_status( _, Atr),
	print( 'ATR: '), print_hex_list(Atr), nl, 

	% enable trace
	scard_enable_verbose(true),

	fd_domain(P2,0,0xf),					% P2 finite domain is the interval [0,15]

	(
		
		print('\nThis example sends successively the following Apdu = [e2h,00h,04h,X,00h],\n where X= 00h to 0fh.\n'), nl,
		fd_labeling(P2),						% try out every different value in the domain
		
		(
			ApduIn = [0xE2,0,4,P2,0],
			scard_transmit(ApduIn, _ApduOut, _Sw, _Time) -> true
		;
			print('Application error in transmit'), nl 
		),
		
		fail												% backtrack (re-execute) with a different value for P2
	;
		write('No more solutions'), nl
	).


:- initialization(start).
