#!/bin/sh
# Copyright 2011 The Go Authors. All rights reserved.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.

set -e

cat <<EOF
// Go definitions for C variables and types.
// AUTOMATICALLY GENERATED BY THE FOLLOWING COMMAND. DO NOT EDIT.
// CC="$CC" CFLAGS="$CFLAGS" ./mkgodefs.sh $@

package runtime
import "unsafe"
var _ unsafe.Pointer

EOF

for i in "$@"; do
	$CC $CFLAGS -q $i
done | awk '
/^func/ { next }
/^const/ { next }
/^\/\/.*type/ { next }

/^(const|func|type|var) / {
	if(seen[$2]++) {
        	skip = /{[^}]*$/;
		next;
	}
}

skip {
	skip = !/^}/
	next;
}

{print}
'
