// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/audit/audit_log.proto
// DO NOT EDIT!

/*
Package google_cloud_audit is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/audit/audit_log.proto

It has these top-level messages:
	AuditLog
	AuthenticationInfo
	AuthorizationInfo
	RequestMetadata
*/
package google_cloud_audit // import "google.golang.org/genproto/googleapis/cloud/audit"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import google_protobuf2 "github.com/golang/protobuf/ptypes/struct"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Common audit log format for Google Cloud Platform API operations.
type AuditLog struct {
	// The name of the API service performing the operation. For example,
	// `"datastore.googleapis.com"`.
	ServiceName string `protobuf:"bytes,7,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The name of the service method or operation.
	// For API calls, this should be the name of the API method.
	// For example,
	//
	//     "google.datastore.v1.Datastore.RunQuery"
	//     "google.logging.v1.LoggingService.DeleteLog"
	MethodName string `protobuf:"bytes,8,opt,name=method_name,json=methodName" json:"method_name,omitempty"`
	// The resource or collection that is the target of the operation.
	// The name is a scheme-less URI, not including the API service name.
	// For example:
	//
	//     "shelves/SHELF_ID/books"
	//     "shelves/SHELF_ID/books/BOOK_ID"
	ResourceName string `protobuf:"bytes,11,opt,name=resource_name,json=resourceName" json:"resource_name,omitempty"`
	// The number of items returned from a List or Query API method,
	// if applicable.
	NumResponseItems int64 `protobuf:"varint,12,opt,name=num_response_items,json=numResponseItems" json:"num_response_items,omitempty"`
	// The status of the overall operation.
	Status *google_rpc.Status `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
	// Authentication information.
	AuthenticationInfo *AuthenticationInfo `protobuf:"bytes,3,opt,name=authentication_info,json=authenticationInfo" json:"authentication_info,omitempty"`
	// Authorization information. If there are multiple
	// resources or permissions involved, then there is
	// one AuthorizationInfo element for each {resource, permission} tuple.
	AuthorizationInfo []*AuthorizationInfo `protobuf:"bytes,9,rep,name=authorization_info,json=authorizationInfo" json:"authorization_info,omitempty"`
	// Metadata about the operation.
	RequestMetadata *RequestMetadata `protobuf:"bytes,4,opt,name=request_metadata,json=requestMetadata" json:"request_metadata,omitempty"`
	// The operation request. This may not include all request parameters,
	// such as those that are too large, privacy-sensitive, or duplicated
	// elsewhere in the log record.
	// It should never include user-generated data, such as file contents.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	Request *google_protobuf2.Struct `protobuf:"bytes,16,opt,name=request" json:"request,omitempty"`
	// The operation response. This may not include all response elements,
	// such as those that are too large, privacy-sensitive, or duplicated
	// elsewhere in the log record.
	// It should never include user-generated data, such as file contents.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	Response *google_protobuf2.Struct `protobuf:"bytes,17,opt,name=response" json:"response,omitempty"`
	// Other service-specific data about the request, response, and other
	// activities.
	ServiceData *google_protobuf1.Any `protobuf:"bytes,15,opt,name=service_data,json=serviceData" json:"service_data,omitempty"`
}

func (m *AuditLog) Reset()                    { *m = AuditLog{} }
func (m *AuditLog) String() string            { return proto.CompactTextString(m) }
func (*AuditLog) ProtoMessage()               {}
func (*AuditLog) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *AuditLog) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *AuditLog) GetAuthenticationInfo() *AuthenticationInfo {
	if m != nil {
		return m.AuthenticationInfo
	}
	return nil
}

func (m *AuditLog) GetAuthorizationInfo() []*AuthorizationInfo {
	if m != nil {
		return m.AuthorizationInfo
	}
	return nil
}

func (m *AuditLog) GetRequestMetadata() *RequestMetadata {
	if m != nil {
		return m.RequestMetadata
	}
	return nil
}

func (m *AuditLog) GetRequest() *google_protobuf2.Struct {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *AuditLog) GetResponse() *google_protobuf2.Struct {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *AuditLog) GetServiceData() *google_protobuf1.Any {
	if m != nil {
		return m.ServiceData
	}
	return nil
}

// Authentication information for the operation.
type AuthenticationInfo struct {
	// The email address of the authenticated user making the request.
	PrincipalEmail string `protobuf:"bytes,1,opt,name=principal_email,json=principalEmail" json:"principal_email,omitempty"`
}

func (m *AuthenticationInfo) Reset()                    { *m = AuthenticationInfo{} }
func (m *AuthenticationInfo) String() string            { return proto.CompactTextString(m) }
func (*AuthenticationInfo) ProtoMessage()               {}
func (*AuthenticationInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Authorization information for the operation.
type AuthorizationInfo struct {
	// The resource being accessed, as a REST-style string. For example:
	//
	//     bigquery.googlapis.com/projects/PROJECTID/datasets/DATASETID
	Resource string `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
	// The required IAM permission.
	Permission string `protobuf:"bytes,2,opt,name=permission" json:"permission,omitempty"`
	// Whether or not authorization for `resource` and `permission`
	// was granted.
	Granted bool `protobuf:"varint,3,opt,name=granted" json:"granted,omitempty"`
}

func (m *AuthorizationInfo) Reset()                    { *m = AuthorizationInfo{} }
func (m *AuthorizationInfo) String() string            { return proto.CompactTextString(m) }
func (*AuthorizationInfo) ProtoMessage()               {}
func (*AuthorizationInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Metadata about the request.
type RequestMetadata struct {
	// The IP address of the caller.
	CallerIp string `protobuf:"bytes,1,opt,name=caller_ip,json=callerIp" json:"caller_ip,omitempty"`
	// The user agent of the caller.
	// This information is not authenticated and should be treated accordingly.
	// For example:
	//
	// +   `google-api-python-client/1.4.0`:
	//     The request was made by the Google API client for Python.
	// +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
	//     The request was made by the Google Cloud SDK CLI (gcloud).
	// +   `AppEngine-Google; (+http://code.google.com/appengine; appid: s~my-project`:
	//     The request was made from the `my-project` App Engine app.
	CallerSuppliedUserAgent string `protobuf:"bytes,2,opt,name=caller_supplied_user_agent,json=callerSuppliedUserAgent" json:"caller_supplied_user_agent,omitempty"`
}

func (m *RequestMetadata) Reset()                    { *m = RequestMetadata{} }
func (m *RequestMetadata) String() string            { return proto.CompactTextString(m) }
func (*RequestMetadata) ProtoMessage()               {}
func (*RequestMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func init() {
	proto.RegisterType((*AuditLog)(nil), "google.cloud.audit.AuditLog")
	proto.RegisterType((*AuthenticationInfo)(nil), "google.cloud.audit.AuthenticationInfo")
	proto.RegisterType((*AuthorizationInfo)(nil), "google.cloud.audit.AuthorizationInfo")
	proto.RegisterType((*RequestMetadata)(nil), "google.cloud.audit.RequestMetadata")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/audit/audit_log.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 597 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x93, 0x5f, 0x6f, 0xd3, 0x30,
	0x14, 0xc5, 0x55, 0x36, 0x6d, 0xad, 0xbb, 0xd1, 0xcd, 0x20, 0x16, 0x15, 0x09, 0x4a, 0x27, 0xa0,
	0x20, 0x14, 0x8b, 0x4d, 0x88, 0x07, 0xb4, 0x87, 0x4e, 0xf0, 0x50, 0x09, 0xa6, 0x29, 0x03, 0xf1,
	0x18, 0x79, 0xe9, 0xad, 0x67, 0x91, 0xd8, 0xc6, 0x7f, 0x90, 0xca, 0x77, 0xe6, 0x3b, 0xa0, 0xde,
	0x38, 0x65, 0x5b, 0x07, 0xec, 0xa1, 0x8d, 0x72, 0xee, 0xef, 0x1c, 0xdb, 0xd7, 0x37, 0x64, 0x2c,
	0xb4, 0x16, 0x25, 0xa4, 0x42, 0x97, 0x5c, 0x89, 0x54, 0x5b, 0xc1, 0x04, 0x28, 0x63, 0xb5, 0xd7,
	0xac, 0x2e, 0x71, 0x23, 0x1d, 0x2b, 0x4a, 0x1d, 0xa6, 0x8c, 0x87, 0xa9, 0xf4, 0xf5, 0x7f, 0x5e,
	0x6a, 0x91, 0x22, 0x46, 0x69, 0x8c, 0x40, 0x26, 0xc5, 0x6a, 0x7f, 0x72, 0xbb, 0x58, 0x6e, 0x24,
	0x73, 0x60, 0x7f, 0xc8, 0x02, 0x0a, 0xad, 0x66, 0x52, 0x30, 0xae, 0x94, 0xf6, 0xdc, 0x4b, 0xad,
	0x5c, 0x1d, 0xdf, 0x67, 0x42, 0xfa, 0x8b, 0x70, 0x9e, 0x16, 0xba, 0x62, 0x75, 0x1c, 0xc3, 0xc2,
	0x79, 0x98, 0x31, 0xe3, 0xe7, 0x06, 0x1c, 0xe3, 0x6a, 0xbe, 0xf8, 0x45, 0xc3, 0x9b, 0xff, 0x1b,
	0x9c, 0xb7, 0xa1, 0xf0, 0xf1, 0x11, 0x6d, 0x47, 0xb7, 0xdb, 0xb2, 0x35, 0x05, 0x73, 0x9e, 0xfb,
	0xe0, 0xe2, 0xa3, 0xb6, 0x0f, 0x7f, 0xad, 0x93, 0xf6, 0x78, 0x71, 0xf6, 0x8f, 0x5a, 0xd0, 0x27,
	0x64, 0x2b, 0x1e, 0x2b, 0x57, 0xbc, 0x82, 0x64, 0x73, 0xd0, 0x1a, 0x75, 0xb2, 0x6e, 0xd4, 0x4e,
	0x78, 0x05, 0xf4, 0x31, 0xe9, 0x56, 0xe0, 0x2f, 0xf4, 0xb4, 0x26, 0xda, 0x48, 0x90, 0x5a, 0x42,
	0x60, 0x9f, 0x6c, 0x5b, 0x70, 0x3a, 0xd8, 0x26, 0xa4, 0x8b, 0xc8, 0x56, 0x23, 0x22, 0xf4, 0x8a,
	0x50, 0x15, 0xaa, 0xdc, 0x82, 0x33, 0x5a, 0x39, 0xc8, 0xa5, 0x87, 0xca, 0x25, 0x5b, 0x83, 0xd6,
	0x68, 0x2d, 0xdb, 0x51, 0xa1, 0xca, 0x62, 0x61, 0xb2, 0xd0, 0xe9, 0x4b, 0xb2, 0x51, 0xef, 0x39,
	0xb9, 0x33, 0x68, 0x8d, 0xba, 0x07, 0x34, 0x8d, 0x67, 0xb6, 0xa6, 0x48, 0xcf, 0xb0, 0x92, 0x45,
	0x82, 0x7e, 0x25, 0xf7, 0x78, 0xf0, 0x17, 0xa0, 0xbc, 0x2c, 0xf0, 0x3e, 0x72, 0xa9, 0x66, 0x3a,
	0x59, 0x43, 0xe3, 0xb3, 0x74, 0xf5, 0xce, 0xd3, 0xf1, 0x15, 0x7c, 0xa2, 0x66, 0x3a, 0xa3, 0x7c,
	0x45, 0xa3, 0x9f, 0x09, 0xaa, 0xda, 0xca, 0x9f, 0x97, 0x72, 0x3b, 0x83, 0xb5, 0x51, 0xf7, 0xe0,
	0xe9, 0xdf, 0x72, 0x97, 0x34, 0xc6, 0xee, 0xf2, 0xeb, 0x12, 0x3d, 0x21, 0x3b, 0x16, 0xbe, 0x07,
	0x70, 0x3e, 0xaf, 0xc0, 0xf3, 0x29, 0xf7, 0x3c, 0x59, 0xc7, 0xbd, 0xee, 0xdf, 0x94, 0x99, 0xd5,
	0xec, 0xa7, 0x88, 0x66, 0x3d, 0x7b, 0x55, 0xa0, 0xaf, 0xc9, 0x66, 0x94, 0x92, 0x1d, 0x8c, 0xd9,
	0x6b, 0x62, 0x9a, 0x59, 0x4a, 0xcf, 0x70, 0x7a, 0xb2, 0x86, 0xa3, 0x87, 0xa4, 0xdd, 0xdc, 0x43,
	0xb2, 0xfb, 0x6f, 0xcf, 0x12, 0xa4, 0x6f, 0xff, 0x4c, 0x0a, 0xee, 0xb9, 0x87, 0xc6, 0xfb, 0x2b,
	0xc6, 0xb1, 0x9a, 0x2f, 0xe7, 0xe7, 0x3d, 0xf7, 0x7c, 0x78, 0x44, 0xe8, 0x6a, 0xc3, 0xe9, 0x73,
	0xd2, 0x33, 0x56, 0xaa, 0x42, 0x1a, 0x5e, 0xe6, 0x50, 0x71, 0x59, 0x26, 0x2d, 0x1c, 0x9b, 0xbb,
	0x4b, 0xf9, 0xc3, 0x42, 0x1d, 0x4a, 0xb2, 0xbb, 0xd2, 0x57, 0xda, 0xc7, 0x13, 0xe0, 0x74, 0x45,
	0xdb, 0xf2, 0x9d, 0x3e, 0x22, 0xc4, 0x80, 0xad, 0xa4, 0x73, 0x52, 0x2b, 0x9c, 0x9f, 0x4e, 0x76,
	0x49, 0xa1, 0x09, 0xd9, 0x14, 0x96, 0x2b, 0x0f, 0x53, 0x9c, 0x91, 0x76, 0xd6, 0xbc, 0x0e, 0xbf,
	0x91, 0xde, 0xb5, 0x76, 0xd3, 0x87, 0xa4, 0x53, 0xf0, 0xb2, 0x04, 0x9b, 0x4b, 0xd3, 0xac, 0x54,
	0x0b, 0x13, 0x43, 0xdf, 0x91, 0x7e, 0x2c, 0xba, 0x60, 0x4c, 0x29, 0x61, 0x9a, 0x07, 0x07, 0x36,
	0xe7, 0x02, 0x94, 0x8f, 0x2b, 0xef, 0xd5, 0xc4, 0x59, 0x04, 0xbe, 0x38, 0xb0, 0xe3, 0x45, 0xf9,
	0xf8, 0x05, 0x79, 0x50, 0xe8, 0xea, 0x86, 0x2b, 0x3f, 0xde, 0x6e, 0xbe, 0xce, 0xd3, 0x45, 0x4f,
	0x4f, 0x5b, 0xe7, 0x1b, 0xd8, 0xdc, 0xc3, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x93, 0xa1, 0x4a,
	0x9b, 0x03, 0x05, 0x00, 0x00,
}
