// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMesh = "CreateMesh"

// CreateMeshRequest generates a "aws/request.Request" representing the
// client's request for the CreateMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMesh for more information on using the CreateMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMeshRequest method.
//    req, resp := client.CreateMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateMesh
func (c *AppMesh) CreateMeshRequest(input *CreateMeshInput) (req *request.Request, output *CreateMeshOutput) {
	op := &request.Operation{
		Name:       opCreateMesh,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes",
	}

	if input == nil {
		input = &CreateMeshInput{}
	}

	output = &CreateMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMesh API operation for AWS App Mesh.
//
// Creates a service mesh. A service mesh is a logical boundary for network
// traffic between the services that reside within it.
//
// After you create your service mesh, you can create virtual services, virtual
// nodes, virtual routers, and routes to distribute traffic between the applications
// in your mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateMesh
func (c *AppMesh) CreateMesh(input *CreateMeshInput) (*CreateMeshOutput, error) {
	req, out := c.CreateMeshRequest(input)
	return out, req.Send()
}

// CreateMeshWithContext is the same as CreateMesh with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateMeshWithContext(ctx aws.Context, input *CreateMeshInput, opts ...request.Option) (*CreateMeshOutput, error) {
	req, out := c.CreateMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteRequest method.
//    req, resp := client.CreateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateRoute
func (c *AppMesh) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for AWS App Mesh.
//
// Creates a route that is associated with a virtual router.
//
// You can use the prefix parameter in your route specification for path-based
// routing of requests. For example, if your virtual service name is my-service.local
// and you want the route to match requests to my-service.local/metrics, your
// prefix should be /metrics.
//
// If your route matches a request, you can distribute traffic to one or more
// target virtual nodes with relative weighting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateRoute
func (c *AppMesh) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualNode = "CreateVirtualNode"

// CreateVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualNode for more information on using the CreateVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVirtualNodeRequest method.
//    req, resp := client.CreateVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNode
func (c *AppMesh) CreateVirtualNodeRequest(input *CreateVirtualNodeInput) (req *request.Request, output *CreateVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualNode,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes",
	}

	if input == nil {
		input = &CreateVirtualNodeInput{}
	}

	output = &CreateVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualNode API operation for AWS App Mesh.
//
// Creates a virtual node within a service mesh.
//
// A virtual node acts as a logical pointer to a particular task group, such
// as an Amazon ECS service or a Kubernetes deployment. When you create a virtual
// node, you can specify the service discovery information for your task group.
//
// Any inbound traffic that your virtual node expects should be specified as
// a listener. Any outbound traffic that your virtual node expects to reach
// should be specified as a backend.
//
// The response metadata for your new virtual node contains the arn that is
// associated with the virtual node. Set this value (either the full ARN or
// the truncated resource name: for example, mesh/default/virtualNode/simpleapp)
// as the APPMESH_VIRTUAL_NODE_NAME environment variable for your task group's
// Envoy proxy container in your task definition or pod spec. This is then mapped
// to the node.id and node.cluster Envoy parameters.
//
// If you require your Envoy stats or tracing to use a different name, you can
// override the node.cluster value that is set by APPMESH_VIRTUAL_NODE_NAME
// with the APPMESH_VIRTUAL_NODE_CLUSTER environment variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNode
func (c *AppMesh) CreateVirtualNode(input *CreateVirtualNodeInput) (*CreateVirtualNodeOutput, error) {
	req, out := c.CreateVirtualNodeRequest(input)
	return out, req.Send()
}

// CreateVirtualNodeWithContext is the same as CreateVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualNodeWithContext(ctx aws.Context, input *CreateVirtualNodeInput, opts ...request.Option) (*CreateVirtualNodeOutput, error) {
	req, out := c.CreateVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualRouter = "CreateVirtualRouter"

// CreateVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualRouter for more information on using the CreateVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVirtualRouterRequest method.
//    req, resp := client.CreateVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouter
func (c *AppMesh) CreateVirtualRouterRequest(input *CreateVirtualRouterInput) (req *request.Request, output *CreateVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualRouter,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters",
	}

	if input == nil {
		input = &CreateVirtualRouterInput{}
	}

	output = &CreateVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualRouter API operation for AWS App Mesh.
//
// Creates a virtual router within a service mesh.
//
// Any inbound traffic that your virtual router expects should be specified
// as a listener.
//
// Virtual routers handle traffic for one or more virtual services within your
// mesh. After you create your virtual router, create and associate routes for
// your virtual router that direct incoming requests to different virtual nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouter
func (c *AppMesh) CreateVirtualRouter(input *CreateVirtualRouterInput) (*CreateVirtualRouterOutput, error) {
	req, out := c.CreateVirtualRouterRequest(input)
	return out, req.Send()
}

// CreateVirtualRouterWithContext is the same as CreateVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualRouterWithContext(ctx aws.Context, input *CreateVirtualRouterInput, opts ...request.Option) (*CreateVirtualRouterOutput, error) {
	req, out := c.CreateVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualService = "CreateVirtualService"

// CreateVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualService for more information on using the CreateVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVirtualServiceRequest method.
//    req, resp := client.CreateVirtualServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualService
func (c *AppMesh) CreateVirtualServiceRequest(input *CreateVirtualServiceInput) (req *request.Request, output *CreateVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualService,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices",
	}

	if input == nil {
		input = &CreateVirtualServiceInput{}
	}

	output = &CreateVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualService API operation for AWS App Mesh.
//
// Creates a virtual service within a service mesh.
//
// A virtual service is an abstraction of a real service that is provided by
// a virtual node directly or indirectly by means of a virtual router. Dependent
// services call your virtual service by its virtualServiceName, and those requests
// are routed to the virtual node or virtual router that is specified as the
// provider for the virtual service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation CreateVirtualService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualService
func (c *AppMesh) CreateVirtualService(input *CreateVirtualServiceInput) (*CreateVirtualServiceOutput, error) {
	req, out := c.CreateVirtualServiceRequest(input)
	return out, req.Send()
}

// CreateVirtualServiceWithContext is the same as CreateVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) CreateVirtualServiceWithContext(ctx aws.Context, input *CreateVirtualServiceInput, opts ...request.Option) (*CreateVirtualServiceOutput, error) {
	req, out := c.CreateVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMesh = "DeleteMesh"

// DeleteMeshRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMesh for more information on using the DeleteMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMeshRequest method.
//    req, resp := client.DeleteMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh
func (c *AppMesh) DeleteMeshRequest(input *DeleteMeshInput) (req *request.Request, output *DeleteMeshOutput) {
	op := &request.Operation{
		Name:       opDeleteMesh,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &DeleteMeshInput{}
	}

	output = &DeleteMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMesh API operation for AWS App Mesh.
//
// Deletes an existing service mesh.
//
// You must delete all resources (virtual services, routes, virtual routers,
// and virtual nodes) in the service mesh before you can delete the mesh itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You can't delete the specified resource because it's in use or required by
//   another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh
func (c *AppMesh) DeleteMesh(input *DeleteMeshInput) (*DeleteMeshOutput, error) {
	req, out := c.DeleteMeshRequest(input)
	return out, req.Send()
}

// DeleteMeshWithContext is the same as DeleteMesh with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteMeshWithContext(ctx aws.Context, input *DeleteMeshInput, opts ...request.Option) (*DeleteMeshOutput, error) {
	req, out := c.DeleteMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteRequest method.
//    req, resp := client.DeleteRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteRoute
func (c *AppMesh) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoute API operation for AWS App Mesh.
//
// Deletes an existing route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You can't delete the specified resource because it's in use or required by
//   another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteRoute
func (c *AppMesh) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualNode = "DeleteVirtualNode"

// DeleteVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualNode for more information on using the DeleteVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualNodeRequest method.
//    req, resp := client.DeleteVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualNode
func (c *AppMesh) DeleteVirtualNodeRequest(input *DeleteVirtualNodeInput) (req *request.Request, output *DeleteVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualNode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &DeleteVirtualNodeInput{}
	}

	output = &DeleteVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualNode API operation for AWS App Mesh.
//
// Deletes an existing virtual node.
//
// You must delete any virtual services that list a virtual node as a service
// provider before you can delete the virtual node itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You can't delete the specified resource because it's in use or required by
//   another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualNode
func (c *AppMesh) DeleteVirtualNode(input *DeleteVirtualNodeInput) (*DeleteVirtualNodeOutput, error) {
	req, out := c.DeleteVirtualNodeRequest(input)
	return out, req.Send()
}

// DeleteVirtualNodeWithContext is the same as DeleteVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualNodeWithContext(ctx aws.Context, input *DeleteVirtualNodeInput, opts ...request.Option) (*DeleteVirtualNodeOutput, error) {
	req, out := c.DeleteVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualRouter = "DeleteVirtualRouter"

// DeleteVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualRouter for more information on using the DeleteVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualRouterRequest method.
//    req, resp := client.DeleteVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter
func (c *AppMesh) DeleteVirtualRouterRequest(input *DeleteVirtualRouterInput) (req *request.Request, output *DeleteVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualRouter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DeleteVirtualRouterInput{}
	}

	output = &DeleteVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualRouter API operation for AWS App Mesh.
//
// Deletes an existing virtual router.
//
// You must delete any routes associated with the virtual router before you
// can delete the router itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   You can't delete the specified resource because it's in use or required by
//   another resource.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter
func (c *AppMesh) DeleteVirtualRouter(input *DeleteVirtualRouterInput) (*DeleteVirtualRouterOutput, error) {
	req, out := c.DeleteVirtualRouterRequest(input)
	return out, req.Send()
}

// DeleteVirtualRouterWithContext is the same as DeleteVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualRouterWithContext(ctx aws.Context, input *DeleteVirtualRouterInput, opts ...request.Option) (*DeleteVirtualRouterOutput, error) {
	req, out := c.DeleteVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualService = "DeleteVirtualService"

// DeleteVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualService for more information on using the DeleteVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVirtualServiceRequest method.
//    req, resp := client.DeleteVirtualServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualService
func (c *AppMesh) DeleteVirtualServiceRequest(input *DeleteVirtualServiceInput) (req *request.Request, output *DeleteVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualService,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
	}

	if input == nil {
		input = &DeleteVirtualServiceInput{}
	}

	output = &DeleteVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualService API operation for AWS App Mesh.
//
// Deletes an existing virtual service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DeleteVirtualService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualService
func (c *AppMesh) DeleteVirtualService(input *DeleteVirtualServiceInput) (*DeleteVirtualServiceOutput, error) {
	req, out := c.DeleteVirtualServiceRequest(input)
	return out, req.Send()
}

// DeleteVirtualServiceWithContext is the same as DeleteVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DeleteVirtualServiceWithContext(ctx aws.Context, input *DeleteVirtualServiceInput, opts ...request.Option) (*DeleteVirtualServiceOutput, error) {
	req, out := c.DeleteVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMesh = "DescribeMesh"

// DescribeMeshRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMesh for more information on using the DescribeMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMeshRequest method.
//    req, resp := client.DescribeMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeMesh
func (c *AppMesh) DescribeMeshRequest(input *DescribeMeshInput) (req *request.Request, output *DescribeMeshOutput) {
	op := &request.Operation{
		Name:       opDescribeMesh,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &DescribeMeshInput{}
	}

	output = &DescribeMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMesh API operation for AWS App Mesh.
//
// Describes an existing service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeMesh
func (c *AppMesh) DescribeMesh(input *DescribeMeshInput) (*DescribeMeshOutput, error) {
	req, out := c.DescribeMeshRequest(input)
	return out, req.Send()
}

// DescribeMeshWithContext is the same as DescribeMesh with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeMeshWithContext(ctx aws.Context, input *DescribeMeshInput, opts ...request.Option) (*DescribeMeshOutput, error) {
	req, out := c.DescribeMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoute = "DescribeRoute"

// DescribeRouteRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoute for more information on using the DescribeRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRouteRequest method.
//    req, resp := client.DescribeRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeRoute
func (c *AppMesh) DescribeRouteRequest(input *DescribeRouteInput) (req *request.Request, output *DescribeRouteOutput) {
	op := &request.Operation{
		Name:       opDescribeRoute,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &DescribeRouteInput{}
	}

	output = &DescribeRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoute API operation for AWS App Mesh.
//
// Describes an existing route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeRoute
func (c *AppMesh) DescribeRoute(input *DescribeRouteInput) (*DescribeRouteOutput, error) {
	req, out := c.DescribeRouteRequest(input)
	return out, req.Send()
}

// DescribeRouteWithContext is the same as DescribeRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeRouteWithContext(ctx aws.Context, input *DescribeRouteInput, opts ...request.Option) (*DescribeRouteOutput, error) {
	req, out := c.DescribeRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualNode = "DescribeVirtualNode"

// DescribeVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualNode for more information on using the DescribeVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualNodeRequest method.
//    req, resp := client.DescribeVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualNode
func (c *AppMesh) DescribeVirtualNodeRequest(input *DescribeVirtualNodeInput) (req *request.Request, output *DescribeVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualNode,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &DescribeVirtualNodeInput{}
	}

	output = &DescribeVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualNode API operation for AWS App Mesh.
//
// Describes an existing virtual node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualNode
func (c *AppMesh) DescribeVirtualNode(input *DescribeVirtualNodeInput) (*DescribeVirtualNodeOutput, error) {
	req, out := c.DescribeVirtualNodeRequest(input)
	return out, req.Send()
}

// DescribeVirtualNodeWithContext is the same as DescribeVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualNodeWithContext(ctx aws.Context, input *DescribeVirtualNodeInput, opts ...request.Option) (*DescribeVirtualNodeOutput, error) {
	req, out := c.DescribeVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualRouter = "DescribeVirtualRouter"

// DescribeVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualRouter for more information on using the DescribeVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualRouterRequest method.
//    req, resp := client.DescribeVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter
func (c *AppMesh) DescribeVirtualRouterRequest(input *DescribeVirtualRouterInput) (req *request.Request, output *DescribeVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualRouter,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DescribeVirtualRouterInput{}
	}

	output = &DescribeVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualRouter API operation for AWS App Mesh.
//
// Describes an existing virtual router.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter
func (c *AppMesh) DescribeVirtualRouter(input *DescribeVirtualRouterInput) (*DescribeVirtualRouterOutput, error) {
	req, out := c.DescribeVirtualRouterRequest(input)
	return out, req.Send()
}

// DescribeVirtualRouterWithContext is the same as DescribeVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualRouterWithContext(ctx aws.Context, input *DescribeVirtualRouterInput, opts ...request.Option) (*DescribeVirtualRouterOutput, error) {
	req, out := c.DescribeVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualService = "DescribeVirtualService"

// DescribeVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualService for more information on using the DescribeVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVirtualServiceRequest method.
//    req, resp := client.DescribeVirtualServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualService
func (c *AppMesh) DescribeVirtualServiceRequest(input *DescribeVirtualServiceInput) (req *request.Request, output *DescribeVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualService,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
	}

	if input == nil {
		input = &DescribeVirtualServiceInput{}
	}

	output = &DescribeVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualService API operation for AWS App Mesh.
//
// Describes an existing virtual service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation DescribeVirtualService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualService
func (c *AppMesh) DescribeVirtualService(input *DescribeVirtualServiceInput) (*DescribeVirtualServiceOutput, error) {
	req, out := c.DescribeVirtualServiceRequest(input)
	return out, req.Send()
}

// DescribeVirtualServiceWithContext is the same as DescribeVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) DescribeVirtualServiceWithContext(ctx aws.Context, input *DescribeVirtualServiceInput, opts ...request.Option) (*DescribeVirtualServiceOutput, error) {
	req, out := c.DescribeVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMeshes = "ListMeshes"

// ListMeshesRequest generates a "aws/request.Request" representing the
// client's request for the ListMeshes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeshes for more information on using the ListMeshes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMeshesRequest method.
//    req, resp := client.ListMeshesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes
func (c *AppMesh) ListMeshesRequest(input *ListMeshesInput) (req *request.Request, output *ListMeshesOutput) {
	op := &request.Operation{
		Name:       opListMeshes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMeshesInput{}
	}

	output = &ListMeshesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMeshes API operation for AWS App Mesh.
//
// Returns a list of existing service meshes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListMeshes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes
func (c *AppMesh) ListMeshes(input *ListMeshesInput) (*ListMeshesOutput, error) {
	req, out := c.ListMeshesRequest(input)
	return out, req.Send()
}

// ListMeshesWithContext is the same as ListMeshes with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeshes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListMeshesWithContext(ctx aws.Context, input *ListMeshesInput, opts ...request.Option) (*ListMeshesOutput, error) {
	req, out := c.ListMeshesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMeshesPages iterates over the pages of a ListMeshes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMeshes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMeshes operation.
//    pageNum := 0
//    err := client.ListMeshesPages(params,
//        func(page *appmesh.ListMeshesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListMeshesPages(input *ListMeshesInput, fn func(*ListMeshesOutput, bool) bool) error {
	return c.ListMeshesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMeshesPagesWithContext same as ListMeshesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListMeshesPagesWithContext(ctx aws.Context, input *ListMeshesInput, fn func(*ListMeshesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMeshesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMeshesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMeshesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRoutes = "ListRoutes"

// ListRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutes for more information on using the ListRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoutesRequest method.
//    req, resp := client.ListRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes
func (c *AppMesh) ListRoutesRequest(input *ListRoutesInput) (req *request.Request, output *ListRoutesOutput) {
	op := &request.Operation{
		Name:       opListRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutesInput{}
	}

	output = &ListRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutes API operation for AWS App Mesh.
//
// Returns a list of existing routes in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListRoutes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes
func (c *AppMesh) ListRoutes(input *ListRoutesInput) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	return out, req.Send()
}

// ListRoutesWithContext is the same as ListRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListRoutesWithContext(ctx aws.Context, input *ListRoutesInput, opts ...request.Option) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutesPages iterates over the pages of a ListRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoutes operation.
//    pageNum := 0
//    err := client.ListRoutesPages(params,
//        func(page *appmesh.ListRoutesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListRoutesPages(input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool) error {
	return c.ListRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutesPagesWithContext same as ListRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListRoutesPagesWithContext(ctx aws.Context, input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRoutesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource
func (c *AppMesh) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/tags",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS App Mesh.
//
// List the tags for an App Mesh resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource
func (c *AppMesh) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *appmesh.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListVirtualNodes = "ListVirtualNodes"

// ListVirtualNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualNodes for more information on using the ListVirtualNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVirtualNodesRequest method.
//    req, resp := client.ListVirtualNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes
func (c *AppMesh) ListVirtualNodesRequest(input *ListVirtualNodesInput) (req *request.Request, output *ListVirtualNodesOutput) {
	op := &request.Operation{
		Name:       opListVirtualNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualNodesInput{}
	}

	output = &ListVirtualNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualNodes API operation for AWS App Mesh.
//
// Returns a list of existing virtual nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualNodes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes
func (c *AppMesh) ListVirtualNodes(input *ListVirtualNodesInput) (*ListVirtualNodesOutput, error) {
	req, out := c.ListVirtualNodesRequest(input)
	return out, req.Send()
}

// ListVirtualNodesWithContext is the same as ListVirtualNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualNodesWithContext(ctx aws.Context, input *ListVirtualNodesInput, opts ...request.Option) (*ListVirtualNodesOutput, error) {
	req, out := c.ListVirtualNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualNodesPages iterates over the pages of a ListVirtualNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVirtualNodes operation.
//    pageNum := 0
//    err := client.ListVirtualNodesPages(params,
//        func(page *appmesh.ListVirtualNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListVirtualNodesPages(input *ListVirtualNodesInput, fn func(*ListVirtualNodesOutput, bool) bool) error {
	return c.ListVirtualNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualNodesPagesWithContext same as ListVirtualNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualNodesPagesWithContext(ctx aws.Context, input *ListVirtualNodesInput, fn func(*ListVirtualNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVirtualNodesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListVirtualRouters = "ListVirtualRouters"

// ListVirtualRoutersRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualRouters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualRouters for more information on using the ListVirtualRouters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVirtualRoutersRequest method.
//    req, resp := client.ListVirtualRoutersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters
func (c *AppMesh) ListVirtualRoutersRequest(input *ListVirtualRoutersInput) (req *request.Request, output *ListVirtualRoutersOutput) {
	op := &request.Operation{
		Name:       opListVirtualRouters,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualRoutersInput{}
	}

	output = &ListVirtualRoutersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualRouters API operation for AWS App Mesh.
//
// Returns a list of existing virtual routers in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualRouters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters
func (c *AppMesh) ListVirtualRouters(input *ListVirtualRoutersInput) (*ListVirtualRoutersOutput, error) {
	req, out := c.ListVirtualRoutersRequest(input)
	return out, req.Send()
}

// ListVirtualRoutersWithContext is the same as ListVirtualRouters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualRouters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualRoutersWithContext(ctx aws.Context, input *ListVirtualRoutersInput, opts ...request.Option) (*ListVirtualRoutersOutput, error) {
	req, out := c.ListVirtualRoutersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualRoutersPages iterates over the pages of a ListVirtualRouters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualRouters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVirtualRouters operation.
//    pageNum := 0
//    err := client.ListVirtualRoutersPages(params,
//        func(page *appmesh.ListVirtualRoutersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListVirtualRoutersPages(input *ListVirtualRoutersInput, fn func(*ListVirtualRoutersOutput, bool) bool) error {
	return c.ListVirtualRoutersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualRoutersPagesWithContext same as ListVirtualRoutersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualRoutersPagesWithContext(ctx aws.Context, input *ListVirtualRoutersInput, fn func(*ListVirtualRoutersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualRoutersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualRoutersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVirtualRoutersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListVirtualServices = "ListVirtualServices"

// ListVirtualServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualServices for more information on using the ListVirtualServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVirtualServicesRequest method.
//    req, resp := client.ListVirtualServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices
func (c *AppMesh) ListVirtualServicesRequest(input *ListVirtualServicesInput) (req *request.Request, output *ListVirtualServicesOutput) {
	op := &request.Operation{
		Name:       opListVirtualServices,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualServicesInput{}
	}

	output = &ListVirtualServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualServices API operation for AWS App Mesh.
//
// Returns a list of existing virtual services in a service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation ListVirtualServices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices
func (c *AppMesh) ListVirtualServices(input *ListVirtualServicesInput) (*ListVirtualServicesOutput, error) {
	req, out := c.ListVirtualServicesRequest(input)
	return out, req.Send()
}

// ListVirtualServicesWithContext is the same as ListVirtualServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualServicesWithContext(ctx aws.Context, input *ListVirtualServicesInput, opts ...request.Option) (*ListVirtualServicesOutput, error) {
	req, out := c.ListVirtualServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualServicesPages iterates over the pages of a ListVirtualServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVirtualServices operation.
//    pageNum := 0
//    err := client.ListVirtualServicesPages(params,
//        func(page *appmesh.ListVirtualServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppMesh) ListVirtualServicesPages(input *ListVirtualServicesInput, fn func(*ListVirtualServicesOutput, bool) bool) error {
	return c.ListVirtualServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualServicesPagesWithContext same as ListVirtualServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) ListVirtualServicesPagesWithContext(ctx aws.Context, input *ListVirtualServicesInput, fn func(*ListVirtualServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVirtualServicesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagResource
func (c *AppMesh) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/tag",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS App Mesh.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource aren't specified in the request parameters,
// they aren't changed. When a resource is deleted, the tags associated with
// that resource are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   The request exceeds the maximum allowed number of tags allowed per resource.
//   The current limit is 50 user tags per resource. You must reduce the number
//   of tags in the request. None of the tags in this request were applied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagResource
func (c *AppMesh) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UntagResource
func (c *AppMesh) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS App Mesh.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UntagResource
func (c *AppMesh) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMesh = "UpdateMesh"

// UpdateMeshRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMesh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMesh for more information on using the UpdateMesh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMeshRequest method.
//    req, resp := client.UpdateMeshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMesh
func (c *AppMesh) UpdateMeshRequest(input *UpdateMeshInput) (req *request.Request, output *UpdateMeshOutput) {
	op := &request.Operation{
		Name:       opUpdateMesh,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &UpdateMeshInput{}
	}

	output = &UpdateMeshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMesh API operation for AWS App Mesh.
//
// Updates an existing service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateMesh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMesh
func (c *AppMesh) UpdateMesh(input *UpdateMeshInput) (*UpdateMeshOutput, error) {
	req, out := c.UpdateMeshRequest(input)
	return out, req.Send()
}

// UpdateMeshWithContext is the same as UpdateMesh with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMesh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateMeshWithContext(ctx aws.Context, input *UpdateMeshInput, opts ...request.Option) (*UpdateMeshOutput, error) {
	req, out := c.UpdateMeshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoute = "UpdateRoute"

// UpdateRouteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoute for more information on using the UpdateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRouteRequest method.
//    req, resp := client.UpdateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateRoute
func (c *AppMesh) UpdateRouteRequest(input *UpdateRouteInput) (req *request.Request, output *UpdateRouteOutput) {
	op := &request.Operation{
		Name:       opUpdateRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
	}

	if input == nil {
		input = &UpdateRouteInput{}
	}

	output = &UpdateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoute API operation for AWS App Mesh.
//
// Updates an existing route for a specified service mesh and virtual router.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateRoute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateRoute
func (c *AppMesh) UpdateRoute(input *UpdateRouteInput) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	return out, req.Send()
}

// UpdateRouteWithContext is the same as UpdateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateRouteWithContext(ctx aws.Context, input *UpdateRouteInput, opts ...request.Option) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualNode = "UpdateVirtualNode"

// UpdateVirtualNodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualNode for more information on using the UpdateVirtualNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVirtualNodeRequest method.
//    req, resp := client.UpdateVirtualNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualNode
func (c *AppMesh) UpdateVirtualNodeRequest(input *UpdateVirtualNodeInput) (req *request.Request, output *UpdateVirtualNodeOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualNode,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
	}

	if input == nil {
		input = &UpdateVirtualNodeInput{}
	}

	output = &UpdateVirtualNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualNode API operation for AWS App Mesh.
//
// Updates an existing virtual node in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualNode
func (c *AppMesh) UpdateVirtualNode(input *UpdateVirtualNodeInput) (*UpdateVirtualNodeOutput, error) {
	req, out := c.UpdateVirtualNodeRequest(input)
	return out, req.Send()
}

// UpdateVirtualNodeWithContext is the same as UpdateVirtualNode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualNodeWithContext(ctx aws.Context, input *UpdateVirtualNodeInput, opts ...request.Option) (*UpdateVirtualNodeOutput, error) {
	req, out := c.UpdateVirtualNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualRouter = "UpdateVirtualRouter"

// UpdateVirtualRouterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualRouter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualRouter for more information on using the UpdateVirtualRouter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVirtualRouterRequest method.
//    req, resp := client.UpdateVirtualRouterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualRouter
func (c *AppMesh) UpdateVirtualRouterRequest(input *UpdateVirtualRouterInput) (req *request.Request, output *UpdateVirtualRouterOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualRouter,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &UpdateVirtualRouterInput{}
	}

	output = &UpdateVirtualRouterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualRouter API operation for AWS App Mesh.
//
// Updates an existing virtual router in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualRouter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualRouter
func (c *AppMesh) UpdateVirtualRouter(input *UpdateVirtualRouterInput) (*UpdateVirtualRouterOutput, error) {
	req, out := c.UpdateVirtualRouterRequest(input)
	return out, req.Send()
}

// UpdateVirtualRouterWithContext is the same as UpdateVirtualRouter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualRouter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualRouterWithContext(ctx aws.Context, input *UpdateVirtualRouterInput, opts ...request.Option) (*UpdateVirtualRouterOutput, error) {
	req, out := c.UpdateVirtualRouterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVirtualService = "UpdateVirtualService"

// UpdateVirtualServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVirtualService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVirtualService for more information on using the UpdateVirtualService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVirtualServiceRequest method.
//    req, resp := client.UpdateVirtualServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualService
func (c *AppMesh) UpdateVirtualServiceRequest(input *UpdateVirtualServiceInput) (req *request.Request, output *UpdateVirtualServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateVirtualService,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
	}

	if input == nil {
		input = &UpdateVirtualServiceInput{}
	}

	output = &UpdateVirtualServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVirtualService API operation for AWS App Mesh.
//
// Updates an existing virtual service in a specified service mesh.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS App Mesh's
// API operation UpdateVirtualService for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request syntax was malformed. Check your request syntax and try again.
//
//   * ErrCodeConflictException "ConflictException"
//   The request contains a client token that was used for a previous update resource
//   call with different specifications. Try the request again with a new client
//   token.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   You don't have permissions to perform this action.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You have exceeded a service limit for your account. For more information,
//   see Service Limits (https://docs.aws.amazon.com/app-mesh/latest/userguide/service_limits.html)
//   in the AWS App Mesh User Guide.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified resource doesn't exist. Check your request syntax and try again.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed due to a temporary failure of the service.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The maximum request rate permitted by the App Mesh APIs has been exceeded
//   for your account. For best results, use an increasing or variable sleep interval
//   between requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualService
func (c *AppMesh) UpdateVirtualService(input *UpdateVirtualServiceInput) (*UpdateVirtualServiceOutput, error) {
	req, out := c.UpdateVirtualServiceRequest(input)
	return out, req.Send()
}

// UpdateVirtualServiceWithContext is the same as UpdateVirtualService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVirtualService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppMesh) UpdateVirtualServiceWithContext(ctx aws.Context, input *UpdateVirtualServiceInput, opts ...request.Option) (*UpdateVirtualServiceOutput, error) {
	req, out := c.UpdateVirtualServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An object representing the access logging information for a virtual node.
type AccessLog struct {
	_ struct{} `type:"structure"`

	// The file object to send virtual node access logs to.
	File *FileAccessLog `locationName:"file" type:"structure"`
}

// String returns the string representation
func (s AccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessLog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessLog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessLog"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *AccessLog) SetFile(v *FileAccessLog) *AccessLog {
	s.File = v
	return s
}

// An object representing the AWS Cloud Map attribute information for your virtual
// node.
type AwsCloudMapInstanceAttribute struct {
	_ struct{} `type:"structure"`

	// The name of an AWS Cloud Map service instance attribute key. Any AWS Cloud
	// Map service instance that contains the specified key and value is returned.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of an AWS Cloud Map service instance attribute key. Any AWS Cloud
	// Map service instance that contains the specified key and value is returned.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AwsCloudMapInstanceAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudMapInstanceAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsCloudMapInstanceAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsCloudMapInstanceAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AwsCloudMapInstanceAttribute) SetKey(v string) *AwsCloudMapInstanceAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCloudMapInstanceAttribute) SetValue(v string) *AwsCloudMapInstanceAttribute {
	s.Value = &v
	return s
}

// An object representing the AWS Cloud Map service discovery information for
// your virtual node.
type AwsCloudMapServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// A string map that contains attributes with values that you can use to filter
	// instances by any custom attribute that you specified when you registered
	// the instance. Only instances that match all of the specified key/value pairs
	// will be returned.
	Attributes []*AwsCloudMapInstanceAttribute `locationName:"attributes" type:"list"`

	// The name of the AWS Cloud Map namespace to use.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"1" type:"string" required:"true"`

	// The name of the AWS Cloud Map service to use.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AwsCloudMapServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudMapServiceDiscovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsCloudMapServiceDiscovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsCloudMapServiceDiscovery"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AwsCloudMapServiceDiscovery) SetAttributes(v []*AwsCloudMapInstanceAttribute) *AwsCloudMapServiceDiscovery {
	s.Attributes = v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *AwsCloudMapServiceDiscovery) SetNamespaceName(v string) *AwsCloudMapServiceDiscovery {
	s.NamespaceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsCloudMapServiceDiscovery) SetServiceName(v string) *AwsCloudMapServiceDiscovery {
	s.ServiceName = &v
	return s
}

// An object representing the backends that a virtual node is expected to send
// outbound traffic to.
type Backend struct {
	_ struct{} `type:"structure"`

	// Specifies a virtual service to use as a backend for a virtual node.
	VirtualService *VirtualServiceBackend `locationName:"virtualService" type:"structure"`
}

// String returns the string representation
func (s Backend) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Backend) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Backend) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Backend"}
	if s.VirtualService != nil {
		if err := s.VirtualService.Validate(); err != nil {
			invalidParams.AddNested("VirtualService", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualService sets the VirtualService field's value.
func (s *Backend) SetVirtualService(v *VirtualServiceBackend) *Backend {
	s.VirtualService = v
	return s
}

type CreateMeshInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name to use for the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The service mesh specification to apply.
	Spec *MeshSpec `locationName:"spec" type:"structure"`

	// Optional metadata that you can apply to the service mesh to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMeshInput) SetClientToken(v string) *CreateMeshInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateMeshInput) SetMeshName(v string) *CreateMeshInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateMeshInput) SetSpec(v *MeshSpec) *CreateMeshInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMeshInput) SetTags(v []*TagRef) *CreateMeshInput {
	s.Tags = v
	return s
}

type CreateMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The full description of your service mesh following the create call.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *CreateMeshOutput) SetMesh(v *MeshData) *CreateMeshOutput {
	s.Mesh = v
	return s
}

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the route in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name to use for the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The route specification to apply.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the route to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name of the virtual router in which to create the route.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRouteInput) SetClientToken(v string) *CreateRouteInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateRouteInput) SetMeshName(v string) *CreateRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *CreateRouteInput) SetRouteName(v string) *CreateRouteInput {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateRouteInput) SetSpec(v *RouteSpec) *CreateRouteInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRouteInput) SetTags(v []*TagRef) *CreateRouteInput {
	s.Tags = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *CreateRouteInput) SetVirtualRouterName(v string) *CreateRouteInput {
	s.VirtualRouterName = &v
	return s
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The full description of your mesh following the create call.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *CreateRouteOutput) SetRoute(v *RouteData) *CreateRouteOutput {
	s.Route = v
	return s
}

type CreateVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual node in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The virtual node specification to apply.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual node to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualNodeInput) SetClientToken(v string) *CreateVirtualNodeInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualNodeInput) SetMeshName(v string) *CreateVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualNodeInput) SetSpec(v *VirtualNodeSpec) *CreateVirtualNodeInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualNodeInput) SetTags(v []*TagRef) *CreateVirtualNodeInput {
	s.Tags = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *CreateVirtualNodeInput) SetVirtualNodeName(v string) *CreateVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type CreateVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The full description of your virtual node following the create call.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *CreateVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *CreateVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type CreateVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual router in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The virtual router specification to apply.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual router to assist with
	// categorization and organization. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualRouterInput) SetClientToken(v string) *CreateVirtualRouterInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualRouterInput) SetMeshName(v string) *CreateVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualRouterInput) SetSpec(v *VirtualRouterSpec) *CreateVirtualRouterInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualRouterInput) SetTags(v []*TagRef) *CreateVirtualRouterInput {
	s.Tags = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *CreateVirtualRouterInput) SetVirtualRouterName(v string) *CreateVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type CreateVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The full description of your virtual router following the create call.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *CreateVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *CreateVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type CreateVirtualServiceInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to create the virtual service in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The virtual service specification to apply.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// Optional metadata that you can apply to the virtual service to assist with
	// categorization and organization. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*TagRef `locationName:"tags" type:"list"`

	// The name to use for the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualServiceInput) SetClientToken(v string) *CreateVirtualServiceInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *CreateVirtualServiceInput) SetMeshName(v string) *CreateVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateVirtualServiceInput) SetSpec(v *VirtualServiceSpec) *CreateVirtualServiceInput {
	s.Spec = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualServiceInput) SetTags(v []*TagRef) *CreateVirtualServiceInput {
	s.Tags = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *CreateVirtualServiceInput) SetVirtualServiceName(v string) *CreateVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type CreateVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// The full description of your virtual service following the create call.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *CreateVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *CreateVirtualServiceOutput {
	s.VirtualService = v
	return s
}

type DeleteMeshInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to delete.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteMeshInput) SetMeshName(v string) *DeleteMeshInput {
	s.MeshName = &v
	return s
}

type DeleteMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The service mesh that was deleted.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *DeleteMeshOutput) SetMesh(v *MeshData) *DeleteMeshOutput {
	s.Mesh = v
	return s
}

type DeleteRouteInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to delete the route in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route to delete.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The name of the virtual router to delete the route in.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteRouteInput) SetMeshName(v string) *DeleteRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *DeleteRouteInput) SetRouteName(v string) *DeleteRouteInput {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DeleteRouteInput) SetVirtualRouterName(v string) *DeleteRouteInput {
	s.VirtualRouterName = &v
	return s
}

type DeleteRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The route that was deleted.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *DeleteRouteOutput) SetRoute(v *RouteData) *DeleteRouteOutput {
	s.Route = v
	return s
}

type DeleteVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to delete the virtual node in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual node to delete.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualNodeInput) SetMeshName(v string) *DeleteVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *DeleteVirtualNodeInput) SetVirtualNodeName(v string) *DeleteVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type DeleteVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The virtual node that was deleted.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *DeleteVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *DeleteVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type DeleteVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to delete the virtual router in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual router to delete.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualRouterInput) SetMeshName(v string) *DeleteVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DeleteVirtualRouterInput) SetVirtualRouterName(v string) *DeleteVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type DeleteVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The virtual router that was deleted.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *DeleteVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *DeleteVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type DeleteVirtualServiceInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to delete the virtual service in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual service to delete.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `location:"uri" locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DeleteVirtualServiceInput) SetMeshName(v string) *DeleteVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *DeleteVirtualServiceInput) SetVirtualServiceName(v string) *DeleteVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type DeleteVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// The virtual service that was deleted.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *DeleteVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *DeleteVirtualServiceOutput {
	s.VirtualService = v
	return s
}

type DescribeMeshInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh to describe.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeMeshInput) SetMeshName(v string) *DescribeMeshInput {
	s.MeshName = &v
	return s
}

type DescribeMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// The full description of your service mesh.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *DescribeMeshOutput) SetMesh(v *MeshData) *DescribeMeshOutput {
	s.Mesh = v
	return s
}

type DescribeRouteInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route to describe.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The name of the virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeRouteInput) SetMeshName(v string) *DescribeRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *DescribeRouteInput) SetRouteName(v string) *DescribeRouteInput {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DescribeRouteInput) SetVirtualRouterName(v string) *DescribeRouteInput {
	s.VirtualRouterName = &v
	return s
}

type DescribeRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// The full description of your route.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *DescribeRouteOutput) SetRoute(v *RouteData) *DescribeRouteOutput {
	s.Route = v
	return s
}

type DescribeVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual node to describe.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualNodeInput) SetMeshName(v string) *DescribeVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *DescribeVirtualNodeInput) SetVirtualNodeName(v string) *DescribeVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type DescribeVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// The full description of your virtual node.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *DescribeVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *DescribeVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type DescribeVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual router to describe.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualRouterInput) SetMeshName(v string) *DescribeVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *DescribeVirtualRouterInput) SetVirtualRouterName(v string) *DescribeVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type DescribeVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// The full description of your virtual router.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *DescribeVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *DescribeVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type DescribeVirtualServiceInput struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual service to describe.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `location:"uri" locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeshName sets the MeshName field's value.
func (s *DescribeVirtualServiceInput) SetMeshName(v string) *DescribeVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *DescribeVirtualServiceInput) SetVirtualServiceName(v string) *DescribeVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type DescribeVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// The full description of your virtual service.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *DescribeVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *DescribeVirtualServiceOutput {
	s.VirtualService = v
	return s
}

// An object representing the DNS service discovery information for your virtual
// node.
type DnsServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS service discovery hostname for the virtual node.
	//
	// Hostname is a required field
	Hostname *string `locationName:"hostname" type:"string" required:"true"`
}

// String returns the string representation
func (s DnsServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsServiceDiscovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsServiceDiscovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsServiceDiscovery"}
	if s.Hostname == nil {
		invalidParams.Add(request.NewErrParamRequired("Hostname"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *DnsServiceDiscovery) SetHostname(v string) *DnsServiceDiscovery {
	s.Hostname = &v
	return s
}

// An object representing the egress filter rules for a service mesh.
type EgressFilter struct {
	_ struct{} `type:"structure"`

	// The egress filter type. By default, the type is DROP_ALL, which allows egress
	// only from virtual nodes to other defined resources in the service mesh (and
	// any traffic to *.amazonaws.com for AWS API calls). You can set the egress
	// filter type to ALLOW_ALL to allow egress to any endpoint inside or outside
	// of the service mesh.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EgressFilterType"`
}

// String returns the string representation
func (s EgressFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EgressFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EgressFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EgressFilter"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EgressFilter) SetType(v string) *EgressFilter {
	s.Type = &v
	return s
}

// An object representing an access log file.
type FileAccessLog struct {
	_ struct{} `type:"structure"`

	// The file path to write access logs to. You can use /dev/stdout to send access
	// logs to standard out and configure your Envoy container to use a log driver,
	// such as awslogs, to export the access logs to a log storage service such
	// as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
	// file system to write the files to disk.
	//
	// The Envoy process must have write permissions to the path that you specify
	// here. Otherwise, Envoy fails to bootstrap properly.
	//
	// Path is a required field
	Path *string `locationName:"path" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FileAccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileAccessLog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileAccessLog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileAccessLog"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPath sets the Path field's value.
func (s *FileAccessLog) SetPath(v string) *FileAccessLog {
	s.Path = &v
	return s
}

// An object representing the health check policy for a virtual node's listener.
type HealthCheckPolicy struct {
	_ struct{} `type:"structure"`

	// The number of consecutive successful health checks that must occur before
	// declaring listener healthy.
	//
	// HealthyThreshold is a required field
	HealthyThreshold *int64 `locationName:"healthyThreshold" min:"2" type:"integer" required:"true"`

	// The time period in milliseconds between each health check execution.
	//
	// IntervalMillis is a required field
	IntervalMillis *int64 `locationName:"intervalMillis" min:"5000" type:"long" required:"true"`

	// The destination path for the health check request. This is required only
	// if the specified protocol is HTTP. If the protocol is TCP, this parameter
	// is ignored.
	Path *string `locationName:"path" type:"string"`

	// The destination port for the health check request. This port must match the
	// port defined in the PortMapping for the listener.
	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// The protocol for the health check request.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"PortProtocol"`

	// The amount of time to wait when receiving a response from the health check,
	// in milliseconds.
	//
	// TimeoutMillis is a required field
	TimeoutMillis *int64 `locationName:"timeoutMillis" min:"2000" type:"long" required:"true"`

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual node unhealthy.
	//
	// UnhealthyThreshold is a required field
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" min:"2" type:"integer" required:"true"`
}

// String returns the string representation
func (s HealthCheckPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckPolicy"}
	if s.HealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthyThreshold"))
	}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThreshold", 2))
	}
	if s.IntervalMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalMillis"))
	}
	if s.IntervalMillis != nil && *s.IntervalMillis < 5000 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalMillis", 5000))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.TimeoutMillis == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutMillis"))
	}
	if s.TimeoutMillis != nil && *s.TimeoutMillis < 2000 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutMillis", 2000))
	}
	if s.UnhealthyThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("UnhealthyThreshold"))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 2 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThreshold", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckPolicy) SetHealthyThreshold(v int64) *HealthCheckPolicy {
	s.HealthyThreshold = &v
	return s
}

// SetIntervalMillis sets the IntervalMillis field's value.
func (s *HealthCheckPolicy) SetIntervalMillis(v int64) *HealthCheckPolicy {
	s.IntervalMillis = &v
	return s
}

// SetPath sets the Path field's value.
func (s *HealthCheckPolicy) SetPath(v string) *HealthCheckPolicy {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckPolicy) SetPort(v int64) *HealthCheckPolicy {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckPolicy) SetProtocol(v string) *HealthCheckPolicy {
	s.Protocol = &v
	return s
}

// SetTimeoutMillis sets the TimeoutMillis field's value.
func (s *HealthCheckPolicy) SetTimeoutMillis(v int64) *HealthCheckPolicy {
	s.TimeoutMillis = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckPolicy) SetUnhealthyThreshold(v int64) *HealthCheckPolicy {
	s.UnhealthyThreshold = &v
	return s
}

// An object representing the HTTP routing specification for a route.
type HttpRoute struct {
	_ struct{} `type:"structure"`

	// The action to take if a match is determined.
	//
	// Action is a required field
	Action *HttpRouteAction `locationName:"action" type:"structure" required:"true"`

	// The criteria for determining an HTTP request match.
	//
	// Match is a required field
	Match *HttpRouteMatch `locationName:"match" type:"structure" required:"true"`
}

// String returns the string representation
func (s HttpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Match == nil {
		invalidParams.Add(request.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *HttpRoute) SetAction(v *HttpRouteAction) *HttpRoute {
	s.Action = v
	return s
}

// SetMatch sets the Match field's value.
func (s *HttpRoute) SetMatch(v *HttpRouteMatch) *HttpRoute {
	s.Match = v
	return s
}

// An object representing the traffic distribution requirements for matched
// HTTP requests.
type HttpRouteAction struct {
	_ struct{} `type:"structure"`

	// The targets that traffic is routed to when a request matches the route. You
	// can specify one or more targets and their relative weights to distribute
	// traffic with.
	//
	// WeightedTargets is a required field
	WeightedTargets []*WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s HttpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRouteAction"}
	if s.WeightedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeightedTargets sets the WeightedTargets field's value.
func (s *HttpRouteAction) SetWeightedTargets(v []*WeightedTarget) *HttpRouteAction {
	s.WeightedTargets = v
	return s
}

// An object representing the requirements for a route to match HTTP requests
// for a virtual router.
type HttpRouteMatch struct {
	_ struct{} `type:"structure"`

	// Specifies the path to match requests with. This parameter must always start
	// with /, which by itself matches all requests to the virtual service name.
	// You can also match for path-based routing of requests. For example, if your
	// virtual service name is my-service.local and you want the route to match
	// requests to my-service.local/metrics, your prefix should be /metrics.
	//
	// Prefix is a required field
	Prefix *string `locationName:"prefix" type:"string" required:"true"`
}

// String returns the string representation
func (s HttpRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpRouteMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpRouteMatch"}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *HttpRouteMatch) SetPrefix(v string) *HttpRouteMatch {
	s.Prefix = &v
	return s
}

type ListMeshesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results returned by ListMeshes in paginated output.
	// When you use this parameter, ListMeshes returns only limit results in a single
	// page along with a nextToken response element. You can see the remaining results
	// of the initial request by sending another ListMeshes request with the returned
	// nextToken value. This value can be between 1 and 100. If you don't use this
	// parameter, ListMeshes returns up to 100 results and a nextToken value if
	// applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListMeshes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMeshesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMeshesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMeshesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMeshesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListMeshesInput) SetLimit(v int64) *ListMeshesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeshesInput) SetNextToken(v string) *ListMeshesInput {
	s.NextToken = &v
	return s
}

type ListMeshesOutput struct {
	_ struct{} `type:"structure"`

	// The list of existing service meshes.
	//
	// Meshes is a required field
	Meshes []*MeshRef `locationName:"meshes" type:"list" required:"true"`

	// The nextToken value to include in a future ListMeshes request. When the results
	// of a ListMeshes request exceed limit, you can use this value to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMeshesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMeshesOutput) GoString() string {
	return s.String()
}

// SetMeshes sets the Meshes field's value.
func (s *ListMeshesOutput) SetMeshes(v []*MeshRef) *ListMeshesOutput {
	s.Meshes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeshesOutput) SetNextToken(v string) *ListMeshesOutput {
	s.NextToken = &v
	return s
}

type ListRoutesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results returned by ListRoutes in paginated output.
	// When you use this parameter, ListRoutes returns only limit results in a single
	// page along with a nextToken response element. You can see the remaining results
	// of the initial request by sending another ListRoutes request with the returned
	// nextToken value. This value can be between 1 and 100. If you don't use this
	// parameter, ListRoutes returns up to 100 results and a nextToken value if
	// applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list routes in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListRoutes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the virtual router to list routes in.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRoutesInput) SetLimit(v int64) *ListRoutesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListRoutesInput) SetMeshName(v string) *ListRoutesInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesInput) SetNextToken(v string) *ListRoutesInput {
	s.NextToken = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *ListRoutesInput) SetVirtualRouterName(v string) *ListRoutesInput {
	s.VirtualRouterName = &v
	return s
}

type ListRoutesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListRoutes request. When the results
	// of a ListRoutes request exceed limit, you can use this value to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing routes for the specified service mesh and virtual router.
	//
	// Routes is a required field
	Routes []*RouteRef `locationName:"routes" type:"list" required:"true"`
}

// String returns the string representation
func (s ListRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesOutput) SetNextToken(v string) *ListRoutesOutput {
	s.NextToken = &v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *ListRoutesOutput) SetRoutes(v []*RouteRef) *ListRoutesOutput {
	s.Routes = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tag results returned by ListTagsForResource in paginated
	// output. When this parameter is used, ListTagsForResource returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListTagsForResource
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListTagsForResource returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListTagsForResource
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListTagsForResource request. When
	// the results of a ListTagsForResource request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags []*TagRef `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*TagRef) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVirtualNodesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results returned by ListVirtualNodes in paginated output.
	// When you use this parameter, ListVirtualNodes returns only limit results
	// in a single page along with a nextToken response element. You can see the
	// remaining results of the initial request by sending another ListVirtualNodes
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualNodes returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual nodes in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListVirtualNodes request
	// where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListVirtualNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualNodesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualNodesInput) SetLimit(v int64) *ListVirtualNodesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualNodesInput) SetMeshName(v string) *ListVirtualNodesInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualNodesInput) SetNextToken(v string) *ListVirtualNodesInput {
	s.NextToken = &v
	return s
}

type ListVirtualNodesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualNodes request. When
	// the results of a ListVirtualNodes request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual nodes for the specified service mesh.
	//
	// VirtualNodes is a required field
	VirtualNodes []*VirtualNodeRef `locationName:"virtualNodes" type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualNodesOutput) SetNextToken(v string) *ListVirtualNodesOutput {
	s.NextToken = &v
	return s
}

// SetVirtualNodes sets the VirtualNodes field's value.
func (s *ListVirtualNodesOutput) SetVirtualNodes(v []*VirtualNodeRef) *ListVirtualNodesOutput {
	s.VirtualNodes = v
	return s
}

type ListVirtualRoutersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results returned by ListVirtualRouters in paginated
	// output. When you use this parameter, ListVirtualRouters returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListVirtualRouters
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualRouters returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual routers in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListVirtualRouters
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListVirtualRoutersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualRoutersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualRoutersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualRoutersInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualRoutersInput) SetLimit(v int64) *ListVirtualRoutersInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualRoutersInput) SetMeshName(v string) *ListVirtualRoutersInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualRoutersInput) SetNextToken(v string) *ListVirtualRoutersInput {
	s.NextToken = &v
	return s
}

type ListVirtualRoutersOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualRouters request. When
	// the results of a ListVirtualRouters request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual routers for the specified service mesh.
	//
	// VirtualRouters is a required field
	VirtualRouters []*VirtualRouterRef `locationName:"virtualRouters" type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualRoutersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualRoutersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualRoutersOutput) SetNextToken(v string) *ListVirtualRoutersOutput {
	s.NextToken = &v
	return s
}

// SetVirtualRouters sets the VirtualRouters field's value.
func (s *ListVirtualRoutersOutput) SetVirtualRouters(v []*VirtualRouterRef) *ListVirtualRoutersOutput {
	s.VirtualRouters = v
	return s
}

type ListVirtualServicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results returned by ListVirtualServices in paginated
	// output. When you use this parameter, ListVirtualServices returns only limit
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListVirtualServices
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListVirtualServices returns up to 100
	// results and a nextToken value if applicable.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The name of the service mesh to list virtual services in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListVirtualServices
	// request where limit was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListVirtualServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualServicesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListVirtualServicesInput) SetLimit(v int64) *ListVirtualServicesInput {
	s.Limit = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *ListVirtualServicesInput) SetMeshName(v string) *ListVirtualServicesInput {
	s.MeshName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualServicesInput) SetNextToken(v string) *ListVirtualServicesInput {
	s.NextToken = &v
	return s
}

type ListVirtualServicesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListVirtualServices request. When
	// the results of a ListVirtualServices request exceed limit, you can use this
	// value to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing virtual services for the specified service mesh.
	//
	// VirtualServices is a required field
	VirtualServices []*VirtualServiceRef `locationName:"virtualServices" type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualServicesOutput) SetNextToken(v string) *ListVirtualServicesOutput {
	s.NextToken = &v
	return s
}

// SetVirtualServices sets the VirtualServices field's value.
func (s *ListVirtualServicesOutput) SetVirtualServices(v []*VirtualServiceRef) *ListVirtualServicesOutput {
	s.VirtualServices = v
	return s
}

// An object representing a listener for a virtual node.
type Listener struct {
	_ struct{} `type:"structure"`

	// The health check information for the listener.
	HealthCheck *HealthCheckPolicy `locationName:"healthCheck" type:"structure"`

	// The port mapping information for the listener.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Listener) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Listener"}
	if s.PortMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("PortMapping"))
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *Listener) SetHealthCheck(v *HealthCheckPolicy) *Listener {
	s.HealthCheck = v
	return s
}

// SetPortMapping sets the PortMapping field's value.
func (s *Listener) SetPortMapping(v *PortMapping) *Listener {
	s.PortMapping = v
	return s
}

// An object representing the logging information for a virtual node.
type Logging struct {
	_ struct{} `type:"structure"`

	// The access log configuration for a virtual node.
	AccessLog *AccessLog `locationName:"accessLog" type:"structure"`
}

// String returns the string representation
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Logging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Logging"}
	if s.AccessLog != nil {
		if err := s.AccessLog.Validate(); err != nil {
			invalidParams.AddNested("AccessLog", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLog sets the AccessLog field's value.
func (s *Logging) SetAccessLog(v *AccessLog) *Logging {
	s.AccessLog = v
	return s
}

// An object representing a service mesh returned by a describe operation.
type MeshData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the service mesh.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The associated specification for the service mesh.
	//
	// Spec is a required field
	Spec *MeshSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the service mesh.
	//
	// Status is a required field
	Status *MeshStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s MeshData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *MeshData) SetMeshName(v string) *MeshData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *MeshData) SetMetadata(v *ResourceMetadata) *MeshData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *MeshData) SetSpec(v *MeshSpec) *MeshData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MeshData) SetStatus(v *MeshStatus) *MeshData {
	s.Status = v
	return s
}

// An object representing a service mesh returned by a list operation.
type MeshRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) of the service mesh.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MeshRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MeshRef) SetArn(v string) *MeshRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *MeshRef) SetMeshName(v string) *MeshRef {
	s.MeshName = &v
	return s
}

// An object representing the specification of a service mesh.
type MeshSpec struct {
	_ struct{} `type:"structure"`

	// The egress filter rules for the service mesh.
	EgressFilter *EgressFilter `locationName:"egressFilter" type:"structure"`
}

// String returns the string representation
func (s MeshSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeshSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeshSpec"}
	if s.EgressFilter != nil {
		if err := s.EgressFilter.Validate(); err != nil {
			invalidParams.AddNested("EgressFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEgressFilter sets the EgressFilter field's value.
func (s *MeshSpec) SetEgressFilter(v *EgressFilter) *MeshSpec {
	s.EgressFilter = v
	return s
}

// An object representing the status of a service mesh.
type MeshStatus struct {
	_ struct{} `type:"structure"`

	// The current mesh status.
	Status *string `locationName:"status" type:"string" enum:"MeshStatusCode"`
}

// String returns the string representation
func (s MeshStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeshStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *MeshStatus) SetStatus(v string) *MeshStatus {
	s.Status = &v
	return s
}

// An object representing a virtual node or virtual router listener port mapping.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port used for the port mapping.
	//
	// Port is a required field
	Port *int64 `locationName:"port" min:"1" type:"integer" required:"true"`

	// The protocol used for the port mapping.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"PortProtocol"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortMapping"}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPort sets the Port field's value.
func (s *PortMapping) SetPort(v int64) *PortMapping {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortMapping) SetProtocol(v string) *PortMapping {
	s.Protocol = &v
	return s
}

// An object representing metadata for a resource.
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// The unique identifier for the resource.
	//
	// Uid is a required field
	Uid *string `locationName:"uid" type:"string" required:"true"`

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`
}

// String returns the string representation
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceMetadata) SetArn(v string) *ResourceMetadata {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ResourceMetadata) SetCreatedAt(v time.Time) *ResourceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ResourceMetadata) SetLastUpdatedAt(v time.Time) *ResourceMetadata {
	s.LastUpdatedAt = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *ResourceMetadata) SetUid(v string) *ResourceMetadata {
	s.Uid = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceMetadata) SetVersion(v int64) *ResourceMetadata {
	s.Version = &v
	return s
}

// An object representing a route returned by a describe operation.
type RouteData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the route.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The specifications of the route.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The status of the route.
	//
	// Status is a required field
	Status *RouteStatus `locationName:"status" type:"structure" required:"true"`

	// The virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *RouteData) SetMeshName(v string) *RouteData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *RouteData) SetMetadata(v *ResourceMetadata) *RouteData {
	s.Metadata = v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *RouteData) SetRouteName(v string) *RouteData {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *RouteData) SetSpec(v *RouteSpec) *RouteData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RouteData) SetStatus(v *RouteStatus) *RouteData {
	s.Status = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *RouteData) SetVirtualRouterName(v string) *RouteData {
	s.VirtualRouterName = &v
	return s
}

// An object representing a route returned by a list operation.
type RouteRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the route.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route.
	//
	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// The virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RouteRef) SetArn(v string) *RouteRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *RouteRef) SetMeshName(v string) *RouteRef {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *RouteRef) SetRouteName(v string) *RouteRef {
	s.RouteName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *RouteRef) SetVirtualRouterName(v string) *RouteRef {
	s.VirtualRouterName = &v
	return s
}

// An object representing the specification of a route.
type RouteSpec struct {
	_ struct{} `type:"structure"`

	// The HTTP routing information for the route.
	HttpRoute *HttpRoute `locationName:"httpRoute" type:"structure"`

	// The TCP routing information for the route.
	TcpRoute *TcpRoute `locationName:"tcpRoute" type:"structure"`
}

// String returns the string representation
func (s RouteSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RouteSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RouteSpec"}
	if s.HttpRoute != nil {
		if err := s.HttpRoute.Validate(); err != nil {
			invalidParams.AddNested("HttpRoute", err.(request.ErrInvalidParams))
		}
	}
	if s.TcpRoute != nil {
		if err := s.TcpRoute.Validate(); err != nil {
			invalidParams.AddNested("TcpRoute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpRoute sets the HttpRoute field's value.
func (s *RouteSpec) SetHttpRoute(v *HttpRoute) *RouteSpec {
	s.HttpRoute = v
	return s
}

// SetTcpRoute sets the TcpRoute field's value.
func (s *RouteSpec) SetTcpRoute(v *TcpRoute) *RouteSpec {
	s.TcpRoute = v
	return s
}

// An object representing the current status of a route.
type RouteStatus struct {
	_ struct{} `type:"structure"`

	// The current status for the route.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RouteStatusCode"`
}

// String returns the string representation
func (s RouteStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *RouteStatus) SetStatus(v string) *RouteStatus {
	s.Status = &v
	return s
}

// An object representing the service discovery information for a virtual node.
type ServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Specifies any AWS Cloud Map information for the virtual node.
	AwsCloudMap *AwsCloudMapServiceDiscovery `locationName:"awsCloudMap" type:"structure"`

	// Specifies the DNS information for the virtual node.
	Dns *DnsServiceDiscovery `locationName:"dns" type:"structure"`
}

// String returns the string representation
func (s ServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceDiscovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceDiscovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceDiscovery"}
	if s.AwsCloudMap != nil {
		if err := s.AwsCloudMap.Validate(); err != nil {
			invalidParams.AddNested("AwsCloudMap", err.(request.ErrInvalidParams))
		}
	}
	if s.Dns != nil {
		if err := s.Dns.Validate(); err != nil {
			invalidParams.AddNested("Dns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsCloudMap sets the AwsCloudMap field's value.
func (s *ServiceDiscovery) SetAwsCloudMap(v *AwsCloudMapServiceDiscovery) *ServiceDiscovery {
	s.AwsCloudMap = v
	return s
}

// SetDns sets the Dns field's value.
func (s *ServiceDiscovery) SetDns(v *DnsServiceDiscovery) *ServiceDiscovery {
	s.Dns = v
	return s
}

// Optional metadata that you apply to a resource to assist with categorization
// and organization. Each tag consists of a key and an optional value, both
// of which you define. Tag keys can have a maximum character length of 128
// characters, and tag values can have a maximum length of 256 characters.
type TagRef struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagRef) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagRef) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagRef"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagRef) SetKey(v string) *TagRef {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagRef) SetValue(v string) *TagRef {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to add tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs. Tag
	// keys can have a maximum character length of 128 characters, and tag values
	// can have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags []*TagRef `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*TagRef) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An object representing the TCP routing specification for a route.
type TcpRoute struct {
	_ struct{} `type:"structure"`

	// The action to take if a match is determined.
	//
	// Action is a required field
	Action *TcpRouteAction `locationName:"action" type:"structure" required:"true"`
}

// String returns the string representation
func (s TcpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TcpRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TcpRoute"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *TcpRoute) SetAction(v *TcpRouteAction) *TcpRoute {
	s.Action = v
	return s
}

// An object representing the traffic distribution requirements for matched
// TCP requests.
type TcpRouteAction struct {
	_ struct{} `type:"structure"`

	// The targets that traffic is routed to when a request matches the route. You
	// can specify one or more targets and their relative weights to distribute
	// traffic with.
	//
	// WeightedTargets is a required field
	WeightedTargets []*WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TcpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TcpRouteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRouteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TcpRouteAction"}
	if s.WeightedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeightedTargets sets the WeightedTargets field's value.
func (s *TcpRouteAction) SetWeightedTargets(v []*WeightedTarget) *TcpRouteAction {
	s.WeightedTargets = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to delete tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateMeshInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh to update.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The service mesh specification to apply.
	Spec *MeshSpec `locationName:"spec" type:"structure"`
}

// String returns the string representation
func (s UpdateMeshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMeshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMeshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMeshInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateMeshInput) SetClientToken(v string) *UpdateMeshInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateMeshInput) SetMeshName(v string) *UpdateMeshInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateMeshInput) SetSpec(v *MeshSpec) *UpdateMeshInput {
	s.Spec = v
	return s
}

type UpdateMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// An object representing a service mesh returned by a describe operation.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMeshOutput) GoString() string {
	return s.String()
}

// SetMesh sets the Mesh field's value.
func (s *UpdateMeshOutput) SetMesh(v *MeshData) *UpdateMeshOutput {
	s.Mesh = v
	return s
}

type UpdateRouteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the route resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the route to update.
	//
	// RouteName is a required field
	RouteName *string `location:"uri" locationName:"routeName" min:"1" type:"string" required:"true"`

	// The new route specification to apply. This overwrites the existing data.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router that the route is associated with.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRouteInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.RouteName == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteName"))
	}
	if s.RouteName != nil && len(*s.RouteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateRouteInput) SetClientToken(v string) *UpdateRouteInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateRouteInput) SetMeshName(v string) *UpdateRouteInput {
	s.MeshName = &v
	return s
}

// SetRouteName sets the RouteName field's value.
func (s *UpdateRouteInput) SetRouteName(v string) *UpdateRouteInput {
	s.RouteName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateRouteInput) SetSpec(v *RouteSpec) *UpdateRouteInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *UpdateRouteInput) SetVirtualRouterName(v string) *UpdateRouteInput {
	s.VirtualRouterName = &v
	return s
}

type UpdateRouteOutput struct {
	_ struct{} `type:"structure" payload:"Route"`

	// A full description of the route that was updated.
	//
	// Route is a required field
	Route *RouteData `locationName:"route" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteOutput) GoString() string {
	return s.String()
}

// SetRoute sets the Route field's value.
func (s *UpdateRouteOutput) SetRoute(v *RouteData) *UpdateRouteOutput {
	s.Route = v
	return s
}

type UpdateVirtualNodeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The new virtual node specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual node to update.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `location:"uri" locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualNodeInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualNodeInput) SetClientToken(v string) *UpdateVirtualNodeInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualNodeInput) SetMeshName(v string) *UpdateVirtualNodeInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualNodeInput) SetSpec(v *VirtualNodeSpec) *UpdateVirtualNodeInput {
	s.Spec = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *UpdateVirtualNodeInput) SetVirtualNodeName(v string) *UpdateVirtualNodeInput {
	s.VirtualNodeName = &v
	return s
}

type UpdateVirtualNodeOutput struct {
	_ struct{} `type:"structure" payload:"VirtualNode"`

	// A full description of the virtual node that was updated.
	//
	// VirtualNode is a required field
	VirtualNode *VirtualNodeData `locationName:"virtualNode" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualNodeOutput) GoString() string {
	return s.String()
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *UpdateVirtualNodeOutput) SetVirtualNode(v *VirtualNodeData) *UpdateVirtualNodeOutput {
	s.VirtualNode = v
	return s
}

type UpdateVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The new virtual router specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual router to update.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualRouterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualRouterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualRouterInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualRouterInput) SetClientToken(v string) *UpdateVirtualRouterInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualRouterInput) SetMeshName(v string) *UpdateVirtualRouterInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualRouterInput) SetSpec(v *VirtualRouterSpec) *UpdateVirtualRouterInput {
	s.Spec = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *UpdateVirtualRouterInput) SetVirtualRouterName(v string) *UpdateVirtualRouterInput {
	s.VirtualRouterName = &v
	return s
}

type UpdateVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// A full description of the virtual router that was updated.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualRouterOutput) GoString() string {
	return s.String()
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *UpdateVirtualRouterOutput) SetVirtualRouter(v *VirtualRouterData) *UpdateVirtualRouterOutput {
	s.VirtualRouter = v
	return s
}

type UpdateVirtualServiceInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// The new virtual service specification to apply. This overwrites the existing
	// data.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// The name of the virtual service to update.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `location:"uri" locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVirtualServiceInput"}
	if s.MeshName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeshName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}
	if s.VirtualServiceName != nil && len(*s.VirtualServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualServiceName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVirtualServiceInput) SetClientToken(v string) *UpdateVirtualServiceInput {
	s.ClientToken = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *UpdateVirtualServiceInput) SetMeshName(v string) *UpdateVirtualServiceInput {
	s.MeshName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateVirtualServiceInput) SetSpec(v *VirtualServiceSpec) *UpdateVirtualServiceInput {
	s.Spec = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *UpdateVirtualServiceInput) SetVirtualServiceName(v string) *UpdateVirtualServiceInput {
	s.VirtualServiceName = &v
	return s
}

type UpdateVirtualServiceOutput struct {
	_ struct{} `type:"structure" payload:"VirtualService"`

	// A full description of the virtual service that was updated.
	//
	// VirtualService is a required field
	VirtualService *VirtualServiceData `locationName:"virtualService" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVirtualServiceOutput) GoString() string {
	return s.String()
}

// SetVirtualService sets the VirtualService field's value.
func (s *UpdateVirtualServiceOutput) SetVirtualService(v *VirtualServiceData) *UpdateVirtualServiceOutput {
	s.VirtualService = v
	return s
}

// An object representing a virtual node returned by a describe operation.
type VirtualNodeData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual node.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual node.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status for the virtual node.
	//
	// Status is a required field
	Status *VirtualNodeStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualNodeData) SetMeshName(v string) *VirtualNodeData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualNodeData) SetMetadata(v *ResourceMetadata) *VirtualNodeData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualNodeData) SetSpec(v *VirtualNodeSpec) *VirtualNodeData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualNodeData) SetStatus(v *VirtualNodeStatus) *VirtualNodeData {
	s.Status = v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeData) SetVirtualNodeName(v string) *VirtualNodeData {
	s.VirtualNodeName = &v
	return s
}

// An object representing a virtual node returned by a list operation.
type VirtualNodeRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual node.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the virtual node resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual node.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualNodeRef) SetArn(v string) *VirtualNodeRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualNodeRef) SetMeshName(v string) *VirtualNodeRef {
	s.MeshName = &v
	return s
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeRef) SetVirtualNodeName(v string) *VirtualNodeRef {
	s.VirtualNodeName = &v
	return s
}

// An object representing a virtual node service provider.
type VirtualNodeServiceProvider struct {
	_ struct{} `type:"structure"`

	// The name of the virtual node that is acting as a service provider.
	//
	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeServiceProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeServiceProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeServiceProvider"}
	if s.VirtualNodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualNodeName sets the VirtualNodeName field's value.
func (s *VirtualNodeServiceProvider) SetVirtualNodeName(v string) *VirtualNodeServiceProvider {
	s.VirtualNodeName = &v
	return s
}

// An object representing the specification of a virtual node.
type VirtualNodeSpec struct {
	_ struct{} `type:"structure"`

	// The backends that the virtual node is expected to send outbound traffic to.
	Backends []*Backend `locationName:"backends" type:"list"`

	// The listeners that the virtual node is expected to receive inbound traffic
	// from. Currently only one listener is supported per virtual node.
	Listeners []*Listener `locationName:"listeners" type:"list"`

	// The inbound and outbound access logging information for the virtual node.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The service discovery information for the virtual node. If your virtual node
	// does not expect ingress traffic, you can omit this parameter.
	ServiceDiscovery *ServiceDiscovery `locationName:"serviceDiscovery" type:"structure"`
}

// String returns the string representation
func (s VirtualNodeSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualNodeSpec"}
	if s.Backends != nil {
		for i, v := range s.Backends {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Backends", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceDiscovery != nil {
		if err := s.ServiceDiscovery.Validate(); err != nil {
			invalidParams.AddNested("ServiceDiscovery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackends sets the Backends field's value.
func (s *VirtualNodeSpec) SetBackends(v []*Backend) *VirtualNodeSpec {
	s.Backends = v
	return s
}

// SetListeners sets the Listeners field's value.
func (s *VirtualNodeSpec) SetListeners(v []*Listener) *VirtualNodeSpec {
	s.Listeners = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *VirtualNodeSpec) SetLogging(v *Logging) *VirtualNodeSpec {
	s.Logging = v
	return s
}

// SetServiceDiscovery sets the ServiceDiscovery field's value.
func (s *VirtualNodeSpec) SetServiceDiscovery(v *ServiceDiscovery) *VirtualNodeSpec {
	s.ServiceDiscovery = v
	return s
}

// An object representing the current status of the virtual node.
type VirtualNodeStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual node.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualNodeStatusCode"`
}

// String returns the string representation
func (s VirtualNodeStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualNodeStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualNodeStatus) SetStatus(v string) *VirtualNodeStatus {
	s.Status = &v
	return s
}

// An object representing a virtual router returned by a describe operation.
type VirtualRouterData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The associated metadata for the virtual router.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual router.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual router.
	//
	// Status is a required field
	Status *VirtualRouterStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualRouterData) SetMeshName(v string) *VirtualRouterData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualRouterData) SetMetadata(v *ResourceMetadata) *VirtualRouterData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualRouterData) SetSpec(v *VirtualRouterSpec) *VirtualRouterData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualRouterData) SetStatus(v *VirtualRouterStatus) *VirtualRouterData {
	s.Status = v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterData) SetVirtualRouterName(v string) *VirtualRouterData {
	s.VirtualRouterName = &v
	return s
}

// An object representing a virtual router listener.
type VirtualRouterListener struct {
	_ struct{} `type:"structure"`

	// An object representing a virtual node or virtual router listener port mapping.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation
func (s VirtualRouterListener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterListener) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterListener) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualRouterListener"}
	if s.PortMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("PortMapping"))
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortMapping sets the PortMapping field's value.
func (s *VirtualRouterListener) SetPortMapping(v *PortMapping) *VirtualRouterListener {
	s.PortMapping = v
	return s
}

// An object representing a virtual router returned by a list operation.
type VirtualRouterRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual router.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the virtual router resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual router.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualRouterRef) SetArn(v string) *VirtualRouterRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualRouterRef) SetMeshName(v string) *VirtualRouterRef {
	s.MeshName = &v
	return s
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterRef) SetVirtualRouterName(v string) *VirtualRouterRef {
	s.VirtualRouterName = &v
	return s
}

// An object representing a virtual node service provider.
type VirtualRouterServiceProvider struct {
	_ struct{} `type:"structure"`

	// The name of the virtual router that is acting as a service provider.
	//
	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterServiceProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterServiceProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualRouterServiceProvider"}
	if s.VirtualRouterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualRouterName sets the VirtualRouterName field's value.
func (s *VirtualRouterServiceProvider) SetVirtualRouterName(v string) *VirtualRouterServiceProvider {
	s.VirtualRouterName = &v
	return s
}

// An object representing the specification of a virtual router.
type VirtualRouterSpec struct {
	_ struct{} `type:"structure"`

	// The listeners that the virtual router is expected to receive inbound traffic
	// from. Currently only one listener is supported per virtual router.
	Listeners []*VirtualRouterListener `locationName:"listeners" min:"1" type:"list"`
}

// String returns the string representation
func (s VirtualRouterSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualRouterSpec"}
	if s.Listeners != nil && len(s.Listeners) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Listeners", 1))
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListeners sets the Listeners field's value.
func (s *VirtualRouterSpec) SetListeners(v []*VirtualRouterListener) *VirtualRouterSpec {
	s.Listeners = v
	return s
}

// An object representing the status of a virtual router.
type VirtualRouterStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual router.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualRouterStatusCode"`
}

// String returns the string representation
func (s VirtualRouterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualRouterStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualRouterStatus) SetStatus(v string) *VirtualRouterStatus {
	s.Status = &v
	return s
}

// An object representing a virtual service backend for a virtual node.
type VirtualServiceBackend struct {
	_ struct{} `type:"structure"`

	// The name of the virtual service that is acting as a virtual node backend.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceBackend) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualServiceBackend) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceBackend) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualServiceBackend"}
	if s.VirtualServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *VirtualServiceBackend) SetVirtualServiceName(v string) *VirtualServiceBackend {
	s.VirtualServiceName = &v
	return s
}

// An object representing a virtual service returned by a describe operation.
type VirtualServiceData struct {
	_ struct{} `type:"structure"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object representing metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// The specifications of the virtual service.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// The current status of the virtual service.
	//
	// Status is a required field
	Status *VirtualServiceStatus `locationName:"status" type:"structure" required:"true"`

	// The name of the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualServiceData) GoString() string {
	return s.String()
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualServiceData) SetMeshName(v string) *VirtualServiceData {
	s.MeshName = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *VirtualServiceData) SetMetadata(v *ResourceMetadata) *VirtualServiceData {
	s.Metadata = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *VirtualServiceData) SetSpec(v *VirtualServiceSpec) *VirtualServiceData {
	s.Spec = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VirtualServiceData) SetStatus(v *VirtualServiceStatus) *VirtualServiceData {
	s.Status = v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *VirtualServiceData) SetVirtualServiceName(v string) *VirtualServiceData {
	s.VirtualServiceName = &v
	return s
}

// An object representing the provider for a virtual service.
type VirtualServiceProvider struct {
	_ struct{} `type:"structure"`

	// The virtual node associated with a virtual service.
	VirtualNode *VirtualNodeServiceProvider `locationName:"virtualNode" type:"structure"`

	// The virtual router associated with a virtual service.
	VirtualRouter *VirtualRouterServiceProvider `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s VirtualServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualServiceProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualServiceProvider"}
	if s.VirtualNode != nil {
		if err := s.VirtualNode.Validate(); err != nil {
			invalidParams.AddNested("VirtualNode", err.(request.ErrInvalidParams))
		}
	}
	if s.VirtualRouter != nil {
		if err := s.VirtualRouter.Validate(); err != nil {
			invalidParams.AddNested("VirtualRouter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *VirtualServiceProvider) SetVirtualNode(v *VirtualNodeServiceProvider) *VirtualServiceProvider {
	s.VirtualNode = v
	return s
}

// SetVirtualRouter sets the VirtualRouter field's value.
func (s *VirtualServiceProvider) SetVirtualRouter(v *VirtualRouterServiceProvider) *VirtualServiceProvider {
	s.VirtualRouter = v
	return s
}

// An object representing a virtual service returned by a list operation.
type VirtualServiceRef struct {
	_ struct{} `type:"structure"`

	// The full Amazon Resource Name (ARN) for the virtual service.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the service mesh that the virtual service resides in.
	//
	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// The name of the virtual service.
	//
	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualServiceRef) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualServiceRef) SetArn(v string) *VirtualServiceRef {
	s.Arn = &v
	return s
}

// SetMeshName sets the MeshName field's value.
func (s *VirtualServiceRef) SetMeshName(v string) *VirtualServiceRef {
	s.MeshName = &v
	return s
}

// SetVirtualServiceName sets the VirtualServiceName field's value.
func (s *VirtualServiceRef) SetVirtualServiceName(v string) *VirtualServiceRef {
	s.VirtualServiceName = &v
	return s
}

// An object representing the specification of a virtual service.
type VirtualServiceSpec struct {
	_ struct{} `type:"structure"`

	// The App Mesh object that is acting as the provider for a virtual service.
	// You can specify a single virtual node or virtual router.
	Provider *VirtualServiceProvider `locationName:"provider" type:"structure"`
}

// String returns the string representation
func (s VirtualServiceSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualServiceSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualServiceSpec"}
	if s.Provider != nil {
		if err := s.Provider.Validate(); err != nil {
			invalidParams.AddNested("Provider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvider sets the Provider field's value.
func (s *VirtualServiceSpec) SetProvider(v *VirtualServiceProvider) *VirtualServiceSpec {
	s.Provider = v
	return s
}

// An object representing the status of a virtual service.
type VirtualServiceStatus struct {
	_ struct{} `type:"structure"`

	// The current status of the virtual service.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"VirtualServiceStatusCode"`
}

// String returns the string representation
func (s VirtualServiceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualServiceStatus) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VirtualServiceStatus) SetStatus(v string) *VirtualServiceStatus {
	s.Status = &v
	return s
}

// An object representing a target and its relative weight. Traffic is distributed
// across targets according to their relative weight. For example, a weighted
// target with a relative weight of 50 receives five times as much traffic as
// one with a relative weight of 10.
type WeightedTarget struct {
	_ struct{} `type:"structure"`

	// The virtual node to associate with the weighted target.
	//
	// VirtualNode is a required field
	VirtualNode *string `locationName:"virtualNode" min:"1" type:"string" required:"true"`

	// The relative weight of the weighted target.
	//
	// Weight is a required field
	Weight *int64 `locationName:"weight" type:"integer" required:"true"`
}

// String returns the string representation
func (s WeightedTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeightedTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeightedTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeightedTarget"}
	if s.VirtualNode == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualNode"))
	}
	if s.VirtualNode != nil && len(*s.VirtualNode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualNode", 1))
	}
	if s.Weight == nil {
		invalidParams.Add(request.NewErrParamRequired("Weight"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualNode sets the VirtualNode field's value.
func (s *WeightedTarget) SetVirtualNode(v string) *WeightedTarget {
	s.VirtualNode = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *WeightedTarget) SetWeight(v int64) *WeightedTarget {
	s.Weight = &v
	return s
}

const (
	// EgressFilterTypeAllowAll is a EgressFilterType enum value
	EgressFilterTypeAllowAll = "ALLOW_ALL"

	// EgressFilterTypeDropAll is a EgressFilterType enum value
	EgressFilterTypeDropAll = "DROP_ALL"
)

const (
	// MeshStatusCodeActive is a MeshStatusCode enum value
	MeshStatusCodeActive = "ACTIVE"

	// MeshStatusCodeDeleted is a MeshStatusCode enum value
	MeshStatusCodeDeleted = "DELETED"

	// MeshStatusCodeInactive is a MeshStatusCode enum value
	MeshStatusCodeInactive = "INACTIVE"
)

const (
	// PortProtocolHttp is a PortProtocol enum value
	PortProtocolHttp = "http"

	// PortProtocolTcp is a PortProtocol enum value
	PortProtocolTcp = "tcp"
)

const (
	// RouteStatusCodeActive is a RouteStatusCode enum value
	RouteStatusCodeActive = "ACTIVE"

	// RouteStatusCodeDeleted is a RouteStatusCode enum value
	RouteStatusCodeDeleted = "DELETED"

	// RouteStatusCodeInactive is a RouteStatusCode enum value
	RouteStatusCodeInactive = "INACTIVE"
)

const (
	// VirtualNodeStatusCodeActive is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeActive = "ACTIVE"

	// VirtualNodeStatusCodeDeleted is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeDeleted = "DELETED"

	// VirtualNodeStatusCodeInactive is a VirtualNodeStatusCode enum value
	VirtualNodeStatusCodeInactive = "INACTIVE"
)

const (
	// VirtualRouterStatusCodeActive is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeActive = "ACTIVE"

	// VirtualRouterStatusCodeDeleted is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeDeleted = "DELETED"

	// VirtualRouterStatusCodeInactive is a VirtualRouterStatusCode enum value
	VirtualRouterStatusCodeInactive = "INACTIVE"
)

const (
	// VirtualServiceStatusCodeActive is a VirtualServiceStatusCode enum value
	VirtualServiceStatusCodeActive = "ACTIVE"

	// VirtualServiceStatusCodeDeleted is a VirtualServiceStatusCode enum value
	VirtualServiceStatusCodeDeleted = "DELETED"

	// VirtualServiceStatusCodeInactive is a VirtualServiceStatusCode enum value
	VirtualServiceStatusCodeInactive = "INACTIVE"
)
