// Code generated by smithy-go-codegen DO NOT EDIT.

package voiceid

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/voiceid/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified fraudster registration job.
func (c *Client) DescribeFraudsterRegistrationJob(ctx context.Context, params *DescribeFraudsterRegistrationJobInput, optFns ...func(*Options)) (*DescribeFraudsterRegistrationJobOutput, error) {
	if params == nil {
		params = &DescribeFraudsterRegistrationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFraudsterRegistrationJob", params, optFns, c.addOperationDescribeFraudsterRegistrationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFraudsterRegistrationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFraudsterRegistrationJobInput struct {

	// The identifier of the domain that contains the fraudster registration job.
	//
	// This member is required.
	DomainId *string

	// The identifier of the fraudster registration job you are describing.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

type DescribeFraudsterRegistrationJobOutput struct {

	// Contains details about the specified fraudster registration job.
	Job *types.FraudsterRegistrationJob

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFraudsterRegistrationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeFraudsterRegistrationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeFraudsterRegistrationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeFraudsterRegistrationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFraudsterRegistrationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFraudsterRegistrationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "voiceid",
		OperationName: "DescribeFraudsterRegistrationJob",
	}
}
