// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The StartWorkflowExecution API action was called without the required parameters
// set. Some workflow execution parameters, such as the decision taskList, must be
// set to start the execution. However, these parameters might have been set as
// defaults when the workflow type was registered. In this case, you can omit these
// parameters from the StartWorkflowExecution call and Amazon SWF uses the values
// defined in the workflow type. If these parameters aren't set and no default
// parameters were defined in the workflow type, this error is displayed.
type DefaultUndefinedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DefaultUndefinedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DefaultUndefinedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DefaultUndefinedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DefaultUndefinedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DefaultUndefinedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned if the domain already exists. You may get this fault if you are
// registering a domain that is either already registered or deprecated, or if you
// undeprecate a domain that is currently registered.
type DomainAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DomainAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DomainAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DomainAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DomainAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DomainAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when the specified domain has been deprecated.
type DomainDeprecatedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DomainDeprecatedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DomainDeprecatedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DomainDeprecatedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DomainDeprecatedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DomainDeprecatedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned by any operation if a system imposed limitation has been reached. To
// address this fault you should either clean up unused resources or increase the
// limit by contacting AWS.
type LimitExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when the caller doesn't have sufficient permissions to invoke the
// action.
type OperationNotPermittedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationNotPermittedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotPermittedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotPermittedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationNotPermittedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationNotPermittedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You've exceeded the number of tags allowed for a domain.
type TooManyTagsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned if the type already exists in the specified domain. You may get this
// fault if you are registering a type that is either already registered or
// deprecated, or if you undeprecate a type that is currently registered.
type TypeAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TypeAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TypeAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TypeAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TypeAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *TypeAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when the specified activity or workflow type was already deprecated.
type TypeDeprecatedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TypeDeprecatedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TypeDeprecatedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TypeDeprecatedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TypeDeprecatedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *TypeDeprecatedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when the named resource cannot be found with in the scope of this
// operation (region or domain). This could happen if the named resource was never
// created or is no longer available for this operation.
type UnknownResourceFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnknownResourceFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnknownResourceFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnknownResourceFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnknownResourceFault"
	}
	return *e.ErrorCodeOverride
}
func (e *UnknownResourceFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned by StartWorkflowExecution when an open execution with the same
// workflowId is already running in the specified domain.
type WorkflowExecutionAlreadyStartedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *WorkflowExecutionAlreadyStartedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WorkflowExecutionAlreadyStartedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WorkflowExecutionAlreadyStartedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "WorkflowExecutionAlreadyStartedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *WorkflowExecutionAlreadyStartedFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
