// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// This structure specifies the VPC subnets and security groups for the task, and
// whether a public IP address is to be used. This structure is relevant only for
// ECS tasks that use the awsvpc network mode.
type AwsVpcConfiguration struct {

	// Specifies the subnets associated with the task. These subnets must all be in the
	// same VPC. You can specify as many as 16 subnets.
	//
	// This member is required.
	Subnets []string

	// Specifies whether the task's elastic network interface receives a public IP
	// address. You can specify ENABLED only when LaunchType in EcsParameters is set to
	// FARGATE.
	AssignPublicIp AssignPublicIp

	// Specifies the security groups associated with the task. These security groups
	// must all be in the same VPC. You can specify as many as five security groups. If
	// you do not specify a security group, the default security group for the VPC is
	// used.
	SecurityGroups []string

	noSmithyDocumentSerde
}

// The details of a capacity provider strategy.
type CapacityProviderStrategyItem struct {

	// The short name of the capacity provider.
	//
	// This member is required.
	CapacityProvider *string

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined. If no value is specified, the default value of 0 is
	// used.
	Base int32

	// The weight value designates the relative percentage of the total number of tasks
	// launched that should use the specified capacity provider. The weight value is
	// taken into consideration after the base value, if defined, is satisfied.
	Weight int32

	noSmithyDocumentSerde
}

// An object that contains information about an Amazon SQS queue that EventBridge
// Scheduler uses as a dead-letter queue for your schedule. If specified,
// EventBridge Scheduler delivers failed events that could not be successfully
// delivered to a target to the queue.
type DeadLetterConfig struct {

	// The Amazon Resource Name (ARN) of the SQS queue specified as the destination for
	// the dead-letter queue.
	Arn *string

	noSmithyDocumentSerde
}

// The templated target type for the Amazon ECS RunTask
// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API
// operation.
type EcsParameters struct {

	// The Amazon Resource Name (ARN) of the task definition to use if the event target
	// is an Amazon ECS task.
	//
	// This member is required.
	TaskDefinitionArn *string

	// The capacity provider strategy to use for the task.
	CapacityProviderStrategy []CapacityProviderStrategyItem

	// Specifies whether to enable Amazon ECS managed tags for the task. For more
	// information, see Tagging Your Amazon ECS Resources
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon ECS Developer Guide.
	EnableECSManagedTags *bool

	// Whether or not to enable the execute command functionality for the containers in
	// this task. If true, this enables execute command functionality on all containers
	// in the task.
	EnableExecuteCommand *bool

	// Specifies an ECS task group for the task. The maximum length is 255 characters.
	Group *string

	// Specifies the launch type on which your task is running. The launch type that
	// you specify here must match one of the launch type (compatibilities) of the
	// target task. The FARGATE value is supported only in the Regions where Fargate
	// with Amazon ECS is supported. For more information, see AWS Fargate on Amazon
	// ECS
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html)
	// in the Amazon ECS Developer Guide.
	LaunchType LaunchType

	// This structure specifies the network configuration for an ECS task.
	NetworkConfiguration *NetworkConfiguration

	// An array of placement constraint objects to use for the task. You can specify up
	// to 10 constraints per task (including constraints in the task definition and
	// those specified at runtime).
	PlacementConstraints []PlacementConstraint

	// The task placement strategy for a task or service.
	PlacementStrategy []PlacementStrategy

	// Specifies the platform version for the task. Specify only the numeric portion of
	// the platform version, such as 1.1.0.
	PlatformVersion *string

	// Specifies whether to propagate the tags from the task definition to the task. If
	// no value is specified, the tags are not propagated. Tags can only be propagated
	// to the task during task creation. To add tags to a task after task creation, use
	// Amazon ECS's TagResource
	// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html)
	// API action.
	PropagateTags PropagateTags

	// The reference ID to use for the task.
	ReferenceId *string

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define. For more information, see RunTask
	// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in
	// the Amazon ECS API Reference.
	Tags []map[string]string

	// The number of tasks to create based on TaskDefinition. The default is 1.
	TaskCount *int32

	noSmithyDocumentSerde
}

// The templated target type for the EventBridge PutEvents
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html)
// API operation.
type EventBridgeParameters struct {

	// A free-form string, with a maximum of 128 characters, used to decide what fields
	// to expect in the event detail.
	//
	// This member is required.
	DetailType *string

	// The source of the event.
	//
	// This member is required.
	Source *string

	noSmithyDocumentSerde
}

// Allows you to configure a time window during which EventBridge Scheduler invokes
// the schedule.
type FlexibleTimeWindow struct {

	// Determines whether the schedule is invoked within a flexible time window.
	//
	// This member is required.
	Mode FlexibleTimeWindowMode

	// The maximum time window during which a schedule can be invoked.
	MaximumWindowInMinutes *int32

	noSmithyDocumentSerde
}

// The templated target type for the Amazon Kinesis PutRecord API operation.
type KinesisParameters struct {

	// Specifies the shard to which EventBridge Scheduler sends the event. For more
	// information, see Amazon Kinesis Data Streams terminology and concepts
	// (https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html) in the Amazon
	// Kinesis Streams Developer Guide.
	//
	// This member is required.
	PartitionKey *string

	noSmithyDocumentSerde
}

// Specifies the network configuration for an ECS task.
type NetworkConfiguration struct {

	// Specifies the Amazon VPC subnets and security groups for the task, and whether a
	// public IP address is to be used. This structure is relevant only for ECS tasks
	// that use the awsvpc network mode.
	AwsvpcConfiguration *AwsVpcConfiguration

	noSmithyDocumentSerde
}

// An object representing a constraint on task placement.
type PlacementConstraint struct {

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance. For more
	// information, see Cluster query language
	// (https://docs.aws.amazon.com/latest/developerguide/cluster-query-language.html)
	// in the Amazon ECS Developer Guide.
	Expression *string

	// The type of constraint. Use distinctInstance to ensure that each task in a
	// particular group is running on a different container instance. Use memberOf to
	// restrict the selection to a group of valid candidates.
	Type PlacementConstraintType

	noSmithyDocumentSerde
}

// The task placement strategy for a task or service.
type PlacementStrategy struct {

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or instanceId, which has the same
	// effect), or any platform or custom attribute that is applied to a container
	// instance, such as attribute:ecs.availability-zone. For the binpack placement
	// strategy, valid values are cpu and memory. For the random placement strategy,
	// this field is not used.
	Field *string

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least amount
	// of remaining memory (but still enough to run the task).
	Type PlacementStrategyType

	noSmithyDocumentSerde
}

// A RetryPolicy object that includes information about the retry policy settings,
// including the maximum age of an event, and the maximum number of times
// EventBridge Scheduler will try to deliver the event to a target.
type RetryPolicy struct {

	// The maximum amount of time, in seconds, to continue to make retry attempts.
	MaximumEventAgeInSeconds *int32

	// The maximum number of retry attempts to make before the request fails. Retry
	// attempts with exponential backoff continue until either the maximum number of
	// attempts is made or until the duration of the MaximumEventAgeInSeconds is
	// reached.
	MaximumRetryAttempts *int32

	noSmithyDocumentSerde
}

// The name and value pair of a parameter to use to start execution of a SageMaker
// Model Building Pipeline.
type SageMakerPipelineParameter struct {

	// Name of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// This member is required.
	Name *string

	// Value of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The templated target type for the Amazon SageMaker StartPipelineExecution
// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html)
// API operation.
type SageMakerPipelineParameters struct {

	// List of parameter names and values to use when executing the SageMaker Model
	// Building Pipeline.
	PipelineParameterList []SageMakerPipelineParameter

	noSmithyDocumentSerde
}

// The details of a schedule group.
type ScheduleGroupSummary struct {

	// The Amazon Resource Name (ARN) of the schedule group.
	Arn *string

	// The time at which the schedule group was created.
	CreationDate *time.Time

	// The time at which the schedule group was last modified.
	LastModificationDate *time.Time

	// The name of the schedule group.
	Name *string

	// Specifies the state of the schedule group.
	State ScheduleGroupState

	noSmithyDocumentSerde
}

// The details of a schedule.
type ScheduleSummary struct {

	// The Amazon Resource Name (ARN) of the schedule.
	Arn *string

	// The time at which the schedule was created.
	CreationDate *time.Time

	// The name of the schedule group associated with this schedule.
	GroupName *string

	// The time at which the schedule was last modified.
	LastModificationDate *time.Time

	// The name of the schedule.
	Name *string

	// Specifies whether the schedule is enabled or disabled.
	State ScheduleState

	// The schedule's target details.
	Target *TargetSummary

	noSmithyDocumentSerde
}

// The templated target type for the Amazon SQS SendMessage
// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html)
// API operation. Contains the message group ID to use when the target is a FIFO
// queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have
// content-based deduplication enabled. For more information, see Using the Amazon
// SQS message deduplication ID
// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html)
// in the Amazon SQS Developer Guide.
type SqsParameters struct {

	// The FIFO message group ID to use as the target.
	MessageGroupId *string

	noSmithyDocumentSerde
}

// Tag to associate with a schedule group.
type Tag struct {

	// The key for the tag.
	//
	// This member is required.
	Key *string

	// The value for the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The schedule's target. EventBridge Scheduler supports templated target that
// invoke common API operations, as well as universal targets that you can
// customize to invoke over 6,000 API operations across more than 270 services. You
// can only specify one templated or universal target for a schedule.
type Target struct {

	// The Amazon Resource Name (ARN) of the target.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will
	// use for this target when the schedule is invoked.
	//
	// This member is required.
	RoleArn *string

	// An object that contains information about an Amazon SQS queue that EventBridge
	// Scheduler uses as a dead-letter queue for your schedule. If specified,
	// EventBridge Scheduler delivers failed events that could not be successfully
	// delivered to a target to the queue.
	DeadLetterConfig *DeadLetterConfig

	// The templated target type for the Amazon ECS RunTask
	// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API
	// operation.
	EcsParameters *EcsParameters

	// The templated target type for the EventBridge PutEvents
	// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html)
	// API operation.
	EventBridgeParameters *EventBridgeParameters

	// The text, or well-formed JSON, passed to the target. If you are configuring a
	// templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input
	// must be a well-formed JSON. For all other target types, a JSON is not required.
	// If you do not specify anything for this field, EventBridge Scheduler delivers a
	// default notification to the target.
	Input *string

	// The templated target type for the Amazon Kinesis PutRecord API operation.
	KinesisParameters *KinesisParameters

	// A RetryPolicy object that includes information about the retry policy settings,
	// including the maximum age of an event, and the maximum number of times
	// EventBridge Scheduler will try to deliver the event to a target.
	RetryPolicy *RetryPolicy

	// The templated target type for the Amazon SageMaker StartPipelineExecution
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html)
	// API operation.
	SageMakerPipelineParameters *SageMakerPipelineParameters

	// The templated target type for the Amazon SQS SendMessage
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html)
	// API operation. Contains the message group ID to use when the target is a FIFO
	// queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have
	// content-based deduplication enabled. For more information, see Using the Amazon
	// SQS message deduplication ID
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html)
	// in the Amazon SQS Developer Guide.
	SqsParameters *SqsParameters

	noSmithyDocumentSerde
}

// The details of a target.
type TargetSummary struct {

	// The Amazon Resource Name (ARN) of the target.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
