// Code generated by smithy-go-codegen DO NOT EDIT.

package scheduler

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/scheduler/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the specified schedule group.
func (c *Client) GetScheduleGroup(ctx context.Context, params *GetScheduleGroupInput, optFns ...func(*Options)) (*GetScheduleGroupOutput, error) {
	if params == nil {
		params = &GetScheduleGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetScheduleGroup", params, optFns, c.addOperationGetScheduleGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetScheduleGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetScheduleGroupInput struct {

	// The name of the schedule group to retrieve.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type GetScheduleGroupOutput struct {

	// The Amazon Resource Name (ARN) of the schedule group.
	Arn *string

	// The time at which the schedule group was created.
	CreationDate *time.Time

	// The time at which the schedule group was last modified.
	LastModificationDate *time.Time

	// The name of the schedule group.
	Name *string

	// Specifies the state of the schedule group.
	State types.ScheduleGroupState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetScheduleGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetScheduleGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetScheduleGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetScheduleGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetScheduleGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetScheduleGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "scheduler",
		OperationName: "GetScheduleGroup",
	}
}
