// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows you run image query on a specific raster data collection to get a list of
// the satellite imagery matching the selected filters.
func (c *Client) SearchRasterDataCollection(ctx context.Context, params *SearchRasterDataCollectionInput, optFns ...func(*Options)) (*SearchRasterDataCollectionOutput, error) {
	if params == nil {
		params = &SearchRasterDataCollectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchRasterDataCollection", params, optFns, c.addOperationSearchRasterDataCollectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchRasterDataCollectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchRasterDataCollectionInput struct {

	// The Amazon Resource Name (ARN) of the raster data collection.
	//
	// This member is required.
	Arn *string

	// RasterDataCollectionQuery consisting of AreaOfInterest(AOI)
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html),
	// PropertyFilters
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html)
	// and TimeRangeFilterInput
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html)
	// used in SearchRasterDataCollection
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html).
	//
	// This member is required.
	RasterDataCollectionQuery *types.RasterDataCollectionQueryWithBandFilterInput

	// If the previous response was truncated, you receive this token. Use it in your
	// next request to receive the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type SearchRasterDataCollectionOutput struct {

	// Approximate number of results in the response.
	//
	// This member is required.
	ApproximateResultCount *int32

	// List of items matching the Raster DataCollectionQuery.
	Items []types.ItemSource

	// If the previous response was truncated, you receive this token. Use it in your
	// next request to receive the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchRasterDataCollectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchRasterDataCollection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchRasterDataCollection{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSearchRasterDataCollectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchRasterDataCollection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchRasterDataCollectionAPIClient is a client that implements the
// SearchRasterDataCollection operation.
type SearchRasterDataCollectionAPIClient interface {
	SearchRasterDataCollection(context.Context, *SearchRasterDataCollectionInput, ...func(*Options)) (*SearchRasterDataCollectionOutput, error)
}

var _ SearchRasterDataCollectionAPIClient = (*Client)(nil)

// SearchRasterDataCollectionPaginatorOptions is the paginator options for
// SearchRasterDataCollection
type SearchRasterDataCollectionPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchRasterDataCollectionPaginator is a paginator for
// SearchRasterDataCollection
type SearchRasterDataCollectionPaginator struct {
	options   SearchRasterDataCollectionPaginatorOptions
	client    SearchRasterDataCollectionAPIClient
	params    *SearchRasterDataCollectionInput
	nextToken *string
	firstPage bool
}

// NewSearchRasterDataCollectionPaginator returns a new
// SearchRasterDataCollectionPaginator
func NewSearchRasterDataCollectionPaginator(client SearchRasterDataCollectionAPIClient, params *SearchRasterDataCollectionInput, optFns ...func(*SearchRasterDataCollectionPaginatorOptions)) *SearchRasterDataCollectionPaginator {
	if params == nil {
		params = &SearchRasterDataCollectionInput{}
	}

	options := SearchRasterDataCollectionPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchRasterDataCollectionPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchRasterDataCollectionPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchRasterDataCollection page.
func (p *SearchRasterDataCollectionPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchRasterDataCollectionOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.SearchRasterDataCollection(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opSearchRasterDataCollection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker-geospatial",
		OperationName: "SearchRasterDataCollection",
	}
}
