// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the available DB engines.
func (c *Client) DescribeDBEngineVersions(ctx context.Context, params *DescribeDBEngineVersionsInput, optFns ...func(*Options)) (*DescribeDBEngineVersionsOutput, error) {
	if params == nil {
		params = &DescribeDBEngineVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDBEngineVersions", params, optFns, c.addOperationDescribeDBEngineVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDBEngineVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDBEngineVersionsInput struct {

	// The name of a specific DB parameter group family to return details for.
	// Constraints:
	//
	// * If supplied, must match an existing DBParameterGroupFamily.
	DBParameterGroupFamily *string

	// A value that indicates whether only the default version of the specified engine
	// or engine and major version combination is returned.
	DefaultOnly bool

	// The database engine to return. Valid Values:
	//
	// * aurora-mysql (for MySQL
	// 5.7-compatible and MySQL 8.0-compatible Aurora)
	//
	// * aurora-postgresql
	//
	// *
	// mariadb
	//
	// * mysql
	//
	// * oracle-ee
	//
	// * oracle-ee-cdb
	//
	// * oracle-se2
	//
	// *
	// oracle-se2-cdb
	//
	// * postgres
	//
	// * sqlserver-ee
	//
	// * sqlserver-se
	//
	// * sqlserver-ex
	//
	// *
	// sqlserver-web
	Engine *string

	// The database engine version to return. Example: 5.1.49
	EngineVersion *string

	// A filter that specifies one or more DB engine versions to describe. Supported
	// filters:
	//
	// * db-parameter-group-family - Accepts parameter groups family names.
	// The results list only includes information about the DB engine versions for
	// these parameter group families.
	//
	// * engine - Accepts engine names. The results
	// list only includes information about the DB engine versions for these
	// engines.
	//
	// * engine-mode - Accepts DB engine modes. The results list only
	// includes information about the DB engine versions for these engine modes. Valid
	// DB engine modes are the following:
	//
	// * global
	//
	// * multimaster
	//
	// * parallelquery
	//
	// *
	// provisioned
	//
	// * serverless
	//
	// * engine-version - Accepts engine versions. The
	// results list only includes information about the DB engine versions for these
	// engine versions.
	//
	// * status - Accepts engine version statuses. The results list
	// only includes information about the DB engine versions for these statuses. Valid
	// statuses are the following:
	//
	// * available
	//
	// * deprecated
	Filters []types.Filter

	// A value that indicates whether to include engine versions that aren't available
	// in the list. The default is to list only available engine versions.
	IncludeAll *bool

	// A value that indicates whether to list the supported character sets for each
	// engine version. If this parameter is enabled and the requested engine supports
	// the CharacterSetName parameter for CreateDBInstance, the response includes a
	// list of supported character sets for each engine version. For RDS Custom, the
	// default is not to list supported character sets. If you set
	// ListSupportedCharacterSets to true, RDS Custom returns no results.
	ListSupportedCharacterSets *bool

	// A value that indicates whether to list the supported time zones for each engine
	// version. If this parameter is enabled and the requested engine supports the
	// TimeZone parameter for CreateDBInstance, the response includes a list of
	// supported time zones for each engine version. For RDS Custom, the default is not
	// to list supported time zones. If you set ListSupportedTimezones to true, RDS
	// Custom returns no results.
	ListSupportedTimezones *bool

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to the
	// value specified by MaxRecords.
	Marker *string

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included in
	// the response so you can retrieve the remaining results. Default: 100
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int32

	noSmithyDocumentSerde
}

// Contains the result of a successful invocation of the DescribeDBEngineVersions
// action.
type DescribeDBEngineVersionsOutput struct {

	// A list of DBEngineVersion elements.
	DBEngineVersions []types.DBEngineVersion

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to the
	// value specified by MaxRecords.
	Marker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDBEngineVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeDBEngineVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeDBEngineVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeDBEngineVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDBEngineVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeDBEngineVersionsAPIClient is a client that implements the
// DescribeDBEngineVersions operation.
type DescribeDBEngineVersionsAPIClient interface {
	DescribeDBEngineVersions(context.Context, *DescribeDBEngineVersionsInput, ...func(*Options)) (*DescribeDBEngineVersionsOutput, error)
}

var _ DescribeDBEngineVersionsAPIClient = (*Client)(nil)

// DescribeDBEngineVersionsPaginatorOptions is the paginator options for
// DescribeDBEngineVersions
type DescribeDBEngineVersionsPaginatorOptions struct {
	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included in
	// the response so you can retrieve the remaining results. Default: 100
	// Constraints: Minimum 20, maximum 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeDBEngineVersionsPaginator is a paginator for DescribeDBEngineVersions
type DescribeDBEngineVersionsPaginator struct {
	options   DescribeDBEngineVersionsPaginatorOptions
	client    DescribeDBEngineVersionsAPIClient
	params    *DescribeDBEngineVersionsInput
	nextToken *string
	firstPage bool
}

// NewDescribeDBEngineVersionsPaginator returns a new
// DescribeDBEngineVersionsPaginator
func NewDescribeDBEngineVersionsPaginator(client DescribeDBEngineVersionsAPIClient, params *DescribeDBEngineVersionsInput, optFns ...func(*DescribeDBEngineVersionsPaginatorOptions)) *DescribeDBEngineVersionsPaginator {
	if params == nil {
		params = &DescribeDBEngineVersionsInput{}
	}

	options := DescribeDBEngineVersionsPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeDBEngineVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeDBEngineVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeDBEngineVersions page.
func (p *DescribeDBEngineVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeDBEngineVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	result, err := p.client.DescribeDBEngineVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeDBEngineVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rds",
		OperationName: "DescribeDBEngineVersions",
	}
}
