// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpoint

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/pinpoint/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"math"
	"strings"
)

type awsRestjson1_deserializeOpCreateApp struct {
}

func (*awsRestjson1_deserializeOpCreateApp) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateApp) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateApp(response, &metadata)
	}
	output := &CreateAppOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationResponse(&output.ApplicationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateApp(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateAppOutput(v **CreateAppOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateAppOutput
	if *v == nil {
		sv = &CreateAppOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationResponse":
			if err := awsRestjson1_deserializeDocumentApplicationResponse(&sv.ApplicationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateCampaign struct {
}

func (*awsRestjson1_deserializeOpCreateCampaign) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateCampaign) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateCampaign(response, &metadata)
	}
	output := &CreateCampaignOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignResponse(&output.CampaignResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateCampaign(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateCampaignOutput(v **CreateCampaignOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateCampaignOutput
	if *v == nil {
		sv = &CreateCampaignOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignResponse":
			if err := awsRestjson1_deserializeDocumentCampaignResponse(&sv.CampaignResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateEmailTemplate struct {
}

func (*awsRestjson1_deserializeOpCreateEmailTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateEmailTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateEmailTemplate(response, &metadata)
	}
	output := &CreateEmailTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&output.CreateTemplateMessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateEmailTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateEmailTemplateOutput(v **CreateEmailTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateEmailTemplateOutput
	if *v == nil {
		sv = &CreateEmailTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreateTemplateMessageBody":
			if err := awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&sv.CreateTemplateMessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateExportJob struct {
}

func (*awsRestjson1_deserializeOpCreateExportJob) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateExportJob) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateExportJob(response, &metadata)
	}
	output := &CreateExportJobOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentExportJobResponse(&output.ExportJobResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateExportJob(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateExportJobOutput(v **CreateExportJobOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateExportJobOutput
	if *v == nil {
		sv = &CreateExportJobOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ExportJobResponse":
			if err := awsRestjson1_deserializeDocumentExportJobResponse(&sv.ExportJobResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateImportJob struct {
}

func (*awsRestjson1_deserializeOpCreateImportJob) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateImportJob) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateImportJob(response, &metadata)
	}
	output := &CreateImportJobOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentImportJobResponse(&output.ImportJobResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateImportJob(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateImportJobOutput(v **CreateImportJobOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateImportJobOutput
	if *v == nil {
		sv = &CreateImportJobOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ImportJobResponse":
			if err := awsRestjson1_deserializeDocumentImportJobResponse(&sv.ImportJobResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateInAppTemplate struct {
}

func (*awsRestjson1_deserializeOpCreateInAppTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateInAppTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateInAppTemplate(response, &metadata)
	}
	output := &CreateInAppTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentTemplateCreateMessageBody(&output.TemplateCreateMessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateInAppTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateInAppTemplateOutput(v **CreateInAppTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateInAppTemplateOutput
	if *v == nil {
		sv = &CreateInAppTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "TemplateCreateMessageBody":
			if err := awsRestjson1_deserializeDocumentTemplateCreateMessageBody(&sv.TemplateCreateMessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateJourney struct {
}

func (*awsRestjson1_deserializeOpCreateJourney) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateJourney) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateJourney(response, &metadata)
	}
	output := &CreateJourneyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyResponse(&output.JourneyResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateJourney(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateJourneyOutput(v **CreateJourneyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateJourneyOutput
	if *v == nil {
		sv = &CreateJourneyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyResponse":
			if err := awsRestjson1_deserializeDocumentJourneyResponse(&sv.JourneyResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreatePushTemplate struct {
}

func (*awsRestjson1_deserializeOpCreatePushTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreatePushTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreatePushTemplate(response, &metadata)
	}
	output := &CreatePushTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&output.CreateTemplateMessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreatePushTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreatePushTemplateOutput(v **CreatePushTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreatePushTemplateOutput
	if *v == nil {
		sv = &CreatePushTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreateTemplateMessageBody":
			if err := awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&sv.CreateTemplateMessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateRecommenderConfiguration struct {
}

func (*awsRestjson1_deserializeOpCreateRecommenderConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateRecommenderConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateRecommenderConfiguration(response, &metadata)
	}
	output := &CreateRecommenderConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&output.RecommenderConfigurationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateRecommenderConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateRecommenderConfigurationOutput(v **CreateRecommenderConfigurationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateRecommenderConfigurationOutput
	if *v == nil {
		sv = &CreateRecommenderConfigurationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RecommenderConfigurationResponse":
			if err := awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&sv.RecommenderConfigurationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateSegment struct {
}

func (*awsRestjson1_deserializeOpCreateSegment) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateSegment) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateSegment(response, &metadata)
	}
	output := &CreateSegmentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentResponse(&output.SegmentResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateSegment(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateSegmentOutput(v **CreateSegmentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateSegmentOutput
	if *v == nil {
		sv = &CreateSegmentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentResponse":
			if err := awsRestjson1_deserializeDocumentSegmentResponse(&sv.SegmentResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateSmsTemplate struct {
}

func (*awsRestjson1_deserializeOpCreateSmsTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateSmsTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateSmsTemplate(response, &metadata)
	}
	output := &CreateSmsTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&output.CreateTemplateMessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateSmsTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateSmsTemplateOutput(v **CreateSmsTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateSmsTemplateOutput
	if *v == nil {
		sv = &CreateSmsTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreateTemplateMessageBody":
			if err := awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&sv.CreateTemplateMessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateVoiceTemplate struct {
}

func (*awsRestjson1_deserializeOpCreateVoiceTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateVoiceTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateVoiceTemplate(response, &metadata)
	}
	output := &CreateVoiceTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&output.CreateTemplateMessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateVoiceTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateVoiceTemplateOutput(v **CreateVoiceTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateVoiceTemplateOutput
	if *v == nil {
		sv = &CreateVoiceTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreateTemplateMessageBody":
			if err := awsRestjson1_deserializeDocumentCreateTemplateMessageBody(&sv.CreateTemplateMessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteAdmChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteAdmChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteAdmChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteAdmChannel(response, &metadata)
	}
	output := &DeleteAdmChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentADMChannelResponse(&output.ADMChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteAdmChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteAdmChannelOutput(v **DeleteAdmChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteAdmChannelOutput
	if *v == nil {
		sv = &DeleteAdmChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ADMChannelResponse":
			if err := awsRestjson1_deserializeDocumentADMChannelResponse(&sv.ADMChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteApnsChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteApnsChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteApnsChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteApnsChannel(response, &metadata)
	}
	output := &DeleteApnsChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSChannelResponse(&output.APNSChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteApnsChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteApnsChannelOutput(v **DeleteApnsChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteApnsChannelOutput
	if *v == nil {
		sv = &DeleteApnsChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSChannelResponse(&sv.APNSChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteApnsSandboxChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteApnsSandboxChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteApnsSandboxChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteApnsSandboxChannel(response, &metadata)
	}
	output := &DeleteApnsSandboxChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(&output.APNSSandboxChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteApnsSandboxChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteApnsSandboxChannelOutput(v **DeleteApnsSandboxChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteApnsSandboxChannelOutput
	if *v == nil {
		sv = &DeleteApnsSandboxChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSSandboxChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(&sv.APNSSandboxChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteApnsVoipChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteApnsVoipChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteApnsVoipChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteApnsVoipChannel(response, &metadata)
	}
	output := &DeleteApnsVoipChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(&output.APNSVoipChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteApnsVoipChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteApnsVoipChannelOutput(v **DeleteApnsVoipChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteApnsVoipChannelOutput
	if *v == nil {
		sv = &DeleteApnsVoipChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSVoipChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(&sv.APNSVoipChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteApnsVoipSandboxChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteApnsVoipSandboxChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteApnsVoipSandboxChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteApnsVoipSandboxChannel(response, &metadata)
	}
	output := &DeleteApnsVoipSandboxChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(&output.APNSVoipSandboxChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteApnsVoipSandboxChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteApnsVoipSandboxChannelOutput(v **DeleteApnsVoipSandboxChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteApnsVoipSandboxChannelOutput
	if *v == nil {
		sv = &DeleteApnsVoipSandboxChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSVoipSandboxChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(&sv.APNSVoipSandboxChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteApp struct {
}

func (*awsRestjson1_deserializeOpDeleteApp) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteApp) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteApp(response, &metadata)
	}
	output := &DeleteAppOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationResponse(&output.ApplicationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteApp(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteAppOutput(v **DeleteAppOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteAppOutput
	if *v == nil {
		sv = &DeleteAppOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationResponse":
			if err := awsRestjson1_deserializeDocumentApplicationResponse(&sv.ApplicationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteBaiduChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteBaiduChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteBaiduChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteBaiduChannel(response, &metadata)
	}
	output := &DeleteBaiduChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentBaiduChannelResponse(&output.BaiduChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteBaiduChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteBaiduChannelOutput(v **DeleteBaiduChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteBaiduChannelOutput
	if *v == nil {
		sv = &DeleteBaiduChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BaiduChannelResponse":
			if err := awsRestjson1_deserializeDocumentBaiduChannelResponse(&sv.BaiduChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteCampaign struct {
}

func (*awsRestjson1_deserializeOpDeleteCampaign) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteCampaign) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteCampaign(response, &metadata)
	}
	output := &DeleteCampaignOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignResponse(&output.CampaignResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteCampaign(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteCampaignOutput(v **DeleteCampaignOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteCampaignOutput
	if *v == nil {
		sv = &DeleteCampaignOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignResponse":
			if err := awsRestjson1_deserializeDocumentCampaignResponse(&sv.CampaignResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteEmailChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteEmailChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteEmailChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteEmailChannel(response, &metadata)
	}
	output := &DeleteEmailChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEmailChannelResponse(&output.EmailChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteEmailChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteEmailChannelOutput(v **DeleteEmailChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteEmailChannelOutput
	if *v == nil {
		sv = &DeleteEmailChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmailChannelResponse":
			if err := awsRestjson1_deserializeDocumentEmailChannelResponse(&sv.EmailChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteEmailTemplate struct {
}

func (*awsRestjson1_deserializeOpDeleteEmailTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteEmailTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteEmailTemplate(response, &metadata)
	}
	output := &DeleteEmailTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteEmailTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteEmailTemplateOutput(v **DeleteEmailTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteEmailTemplateOutput
	if *v == nil {
		sv = &DeleteEmailTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteEndpoint struct {
}

func (*awsRestjson1_deserializeOpDeleteEndpoint) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteEndpoint) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteEndpoint(response, &metadata)
	}
	output := &DeleteEndpointOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEndpointResponse(&output.EndpointResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteEndpoint(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteEndpointOutput(v **DeleteEndpointOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteEndpointOutput
	if *v == nil {
		sv = &DeleteEndpointOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndpointResponse":
			if err := awsRestjson1_deserializeDocumentEndpointResponse(&sv.EndpointResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteEventStream struct {
}

func (*awsRestjson1_deserializeOpDeleteEventStream) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteEventStream) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteEventStream(response, &metadata)
	}
	output := &DeleteEventStreamOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEventStream(&output.EventStream, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteEventStream(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteEventStreamOutput(v **DeleteEventStreamOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteEventStreamOutput
	if *v == nil {
		sv = &DeleteEventStreamOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventStream":
			if err := awsRestjson1_deserializeDocumentEventStream(&sv.EventStream, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteGcmChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteGcmChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteGcmChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteGcmChannel(response, &metadata)
	}
	output := &DeleteGcmChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentGCMChannelResponse(&output.GCMChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteGcmChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteGcmChannelOutput(v **DeleteGcmChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteGcmChannelOutput
	if *v == nil {
		sv = &DeleteGcmChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GCMChannelResponse":
			if err := awsRestjson1_deserializeDocumentGCMChannelResponse(&sv.GCMChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteInAppTemplate struct {
}

func (*awsRestjson1_deserializeOpDeleteInAppTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteInAppTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteInAppTemplate(response, &metadata)
	}
	output := &DeleteInAppTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteInAppTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteInAppTemplateOutput(v **DeleteInAppTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteInAppTemplateOutput
	if *v == nil {
		sv = &DeleteInAppTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteJourney struct {
}

func (*awsRestjson1_deserializeOpDeleteJourney) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteJourney) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteJourney(response, &metadata)
	}
	output := &DeleteJourneyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyResponse(&output.JourneyResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteJourney(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteJourneyOutput(v **DeleteJourneyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteJourneyOutput
	if *v == nil {
		sv = &DeleteJourneyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyResponse":
			if err := awsRestjson1_deserializeDocumentJourneyResponse(&sv.JourneyResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeletePushTemplate struct {
}

func (*awsRestjson1_deserializeOpDeletePushTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeletePushTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeletePushTemplate(response, &metadata)
	}
	output := &DeletePushTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeletePushTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeletePushTemplateOutput(v **DeletePushTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeletePushTemplateOutput
	if *v == nil {
		sv = &DeletePushTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteRecommenderConfiguration struct {
}

func (*awsRestjson1_deserializeOpDeleteRecommenderConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteRecommenderConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteRecommenderConfiguration(response, &metadata)
	}
	output := &DeleteRecommenderConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&output.RecommenderConfigurationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteRecommenderConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteRecommenderConfigurationOutput(v **DeleteRecommenderConfigurationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteRecommenderConfigurationOutput
	if *v == nil {
		sv = &DeleteRecommenderConfigurationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RecommenderConfigurationResponse":
			if err := awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&sv.RecommenderConfigurationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteSegment struct {
}

func (*awsRestjson1_deserializeOpDeleteSegment) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteSegment) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteSegment(response, &metadata)
	}
	output := &DeleteSegmentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentResponse(&output.SegmentResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteSegment(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteSegmentOutput(v **DeleteSegmentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteSegmentOutput
	if *v == nil {
		sv = &DeleteSegmentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentResponse":
			if err := awsRestjson1_deserializeDocumentSegmentResponse(&sv.SegmentResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteSmsChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteSmsChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteSmsChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteSmsChannel(response, &metadata)
	}
	output := &DeleteSmsChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSMSChannelResponse(&output.SMSChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteSmsChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteSmsChannelOutput(v **DeleteSmsChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteSmsChannelOutput
	if *v == nil {
		sv = &DeleteSmsChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SMSChannelResponse":
			if err := awsRestjson1_deserializeDocumentSMSChannelResponse(&sv.SMSChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteSmsTemplate struct {
}

func (*awsRestjson1_deserializeOpDeleteSmsTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteSmsTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteSmsTemplate(response, &metadata)
	}
	output := &DeleteSmsTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteSmsTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteSmsTemplateOutput(v **DeleteSmsTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteSmsTemplateOutput
	if *v == nil {
		sv = &DeleteSmsTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteUserEndpoints struct {
}

func (*awsRestjson1_deserializeOpDeleteUserEndpoints) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteUserEndpoints) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteUserEndpoints(response, &metadata)
	}
	output := &DeleteUserEndpointsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEndpointsResponse(&output.EndpointsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteUserEndpoints(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteUserEndpointsOutput(v **DeleteUserEndpointsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteUserEndpointsOutput
	if *v == nil {
		sv = &DeleteUserEndpointsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndpointsResponse":
			if err := awsRestjson1_deserializeDocumentEndpointsResponse(&sv.EndpointsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteVoiceChannel struct {
}

func (*awsRestjson1_deserializeOpDeleteVoiceChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteVoiceChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteVoiceChannel(response, &metadata)
	}
	output := &DeleteVoiceChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentVoiceChannelResponse(&output.VoiceChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteVoiceChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteVoiceChannelOutput(v **DeleteVoiceChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteVoiceChannelOutput
	if *v == nil {
		sv = &DeleteVoiceChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "VoiceChannelResponse":
			if err := awsRestjson1_deserializeDocumentVoiceChannelResponse(&sv.VoiceChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteVoiceTemplate struct {
}

func (*awsRestjson1_deserializeOpDeleteVoiceTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteVoiceTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteVoiceTemplate(response, &metadata)
	}
	output := &DeleteVoiceTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteVoiceTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteVoiceTemplateOutput(v **DeleteVoiceTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteVoiceTemplateOutput
	if *v == nil {
		sv = &DeleteVoiceTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetAdmChannel struct {
}

func (*awsRestjson1_deserializeOpGetAdmChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetAdmChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetAdmChannel(response, &metadata)
	}
	output := &GetAdmChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentADMChannelResponse(&output.ADMChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetAdmChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetAdmChannelOutput(v **GetAdmChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAdmChannelOutput
	if *v == nil {
		sv = &GetAdmChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ADMChannelResponse":
			if err := awsRestjson1_deserializeDocumentADMChannelResponse(&sv.ADMChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApnsChannel struct {
}

func (*awsRestjson1_deserializeOpGetApnsChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApnsChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApnsChannel(response, &metadata)
	}
	output := &GetApnsChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSChannelResponse(&output.APNSChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApnsChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetApnsChannelOutput(v **GetApnsChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApnsChannelOutput
	if *v == nil {
		sv = &GetApnsChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSChannelResponse(&sv.APNSChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApnsSandboxChannel struct {
}

func (*awsRestjson1_deserializeOpGetApnsSandboxChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApnsSandboxChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApnsSandboxChannel(response, &metadata)
	}
	output := &GetApnsSandboxChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(&output.APNSSandboxChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApnsSandboxChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetApnsSandboxChannelOutput(v **GetApnsSandboxChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApnsSandboxChannelOutput
	if *v == nil {
		sv = &GetApnsSandboxChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSSandboxChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(&sv.APNSSandboxChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApnsVoipChannel struct {
}

func (*awsRestjson1_deserializeOpGetApnsVoipChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApnsVoipChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApnsVoipChannel(response, &metadata)
	}
	output := &GetApnsVoipChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(&output.APNSVoipChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApnsVoipChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetApnsVoipChannelOutput(v **GetApnsVoipChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApnsVoipChannelOutput
	if *v == nil {
		sv = &GetApnsVoipChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSVoipChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(&sv.APNSVoipChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApnsVoipSandboxChannel struct {
}

func (*awsRestjson1_deserializeOpGetApnsVoipSandboxChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApnsVoipSandboxChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApnsVoipSandboxChannel(response, &metadata)
	}
	output := &GetApnsVoipSandboxChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(&output.APNSVoipSandboxChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApnsVoipSandboxChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetApnsVoipSandboxChannelOutput(v **GetApnsVoipSandboxChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApnsVoipSandboxChannelOutput
	if *v == nil {
		sv = &GetApnsVoipSandboxChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSVoipSandboxChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(&sv.APNSVoipSandboxChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApp struct {
}

func (*awsRestjson1_deserializeOpGetApp) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApp) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApp(response, &metadata)
	}
	output := &GetAppOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationResponse(&output.ApplicationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApp(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetAppOutput(v **GetAppOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAppOutput
	if *v == nil {
		sv = &GetAppOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationResponse":
			if err := awsRestjson1_deserializeDocumentApplicationResponse(&sv.ApplicationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApplicationDateRangeKpi struct {
}

func (*awsRestjson1_deserializeOpGetApplicationDateRangeKpi) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApplicationDateRangeKpi) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApplicationDateRangeKpi(response, &metadata)
	}
	output := &GetApplicationDateRangeKpiOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationDateRangeKpiResponse(&output.ApplicationDateRangeKpiResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApplicationDateRangeKpi(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetApplicationDateRangeKpiOutput(v **GetApplicationDateRangeKpiOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApplicationDateRangeKpiOutput
	if *v == nil {
		sv = &GetApplicationDateRangeKpiOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationDateRangeKpiResponse":
			if err := awsRestjson1_deserializeDocumentApplicationDateRangeKpiResponse(&sv.ApplicationDateRangeKpiResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApplicationSettings struct {
}

func (*awsRestjson1_deserializeOpGetApplicationSettings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApplicationSettings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApplicationSettings(response, &metadata)
	}
	output := &GetApplicationSettingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationSettingsResource(&output.ApplicationSettingsResource, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApplicationSettings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetApplicationSettingsOutput(v **GetApplicationSettingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApplicationSettingsOutput
	if *v == nil {
		sv = &GetApplicationSettingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationSettingsResource":
			if err := awsRestjson1_deserializeDocumentApplicationSettingsResource(&sv.ApplicationSettingsResource, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetApps struct {
}

func (*awsRestjson1_deserializeOpGetApps) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetApps) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetApps(response, &metadata)
	}
	output := &GetAppsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationsResponse(&output.ApplicationsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetApps(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetAppsOutput(v **GetAppsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAppsOutput
	if *v == nil {
		sv = &GetAppsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationsResponse":
			if err := awsRestjson1_deserializeDocumentApplicationsResponse(&sv.ApplicationsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetBaiduChannel struct {
}

func (*awsRestjson1_deserializeOpGetBaiduChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetBaiduChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetBaiduChannel(response, &metadata)
	}
	output := &GetBaiduChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentBaiduChannelResponse(&output.BaiduChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetBaiduChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetBaiduChannelOutput(v **GetBaiduChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetBaiduChannelOutput
	if *v == nil {
		sv = &GetBaiduChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BaiduChannelResponse":
			if err := awsRestjson1_deserializeDocumentBaiduChannelResponse(&sv.BaiduChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetCampaign struct {
}

func (*awsRestjson1_deserializeOpGetCampaign) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetCampaign) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetCampaign(response, &metadata)
	}
	output := &GetCampaignOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignResponse(&output.CampaignResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetCampaign(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetCampaignOutput(v **GetCampaignOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCampaignOutput
	if *v == nil {
		sv = &GetCampaignOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignResponse":
			if err := awsRestjson1_deserializeDocumentCampaignResponse(&sv.CampaignResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetCampaignActivities struct {
}

func (*awsRestjson1_deserializeOpGetCampaignActivities) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetCampaignActivities) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetCampaignActivities(response, &metadata)
	}
	output := &GetCampaignActivitiesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentActivitiesResponse(&output.ActivitiesResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetCampaignActivities(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetCampaignActivitiesOutput(v **GetCampaignActivitiesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCampaignActivitiesOutput
	if *v == nil {
		sv = &GetCampaignActivitiesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActivitiesResponse":
			if err := awsRestjson1_deserializeDocumentActivitiesResponse(&sv.ActivitiesResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetCampaignDateRangeKpi struct {
}

func (*awsRestjson1_deserializeOpGetCampaignDateRangeKpi) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetCampaignDateRangeKpi) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetCampaignDateRangeKpi(response, &metadata)
	}
	output := &GetCampaignDateRangeKpiOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignDateRangeKpiResponse(&output.CampaignDateRangeKpiResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetCampaignDateRangeKpi(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetCampaignDateRangeKpiOutput(v **GetCampaignDateRangeKpiOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCampaignDateRangeKpiOutput
	if *v == nil {
		sv = &GetCampaignDateRangeKpiOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignDateRangeKpiResponse":
			if err := awsRestjson1_deserializeDocumentCampaignDateRangeKpiResponse(&sv.CampaignDateRangeKpiResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetCampaigns struct {
}

func (*awsRestjson1_deserializeOpGetCampaigns) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetCampaigns) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetCampaigns(response, &metadata)
	}
	output := &GetCampaignsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignsResponse(&output.CampaignsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetCampaigns(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetCampaignsOutput(v **GetCampaignsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCampaignsOutput
	if *v == nil {
		sv = &GetCampaignsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignsResponse":
			if err := awsRestjson1_deserializeDocumentCampaignsResponse(&sv.CampaignsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetCampaignVersion struct {
}

func (*awsRestjson1_deserializeOpGetCampaignVersion) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetCampaignVersion) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetCampaignVersion(response, &metadata)
	}
	output := &GetCampaignVersionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignResponse(&output.CampaignResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetCampaignVersion(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetCampaignVersionOutput(v **GetCampaignVersionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCampaignVersionOutput
	if *v == nil {
		sv = &GetCampaignVersionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignResponse":
			if err := awsRestjson1_deserializeDocumentCampaignResponse(&sv.CampaignResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetCampaignVersions struct {
}

func (*awsRestjson1_deserializeOpGetCampaignVersions) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetCampaignVersions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetCampaignVersions(response, &metadata)
	}
	output := &GetCampaignVersionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignsResponse(&output.CampaignsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetCampaignVersions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetCampaignVersionsOutput(v **GetCampaignVersionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCampaignVersionsOutput
	if *v == nil {
		sv = &GetCampaignVersionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignsResponse":
			if err := awsRestjson1_deserializeDocumentCampaignsResponse(&sv.CampaignsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetChannels struct {
}

func (*awsRestjson1_deserializeOpGetChannels) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetChannels) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetChannels(response, &metadata)
	}
	output := &GetChannelsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentChannelsResponse(&output.ChannelsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetChannels(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetChannelsOutput(v **GetChannelsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetChannelsOutput
	if *v == nil {
		sv = &GetChannelsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ChannelsResponse":
			if err := awsRestjson1_deserializeDocumentChannelsResponse(&sv.ChannelsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetEmailChannel struct {
}

func (*awsRestjson1_deserializeOpGetEmailChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetEmailChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetEmailChannel(response, &metadata)
	}
	output := &GetEmailChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEmailChannelResponse(&output.EmailChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetEmailChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetEmailChannelOutput(v **GetEmailChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEmailChannelOutput
	if *v == nil {
		sv = &GetEmailChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmailChannelResponse":
			if err := awsRestjson1_deserializeDocumentEmailChannelResponse(&sv.EmailChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetEmailTemplate struct {
}

func (*awsRestjson1_deserializeOpGetEmailTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetEmailTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetEmailTemplate(response, &metadata)
	}
	output := &GetEmailTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEmailTemplateResponse(&output.EmailTemplateResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetEmailTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetEmailTemplateOutput(v **GetEmailTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEmailTemplateOutput
	if *v == nil {
		sv = &GetEmailTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmailTemplateResponse":
			if err := awsRestjson1_deserializeDocumentEmailTemplateResponse(&sv.EmailTemplateResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetEndpoint struct {
}

func (*awsRestjson1_deserializeOpGetEndpoint) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetEndpoint) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetEndpoint(response, &metadata)
	}
	output := &GetEndpointOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEndpointResponse(&output.EndpointResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetEndpoint(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetEndpointOutput(v **GetEndpointOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEndpointOutput
	if *v == nil {
		sv = &GetEndpointOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndpointResponse":
			if err := awsRestjson1_deserializeDocumentEndpointResponse(&sv.EndpointResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetEventStream struct {
}

func (*awsRestjson1_deserializeOpGetEventStream) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetEventStream) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetEventStream(response, &metadata)
	}
	output := &GetEventStreamOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEventStream(&output.EventStream, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetEventStream(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetEventStreamOutput(v **GetEventStreamOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEventStreamOutput
	if *v == nil {
		sv = &GetEventStreamOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventStream":
			if err := awsRestjson1_deserializeDocumentEventStream(&sv.EventStream, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetExportJob struct {
}

func (*awsRestjson1_deserializeOpGetExportJob) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetExportJob) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetExportJob(response, &metadata)
	}
	output := &GetExportJobOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentExportJobResponse(&output.ExportJobResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetExportJob(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetExportJobOutput(v **GetExportJobOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetExportJobOutput
	if *v == nil {
		sv = &GetExportJobOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ExportJobResponse":
			if err := awsRestjson1_deserializeDocumentExportJobResponse(&sv.ExportJobResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetExportJobs struct {
}

func (*awsRestjson1_deserializeOpGetExportJobs) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetExportJobs) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetExportJobs(response, &metadata)
	}
	output := &GetExportJobsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentExportJobsResponse(&output.ExportJobsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetExportJobs(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetExportJobsOutput(v **GetExportJobsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetExportJobsOutput
	if *v == nil {
		sv = &GetExportJobsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ExportJobsResponse":
			if err := awsRestjson1_deserializeDocumentExportJobsResponse(&sv.ExportJobsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetGcmChannel struct {
}

func (*awsRestjson1_deserializeOpGetGcmChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetGcmChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetGcmChannel(response, &metadata)
	}
	output := &GetGcmChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentGCMChannelResponse(&output.GCMChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetGcmChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetGcmChannelOutput(v **GetGcmChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetGcmChannelOutput
	if *v == nil {
		sv = &GetGcmChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GCMChannelResponse":
			if err := awsRestjson1_deserializeDocumentGCMChannelResponse(&sv.GCMChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetImportJob struct {
}

func (*awsRestjson1_deserializeOpGetImportJob) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetImportJob) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetImportJob(response, &metadata)
	}
	output := &GetImportJobOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentImportJobResponse(&output.ImportJobResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetImportJob(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetImportJobOutput(v **GetImportJobOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetImportJobOutput
	if *v == nil {
		sv = &GetImportJobOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ImportJobResponse":
			if err := awsRestjson1_deserializeDocumentImportJobResponse(&sv.ImportJobResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetImportJobs struct {
}

func (*awsRestjson1_deserializeOpGetImportJobs) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetImportJobs) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetImportJobs(response, &metadata)
	}
	output := &GetImportJobsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentImportJobsResponse(&output.ImportJobsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetImportJobs(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetImportJobsOutput(v **GetImportJobsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetImportJobsOutput
	if *v == nil {
		sv = &GetImportJobsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ImportJobsResponse":
			if err := awsRestjson1_deserializeDocumentImportJobsResponse(&sv.ImportJobsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInAppMessages struct {
}

func (*awsRestjson1_deserializeOpGetInAppMessages) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInAppMessages) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInAppMessages(response, &metadata)
	}
	output := &GetInAppMessagesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentInAppMessagesResponse(&output.InAppMessagesResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInAppMessages(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInAppMessagesOutput(v **GetInAppMessagesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInAppMessagesOutput
	if *v == nil {
		sv = &GetInAppMessagesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InAppMessagesResponse":
			if err := awsRestjson1_deserializeDocumentInAppMessagesResponse(&sv.InAppMessagesResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInAppTemplate struct {
}

func (*awsRestjson1_deserializeOpGetInAppTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInAppTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInAppTemplate(response, &metadata)
	}
	output := &GetInAppTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentInAppTemplateResponse(&output.InAppTemplateResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInAppTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInAppTemplateOutput(v **GetInAppTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInAppTemplateOutput
	if *v == nil {
		sv = &GetInAppTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InAppTemplateResponse":
			if err := awsRestjson1_deserializeDocumentInAppTemplateResponse(&sv.InAppTemplateResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetJourney struct {
}

func (*awsRestjson1_deserializeOpGetJourney) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetJourney) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetJourney(response, &metadata)
	}
	output := &GetJourneyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyResponse(&output.JourneyResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetJourney(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetJourneyOutput(v **GetJourneyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetJourneyOutput
	if *v == nil {
		sv = &GetJourneyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyResponse":
			if err := awsRestjson1_deserializeDocumentJourneyResponse(&sv.JourneyResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetJourneyDateRangeKpi struct {
}

func (*awsRestjson1_deserializeOpGetJourneyDateRangeKpi) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetJourneyDateRangeKpi) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetJourneyDateRangeKpi(response, &metadata)
	}
	output := &GetJourneyDateRangeKpiOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyDateRangeKpiResponse(&output.JourneyDateRangeKpiResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetJourneyDateRangeKpi(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetJourneyDateRangeKpiOutput(v **GetJourneyDateRangeKpiOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetJourneyDateRangeKpiOutput
	if *v == nil {
		sv = &GetJourneyDateRangeKpiOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyDateRangeKpiResponse":
			if err := awsRestjson1_deserializeDocumentJourneyDateRangeKpiResponse(&sv.JourneyDateRangeKpiResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetJourneyExecutionActivityMetrics struct {
}

func (*awsRestjson1_deserializeOpGetJourneyExecutionActivityMetrics) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetJourneyExecutionActivityMetrics) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetJourneyExecutionActivityMetrics(response, &metadata)
	}
	output := &GetJourneyExecutionActivityMetricsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyExecutionActivityMetricsResponse(&output.JourneyExecutionActivityMetricsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetJourneyExecutionActivityMetrics(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetJourneyExecutionActivityMetricsOutput(v **GetJourneyExecutionActivityMetricsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetJourneyExecutionActivityMetricsOutput
	if *v == nil {
		sv = &GetJourneyExecutionActivityMetricsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyExecutionActivityMetricsResponse":
			if err := awsRestjson1_deserializeDocumentJourneyExecutionActivityMetricsResponse(&sv.JourneyExecutionActivityMetricsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetJourneyExecutionMetrics struct {
}

func (*awsRestjson1_deserializeOpGetJourneyExecutionMetrics) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetJourneyExecutionMetrics) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetJourneyExecutionMetrics(response, &metadata)
	}
	output := &GetJourneyExecutionMetricsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyExecutionMetricsResponse(&output.JourneyExecutionMetricsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetJourneyExecutionMetrics(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetJourneyExecutionMetricsOutput(v **GetJourneyExecutionMetricsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetJourneyExecutionMetricsOutput
	if *v == nil {
		sv = &GetJourneyExecutionMetricsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyExecutionMetricsResponse":
			if err := awsRestjson1_deserializeDocumentJourneyExecutionMetricsResponse(&sv.JourneyExecutionMetricsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetPushTemplate struct {
}

func (*awsRestjson1_deserializeOpGetPushTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetPushTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetPushTemplate(response, &metadata)
	}
	output := &GetPushTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentPushNotificationTemplateResponse(&output.PushNotificationTemplateResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetPushTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetPushTemplateOutput(v **GetPushTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetPushTemplateOutput
	if *v == nil {
		sv = &GetPushTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PushNotificationTemplateResponse":
			if err := awsRestjson1_deserializeDocumentPushNotificationTemplateResponse(&sv.PushNotificationTemplateResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetRecommenderConfiguration struct {
}

func (*awsRestjson1_deserializeOpGetRecommenderConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetRecommenderConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetRecommenderConfiguration(response, &metadata)
	}
	output := &GetRecommenderConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&output.RecommenderConfigurationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetRecommenderConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetRecommenderConfigurationOutput(v **GetRecommenderConfigurationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetRecommenderConfigurationOutput
	if *v == nil {
		sv = &GetRecommenderConfigurationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RecommenderConfigurationResponse":
			if err := awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&sv.RecommenderConfigurationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetRecommenderConfigurations struct {
}

func (*awsRestjson1_deserializeOpGetRecommenderConfigurations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetRecommenderConfigurations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetRecommenderConfigurations(response, &metadata)
	}
	output := &GetRecommenderConfigurationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentListRecommenderConfigurationsResponse(&output.ListRecommenderConfigurationsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetRecommenderConfigurations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetRecommenderConfigurationsOutput(v **GetRecommenderConfigurationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetRecommenderConfigurationsOutput
	if *v == nil {
		sv = &GetRecommenderConfigurationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ListRecommenderConfigurationsResponse":
			if err := awsRestjson1_deserializeDocumentListRecommenderConfigurationsResponse(&sv.ListRecommenderConfigurationsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSegment struct {
}

func (*awsRestjson1_deserializeOpGetSegment) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSegment) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSegment(response, &metadata)
	}
	output := &GetSegmentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentResponse(&output.SegmentResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSegment(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSegmentOutput(v **GetSegmentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSegmentOutput
	if *v == nil {
		sv = &GetSegmentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentResponse":
			if err := awsRestjson1_deserializeDocumentSegmentResponse(&sv.SegmentResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSegmentExportJobs struct {
}

func (*awsRestjson1_deserializeOpGetSegmentExportJobs) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSegmentExportJobs) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSegmentExportJobs(response, &metadata)
	}
	output := &GetSegmentExportJobsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentExportJobsResponse(&output.ExportJobsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSegmentExportJobs(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSegmentExportJobsOutput(v **GetSegmentExportJobsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSegmentExportJobsOutput
	if *v == nil {
		sv = &GetSegmentExportJobsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ExportJobsResponse":
			if err := awsRestjson1_deserializeDocumentExportJobsResponse(&sv.ExportJobsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSegmentImportJobs struct {
}

func (*awsRestjson1_deserializeOpGetSegmentImportJobs) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSegmentImportJobs) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSegmentImportJobs(response, &metadata)
	}
	output := &GetSegmentImportJobsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentImportJobsResponse(&output.ImportJobsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSegmentImportJobs(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSegmentImportJobsOutput(v **GetSegmentImportJobsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSegmentImportJobsOutput
	if *v == nil {
		sv = &GetSegmentImportJobsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ImportJobsResponse":
			if err := awsRestjson1_deserializeDocumentImportJobsResponse(&sv.ImportJobsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSegments struct {
}

func (*awsRestjson1_deserializeOpGetSegments) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSegments) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSegments(response, &metadata)
	}
	output := &GetSegmentsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentsResponse(&output.SegmentsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSegments(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSegmentsOutput(v **GetSegmentsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSegmentsOutput
	if *v == nil {
		sv = &GetSegmentsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentsResponse":
			if err := awsRestjson1_deserializeDocumentSegmentsResponse(&sv.SegmentsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSegmentVersion struct {
}

func (*awsRestjson1_deserializeOpGetSegmentVersion) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSegmentVersion) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSegmentVersion(response, &metadata)
	}
	output := &GetSegmentVersionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentResponse(&output.SegmentResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSegmentVersion(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSegmentVersionOutput(v **GetSegmentVersionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSegmentVersionOutput
	if *v == nil {
		sv = &GetSegmentVersionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentResponse":
			if err := awsRestjson1_deserializeDocumentSegmentResponse(&sv.SegmentResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSegmentVersions struct {
}

func (*awsRestjson1_deserializeOpGetSegmentVersions) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSegmentVersions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSegmentVersions(response, &metadata)
	}
	output := &GetSegmentVersionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentsResponse(&output.SegmentsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSegmentVersions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSegmentVersionsOutput(v **GetSegmentVersionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSegmentVersionsOutput
	if *v == nil {
		sv = &GetSegmentVersionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentsResponse":
			if err := awsRestjson1_deserializeDocumentSegmentsResponse(&sv.SegmentsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSmsChannel struct {
}

func (*awsRestjson1_deserializeOpGetSmsChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSmsChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSmsChannel(response, &metadata)
	}
	output := &GetSmsChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSMSChannelResponse(&output.SMSChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSmsChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSmsChannelOutput(v **GetSmsChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSmsChannelOutput
	if *v == nil {
		sv = &GetSmsChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SMSChannelResponse":
			if err := awsRestjson1_deserializeDocumentSMSChannelResponse(&sv.SMSChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSmsTemplate struct {
}

func (*awsRestjson1_deserializeOpGetSmsTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSmsTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSmsTemplate(response, &metadata)
	}
	output := &GetSmsTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSMSTemplateResponse(&output.SMSTemplateResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSmsTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSmsTemplateOutput(v **GetSmsTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSmsTemplateOutput
	if *v == nil {
		sv = &GetSmsTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SMSTemplateResponse":
			if err := awsRestjson1_deserializeDocumentSMSTemplateResponse(&sv.SMSTemplateResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetUserEndpoints struct {
}

func (*awsRestjson1_deserializeOpGetUserEndpoints) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetUserEndpoints) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetUserEndpoints(response, &metadata)
	}
	output := &GetUserEndpointsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEndpointsResponse(&output.EndpointsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetUserEndpoints(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetUserEndpointsOutput(v **GetUserEndpointsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetUserEndpointsOutput
	if *v == nil {
		sv = &GetUserEndpointsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndpointsResponse":
			if err := awsRestjson1_deserializeDocumentEndpointsResponse(&sv.EndpointsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetVoiceChannel struct {
}

func (*awsRestjson1_deserializeOpGetVoiceChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetVoiceChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetVoiceChannel(response, &metadata)
	}
	output := &GetVoiceChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentVoiceChannelResponse(&output.VoiceChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetVoiceChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetVoiceChannelOutput(v **GetVoiceChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetVoiceChannelOutput
	if *v == nil {
		sv = &GetVoiceChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "VoiceChannelResponse":
			if err := awsRestjson1_deserializeDocumentVoiceChannelResponse(&sv.VoiceChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetVoiceTemplate struct {
}

func (*awsRestjson1_deserializeOpGetVoiceTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetVoiceTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetVoiceTemplate(response, &metadata)
	}
	output := &GetVoiceTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentVoiceTemplateResponse(&output.VoiceTemplateResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetVoiceTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetVoiceTemplateOutput(v **GetVoiceTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetVoiceTemplateOutput
	if *v == nil {
		sv = &GetVoiceTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "VoiceTemplateResponse":
			if err := awsRestjson1_deserializeDocumentVoiceTemplateResponse(&sv.VoiceTemplateResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListJourneys struct {
}

func (*awsRestjson1_deserializeOpListJourneys) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListJourneys) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListJourneys(response, &metadata)
	}
	output := &ListJourneysOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneysResponse(&output.JourneysResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListJourneys(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListJourneysOutput(v **ListJourneysOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListJourneysOutput
	if *v == nil {
		sv = &ListJourneysOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneysResponse":
			if err := awsRestjson1_deserializeDocumentJourneysResponse(&sv.JourneysResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListTagsForResource struct {
}

func (*awsRestjson1_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentTagsModel(&output.TagsModel, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "TagsModel":
			if err := awsRestjson1_deserializeDocumentTagsModel(&sv.TagsModel, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListTemplates struct {
}

func (*awsRestjson1_deserializeOpListTemplates) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListTemplates) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListTemplates(response, &metadata)
	}
	output := &ListTemplatesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentTemplatesResponse(&output.TemplatesResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListTemplates(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListTemplatesOutput(v **ListTemplatesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTemplatesOutput
	if *v == nil {
		sv = &ListTemplatesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "TemplatesResponse":
			if err := awsRestjson1_deserializeDocumentTemplatesResponse(&sv.TemplatesResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListTemplateVersions struct {
}

func (*awsRestjson1_deserializeOpListTemplateVersions) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListTemplateVersions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListTemplateVersions(response, &metadata)
	}
	output := &ListTemplateVersionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentTemplateVersionsResponse(&output.TemplateVersionsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListTemplateVersions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListTemplateVersionsOutput(v **ListTemplateVersionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTemplateVersionsOutput
	if *v == nil {
		sv = &ListTemplateVersionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "TemplateVersionsResponse":
			if err := awsRestjson1_deserializeDocumentTemplateVersionsResponse(&sv.TemplateVersionsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpPhoneNumberValidate struct {
}

func (*awsRestjson1_deserializeOpPhoneNumberValidate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpPhoneNumberValidate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorPhoneNumberValidate(response, &metadata)
	}
	output := &PhoneNumberValidateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentNumberValidateResponse(&output.NumberValidateResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorPhoneNumberValidate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentPhoneNumberValidateOutput(v **PhoneNumberValidateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PhoneNumberValidateOutput
	if *v == nil {
		sv = &PhoneNumberValidateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NumberValidateResponse":
			if err := awsRestjson1_deserializeDocumentNumberValidateResponse(&sv.NumberValidateResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpPutEvents struct {
}

func (*awsRestjson1_deserializeOpPutEvents) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpPutEvents) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorPutEvents(response, &metadata)
	}
	output := &PutEventsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEventsResponse(&output.EventsResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorPutEvents(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentPutEventsOutput(v **PutEventsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PutEventsOutput
	if *v == nil {
		sv = &PutEventsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventsResponse":
			if err := awsRestjson1_deserializeDocumentEventsResponse(&sv.EventsResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpPutEventStream struct {
}

func (*awsRestjson1_deserializeOpPutEventStream) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpPutEventStream) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorPutEventStream(response, &metadata)
	}
	output := &PutEventStreamOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEventStream(&output.EventStream, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorPutEventStream(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentPutEventStreamOutput(v **PutEventStreamOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PutEventStreamOutput
	if *v == nil {
		sv = &PutEventStreamOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventStream":
			if err := awsRestjson1_deserializeDocumentEventStream(&sv.EventStream, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpRemoveAttributes struct {
}

func (*awsRestjson1_deserializeOpRemoveAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpRemoveAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorRemoveAttributes(response, &metadata)
	}
	output := &RemoveAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAttributesResource(&output.AttributesResource, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorRemoveAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentRemoveAttributesOutput(v **RemoveAttributesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *RemoveAttributesOutput
	if *v == nil {
		sv = &RemoveAttributesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributesResource":
			if err := awsRestjson1_deserializeDocumentAttributesResource(&sv.AttributesResource, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpSendMessages struct {
}

func (*awsRestjson1_deserializeOpSendMessages) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpSendMessages) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorSendMessages(response, &metadata)
	}
	output := &SendMessagesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageResponse(&output.MessageResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorSendMessages(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentSendMessagesOutput(v **SendMessagesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *SendMessagesOutput
	if *v == nil {
		sv = &SendMessagesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageResponse":
			if err := awsRestjson1_deserializeDocumentMessageResponse(&sv.MessageResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpSendOTPMessage struct {
}

func (*awsRestjson1_deserializeOpSendOTPMessage) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpSendOTPMessage) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorSendOTPMessage(response, &metadata)
	}
	output := &SendOTPMessageOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageResponse(&output.MessageResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorSendOTPMessage(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentSendOTPMessageOutput(v **SendOTPMessageOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *SendOTPMessageOutput
	if *v == nil {
		sv = &SendOTPMessageOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageResponse":
			if err := awsRestjson1_deserializeDocumentMessageResponse(&sv.MessageResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpSendUsersMessages struct {
}

func (*awsRestjson1_deserializeOpSendUsersMessages) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpSendUsersMessages) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorSendUsersMessages(response, &metadata)
	}
	output := &SendUsersMessagesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSendUsersMessageResponse(&output.SendUsersMessageResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorSendUsersMessages(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentSendUsersMessagesOutput(v **SendUsersMessagesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *SendUsersMessagesOutput
	if *v == nil {
		sv = &SendUsersMessagesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SendUsersMessageResponse":
			if err := awsRestjson1_deserializeDocumentSendUsersMessageResponse(&sv.SendUsersMessageResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpTagResource struct {
}

func (*awsRestjson1_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorTagResource(response, &metadata)
	}
	output := &TagResourceOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorTagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUntagResource struct {
}

func (*awsRestjson1_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUntagResource(response, &metadata)
	}
	output := &UntagResourceOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUntagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateAdmChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateAdmChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateAdmChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateAdmChannel(response, &metadata)
	}
	output := &UpdateAdmChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentADMChannelResponse(&output.ADMChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateAdmChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateAdmChannelOutput(v **UpdateAdmChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateAdmChannelOutput
	if *v == nil {
		sv = &UpdateAdmChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ADMChannelResponse":
			if err := awsRestjson1_deserializeDocumentADMChannelResponse(&sv.ADMChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateApnsChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateApnsChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateApnsChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateApnsChannel(response, &metadata)
	}
	output := &UpdateApnsChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSChannelResponse(&output.APNSChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateApnsChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateApnsChannelOutput(v **UpdateApnsChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApnsChannelOutput
	if *v == nil {
		sv = &UpdateApnsChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSChannelResponse(&sv.APNSChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateApnsSandboxChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateApnsSandboxChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateApnsSandboxChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateApnsSandboxChannel(response, &metadata)
	}
	output := &UpdateApnsSandboxChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(&output.APNSSandboxChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateApnsSandboxChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateApnsSandboxChannelOutput(v **UpdateApnsSandboxChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApnsSandboxChannelOutput
	if *v == nil {
		sv = &UpdateApnsSandboxChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSSandboxChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(&sv.APNSSandboxChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateApnsVoipChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateApnsVoipChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateApnsVoipChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateApnsVoipChannel(response, &metadata)
	}
	output := &UpdateApnsVoipChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(&output.APNSVoipChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateApnsVoipChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateApnsVoipChannelOutput(v **UpdateApnsVoipChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApnsVoipChannelOutput
	if *v == nil {
		sv = &UpdateApnsVoipChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSVoipChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(&sv.APNSVoipChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateApnsVoipSandboxChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateApnsVoipSandboxChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateApnsVoipSandboxChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateApnsVoipSandboxChannel(response, &metadata)
	}
	output := &UpdateApnsVoipSandboxChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(&output.APNSVoipSandboxChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateApnsVoipSandboxChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateApnsVoipSandboxChannelOutput(v **UpdateApnsVoipSandboxChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApnsVoipSandboxChannelOutput
	if *v == nil {
		sv = &UpdateApnsVoipSandboxChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "APNSVoipSandboxChannelResponse":
			if err := awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(&sv.APNSVoipSandboxChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateApplicationSettings struct {
}

func (*awsRestjson1_deserializeOpUpdateApplicationSettings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateApplicationSettings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateApplicationSettings(response, &metadata)
	}
	output := &UpdateApplicationSettingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentApplicationSettingsResource(&output.ApplicationSettingsResource, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateApplicationSettings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateApplicationSettingsOutput(v **UpdateApplicationSettingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApplicationSettingsOutput
	if *v == nil {
		sv = &UpdateApplicationSettingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationSettingsResource":
			if err := awsRestjson1_deserializeDocumentApplicationSettingsResource(&sv.ApplicationSettingsResource, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateBaiduChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateBaiduChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateBaiduChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateBaiduChannel(response, &metadata)
	}
	output := &UpdateBaiduChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentBaiduChannelResponse(&output.BaiduChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateBaiduChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateBaiduChannelOutput(v **UpdateBaiduChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateBaiduChannelOutput
	if *v == nil {
		sv = &UpdateBaiduChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BaiduChannelResponse":
			if err := awsRestjson1_deserializeDocumentBaiduChannelResponse(&sv.BaiduChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateCampaign struct {
}

func (*awsRestjson1_deserializeOpUpdateCampaign) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateCampaign) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateCampaign(response, &metadata)
	}
	output := &UpdateCampaignOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentCampaignResponse(&output.CampaignResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateCampaign(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateCampaignOutput(v **UpdateCampaignOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateCampaignOutput
	if *v == nil {
		sv = &UpdateCampaignOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignResponse":
			if err := awsRestjson1_deserializeDocumentCampaignResponse(&sv.CampaignResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateEmailChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateEmailChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateEmailChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateEmailChannel(response, &metadata)
	}
	output := &UpdateEmailChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentEmailChannelResponse(&output.EmailChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateEmailChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateEmailChannelOutput(v **UpdateEmailChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateEmailChannelOutput
	if *v == nil {
		sv = &UpdateEmailChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmailChannelResponse":
			if err := awsRestjson1_deserializeDocumentEmailChannelResponse(&sv.EmailChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateEmailTemplate struct {
}

func (*awsRestjson1_deserializeOpUpdateEmailTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateEmailTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateEmailTemplate(response, &metadata)
	}
	output := &UpdateEmailTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateEmailTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateEmailTemplateOutput(v **UpdateEmailTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateEmailTemplateOutput
	if *v == nil {
		sv = &UpdateEmailTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateEndpoint struct {
}

func (*awsRestjson1_deserializeOpUpdateEndpoint) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateEndpoint) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateEndpoint(response, &metadata)
	}
	output := &UpdateEndpointOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateEndpoint(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateEndpointOutput(v **UpdateEndpointOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateEndpointOutput
	if *v == nil {
		sv = &UpdateEndpointOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateEndpointsBatch struct {
}

func (*awsRestjson1_deserializeOpUpdateEndpointsBatch) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateEndpointsBatch) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateEndpointsBatch(response, &metadata)
	}
	output := &UpdateEndpointsBatchOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateEndpointsBatch(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateEndpointsBatchOutput(v **UpdateEndpointsBatchOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateEndpointsBatchOutput
	if *v == nil {
		sv = &UpdateEndpointsBatchOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateGcmChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateGcmChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateGcmChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateGcmChannel(response, &metadata)
	}
	output := &UpdateGcmChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentGCMChannelResponse(&output.GCMChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateGcmChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateGcmChannelOutput(v **UpdateGcmChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateGcmChannelOutput
	if *v == nil {
		sv = &UpdateGcmChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GCMChannelResponse":
			if err := awsRestjson1_deserializeDocumentGCMChannelResponse(&sv.GCMChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateInAppTemplate struct {
}

func (*awsRestjson1_deserializeOpUpdateInAppTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateInAppTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateInAppTemplate(response, &metadata)
	}
	output := &UpdateInAppTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateInAppTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateInAppTemplateOutput(v **UpdateInAppTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateInAppTemplateOutput
	if *v == nil {
		sv = &UpdateInAppTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateJourney struct {
}

func (*awsRestjson1_deserializeOpUpdateJourney) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateJourney) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateJourney(response, &metadata)
	}
	output := &UpdateJourneyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyResponse(&output.JourneyResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateJourney(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ConflictException", errorCode):
		return awsRestjson1_deserializeErrorConflictException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateJourneyOutput(v **UpdateJourneyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateJourneyOutput
	if *v == nil {
		sv = &UpdateJourneyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyResponse":
			if err := awsRestjson1_deserializeDocumentJourneyResponse(&sv.JourneyResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateJourneyState struct {
}

func (*awsRestjson1_deserializeOpUpdateJourneyState) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateJourneyState) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateJourneyState(response, &metadata)
	}
	output := &UpdateJourneyStateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentJourneyResponse(&output.JourneyResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateJourneyState(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateJourneyStateOutput(v **UpdateJourneyStateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateJourneyStateOutput
	if *v == nil {
		sv = &UpdateJourneyStateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JourneyResponse":
			if err := awsRestjson1_deserializeDocumentJourneyResponse(&sv.JourneyResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdatePushTemplate struct {
}

func (*awsRestjson1_deserializeOpUpdatePushTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdatePushTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdatePushTemplate(response, &metadata)
	}
	output := &UpdatePushTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdatePushTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdatePushTemplateOutput(v **UpdatePushTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdatePushTemplateOutput
	if *v == nil {
		sv = &UpdatePushTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateRecommenderConfiguration struct {
}

func (*awsRestjson1_deserializeOpUpdateRecommenderConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateRecommenderConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateRecommenderConfiguration(response, &metadata)
	}
	output := &UpdateRecommenderConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&output.RecommenderConfigurationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateRecommenderConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateRecommenderConfigurationOutput(v **UpdateRecommenderConfigurationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateRecommenderConfigurationOutput
	if *v == nil {
		sv = &UpdateRecommenderConfigurationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RecommenderConfigurationResponse":
			if err := awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&sv.RecommenderConfigurationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateSegment struct {
}

func (*awsRestjson1_deserializeOpUpdateSegment) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateSegment) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateSegment(response, &metadata)
	}
	output := &UpdateSegmentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSegmentResponse(&output.SegmentResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateSegment(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateSegmentOutput(v **UpdateSegmentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateSegmentOutput
	if *v == nil {
		sv = &UpdateSegmentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentResponse":
			if err := awsRestjson1_deserializeDocumentSegmentResponse(&sv.SegmentResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateSmsChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateSmsChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateSmsChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateSmsChannel(response, &metadata)
	}
	output := &UpdateSmsChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentSMSChannelResponse(&output.SMSChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateSmsChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateSmsChannelOutput(v **UpdateSmsChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateSmsChannelOutput
	if *v == nil {
		sv = &UpdateSmsChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SMSChannelResponse":
			if err := awsRestjson1_deserializeDocumentSMSChannelResponse(&sv.SMSChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateSmsTemplate struct {
}

func (*awsRestjson1_deserializeOpUpdateSmsTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateSmsTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateSmsTemplate(response, &metadata)
	}
	output := &UpdateSmsTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateSmsTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateSmsTemplateOutput(v **UpdateSmsTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateSmsTemplateOutput
	if *v == nil {
		sv = &UpdateSmsTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateTemplateActiveVersion struct {
}

func (*awsRestjson1_deserializeOpUpdateTemplateActiveVersion) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateTemplateActiveVersion) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateTemplateActiveVersion(response, &metadata)
	}
	output := &UpdateTemplateActiveVersionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateTemplateActiveVersion(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateTemplateActiveVersionOutput(v **UpdateTemplateActiveVersionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateTemplateActiveVersionOutput
	if *v == nil {
		sv = &UpdateTemplateActiveVersionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateVoiceChannel struct {
}

func (*awsRestjson1_deserializeOpUpdateVoiceChannel) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateVoiceChannel) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateVoiceChannel(response, &metadata)
	}
	output := &UpdateVoiceChannelOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentVoiceChannelResponse(&output.VoiceChannelResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateVoiceChannel(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateVoiceChannelOutput(v **UpdateVoiceChannelOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateVoiceChannelOutput
	if *v == nil {
		sv = &UpdateVoiceChannelOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "VoiceChannelResponse":
			if err := awsRestjson1_deserializeDocumentVoiceChannelResponse(&sv.VoiceChannelResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateVoiceTemplate struct {
}

func (*awsRestjson1_deserializeOpUpdateVoiceTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateVoiceTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateVoiceTemplate(response, &metadata)
	}
	output := &UpdateVoiceTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentMessageBody(&output.MessageBody, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateVoiceTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateVoiceTemplateOutput(v **UpdateVoiceTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateVoiceTemplateOutput
	if *v == nil {
		sv = &UpdateVoiceTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageBody":
			if err := awsRestjson1_deserializeDocumentMessageBody(&sv.MessageBody, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpVerifyOTPMessage struct {
}

func (*awsRestjson1_deserializeOpVerifyOTPMessage) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpVerifyOTPMessage) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorVerifyOTPMessage(response, &metadata)
	}
	output := &VerifyOTPMessageOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeDocumentVerificationResponse(&output.VerificationResponse, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorVerifyOTPMessage(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("BadRequestException", errorCode):
		return awsRestjson1_deserializeErrorBadRequestException(response, errorBody)

	case strings.EqualFold("ForbiddenException", errorCode):
		return awsRestjson1_deserializeErrorForbiddenException(response, errorBody)

	case strings.EqualFold("InternalServerErrorException", errorCode):
		return awsRestjson1_deserializeErrorInternalServerErrorException(response, errorBody)

	case strings.EqualFold("MethodNotAllowedException", errorCode):
		return awsRestjson1_deserializeErrorMethodNotAllowedException(response, errorBody)

	case strings.EqualFold("NotFoundException", errorCode):
		return awsRestjson1_deserializeErrorNotFoundException(response, errorBody)

	case strings.EqualFold("PayloadTooLargeException", errorCode):
		return awsRestjson1_deserializeErrorPayloadTooLargeException(response, errorBody)

	case strings.EqualFold("TooManyRequestsException", errorCode):
		return awsRestjson1_deserializeErrorTooManyRequestsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentVerifyOTPMessageOutput(v **VerifyOTPMessageOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *VerifyOTPMessageOutput
	if *v == nil {
		sv = &VerifyOTPMessageOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "VerificationResponse":
			if err := awsRestjson1_deserializeDocumentVerificationResponse(&sv.VerificationResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeErrorBadRequestException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.BadRequestException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentBadRequestException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorConflictException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ConflictException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentConflictException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorForbiddenException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ForbiddenException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentForbiddenException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInternalServerErrorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InternalServerErrorException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInternalServerErrorException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorMethodNotAllowedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.MethodNotAllowedException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentMethodNotAllowedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentNotFoundException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorPayloadTooLargeException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.PayloadTooLargeException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentPayloadTooLargeException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorTooManyRequestsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TooManyRequestsException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentTooManyRequestsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeDocumentActivitiesResponse(v **types.ActivitiesResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivitiesResponse
	if *v == nil {
		sv = &types.ActivitiesResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfActivityResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActivity(v **types.Activity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Activity
	if *v == nil {
		sv = &types.Activity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ConditionalSplit":
			if err := awsRestjson1_deserializeDocumentConditionalSplitActivity(&sv.ConditionalSplit, value); err != nil {
				return err
			}

		case "ContactCenter":
			if err := awsRestjson1_deserializeDocumentContactCenterActivity(&sv.ContactCenter, value); err != nil {
				return err
			}

		case "CUSTOM":
			if err := awsRestjson1_deserializeDocumentCustomMessageActivity(&sv.CUSTOM, value); err != nil {
				return err
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EMAIL":
			if err := awsRestjson1_deserializeDocumentEmailMessageActivity(&sv.EMAIL, value); err != nil {
				return err
			}

		case "Holdout":
			if err := awsRestjson1_deserializeDocumentHoldoutActivity(&sv.Holdout, value); err != nil {
				return err
			}

		case "MultiCondition":
			if err := awsRestjson1_deserializeDocumentMultiConditionalSplitActivity(&sv.MultiCondition, value); err != nil {
				return err
			}

		case "PUSH":
			if err := awsRestjson1_deserializeDocumentPushMessageActivity(&sv.PUSH, value); err != nil {
				return err
			}

		case "RandomSplit":
			if err := awsRestjson1_deserializeDocumentRandomSplitActivity(&sv.RandomSplit, value); err != nil {
				return err
			}

		case "SMS":
			if err := awsRestjson1_deserializeDocumentSMSMessageActivity(&sv.SMS, value); err != nil {
				return err
			}

		case "Wait":
			if err := awsRestjson1_deserializeDocumentWaitActivity(&sv.Wait, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActivityResponse(v **types.ActivityResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityResponse
	if *v == nil {
		sv = &types.ActivityResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CampaignId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CampaignId = ptr.String(jtv)
			}

		case "End":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.End = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Result":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Result = ptr.String(jtv)
			}

		case "ScheduledStart":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ScheduledStart = ptr.String(jtv)
			}

		case "Start":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Start = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "SuccessfulEndpointCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SuccessfulEndpointCount = int32(i64)
			}

		case "TimezonesCompletedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TimezonesCompletedCount = int32(i64)
			}

		case "TimezonesTotalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TimezonesTotalCount = int32(i64)
			}

		case "TotalEndpointCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalEndpointCount = int32(i64)
			}

		case "TreatmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TreatmentId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentADMChannelResponse(v **types.ADMChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ADMChannelResponse
	if *v == nil {
		sv = &types.ADMChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAndroidPushNotificationTemplate(v **types.AndroidPushNotificationTemplate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AndroidPushNotificationTemplate
	if *v == nil {
		sv = &types.AndroidPushNotificationTemplate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Action to be of type string, got %T instead", value)
				}
				sv.Action = types.Action(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "ImageIconUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ImageIconUrl = ptr.String(jtv)
			}

		case "ImageUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ImageUrl = ptr.String(jtv)
			}

		case "RawContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RawContent = ptr.String(jtv)
			}

		case "SmallImageIconUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SmallImageIconUrl = ptr.String(jtv)
			}

		case "Sound":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Sound = ptr.String(jtv)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Url = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAPNSChannelResponse(v **types.APNSChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.APNSChannelResponse
	if *v == nil {
		sv = &types.APNSChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultAuthenticationMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultAuthenticationMethod = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "HasTokenKey":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasTokenKey = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAPNSPushNotificationTemplate(v **types.APNSPushNotificationTemplate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.APNSPushNotificationTemplate
	if *v == nil {
		sv = &types.APNSPushNotificationTemplate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Action to be of type string, got %T instead", value)
				}
				sv.Action = types.Action(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "MediaUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.MediaUrl = ptr.String(jtv)
			}

		case "RawContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RawContent = ptr.String(jtv)
			}

		case "Sound":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Sound = ptr.String(jtv)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Url = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAPNSSandboxChannelResponse(v **types.APNSSandboxChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.APNSSandboxChannelResponse
	if *v == nil {
		sv = &types.APNSSandboxChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultAuthenticationMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultAuthenticationMethod = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "HasTokenKey":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasTokenKey = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAPNSVoipChannelResponse(v **types.APNSVoipChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.APNSVoipChannelResponse
	if *v == nil {
		sv = &types.APNSVoipChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultAuthenticationMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultAuthenticationMethod = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "HasTokenKey":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasTokenKey = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAPNSVoipSandboxChannelResponse(v **types.APNSVoipSandboxChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.APNSVoipSandboxChannelResponse
	if *v == nil {
		sv = &types.APNSVoipSandboxChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultAuthenticationMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultAuthenticationMethod = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "HasTokenKey":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasTokenKey = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentApplicationDateRangeKpiResponse(v **types.ApplicationDateRangeKpiResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApplicationDateRangeKpiResponse
	if *v == nil {
		sv = &types.ApplicationDateRangeKpiResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case "KpiName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.KpiName = ptr.String(jtv)
			}

		case "KpiResult":
			if err := awsRestjson1_deserializeDocumentBaseKpiResult(&sv.KpiResult, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentApplicationResponse(v **types.ApplicationResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApplicationResponse
	if *v == nil {
		sv = &types.ApplicationResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentApplicationSettingsResource(v **types.ApplicationSettingsResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApplicationSettingsResource
	if *v == nil {
		sv = &types.ApplicationSettingsResource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CampaignHook":
			if err := awsRestjson1_deserializeDocumentCampaignHook(&sv.CampaignHook, value); err != nil {
				return err
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Limits":
			if err := awsRestjson1_deserializeDocumentCampaignLimits(&sv.Limits, value); err != nil {
				return err
			}

		case "QuietTime":
			if err := awsRestjson1_deserializeDocumentQuietTime(&sv.QuietTime, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentApplicationsResponse(v **types.ApplicationsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApplicationsResponse
	if *v == nil {
		sv = &types.ApplicationsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfApplicationResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAttributeDimension(v **types.AttributeDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AttributeDimension
	if *v == nil {
		sv = &types.AttributeDimension{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AttributeType to be of type string, got %T instead", value)
				}
				sv.AttributeType = types.AttributeType(jtv)
			}

		case "Values":
			if err := awsRestjson1_deserializeDocumentListOf__string(&sv.Values, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAttributesResource(v **types.AttributesResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AttributesResource
	if *v == nil {
		sv = &types.AttributesResource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "Attributes":
			if err := awsRestjson1_deserializeDocumentListOf__string(&sv.Attributes, value); err != nil {
				return err
			}

		case "AttributeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.AttributeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentBadRequestException(v **types.BadRequestException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BadRequestException
	if *v == nil {
		sv = &types.BadRequestException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentBaiduChannelResponse(v **types.BaiduChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BaiduChannelResponse
	if *v == nil {
		sv = &types.BaiduChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Credential":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Credential = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentBaseKpiResult(v **types.BaseKpiResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BaseKpiResult
	if *v == nil {
		sv = &types.BaseKpiResult{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Rows":
			if err := awsRestjson1_deserializeDocumentListOfResultRow(&sv.Rows, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignCustomMessage(v **types.CampaignCustomMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignCustomMessage
	if *v == nil {
		sv = &types.CampaignCustomMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Data":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Data = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignDateRangeKpiResponse(v **types.CampaignDateRangeKpiResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignDateRangeKpiResponse
	if *v == nil {
		sv = &types.CampaignDateRangeKpiResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CampaignId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CampaignId = ptr.String(jtv)
			}

		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case "KpiName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.KpiName = ptr.String(jtv)
			}

		case "KpiResult":
			if err := awsRestjson1_deserializeDocumentBaseKpiResult(&sv.KpiResult, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignEmailMessage(v **types.CampaignEmailMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignEmailMessage
	if *v == nil {
		sv = &types.CampaignEmailMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "FromAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.FromAddress = ptr.String(jtv)
			}

		case "HtmlBody":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.HtmlBody = ptr.String(jtv)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignEventFilter(v **types.CampaignEventFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignEventFilter
	if *v == nil {
		sv = &types.CampaignEventFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Dimensions":
			if err := awsRestjson1_deserializeDocumentEventDimensions(&sv.Dimensions, value); err != nil {
				return err
			}

		case "FilterType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FilterType to be of type string, got %T instead", value)
				}
				sv.FilterType = types.FilterType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignHook(v **types.CampaignHook, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignHook
	if *v == nil {
		sv = &types.CampaignHook{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LambdaFunctionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LambdaFunctionName = ptr.String(jtv)
			}

		case "Mode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Mode to be of type string, got %T instead", value)
				}
				sv.Mode = types.Mode(jtv)
			}

		case "WebUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.WebUrl = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignInAppMessage(v **types.CampaignInAppMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignInAppMessage
	if *v == nil {
		sv = &types.CampaignInAppMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "Content":
			if err := awsRestjson1_deserializeDocumentListOfInAppMessageContent(&sv.Content, value); err != nil {
				return err
			}

		case "CustomConfig":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.CustomConfig, value); err != nil {
				return err
			}

		case "Layout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Layout to be of type string, got %T instead", value)
				}
				sv.Layout = types.Layout(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignLimits(v **types.CampaignLimits, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignLimits
	if *v == nil {
		sv = &types.CampaignLimits{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Daily":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Daily = int32(i64)
			}

		case "MaximumDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaximumDuration = int32(i64)
			}

		case "MessagesPerSecond":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MessagesPerSecond = int32(i64)
			}

		case "Session":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Session = int32(i64)
			}

		case "Total":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Total = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignResponse(v **types.CampaignResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignResponse
	if *v == nil {
		sv = &types.CampaignResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AdditionalTreatments":
			if err := awsRestjson1_deserializeDocumentListOfTreatmentResource(&sv.AdditionalTreatments, value); err != nil {
				return err
			}

		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "CustomDeliveryConfiguration":
			if err := awsRestjson1_deserializeDocumentCustomDeliveryConfiguration(&sv.CustomDeliveryConfiguration, value); err != nil {
				return err
			}

		case "DefaultState":
			if err := awsRestjson1_deserializeDocumentCampaignState(&sv.DefaultState, value); err != nil {
				return err
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "HoldoutPercent":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HoldoutPercent = int32(i64)
			}

		case "Hook":
			if err := awsRestjson1_deserializeDocumentCampaignHook(&sv.Hook, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsPaused":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsPaused = jtv
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Limits":
			if err := awsRestjson1_deserializeDocumentCampaignLimits(&sv.Limits, value); err != nil {
				return err
			}

		case "MessageConfiguration":
			if err := awsRestjson1_deserializeDocumentMessageConfiguration(&sv.MessageConfiguration, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Priority":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Priority = int32(i64)
			}

		case "Schedule":
			if err := awsRestjson1_deserializeDocumentSchedule(&sv.Schedule, value); err != nil {
				return err
			}

		case "SegmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SegmentId = ptr.String(jtv)
			}

		case "SegmentVersion":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SegmentVersion = int32(i64)
			}

		case "State":
			if err := awsRestjson1_deserializeDocumentCampaignState(&sv.State, value); err != nil {
				return err
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateConfiguration":
			if err := awsRestjson1_deserializeDocumentTemplateConfiguration(&sv.TemplateConfiguration, value); err != nil {
				return err
			}

		case "TreatmentDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TreatmentDescription = ptr.String(jtv)
			}

		case "TreatmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TreatmentName = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignSmsMessage(v **types.CampaignSmsMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignSmsMessage
	if *v == nil {
		sv = &types.CampaignSmsMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "EntityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EntityId = ptr.String(jtv)
			}

		case "MessageType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MessageType to be of type string, got %T instead", value)
				}
				sv.MessageType = types.MessageType(jtv)
			}

		case "OriginationNumber":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.OriginationNumber = ptr.String(jtv)
			}

		case "SenderId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SenderId = ptr.String(jtv)
			}

		case "TemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignsResponse(v **types.CampaignsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignsResponse
	if *v == nil {
		sv = &types.CampaignsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfCampaignResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCampaignState(v **types.CampaignState, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CampaignState
	if *v == nil {
		sv = &types.CampaignState{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CampaignStatus to be of type string, got %T instead", value)
				}
				sv.CampaignStatus = types.CampaignStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentChannelResponse(v **types.ChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChannelResponse
	if *v == nil {
		sv = &types.ChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentChannelsResponse(v **types.ChannelsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChannelsResponse
	if *v == nil {
		sv = &types.ChannelsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Channels":
			if err := awsRestjson1_deserializeDocumentMapOfChannelResponse(&sv.Channels, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentClosedDays(v **types.ClosedDays, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ClosedDays
	if *v == nil {
		sv = &types.ClosedDays{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CUSTOM":
			if err := awsRestjson1_deserializeDocumentListOfClosedDaysRules(&sv.CUSTOM, value); err != nil {
				return err
			}

		case "EMAIL":
			if err := awsRestjson1_deserializeDocumentListOfClosedDaysRules(&sv.EMAIL, value); err != nil {
				return err
			}

		case "PUSH":
			if err := awsRestjson1_deserializeDocumentListOfClosedDaysRules(&sv.PUSH, value); err != nil {
				return err
			}

		case "SMS":
			if err := awsRestjson1_deserializeDocumentListOfClosedDaysRules(&sv.SMS, value); err != nil {
				return err
			}

		case "VOICE":
			if err := awsRestjson1_deserializeDocumentListOfClosedDaysRules(&sv.VOICE, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentClosedDaysRule(v **types.ClosedDaysRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ClosedDaysRule
	if *v == nil {
		sv = &types.ClosedDaysRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EndDateTime = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "StartDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.StartDateTime = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCondition(v **types.Condition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Condition
	if *v == nil {
		sv = &types.Condition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Conditions":
			if err := awsRestjson1_deserializeDocumentListOfSimpleCondition(&sv.Conditions, value); err != nil {
				return err
			}

		case "Operator":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Operator to be of type string, got %T instead", value)
				}
				sv.Operator = types.Operator(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConditionalSplitActivity(v **types.ConditionalSplitActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConditionalSplitActivity
	if *v == nil {
		sv = &types.ConditionalSplitActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Condition":
			if err := awsRestjson1_deserializeDocumentCondition(&sv.Condition, value); err != nil {
				return err
			}

		case "EvaluationWaitTime":
			if err := awsRestjson1_deserializeDocumentWaitTime(&sv.EvaluationWaitTime, value); err != nil {
				return err
			}

		case "FalseActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.FalseActivity = ptr.String(jtv)
			}

		case "TrueActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TrueActivity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentConflictException(v **types.ConflictException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConflictException
	if *v == nil {
		sv = &types.ConflictException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentContactCenterActivity(v **types.ContactCenterActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ContactCenterActivity
	if *v == nil {
		sv = &types.ContactCenterActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCreateTemplateMessageBody(v **types.CreateTemplateMessageBody, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CreateTemplateMessageBody
	if *v == nil {
		sv = &types.CreateTemplateMessageBody{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCustomDeliveryConfiguration(v **types.CustomDeliveryConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CustomDeliveryConfiguration
	if *v == nil {
		sv = &types.CustomDeliveryConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeliveryUri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DeliveryUri = ptr.String(jtv)
			}

		case "EndpointTypes":
			if err := awsRestjson1_deserializeDocumentListOf__EndpointTypesElement(&sv.EndpointTypes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCustomMessageActivity(v **types.CustomMessageActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CustomMessageActivity
	if *v == nil {
		sv = &types.CustomMessageActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeliveryUri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DeliveryUri = ptr.String(jtv)
			}

		case "EndpointTypes":
			if err := awsRestjson1_deserializeDocumentListOf__EndpointTypesElement(&sv.EndpointTypes, value); err != nil {
				return err
			}

		case "MessageConfig":
			if err := awsRestjson1_deserializeDocumentJourneyCustomMessage(&sv.MessageConfig, value); err != nil {
				return err
			}

		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateVersion = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDefaultButtonConfiguration(v **types.DefaultButtonConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DefaultButtonConfiguration
	if *v == nil {
		sv = &types.DefaultButtonConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackgroundColor":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.BackgroundColor = ptr.String(jtv)
			}

		case "BorderRadius":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BorderRadius = int32(i64)
			}

		case "ButtonAction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ButtonAction to be of type string, got %T instead", value)
				}
				sv.ButtonAction = types.ButtonAction(jtv)
			}

		case "Link":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Link = ptr.String(jtv)
			}

		case "Text":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Text = ptr.String(jtv)
			}

		case "TextColor":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TextColor = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDefaultPushNotificationTemplate(v **types.DefaultPushNotificationTemplate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DefaultPushNotificationTemplate
	if *v == nil {
		sv = &types.DefaultPushNotificationTemplate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Action to be of type string, got %T instead", value)
				}
				sv.Action = types.Action(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "Sound":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Sound = ptr.String(jtv)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Url = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEmailChannelResponse(v **types.EmailChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EmailChannelResponse
	if *v == nil {
		sv = &types.EmailChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "ConfigurationSet":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ConfigurationSet = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "FromAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.FromAddress = ptr.String(jtv)
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Identity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Identity = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "MessagesPerSecond":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MessagesPerSecond = int32(i64)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEmailMessageActivity(v **types.EmailMessageActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EmailMessageActivity
	if *v == nil {
		sv = &types.EmailMessageActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageConfig":
			if err := awsRestjson1_deserializeDocumentJourneyEmailMessage(&sv.MessageConfig, value); err != nil {
				return err
			}

		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateVersion = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEmailTemplateResponse(v **types.EmailTemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EmailTemplateResponse
	if *v == nil {
		sv = &types.EmailTemplateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultSubstitutions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultSubstitutions = ptr.String(jtv)
			}

		case "HtmlPart":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.HtmlPart = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "RecommenderId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommenderId = ptr.String(jtv)
			}

		case "Subject":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Subject = ptr.String(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TemplateType to be of type string, got %T instead", value)
				}
				sv.TemplateType = types.TemplateType(jtv)
			}

		case "TextPart":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TextPart = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointDemographic(v **types.EndpointDemographic, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointDemographic
	if *v == nil {
		sv = &types.EndpointDemographic{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AppVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.AppVersion = ptr.String(jtv)
			}

		case "Locale":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Locale = ptr.String(jtv)
			}

		case "Make":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Make = ptr.String(jtv)
			}

		case "Model":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Model = ptr.String(jtv)
			}

		case "ModelVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ModelVersion = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "PlatformVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.PlatformVersion = ptr.String(jtv)
			}

		case "Timezone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Timezone = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointItemResponse(v **types.EndpointItemResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointItemResponse
	if *v == nil {
		sv = &types.EndpointItemResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "StatusCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StatusCode = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointLocation(v **types.EndpointLocation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointLocation
	if *v == nil {
		sv = &types.EndpointLocation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "City":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.City = ptr.String(jtv)
			}

		case "Country":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Country = ptr.String(jtv)
			}

		case "Latitude":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Latitude = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Latitude = f64

				default:
					return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

				}
			}

		case "Longitude":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Longitude = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Longitude = f64

				default:
					return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

				}
			}

		case "PostalCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.PostalCode = ptr.String(jtv)
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointMessageResult(v **types.EndpointMessageResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointMessageResult
	if *v == nil {
		sv = &types.EndpointMessageResult{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Address = ptr.String(jtv)
			}

		case "DeliveryStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DeliveryStatus to be of type string, got %T instead", value)
				}
				sv.DeliveryStatus = types.DeliveryStatus(jtv)
			}

		case "MessageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.MessageId = ptr.String(jtv)
			}

		case "StatusCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StatusCode = int32(i64)
			}

		case "StatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.StatusMessage = ptr.String(jtv)
			}

		case "UpdatedToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.UpdatedToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointResponse(v **types.EndpointResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointResponse
	if *v == nil {
		sv = &types.EndpointResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Address = ptr.String(jtv)
			}

		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "Attributes":
			if err := awsRestjson1_deserializeDocumentMapOfListOf__string(&sv.Attributes, value); err != nil {
				return err
			}

		case "ChannelType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChannelType to be of type string, got %T instead", value)
				}
				sv.ChannelType = types.ChannelType(jtv)
			}

		case "CohortId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CohortId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Demographic":
			if err := awsRestjson1_deserializeDocumentEndpointDemographic(&sv.Demographic, value); err != nil {
				return err
			}

		case "EffectiveDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EffectiveDate = ptr.String(jtv)
			}

		case "EndpointStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EndpointStatus = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Location":
			if err := awsRestjson1_deserializeDocumentEndpointLocation(&sv.Location, value); err != nil {
				return err
			}

		case "Metrics":
			if err := awsRestjson1_deserializeDocumentMapOf__double(&sv.Metrics, value); err != nil {
				return err
			}

		case "OptOut":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.OptOut = ptr.String(jtv)
			}

		case "RequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestId = ptr.String(jtv)
			}

		case "User":
			if err := awsRestjson1_deserializeDocumentEndpointUser(&sv.User, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointsResponse(v **types.EndpointsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointsResponse
	if *v == nil {
		sv = &types.EndpointsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfEndpointResponse(&sv.Item, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEndpointUser(v **types.EndpointUser, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EndpointUser
	if *v == nil {
		sv = &types.EndpointUser{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UserAttributes":
			if err := awsRestjson1_deserializeDocumentMapOfListOf__string(&sv.UserAttributes, value); err != nil {
				return err
			}

		case "UserId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.UserId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventCondition(v **types.EventCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventCondition
	if *v == nil {
		sv = &types.EventCondition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Dimensions":
			if err := awsRestjson1_deserializeDocumentEventDimensions(&sv.Dimensions, value); err != nil {
				return err
			}

		case "MessageActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.MessageActivity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventDimensions(v **types.EventDimensions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventDimensions
	if *v == nil {
		sv = &types.EventDimensions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attributes":
			if err := awsRestjson1_deserializeDocumentMapOfAttributeDimension(&sv.Attributes, value); err != nil {
				return err
			}

		case "EventType":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.EventType, value); err != nil {
				return err
			}

		case "Metrics":
			if err := awsRestjson1_deserializeDocumentMapOfMetricDimension(&sv.Metrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventFilter(v **types.EventFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventFilter
	if *v == nil {
		sv = &types.EventFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Dimensions":
			if err := awsRestjson1_deserializeDocumentEventDimensions(&sv.Dimensions, value); err != nil {
				return err
			}

		case "FilterType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FilterType to be of type string, got %T instead", value)
				}
				sv.FilterType = types.FilterType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventItemResponse(v **types.EventItemResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventItemResponse
	if *v == nil {
		sv = &types.EventItemResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "StatusCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StatusCode = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventsResponse(v **types.EventsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventsResponse
	if *v == nil {
		sv = &types.EventsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Results":
			if err := awsRestjson1_deserializeDocumentMapOfItemResponse(&sv.Results, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventStartCondition(v **types.EventStartCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventStartCondition
	if *v == nil {
		sv = &types.EventStartCondition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventFilter":
			if err := awsRestjson1_deserializeDocumentEventFilter(&sv.EventFilter, value); err != nil {
				return err
			}

		case "SegmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SegmentId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentEventStream(v **types.EventStream, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EventStream
	if *v == nil {
		sv = &types.EventStream{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "DestinationStreamArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DestinationStreamArn = ptr.String(jtv)
			}

		case "ExternalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ExternalId = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "LastUpdatedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastUpdatedBy = ptr.String(jtv)
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentExportJobResource(v **types.ExportJobResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ExportJobResource
	if *v == nil {
		sv = &types.ExportJobResource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "S3UrlPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.S3UrlPrefix = ptr.String(jtv)
			}

		case "SegmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SegmentId = ptr.String(jtv)
			}

		case "SegmentVersion":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SegmentVersion = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentExportJobResponse(v **types.ExportJobResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ExportJobResponse
	if *v == nil {
		sv = &types.ExportJobResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CompletedPieces":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompletedPieces = int32(i64)
			}

		case "CompletionDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CompletionDate = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Definition":
			if err := awsRestjson1_deserializeDocumentExportJobResource(&sv.Definition, value); err != nil {
				return err
			}

		case "FailedPieces":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FailedPieces = int32(i64)
			}

		case "Failures":
			if err := awsRestjson1_deserializeDocumentListOf__string(&sv.Failures, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "JobStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobStatus to be of type string, got %T instead", value)
				}
				sv.JobStatus = types.JobStatus(jtv)
			}

		case "TotalFailures":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalFailures = int32(i64)
			}

		case "TotalPieces":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalPieces = int32(i64)
			}

		case "TotalProcessed":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalProcessed = int32(i64)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentExportJobsResponse(v **types.ExportJobsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ExportJobsResponse
	if *v == nil {
		sv = &types.ExportJobsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfExportJobResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentForbiddenException(v **types.ForbiddenException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ForbiddenException
	if *v == nil {
		sv = &types.ForbiddenException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGCMChannelResponse(v **types.GCMChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GCMChannelResponse
	if *v == nil {
		sv = &types.GCMChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Credential":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Credential = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGPSCoordinates(v **types.GPSCoordinates, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GPSCoordinates
	if *v == nil {
		sv = &types.GPSCoordinates{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Latitude":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Latitude = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Latitude = f64

				default:
					return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

				}
			}

		case "Longitude":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Longitude = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Longitude = f64

				default:
					return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGPSPointDimension(v **types.GPSPointDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GPSPointDimension
	if *v == nil {
		sv = &types.GPSPointDimension{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Coordinates":
			if err := awsRestjson1_deserializeDocumentGPSCoordinates(&sv.Coordinates, value); err != nil {
				return err
			}

		case "RangeInKilometers":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.RangeInKilometers = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.RangeInKilometers = f64

				default:
					return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentHoldoutActivity(v **types.HoldoutActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.HoldoutActivity
	if *v == nil {
		sv = &types.HoldoutActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "Percentage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Percentage = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentImportJobResource(v **types.ImportJobResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ImportJobResource
	if *v == nil {
		sv = &types.ImportJobResource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DefineSegment":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.DefineSegment = jtv
			}

		case "ExternalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ExternalId = ptr.String(jtv)
			}

		case "Format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Format to be of type string, got %T instead", value)
				}
				sv.Format = types.Format(jtv)
			}

		case "RegisterEndpoints":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.RegisterEndpoints = jtv
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "S3Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.S3Url = ptr.String(jtv)
			}

		case "SegmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SegmentId = ptr.String(jtv)
			}

		case "SegmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SegmentName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentImportJobResponse(v **types.ImportJobResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ImportJobResponse
	if *v == nil {
		sv = &types.ImportJobResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CompletedPieces":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompletedPieces = int32(i64)
			}

		case "CompletionDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CompletionDate = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Definition":
			if err := awsRestjson1_deserializeDocumentImportJobResource(&sv.Definition, value); err != nil {
				return err
			}

		case "FailedPieces":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FailedPieces = int32(i64)
			}

		case "Failures":
			if err := awsRestjson1_deserializeDocumentListOf__string(&sv.Failures, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "JobStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobStatus to be of type string, got %T instead", value)
				}
				sv.JobStatus = types.JobStatus(jtv)
			}

		case "TotalFailures":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalFailures = int32(i64)
			}

		case "TotalPieces":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalPieces = int32(i64)
			}

		case "TotalProcessed":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalProcessed = int32(i64)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentImportJobsResponse(v **types.ImportJobsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ImportJobsResponse
	if *v == nil {
		sv = &types.ImportJobsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfImportJobResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppCampaignSchedule(v **types.InAppCampaignSchedule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppCampaignSchedule
	if *v == nil {
		sv = &types.InAppCampaignSchedule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EndDate = ptr.String(jtv)
			}

		case "EventFilter":
			if err := awsRestjson1_deserializeDocumentCampaignEventFilter(&sv.EventFilter, value); err != nil {
				return err
			}

		case "QuietTime":
			if err := awsRestjson1_deserializeDocumentQuietTime(&sv.QuietTime, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessage(v **types.InAppMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessage
	if *v == nil {
		sv = &types.InAppMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Content":
			if err := awsRestjson1_deserializeDocumentListOfInAppMessageContent(&sv.Content, value); err != nil {
				return err
			}

		case "CustomConfig":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.CustomConfig, value); err != nil {
				return err
			}

		case "Layout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Layout to be of type string, got %T instead", value)
				}
				sv.Layout = types.Layout(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessageBodyConfig(v **types.InAppMessageBodyConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessageBodyConfig
	if *v == nil {
		sv = &types.InAppMessageBodyConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Alignment":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Alignment to be of type string, got %T instead", value)
				}
				sv.Alignment = types.Alignment(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "TextColor":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TextColor = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessageButton(v **types.InAppMessageButton, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessageButton
	if *v == nil {
		sv = &types.InAppMessageButton{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Android":
			if err := awsRestjson1_deserializeDocumentOverrideButtonConfiguration(&sv.Android, value); err != nil {
				return err
			}

		case "DefaultConfig":
			if err := awsRestjson1_deserializeDocumentDefaultButtonConfiguration(&sv.DefaultConfig, value); err != nil {
				return err
			}

		case "IOS":
			if err := awsRestjson1_deserializeDocumentOverrideButtonConfiguration(&sv.IOS, value); err != nil {
				return err
			}

		case "Web":
			if err := awsRestjson1_deserializeDocumentOverrideButtonConfiguration(&sv.Web, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessageCampaign(v **types.InAppMessageCampaign, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessageCampaign
	if *v == nil {
		sv = &types.InAppMessageCampaign{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CampaignId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CampaignId = ptr.String(jtv)
			}

		case "DailyCap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DailyCap = int32(i64)
			}

		case "InAppMessage":
			if err := awsRestjson1_deserializeDocumentInAppMessage(&sv.InAppMessage, value); err != nil {
				return err
			}

		case "Priority":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Priority = int32(i64)
			}

		case "Schedule":
			if err := awsRestjson1_deserializeDocumentInAppCampaignSchedule(&sv.Schedule, value); err != nil {
				return err
			}

		case "SessionCap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SessionCap = int32(i64)
			}

		case "TotalCap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalCap = int32(i64)
			}

		case "TreatmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TreatmentId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessageContent(v **types.InAppMessageContent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessageContent
	if *v == nil {
		sv = &types.InAppMessageContent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackgroundColor":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.BackgroundColor = ptr.String(jtv)
			}

		case "BodyConfig":
			if err := awsRestjson1_deserializeDocumentInAppMessageBodyConfig(&sv.BodyConfig, value); err != nil {
				return err
			}

		case "HeaderConfig":
			if err := awsRestjson1_deserializeDocumentInAppMessageHeaderConfig(&sv.HeaderConfig, value); err != nil {
				return err
			}

		case "ImageUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ImageUrl = ptr.String(jtv)
			}

		case "PrimaryBtn":
			if err := awsRestjson1_deserializeDocumentInAppMessageButton(&sv.PrimaryBtn, value); err != nil {
				return err
			}

		case "SecondaryBtn":
			if err := awsRestjson1_deserializeDocumentInAppMessageButton(&sv.SecondaryBtn, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessageHeaderConfig(v **types.InAppMessageHeaderConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessageHeaderConfig
	if *v == nil {
		sv = &types.InAppMessageHeaderConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Alignment":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Alignment to be of type string, got %T instead", value)
				}
				sv.Alignment = types.Alignment(jtv)
			}

		case "Header":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Header = ptr.String(jtv)
			}

		case "TextColor":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TextColor = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppMessagesResponse(v **types.InAppMessagesResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppMessagesResponse
	if *v == nil {
		sv = &types.InAppMessagesResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InAppMessageCampaigns":
			if err := awsRestjson1_deserializeDocumentListOfInAppMessageCampaign(&sv.InAppMessageCampaigns, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInAppTemplateResponse(v **types.InAppTemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InAppTemplateResponse
	if *v == nil {
		sv = &types.InAppTemplateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Content":
			if err := awsRestjson1_deserializeDocumentListOfInAppMessageContent(&sv.Content, value); err != nil {
				return err
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "CustomConfig":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.CustomConfig, value); err != nil {
				return err
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Layout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Layout to be of type string, got %T instead", value)
				}
				sv.Layout = types.Layout(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TemplateType to be of type string, got %T instead", value)
				}
				sv.TemplateType = types.TemplateType(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInternalServerErrorException(v **types.InternalServerErrorException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InternalServerErrorException
	if *v == nil {
		sv = &types.InternalServerErrorException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentItemResponse(v **types.ItemResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ItemResponse
	if *v == nil {
		sv = &types.ItemResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndpointItemResponse":
			if err := awsRestjson1_deserializeDocumentEndpointItemResponse(&sv.EndpointItemResponse, value); err != nil {
				return err
			}

		case "EventsItemResponse":
			if err := awsRestjson1_deserializeDocumentMapOfEventItemResponse(&sv.EventsItemResponse, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyChannelSettings(v **types.JourneyChannelSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyChannelSettings
	if *v == nil {
		sv = &types.JourneyChannelSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ConnectCampaignArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ConnectCampaignArn = ptr.String(jtv)
			}

		case "ConnectCampaignExecutionRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ConnectCampaignExecutionRoleArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyCustomMessage(v **types.JourneyCustomMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyCustomMessage
	if *v == nil {
		sv = &types.JourneyCustomMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Data":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Data = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyDateRangeKpiResponse(v **types.JourneyDateRangeKpiResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyDateRangeKpiResponse
	if *v == nil {
		sv = &types.JourneyDateRangeKpiResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case "JourneyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.JourneyId = ptr.String(jtv)
			}

		case "KpiName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.KpiName = ptr.String(jtv)
			}

		case "KpiResult":
			if err := awsRestjson1_deserializeDocumentBaseKpiResult(&sv.KpiResult, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyEmailMessage(v **types.JourneyEmailMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyEmailMessage
	if *v == nil {
		sv = &types.JourneyEmailMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FromAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.FromAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyExecutionActivityMetricsResponse(v **types.JourneyExecutionActivityMetricsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyExecutionActivityMetricsResponse
	if *v == nil {
		sv = &types.JourneyExecutionActivityMetricsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActivityType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ActivityType = ptr.String(jtv)
			}

		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "JourneyActivityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.JourneyActivityId = ptr.String(jtv)
			}

		case "JourneyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.JourneyId = ptr.String(jtv)
			}

		case "LastEvaluatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastEvaluatedTime = ptr.String(jtv)
			}

		case "Metrics":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Metrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyExecutionMetricsResponse(v **types.JourneyExecutionMetricsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyExecutionMetricsResponse
	if *v == nil {
		sv = &types.JourneyExecutionMetricsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "JourneyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.JourneyId = ptr.String(jtv)
			}

		case "LastEvaluatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastEvaluatedTime = ptr.String(jtv)
			}

		case "Metrics":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Metrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyLimits(v **types.JourneyLimits, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyLimits
	if *v == nil {
		sv = &types.JourneyLimits{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DailyCap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DailyCap = int32(i64)
			}

		case "EndpointReentryCap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EndpointReentryCap = int32(i64)
			}

		case "EndpointReentryInterval":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EndpointReentryInterval = ptr.String(jtv)
			}

		case "MessagesPerSecond":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MessagesPerSecond = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyPushMessage(v **types.JourneyPushMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyPushMessage
	if *v == nil {
		sv = &types.JourneyPushMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "TimeToLive":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TimeToLive = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneyResponse(v **types.JourneyResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneyResponse
	if *v == nil {
		sv = &types.JourneyResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Activities":
			if err := awsRestjson1_deserializeDocumentMapOfActivity(&sv.Activities, value); err != nil {
				return err
			}

		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "ClosedDays":
			if err := awsRestjson1_deserializeDocumentClosedDays(&sv.ClosedDays, value); err != nil {
				return err
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "JourneyChannelSettings":
			if err := awsRestjson1_deserializeDocumentJourneyChannelSettings(&sv.JourneyChannelSettings, value); err != nil {
				return err
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Limits":
			if err := awsRestjson1_deserializeDocumentJourneyLimits(&sv.Limits, value); err != nil {
				return err
			}

		case "LocalTime":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.LocalTime = jtv
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OpenHours":
			if err := awsRestjson1_deserializeDocumentOpenHours(&sv.OpenHours, value); err != nil {
				return err
			}

		case "QuietTime":
			if err := awsRestjson1_deserializeDocumentQuietTime(&sv.QuietTime, value); err != nil {
				return err
			}

		case "RefreshFrequency":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RefreshFrequency = ptr.String(jtv)
			}

		case "RefreshOnSegmentUpdate":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.RefreshOnSegmentUpdate = jtv
			}

		case "Schedule":
			if err := awsRestjson1_deserializeDocumentJourneySchedule(&sv.Schedule, value); err != nil {
				return err
			}

		case "SendingSchedule":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.SendingSchedule = jtv
			}

		case "StartActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.StartActivity = ptr.String(jtv)
			}

		case "StartCondition":
			if err := awsRestjson1_deserializeDocumentStartCondition(&sv.StartCondition, value); err != nil {
				return err
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected State to be of type string, got %T instead", value)
				}
				sv.State = types.State(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "WaitForQuietTime":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.WaitForQuietTime = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneySchedule(v **types.JourneySchedule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneySchedule
	if *v == nil {
		sv = &types.JourneySchedule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __timestampIso8601 to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		case "Timezone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Timezone = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneySMSMessage(v **types.JourneySMSMessage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneySMSMessage
	if *v == nil {
		sv = &types.JourneySMSMessage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EntityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EntityId = ptr.String(jtv)
			}

		case "MessageType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MessageType to be of type string, got %T instead", value)
				}
				sv.MessageType = types.MessageType(jtv)
			}

		case "OriginationNumber":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.OriginationNumber = ptr.String(jtv)
			}

		case "SenderId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SenderId = ptr.String(jtv)
			}

		case "TemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentJourneysResponse(v **types.JourneysResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.JourneysResponse
	if *v == nil {
		sv = &types.JourneysResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfJourneyResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentListOf__EndpointTypesElement(v *[]types.EndpointTypesElement, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.EndpointTypesElement
	if *v == nil {
		cv = []types.EndpointTypesElement{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.EndpointTypesElement
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected __EndpointTypesElement to be of type string, got %T instead", value)
			}
			col = types.EndpointTypesElement(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOf__string(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected __string to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfActivityResponse(v *[]types.ActivityResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ActivityResponse
	if *v == nil {
		cv = []types.ActivityResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ActivityResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentActivityResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfApplicationResponse(v *[]types.ApplicationResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ApplicationResponse
	if *v == nil {
		cv = []types.ApplicationResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ApplicationResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentApplicationResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfCampaignResponse(v *[]types.CampaignResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.CampaignResponse
	if *v == nil {
		cv = []types.CampaignResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.CampaignResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentCampaignResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfClosedDaysRules(v *[]types.ClosedDaysRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ClosedDaysRule
	if *v == nil {
		cv = []types.ClosedDaysRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ClosedDaysRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentClosedDaysRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfEndpointResponse(v *[]types.EndpointResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.EndpointResponse
	if *v == nil {
		cv = []types.EndpointResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.EndpointResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentEndpointResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfExportJobResponse(v *[]types.ExportJobResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ExportJobResponse
	if *v == nil {
		cv = []types.ExportJobResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ExportJobResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentExportJobResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfImportJobResponse(v *[]types.ImportJobResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ImportJobResponse
	if *v == nil {
		cv = []types.ImportJobResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ImportJobResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentImportJobResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfInAppMessageCampaign(v *[]types.InAppMessageCampaign, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.InAppMessageCampaign
	if *v == nil {
		cv = []types.InAppMessageCampaign{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.InAppMessageCampaign
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentInAppMessageCampaign(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfInAppMessageContent(v *[]types.InAppMessageContent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.InAppMessageContent
	if *v == nil {
		cv = []types.InAppMessageContent{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.InAppMessageContent
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentInAppMessageContent(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfJourneyResponse(v *[]types.JourneyResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.JourneyResponse
	if *v == nil {
		cv = []types.JourneyResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.JourneyResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentJourneyResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfMultiConditionalBranch(v *[]types.MultiConditionalBranch, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.MultiConditionalBranch
	if *v == nil {
		cv = []types.MultiConditionalBranch{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.MultiConditionalBranch
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentMultiConditionalBranch(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfOpenHoursRules(v *[]types.OpenHoursRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.OpenHoursRule
	if *v == nil {
		cv = []types.OpenHoursRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.OpenHoursRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentOpenHoursRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfRandomSplitEntry(v *[]types.RandomSplitEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RandomSplitEntry
	if *v == nil {
		cv = []types.RandomSplitEntry{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RandomSplitEntry
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRandomSplitEntry(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfRecommenderConfigurationResponse(v *[]types.RecommenderConfigurationResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RecommenderConfigurationResponse
	if *v == nil {
		cv = []types.RecommenderConfigurationResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RecommenderConfigurationResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfResultRow(v *[]types.ResultRow, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ResultRow
	if *v == nil {
		cv = []types.ResultRow{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ResultRow
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentResultRow(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfResultRowValue(v *[]types.ResultRowValue, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ResultRowValue
	if *v == nil {
		cv = []types.ResultRowValue{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ResultRowValue
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentResultRowValue(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfSegmentDimensions(v *[]types.SegmentDimensions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SegmentDimensions
	if *v == nil {
		cv = []types.SegmentDimensions{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SegmentDimensions
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSegmentDimensions(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfSegmentGroup(v *[]types.SegmentGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SegmentGroup
	if *v == nil {
		cv = []types.SegmentGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SegmentGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSegmentGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfSegmentReference(v *[]types.SegmentReference, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SegmentReference
	if *v == nil {
		cv = []types.SegmentReference{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SegmentReference
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSegmentReference(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfSegmentResponse(v *[]types.SegmentResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SegmentResponse
	if *v == nil {
		cv = []types.SegmentResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SegmentResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSegmentResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfSimpleCondition(v *[]types.SimpleCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SimpleCondition
	if *v == nil {
		cv = []types.SimpleCondition{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SimpleCondition
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSimpleCondition(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfTemplateResponse(v *[]types.TemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.TemplateResponse
	if *v == nil {
		cv = []types.TemplateResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.TemplateResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentTemplateResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfTemplateVersionResponse(v *[]types.TemplateVersionResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.TemplateVersionResponse
	if *v == nil {
		cv = []types.TemplateVersionResponse{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.TemplateVersionResponse
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentTemplateVersionResponse(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListOfTreatmentResource(v *[]types.TreatmentResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.TreatmentResource
	if *v == nil {
		cv = []types.TreatmentResource{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.TreatmentResource
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentTreatmentResource(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentListRecommenderConfigurationsResponse(v **types.ListRecommenderConfigurationsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ListRecommenderConfigurationsResponse
	if *v == nil {
		sv = &types.ListRecommenderConfigurationsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfRecommenderConfigurationResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMapOf__double(v *map[string]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]float64
	if *v == nil {
		mv = map[string]float64{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal float64
		if value != nil {
			switch jtv := value.(type) {
			case json.Number:
				f64, err := jtv.Float64()
				if err != nil {
					return err
				}
				parsedVal = f64

			case string:
				var f64 float64
				switch {
				case strings.EqualFold(jtv, "NaN"):
					f64 = math.NaN()

				case strings.EqualFold(jtv, "Infinity"):
					f64 = math.Inf(1)

				case strings.EqualFold(jtv, "-Infinity"):
					f64 = math.Inf(-1)

				default:
					return fmt.Errorf("unknown JSON number value: %s", jtv)

				}
				parsedVal = f64

			default:
				return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

			}
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOf__integer(v *map[string]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]int32
	if *v == nil {
		mv = map[string]int32{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			parsedVal = int32(i64)
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOf__string(v *map[string]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]string
	if *v == nil {
		mv = map[string]string{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected __string to be of type string, got %T instead", value)
			}
			parsedVal = jtv
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfActivity(v *map[string]types.Activity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.Activity
	if *v == nil {
		mv = map[string]types.Activity{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.Activity
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentActivity(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfAttributeDimension(v *map[string]types.AttributeDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.AttributeDimension
	if *v == nil {
		mv = map[string]types.AttributeDimension{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.AttributeDimension
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentAttributeDimension(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfChannelResponse(v *map[string]types.ChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.ChannelResponse
	if *v == nil {
		mv = map[string]types.ChannelResponse{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.ChannelResponse
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentChannelResponse(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfEndpointMessageResult(v *map[string]types.EndpointMessageResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.EndpointMessageResult
	if *v == nil {
		mv = map[string]types.EndpointMessageResult{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.EndpointMessageResult
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentEndpointMessageResult(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfEventItemResponse(v *map[string]types.EventItemResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.EventItemResponse
	if *v == nil {
		mv = map[string]types.EventItemResponse{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.EventItemResponse
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentEventItemResponse(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfItemResponse(v *map[string]types.ItemResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.ItemResponse
	if *v == nil {
		mv = map[string]types.ItemResponse{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.ItemResponse
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentItemResponse(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfListOf__string(v *map[string][]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string][]string
	if *v == nil {
		mv = map[string][]string{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal []string
		mapVar := parsedVal
		if err := awsRestjson1_deserializeDocumentListOf__string(&mapVar, value); err != nil {
			return err
		}
		parsedVal = mapVar
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfListOfOpenHoursRules(v *map[string][]types.OpenHoursRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string][]types.OpenHoursRule
	if *v == nil {
		mv = map[string][]types.OpenHoursRule{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal []types.OpenHoursRule
		mapVar := parsedVal
		if err := awsRestjson1_deserializeDocumentListOfOpenHoursRules(&mapVar, value); err != nil {
			return err
		}
		parsedVal = mapVar
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfMapOfEndpointMessageResult(v *map[string]map[string]types.EndpointMessageResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]map[string]types.EndpointMessageResult
	if *v == nil {
		mv = map[string]map[string]types.EndpointMessageResult{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal map[string]types.EndpointMessageResult
		mapVar := parsedVal
		if err := awsRestjson1_deserializeDocumentMapOfEndpointMessageResult(&mapVar, value); err != nil {
			return err
		}
		parsedVal = mapVar
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfMessageResult(v *map[string]types.MessageResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.MessageResult
	if *v == nil {
		mv = map[string]types.MessageResult{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.MessageResult
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentMessageResult(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMapOfMetricDimension(v *map[string]types.MetricDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]types.MetricDimension
	if *v == nil {
		mv = map[string]types.MetricDimension{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal types.MetricDimension
		mapVar := parsedVal
		destAddr := &mapVar
		if err := awsRestjson1_deserializeDocumentMetricDimension(&destAddr, value); err != nil {
			return err
		}
		parsedVal = *destAddr
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentMessage(v **types.Message, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Message
	if *v == nil {
		sv = &types.Message{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Action":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Action to be of type string, got %T instead", value)
				}
				sv.Action = types.Action(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "ImageIconUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ImageIconUrl = ptr.String(jtv)
			}

		case "ImageSmallIconUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ImageSmallIconUrl = ptr.String(jtv)
			}

		case "ImageUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ImageUrl = ptr.String(jtv)
			}

		case "JsonBody":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.JsonBody = ptr.String(jtv)
			}

		case "MediaUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.MediaUrl = ptr.String(jtv)
			}

		case "RawContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RawContent = ptr.String(jtv)
			}

		case "SilentPush":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.SilentPush = jtv
			}

		case "TimeToLive":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TimeToLive = int32(i64)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Url = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMessageBody(v **types.MessageBody, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MessageBody
	if *v == nil {
		sv = &types.MessageBody{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMessageConfiguration(v **types.MessageConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MessageConfiguration
	if *v == nil {
		sv = &types.MessageConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ADMMessage":
			if err := awsRestjson1_deserializeDocumentMessage(&sv.ADMMessage, value); err != nil {
				return err
			}

		case "APNSMessage":
			if err := awsRestjson1_deserializeDocumentMessage(&sv.APNSMessage, value); err != nil {
				return err
			}

		case "BaiduMessage":
			if err := awsRestjson1_deserializeDocumentMessage(&sv.BaiduMessage, value); err != nil {
				return err
			}

		case "CustomMessage":
			if err := awsRestjson1_deserializeDocumentCampaignCustomMessage(&sv.CustomMessage, value); err != nil {
				return err
			}

		case "DefaultMessage":
			if err := awsRestjson1_deserializeDocumentMessage(&sv.DefaultMessage, value); err != nil {
				return err
			}

		case "EmailMessage":
			if err := awsRestjson1_deserializeDocumentCampaignEmailMessage(&sv.EmailMessage, value); err != nil {
				return err
			}

		case "GCMMessage":
			if err := awsRestjson1_deserializeDocumentMessage(&sv.GCMMessage, value); err != nil {
				return err
			}

		case "InAppMessage":
			if err := awsRestjson1_deserializeDocumentCampaignInAppMessage(&sv.InAppMessage, value); err != nil {
				return err
			}

		case "SMSMessage":
			if err := awsRestjson1_deserializeDocumentCampaignSmsMessage(&sv.SMSMessage, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMessageResponse(v **types.MessageResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MessageResponse
	if *v == nil {
		sv = &types.MessageResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "EndpointResult":
			if err := awsRestjson1_deserializeDocumentMapOfEndpointMessageResult(&sv.EndpointResult, value); err != nil {
				return err
			}

		case "RequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestId = ptr.String(jtv)
			}

		case "Result":
			if err := awsRestjson1_deserializeDocumentMapOfMessageResult(&sv.Result, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMessageResult(v **types.MessageResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MessageResult
	if *v == nil {
		sv = &types.MessageResult{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeliveryStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DeliveryStatus to be of type string, got %T instead", value)
				}
				sv.DeliveryStatus = types.DeliveryStatus(jtv)
			}

		case "MessageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.MessageId = ptr.String(jtv)
			}

		case "StatusCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StatusCode = int32(i64)
			}

		case "StatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.StatusMessage = ptr.String(jtv)
			}

		case "UpdatedToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.UpdatedToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMethodNotAllowedException(v **types.MethodNotAllowedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MethodNotAllowedException
	if *v == nil {
		sv = &types.MethodNotAllowedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMetricDimension(v **types.MetricDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MetricDimension
	if *v == nil {
		sv = &types.MetricDimension{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ComparisonOperator":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ComparisonOperator = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected __double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMultiConditionalBranch(v **types.MultiConditionalBranch, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MultiConditionalBranch
	if *v == nil {
		sv = &types.MultiConditionalBranch{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Condition":
			if err := awsRestjson1_deserializeDocumentSimpleCondition(&sv.Condition, value); err != nil {
				return err
			}

		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMultiConditionalSplitActivity(v **types.MultiConditionalSplitActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MultiConditionalSplitActivity
	if *v == nil {
		sv = &types.MultiConditionalSplitActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Branches":
			if err := awsRestjson1_deserializeDocumentListOfMultiConditionalBranch(&sv.Branches, value); err != nil {
				return err
			}

		case "DefaultActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultActivity = ptr.String(jtv)
			}

		case "EvaluationWaitTime":
			if err := awsRestjson1_deserializeDocumentWaitTime(&sv.EvaluationWaitTime, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNotFoundException(v **types.NotFoundException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NotFoundException
	if *v == nil {
		sv = &types.NotFoundException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNumberValidateResponse(v **types.NumberValidateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NumberValidateResponse
	if *v == nil {
		sv = &types.NumberValidateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Carrier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Carrier = ptr.String(jtv)
			}

		case "City":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.City = ptr.String(jtv)
			}

		case "CleansedPhoneNumberE164":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CleansedPhoneNumberE164 = ptr.String(jtv)
			}

		case "CleansedPhoneNumberNational":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CleansedPhoneNumberNational = ptr.String(jtv)
			}

		case "Country":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Country = ptr.String(jtv)
			}

		case "CountryCodeIso2":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CountryCodeIso2 = ptr.String(jtv)
			}

		case "CountryCodeNumeric":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CountryCodeNumeric = ptr.String(jtv)
			}

		case "County":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.County = ptr.String(jtv)
			}

		case "OriginalCountryCodeIso2":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.OriginalCountryCodeIso2 = ptr.String(jtv)
			}

		case "OriginalPhoneNumber":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.OriginalPhoneNumber = ptr.String(jtv)
			}

		case "PhoneType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.PhoneType = ptr.String(jtv)
			}

		case "PhoneTypeCode":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PhoneTypeCode = int32(i64)
			}

		case "Timezone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Timezone = ptr.String(jtv)
			}

		case "ZipCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ZipCode = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentOpenHours(v **types.OpenHours, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OpenHours
	if *v == nil {
		sv = &types.OpenHours{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CUSTOM":
			if err := awsRestjson1_deserializeDocumentMapOfListOfOpenHoursRules(&sv.CUSTOM, value); err != nil {
				return err
			}

		case "EMAIL":
			if err := awsRestjson1_deserializeDocumentMapOfListOfOpenHoursRules(&sv.EMAIL, value); err != nil {
				return err
			}

		case "PUSH":
			if err := awsRestjson1_deserializeDocumentMapOfListOfOpenHoursRules(&sv.PUSH, value); err != nil {
				return err
			}

		case "SMS":
			if err := awsRestjson1_deserializeDocumentMapOfListOfOpenHoursRules(&sv.SMS, value); err != nil {
				return err
			}

		case "VOICE":
			if err := awsRestjson1_deserializeDocumentMapOfListOfOpenHoursRules(&sv.VOICE, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentOpenHoursRule(v **types.OpenHoursRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OpenHoursRule
	if *v == nil {
		sv = &types.OpenHoursRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EndTime = ptr.String(jtv)
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.StartTime = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentOverrideButtonConfiguration(v **types.OverrideButtonConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OverrideButtonConfiguration
	if *v == nil {
		sv = &types.OverrideButtonConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ButtonAction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ButtonAction to be of type string, got %T instead", value)
				}
				sv.ButtonAction = types.ButtonAction(jtv)
			}

		case "Link":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Link = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPayloadTooLargeException(v **types.PayloadTooLargeException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PayloadTooLargeException
	if *v == nil {
		sv = &types.PayloadTooLargeException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPushMessageActivity(v **types.PushMessageActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PushMessageActivity
	if *v == nil {
		sv = &types.PushMessageActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageConfig":
			if err := awsRestjson1_deserializeDocumentJourneyPushMessage(&sv.MessageConfig, value); err != nil {
				return err
			}

		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateVersion = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPushNotificationTemplateResponse(v **types.PushNotificationTemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PushNotificationTemplateResponse
	if *v == nil {
		sv = &types.PushNotificationTemplateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ADM":
			if err := awsRestjson1_deserializeDocumentAndroidPushNotificationTemplate(&sv.ADM, value); err != nil {
				return err
			}

		case "APNS":
			if err := awsRestjson1_deserializeDocumentAPNSPushNotificationTemplate(&sv.APNS, value); err != nil {
				return err
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Baidu":
			if err := awsRestjson1_deserializeDocumentAndroidPushNotificationTemplate(&sv.Baidu, value); err != nil {
				return err
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Default":
			if err := awsRestjson1_deserializeDocumentDefaultPushNotificationTemplate(&sv.Default, value); err != nil {
				return err
			}

		case "DefaultSubstitutions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultSubstitutions = ptr.String(jtv)
			}

		case "GCM":
			if err := awsRestjson1_deserializeDocumentAndroidPushNotificationTemplate(&sv.GCM, value); err != nil {
				return err
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "RecommenderId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommenderId = ptr.String(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TemplateType to be of type string, got %T instead", value)
				}
				sv.TemplateType = types.TemplateType(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentQuietTime(v **types.QuietTime, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.QuietTime
	if *v == nil {
		sv = &types.QuietTime{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "End":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.End = ptr.String(jtv)
			}

		case "Start":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Start = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRandomSplitActivity(v **types.RandomSplitActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RandomSplitActivity
	if *v == nil {
		sv = &types.RandomSplitActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Branches":
			if err := awsRestjson1_deserializeDocumentListOfRandomSplitEntry(&sv.Branches, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRandomSplitEntry(v **types.RandomSplitEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RandomSplitEntry
	if *v == nil {
		sv = &types.RandomSplitEntry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "Percentage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Percentage = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRecencyDimension(v **types.RecencyDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecencyDimension
	if *v == nil {
		sv = &types.RecencyDimension{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Duration":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Duration to be of type string, got %T instead", value)
				}
				sv.Duration = types.Duration(jtv)
			}

		case "RecencyType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecencyType to be of type string, got %T instead", value)
				}
				sv.RecencyType = types.RecencyType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRecommenderConfigurationResponse(v **types.RecommenderConfigurationResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecommenderConfigurationResponse
	if *v == nil {
		sv = &types.RecommenderConfigurationResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attributes":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Attributes, value); err != nil {
				return err
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "RecommendationProviderIdType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommendationProviderIdType = ptr.String(jtv)
			}

		case "RecommendationProviderRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommendationProviderRoleArn = ptr.String(jtv)
			}

		case "RecommendationProviderUri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommendationProviderUri = ptr.String(jtv)
			}

		case "RecommendationsDisplayName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommendationsDisplayName = ptr.String(jtv)
			}

		case "RecommendationsPerMessage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RecommendationsPerMessage = int32(i64)
			}

		case "RecommendationTransformerUri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommendationTransformerUri = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResultRow(v **types.ResultRow, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResultRow
	if *v == nil {
		sv = &types.ResultRow{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupedBys":
			if err := awsRestjson1_deserializeDocumentListOfResultRowValue(&sv.GroupedBys, value); err != nil {
				return err
			}

		case "Values":
			if err := awsRestjson1_deserializeDocumentListOfResultRowValue(&sv.Values, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResultRowValue(v **types.ResultRowValue, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResultRowValue
	if *v == nil {
		sv = &types.ResultRowValue{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSchedule(v **types.Schedule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Schedule
	if *v == nil {
		sv = &types.Schedule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.EndTime = ptr.String(jtv)
			}

		case "EventFilter":
			if err := awsRestjson1_deserializeDocumentCampaignEventFilter(&sv.EventFilter, value); err != nil {
				return err
			}

		case "Frequency":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Frequency to be of type string, got %T instead", value)
				}
				sv.Frequency = types.Frequency(jtv)
			}

		case "IsLocalTime":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsLocalTime = jtv
			}

		case "QuietTime":
			if err := awsRestjson1_deserializeDocumentQuietTime(&sv.QuietTime, value); err != nil {
				return err
			}

		case "StartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.StartTime = ptr.String(jtv)
			}

		case "Timezone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Timezone = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentBehaviors(v **types.SegmentBehaviors, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentBehaviors
	if *v == nil {
		sv = &types.SegmentBehaviors{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Recency":
			if err := awsRestjson1_deserializeDocumentRecencyDimension(&sv.Recency, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentCondition(v **types.SegmentCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentCondition
	if *v == nil {
		sv = &types.SegmentCondition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SegmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SegmentId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentDemographics(v **types.SegmentDemographics, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentDemographics
	if *v == nil {
		sv = &types.SegmentDemographics{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AppVersion":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.AppVersion, value); err != nil {
				return err
			}

		case "Channel":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.Channel, value); err != nil {
				return err
			}

		case "DeviceType":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.DeviceType, value); err != nil {
				return err
			}

		case "Make":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.Make, value); err != nil {
				return err
			}

		case "Model":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.Model, value); err != nil {
				return err
			}

		case "Platform":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.Platform, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentDimensions(v **types.SegmentDimensions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentDimensions
	if *v == nil {
		sv = &types.SegmentDimensions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attributes":
			if err := awsRestjson1_deserializeDocumentMapOfAttributeDimension(&sv.Attributes, value); err != nil {
				return err
			}

		case "Behavior":
			if err := awsRestjson1_deserializeDocumentSegmentBehaviors(&sv.Behavior, value); err != nil {
				return err
			}

		case "Demographic":
			if err := awsRestjson1_deserializeDocumentSegmentDemographics(&sv.Demographic, value); err != nil {
				return err
			}

		case "Location":
			if err := awsRestjson1_deserializeDocumentSegmentLocation(&sv.Location, value); err != nil {
				return err
			}

		case "Metrics":
			if err := awsRestjson1_deserializeDocumentMapOfMetricDimension(&sv.Metrics, value); err != nil {
				return err
			}

		case "UserAttributes":
			if err := awsRestjson1_deserializeDocumentMapOfAttributeDimension(&sv.UserAttributes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentGroup(v **types.SegmentGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentGroup
	if *v == nil {
		sv = &types.SegmentGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Dimensions":
			if err := awsRestjson1_deserializeDocumentListOfSegmentDimensions(&sv.Dimensions, value); err != nil {
				return err
			}

		case "SourceSegments":
			if err := awsRestjson1_deserializeDocumentListOfSegmentReference(&sv.SourceSegments, value); err != nil {
				return err
			}

		case "SourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SourceType to be of type string, got %T instead", value)
				}
				sv.SourceType = types.SourceType(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Type to be of type string, got %T instead", value)
				}
				sv.Type = types.Type(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentGroupList(v **types.SegmentGroupList, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentGroupList
	if *v == nil {
		sv = &types.SegmentGroupList{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Groups":
			if err := awsRestjson1_deserializeDocumentListOfSegmentGroup(&sv.Groups, value); err != nil {
				return err
			}

		case "Include":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Include to be of type string, got %T instead", value)
				}
				sv.Include = types.Include(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentImportResource(v **types.SegmentImportResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentImportResource
	if *v == nil {
		sv = &types.SegmentImportResource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ChannelCounts":
			if err := awsRestjson1_deserializeDocumentMapOf__integer(&sv.ChannelCounts, value); err != nil {
				return err
			}

		case "ExternalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ExternalId = ptr.String(jtv)
			}

		case "Format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Format to be of type string, got %T instead", value)
				}
				sv.Format = types.Format(jtv)
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "S3Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.S3Url = ptr.String(jtv)
			}

		case "Size":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Size = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentLocation(v **types.SegmentLocation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentLocation
	if *v == nil {
		sv = &types.SegmentLocation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Country":
			if err := awsRestjson1_deserializeDocumentSetDimension(&sv.Country, value); err != nil {
				return err
			}

		case "GPSPoint":
			if err := awsRestjson1_deserializeDocumentGPSPointDimension(&sv.GPSPoint, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentReference(v **types.SegmentReference, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentReference
	if *v == nil {
		sv = &types.SegmentReference{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentResponse(v **types.SegmentResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentResponse
	if *v == nil {
		sv = &types.SegmentResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Dimensions":
			if err := awsRestjson1_deserializeDocumentSegmentDimensions(&sv.Dimensions, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "ImportDefinition":
			if err := awsRestjson1_deserializeDocumentSegmentImportResource(&sv.ImportDefinition, value); err != nil {
				return err
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "SegmentGroups":
			if err := awsRestjson1_deserializeDocumentSegmentGroupList(&sv.SegmentGroups, value); err != nil {
				return err
			}

		case "SegmentType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SegmentType to be of type string, got %T instead", value)
				}
				sv.SegmentType = types.SegmentType(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSegmentsResponse(v **types.SegmentsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SegmentsResponse
	if *v == nil {
		sv = &types.SegmentsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfSegmentResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSendUsersMessageResponse(v **types.SendUsersMessageResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SendUsersMessageResponse
	if *v == nil {
		sv = &types.SendUsersMessageResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "RequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestId = ptr.String(jtv)
			}

		case "Result":
			if err := awsRestjson1_deserializeDocumentMapOfMapOfEndpointMessageResult(&sv.Result, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSetDimension(v **types.SetDimension, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SetDimension
	if *v == nil {
		sv = &types.SetDimension{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DimensionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DimensionType to be of type string, got %T instead", value)
				}
				sv.DimensionType = types.DimensionType(jtv)
			}

		case "Values":
			if err := awsRestjson1_deserializeDocumentListOf__string(&sv.Values, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSimpleCondition(v **types.SimpleCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SimpleCondition
	if *v == nil {
		sv = &types.SimpleCondition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventCondition":
			if err := awsRestjson1_deserializeDocumentEventCondition(&sv.EventCondition, value); err != nil {
				return err
			}

		case "SegmentCondition":
			if err := awsRestjson1_deserializeDocumentSegmentCondition(&sv.SegmentCondition, value); err != nil {
				return err
			}

		case "segmentDimensions":
			if err := awsRestjson1_deserializeDocumentSegmentDimensions(&sv.SegmentDimensions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSMSChannelResponse(v **types.SMSChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SMSChannelResponse
	if *v == nil {
		sv = &types.SMSChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "PromotionalMessagesPerSecond":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PromotionalMessagesPerSecond = int32(i64)
			}

		case "SenderId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.SenderId = ptr.String(jtv)
			}

		case "ShortCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ShortCode = ptr.String(jtv)
			}

		case "TransactionalMessagesPerSecond":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TransactionalMessagesPerSecond = int32(i64)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSMSMessageActivity(v **types.SMSMessageActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SMSMessageActivity
	if *v == nil {
		sv = &types.SMSMessageActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MessageConfig":
			if err := awsRestjson1_deserializeDocumentJourneySMSMessage(&sv.MessageConfig, value); err != nil {
				return err
			}

		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateVersion = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSMSTemplateResponse(v **types.SMSTemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SMSTemplateResponse
	if *v == nil {
		sv = &types.SMSTemplateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultSubstitutions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultSubstitutions = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "RecommenderId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RecommenderId = ptr.String(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TemplateType to be of type string, got %T instead", value)
				}
				sv.TemplateType = types.TemplateType(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentStartCondition(v **types.StartCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StartCondition
	if *v == nil {
		sv = &types.StartCondition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EventStartCondition":
			if err := awsRestjson1_deserializeDocumentEventStartCondition(&sv.EventStartCondition, value); err != nil {
				return err
			}

		case "SegmentStartCondition":
			if err := awsRestjson1_deserializeDocumentSegmentCondition(&sv.SegmentStartCondition, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTagsModel(v **types.TagsModel, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TagsModel
	if *v == nil {
		sv = &types.TagsModel{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplate(v **types.Template, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Template
	if *v == nil {
		sv = &types.Template{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplateConfiguration(v **types.TemplateConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TemplateConfiguration
	if *v == nil {
		sv = &types.TemplateConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmailTemplate":
			if err := awsRestjson1_deserializeDocumentTemplate(&sv.EmailTemplate, value); err != nil {
				return err
			}

		case "PushTemplate":
			if err := awsRestjson1_deserializeDocumentTemplate(&sv.PushTemplate, value); err != nil {
				return err
			}

		case "SMSTemplate":
			if err := awsRestjson1_deserializeDocumentTemplate(&sv.SMSTemplate, value); err != nil {
				return err
			}

		case "VoiceTemplate":
			if err := awsRestjson1_deserializeDocumentTemplate(&sv.VoiceTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplateCreateMessageBody(v **types.TemplateCreateMessageBody, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TemplateCreateMessageBody
	if *v == nil {
		sv = &types.TemplateCreateMessageBody{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplateResponse(v **types.TemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TemplateResponse
	if *v == nil {
		sv = &types.TemplateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultSubstitutions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultSubstitutions = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TemplateType to be of type string, got %T instead", value)
				}
				sv.TemplateType = types.TemplateType(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplatesResponse(v **types.TemplatesResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TemplatesResponse
	if *v == nil {
		sv = &types.TemplatesResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfTemplateResponse(&sv.Item, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplateVersionResponse(v **types.TemplateVersionResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TemplateVersionResponse
	if *v == nil {
		sv = &types.TemplateVersionResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultSubstitutions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultSubstitutions = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateType = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTemplateVersionsResponse(v **types.TemplateVersionsResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TemplateVersionsResponse
	if *v == nil {
		sv = &types.TemplateVersionsResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Item":
			if err := awsRestjson1_deserializeDocumentListOfTemplateVersionResponse(&sv.Item, value); err != nil {
				return err
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTooManyRequestsException(v **types.TooManyRequestsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TooManyRequestsException
	if *v == nil {
		sv = &types.TooManyRequestsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "RequestID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.RequestID = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentTreatmentResource(v **types.TreatmentResource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TreatmentResource
	if *v == nil {
		sv = &types.TreatmentResource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CustomDeliveryConfiguration":
			if err := awsRestjson1_deserializeDocumentCustomDeliveryConfiguration(&sv.CustomDeliveryConfiguration, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "MessageConfiguration":
			if err := awsRestjson1_deserializeDocumentMessageConfiguration(&sv.MessageConfiguration, value); err != nil {
				return err
			}

		case "Schedule":
			if err := awsRestjson1_deserializeDocumentSchedule(&sv.Schedule, value); err != nil {
				return err
			}

		case "SizePercent":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SizePercent = int32(i64)
			}

		case "State":
			if err := awsRestjson1_deserializeDocumentCampaignState(&sv.State, value); err != nil {
				return err
			}

		case "TemplateConfiguration":
			if err := awsRestjson1_deserializeDocumentTemplateConfiguration(&sv.TemplateConfiguration, value); err != nil {
				return err
			}

		case "TreatmentDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TreatmentDescription = ptr.String(jtv)
			}

		case "TreatmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TreatmentName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentVerificationResponse(v **types.VerificationResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VerificationResponse
	if *v == nil {
		sv = &types.VerificationResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Valid":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Valid = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentVoiceChannelResponse(v **types.VoiceChannelResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VoiceChannelResponse
	if *v == nil {
		sv = &types.VoiceChannelResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.ApplicationId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "HasCredential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCredential = jtv
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "IsArchived":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected __boolean to be of type *bool, got %T instead", value)
				}
				sv.IsArchived = jtv
			}

		case "LastModifiedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedBy = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "Platform":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Platform = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected __integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentVoiceTemplateResponse(v **types.VoiceTemplateResponse, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VoiceTemplateResponse
	if *v == nil {
		sv = &types.VoiceTemplateResponse{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Body":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Body = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "DefaultSubstitutions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.DefaultSubstitutions = ptr.String(jtv)
			}

		case "LanguageCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LanguageCode = ptr.String(jtv)
			}

		case "LastModifiedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.LastModifiedDate = ptr.String(jtv)
			}

		case "tags":
			if err := awsRestjson1_deserializeDocumentMapOf__string(&sv.Tags, value); err != nil {
				return err
			}

		case "TemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateDescription = ptr.String(jtv)
			}

		case "TemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.TemplateName = ptr.String(jtv)
			}

		case "TemplateType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TemplateType to be of type string, got %T instead", value)
				}
				sv.TemplateType = types.TemplateType(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		case "VoiceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.VoiceId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWaitActivity(v **types.WaitActivity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaitActivity
	if *v == nil {
		sv = &types.WaitActivity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextActivity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.NextActivity = ptr.String(jtv)
			}

		case "WaitTime":
			if err := awsRestjson1_deserializeDocumentWaitTime(&sv.WaitTime, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWaitTime(v **types.WaitTime, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WaitTime
	if *v == nil {
		sv = &types.WaitTime{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "WaitFor":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.WaitFor = ptr.String(jtv)
			}

		case "WaitUntil":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected __string to be of type string, got %T instead", value)
				}
				sv.WaitUntil = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}
