// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves aggregated statistics for your account. If you are a GuardDuty
// administrator, you can retrieve the statistics for all the resources associated
// with the active member accounts in your organization who have enabled EKS
// Runtime Monitoring and have the GuardDuty agent running on their EKS nodes.
func (c *Client) GetCoverageStatistics(ctx context.Context, params *GetCoverageStatisticsInput, optFns ...func(*Options)) (*GetCoverageStatisticsOutput, error) {
	if params == nil {
		params = &GetCoverageStatisticsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCoverageStatistics", params, optFns, c.addOperationGetCoverageStatisticsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCoverageStatisticsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCoverageStatisticsInput struct {

	// The unique ID of the GuardDuty detector associated to the coverage statistics.
	//
	// This member is required.
	DetectorId *string

	// Represents the statistics type used to aggregate the coverage details.
	//
	// This member is required.
	StatisticsType []types.CoverageStatisticsType

	// Represents the criteria used to filter the coverage statistics
	FilterCriteria *types.CoverageFilterCriteria

	noSmithyDocumentSerde
}

type GetCoverageStatisticsOutput struct {

	// Represents the count aggregated by the statusCode and resourceType.
	CoverageStatistics *types.CoverageStatistics

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCoverageStatisticsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCoverageStatistics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCoverageStatistics{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetCoverageStatisticsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCoverageStatistics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCoverageStatistics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "guardduty",
		OperationName: "GetCoverageStatistics",
	}
}
