// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Registers your compute resources in a fleet you previously created. After you
// register a compute to your fleet, you can monitor and manage your compute using
// GameLift. The operation returns the compute resource containing SDK endpoint you
// can use to connect your game server to GameLift. Learn more
//
// * Create an
// Anywhere fleet
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
//
// *
// Test your integration
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
func (c *Client) RegisterCompute(ctx context.Context, params *RegisterComputeInput, optFns ...func(*Options)) (*RegisterComputeOutput, error) {
	if params == nil {
		params = &RegisterComputeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterCompute", params, optFns, c.addOperationRegisterComputeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterComputeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterComputeInput struct {

	// A descriptive label that is associated with the compute resource registered to
	// your fleet.
	//
	// This member is required.
	ComputeName *string

	// A unique identifier for the fleet to register the compute to. You can use either
	// the fleet ID or ARN value.
	//
	// This member is required.
	FleetId *string

	// The path to the TLS certificate on your compute resource. The path and
	// certificate are not validated by GameLift.
	CertificatePath *string

	// The DNS name of the compute resource. GameLift requires the DNS name or IP
	// address to manage your compute resource.
	DnsName *string

	// The IP address of the compute resource. GameLift requires the DNS name or IP
	// address to manage your compute resource.
	IpAddress *string

	// The name of the custom location you added to the fleet you are registering this
	// compute resource to.
	Location *string

	noSmithyDocumentSerde
}

type RegisterComputeOutput struct {

	// The details of the compute resource you registered to the specified fleet.
	Compute *types.Compute

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterComputeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRegisterCompute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRegisterCompute{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRegisterComputeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterCompute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterCompute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "gamelift",
		OperationName: "RegisterCompute",
	}
}
