// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a NAT gateway in the specified subnet. This action creates a network
// interface in the specified subnet with a private IP address from the IP address
// range of the subnet. You can create either a public NAT gateway or a private NAT
// gateway. With a public NAT gateway, internet-bound traffic from a private subnet
// can be routed to the NAT gateway, so that instances in a private subnet can
// connect to the internet. With a private NAT gateway, private communication is
// routed across VPCs and on-premises networks through a transit gateway or virtual
// private gateway. Common use cases include running large workloads behind a small
// pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and
// communicating between overlapping networks. For more information, see NAT
// gateways (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html)
// in the Amazon Virtual Private Cloud User Guide.
func (c *Client) CreateNatGateway(ctx context.Context, params *CreateNatGatewayInput, optFns ...func(*Options)) (*CreateNatGatewayOutput, error) {
	if params == nil {
		params = &CreateNatGatewayInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateNatGateway", params, optFns, c.addOperationCreateNatGatewayMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateNatGatewayOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateNatGatewayInput struct {

	// The ID of the subnet in which to create the NAT gateway.
	//
	// This member is required.
	SubnetId *string

	// [Public NAT gateways only] The allocation ID of an Elastic IP address to
	// associate with the NAT gateway. You cannot specify an Elastic IP address with a
	// private NAT gateway. If the Elastic IP address is associated with another
	// resource, you must first disassociate it.
	AllocationId *string

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. For more information, see How to ensure idempotency
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	// Constraint: Maximum 64 ASCII characters.
	ClientToken *string

	// Indicates whether the NAT gateway supports public or private connectivity. The
	// default is public connectivity.
	ConnectivityType types.ConnectivityType

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	// The private IPv4 address to assign to the NAT gateway. If you don't provide an
	// address, a private IPv4 address will be automatically assigned.
	PrivateIpAddress *string

	// Secondary EIP allocation IDs. For more information about secondary addresses,
	// see Create a NAT gateway
	// (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating)
	// in the Amazon Virtual Private Cloud User Guide.
	SecondaryAllocationIds []string

	// [Private NAT gateway only] The number of secondary private IPv4 addresses you
	// want to assign to the NAT gateway. For more information about secondary
	// addresses, see Create a NAT gateway
	// (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating)
	// in the Amazon Virtual Private Cloud User Guide.
	SecondaryPrivateIpAddressCount *int32

	// Secondary private IPv4 addresses. For more information about secondary
	// addresses, see Create a NAT gateway
	// (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating)
	// in the Amazon Virtual Private Cloud User Guide.
	SecondaryPrivateIpAddresses []string

	// The tags to assign to the NAT gateway.
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

type CreateNatGatewayOutput struct {

	// Unique, case-sensitive identifier to ensure the idempotency of the request. Only
	// returned if a client token was provided in the request.
	ClientToken *string

	// Information about the NAT gateway.
	NatGateway *types.NatGateway

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateNatGatewayMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateNatGateway{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateNatGateway{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateNatGatewayMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateNatGatewayValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateNatGateway(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateNatGateway struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateNatGateway) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateNatGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateNatGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateNatGatewayInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateNatGatewayMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateNatGateway{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateNatGateway(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "CreateNatGateway",
	}
}
